/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.LhsArr;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModDb {
    final List<ElabMod> mods = new ArrayList<ElabMod>();
    final Map<ModName, ElabMod> modnameIdxes = new HashMap<ModName, ElabMod>();

    public ModDb(ModName modName, Map<ModName, Module<Address>> modalist) {
        this.moduleToDb(modName, modalist);
    }

    public ModDb(Map<ModName, Module<Address>> modalist) {
        for (ModName modName : modalist.keySet()) {
            this.moduleToDb(modName, modalist);
        }
    }

    public ModDb(ElabMod elabMod, ModDb origDb) {
        this.moduleToDb(elabMod, origDb.modnameIdxes);
    }

    public int nMods() {
        return this.mods.size();
    }

    public ElabMod getMod(int modIdx) {
        return this.mods.get(modIdx);
    }

    public ElabMod topMod() {
        return this.getMod(this.nMods() - 1);
    }

    public ElabMod modnameGetIndex(ModName modName) {
        return this.modnameIdxes.get(modName);
    }

    public Map<ModName, Module<Address>> modalistNamedToIndex(Map<ModName, Module<Address>> modalist) {
        LinkedHashMap<ModName, Module<Address>> result = new LinkedHashMap<ModName, Module<Address>>();
        for (Map.Entry<ModName, Module<Address>> e2 : modalist.entrySet()) {
            ModName modName = e2.getKey();
            Module<Address> module = e2.getValue();
            ElabMod modIdx = this.modnameIdxes.get(modName);
            Module<Address> newModule = modIdx.moduleNamedToIndex(module);
            result.put(modName, newModule);
        }
        return result;
    }

    private void moduleToDb(ModName modName, Map<ModName, Module<Address>> modalist) {
        ElabMod elabMod = this.modnameIdxes.get(modName);
        if (elabMod != null) {
            return;
        }
        if (this.modnameIdxes.containsKey(modName)) {
            throw new IllegalArgumentException("Module loop " + String.valueOf(modName));
        }
        this.modnameIdxes.put(modName, null);
        Module<Address> module = modalist.get(modName);
        if (module == null) {
            throw new IllegalArgumentException("Module not found " + String.valueOf(modName));
        }
        for (ModInst modInst : module.insts) {
            this.moduleToDb(modInst.modname, modalist);
        }
        elabMod = new ElabMod(modName, module, this.modnameIdxes);
        this.mods.add(elabMod);
        ElabMod old = this.modnameIdxes.put(modName, elabMod);
        assert (old == null);
    }

    private void moduleToDb(ElabMod elabMod, Map<ModName, ElabMod> origModDb) {
        ElabMod newElabMod = this.modnameIdxes.get(elabMod.modName);
        if (newElabMod != null) {
            Util.check(newElabMod == elabMod);
            return;
        }
        this.modnameIdxes.put(elabMod.modName, elabMod);
        for (ModInst modInst : elabMod.origMod.insts) {
            this.moduleToDb(origModDb.get(modInst.modname), origModDb);
        }
        this.mods.add(elabMod);
    }

    public static class FlattenResult {
        public final List<Aliaspair<IndexName>> aliaspairs = new ArrayList<Aliaspair<IndexName>>();
        public final List<Assign<IndexName>> assigns = new ArrayList<Assign<IndexName>>();
        public final SvexManager<IndexName> sm = new SvexManager();
        public LhsArr aliases;

        public ACL2Object aliaspairsToACL2Object() {
            HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
            ACL2Object alist = ACL2.NIL;
            for (Aliaspair<IndexName> aliaspair : this.aliaspairs) {
                alist = ACL2.cons(ACL2.cons(aliaspair.lhs.getACL2Object(backedCache), aliaspair.rhs.getACL2Object(backedCache)), alist);
            }
            return Util.revList(alist);
        }

        public ACL2Object assignsToACL2Object() {
            HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
            ACL2Object alist = ACL2.NIL;
            for (Assign<IndexName> assign : this.assigns) {
                alist = ACL2.cons(ACL2.cons(assign.lhs.getACL2Object(backedCache), assign.driver.getACL2Object(backedCache)), alist);
            }
            return Util.revList(alist);
        }

        public ACL2Object aliasesToACL2Object() {
            return this.aliases.collectAliasesAsACL2Objects();
        }
    }
}

