/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Driver<N extends SvarName>
implements ACL2Backed {
    public static final int DEFAULT_STRENGTH = 6;
    public final Svex<N> svex;
    public final int strength;
    private final int hashCode;
    public final List<Svar<N>> vars;

    public Driver(Svex<N> svex) {
        this(svex, 6);
    }

    public Driver(Svex<N> svex, int strength) {
        this.svex = svex;
        this.strength = strength;
        this.vars = svex.collectVars();
        this.hashCode = ACL2Object.hashCodeOfCons(svex.hashCode(), ACL2Object.hashCodeOf(strength));
    }

    static <N extends SvarName> Driver<N> fromACL2(SvarName.Builder<N> snb, SvexManager<N> sm, ACL2Object impl, Map<ACL2Object, Svex<N>> svexCache) {
        Svex<N> svex = Svex.fromACL2(snb, sm, ACL2.car(impl), svexCache);
        int strength = ACL2.cdr(impl).intValueExact();
        return new Driver<N>(svex, strength);
    }

    public <N1 extends SvarName> Driver<N1> convertVars(Function<N, N1> rename, SvexManager<N1> sm, Map<Svex<N>, Svex<N1>> svexCache) {
        Svex<N1> newSvex = this.svex.convertVars(rename, sm, svexCache);
        return new Driver<N1>(newSvex, this.strength);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof Driver) {
            Driver that = (Driver)o2;
            return this.hashCode == that.hashCode && this.svex.equals(that.svex) && this.strength == that.strength;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object(Map<ACL2Backed, ACL2Object> backedCache) {
        ACL2Object result = backedCache.get(this);
        if (result == null) {
            result = ACL2.hons(this.svex.getACL2Object(backedCache), ACL2Object.valueOf(this.strength));
            backedCache.put(this, result);
        }
        assert (result.hashCode() == this.hashCode);
        return result;
    }

    void vars(Collection<Svar<N>> vars) {
        vars.addAll(this.vars);
    }
}

