/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SweptSample<S extends Sample>
implements Sample {
    private final Sample[] vals;

    public SweptSample(Sample[] vals) {
        this.vals = new Sample[vals.length];
        for (int i2 = 0; i2 < vals.length; ++i2) {
            this.vals[i2] = vals[i2];
        }
    }

    public int getWidth() {
        return this.vals.length;
    }

    public S getSweep(int i2) {
        return (S)this.vals[i2];
    }

    public double getMin() {
        double minVal = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            if (this.vals[i2] == null) continue;
            minVal = Math.min(minVal, ((ScalarSample)this.vals[i2]).getValue());
        }
        return minVal;
    }

    public double getMax() {
        double maxVal = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            if (this.vals[i2] == null) continue;
            maxVal = Math.max(maxVal, ((ScalarSample)this.vals[i2]).getValue());
        }
        return maxVal;
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof SweptSample)) {
            return false;
        }
        SweptSample bo = (SweptSample)o2;
        if (bo.vals.length != this.vals.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            if (this.vals[i2] == null) {
                if (bo.vals[i2] == null) continue;
                return false;
            }
            if (bo.vals[i2] == null) {
                return false;
            }
            if (this.vals[i2].equals(bo.vals[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            if (this.vals[i2] == null) continue;
            ret ^= this.vals[i2].hashCode();
        }
        return ret;
    }

    @Override
    public boolean isLogicX() {
        return false;
    }

    @Override
    public boolean isLogicZ() {
        return false;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof SweptSample)) {
            throw new RuntimeException("tried to call SweptSample.lub(" + s.getClass().getName() + ")");
        }
        SweptSample ds = (SweptSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call lub() on SweptSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            if (this.vals[i2] == null || ds.vals[i2] == null) continue;
            ret[i2] = this.vals[i2].lub(ds.vals[i2]);
        }
        return new SweptSample<S>(ret);
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof SweptSample)) {
            throw new RuntimeException("tried to call SweptSample.glb(" + s.getClass().getName() + ")");
        }
        SweptSample ds = (SweptSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call glb() on SweptSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            if (this.vals[i2] == null || ds.vals[i2] == null) continue;
            ret[i2] = this.vals[i2].glb(ds.vals[i2]);
        }
        return new SweptSample<S>(ret);
    }

    @Override
    public double getMinValue() {
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            min = Math.min(min, this.vals[i2].getMinValue());
        }
        return min;
    }

    @Override
    public double getMaxValue() {
        double max = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            max = Math.max(max, this.vals[i2].getMaxValue());
        }
        return max;
    }

    public static <SS extends Sample> Signal<SweptSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, int width) {
        throw new RuntimeException("not implemented");
    }

    public static <SS extends Sample> Signal<SweptSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, final Signal<SS>[] subsignals) {
        final String scName = sc.getName();
        return new Signal<SweptSample<SS>>(sc, sd, signalName, signalContext, digital){

            @Override
            public boolean isEmpty() {
                for (Signal sig : subsignals) {
                    if (sig.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Signal.View<RangeSample<SweptSample<SS>>> getRasterView(double t0, double t1, int numPixels) {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i2 = 0; i2 < subviews.length; ++i2) {
                    subviews[i2] = subsignals[i2].getRasterView(t0, t1, numPixels);
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i3 = 0; i3 < subviews.length; ++i3) {
                    Signal.View view = subviews[i3];
                    for (int j2 = 0; j2 < view.getNumEvents(); ++j2) {
                        double t = view.getTime(j2);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i3);
                    }
                }
                final double[] times = new double[tm.size()];
                final RangeSample[] vals = new RangeSample[tm.size()];
                int i4 = 0;
                int[] event = new int[subviews.length];
                Sample[] minvals = new Sample[subviews.length];
                Sample[] maxvals = new Sample[subviews.length];
                Iterator iterator = tm.keySet().iterator();
                while (iterator.hasNext()) {
                    double t;
                    times[i4] = t = ((Double)iterator.next()).doubleValue();
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator2 = hs.iterator();
                    while (iterator2.hasNext()) {
                        int v = (Integer)iterator2.next();
                        assert (subviews[v].getTime(event[v]) == t);
                        RangeSample rs = (RangeSample)subviews[v].getSample(event[v]);
                        if (rs != null) {
                            minvals[v] = rs.getMin();
                            maxvals[v] = rs.getMax();
                        }
                        int n2 = v;
                        event[n2] = event[n2] + 1;
                    }
                    vals[i4] = new RangeSample(new SweptSample(minvals), new SweptSample(maxvals));
                    ++i4;
                }
                return new Signal.View<RangeSample<SweptSample<SS>>>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public RangeSample<SweptSample<SS>> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public Signal.View<SweptSample<SS>> getExactView() {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i2 = 0; i2 < subviews.length; ++i2) {
                    subviews[i2] = subsignals[i2].getExactView();
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i3 = 0; i3 < subviews.length; ++i3) {
                    Signal.View view = subviews[i3];
                    for (int j2 = 0; j2 < view.getNumEvents(); ++j2) {
                        double t = view.getTime(j2);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i3);
                    }
                }
                final double[] times = new double[tm.size()];
                final SweptSample[] vals = new SweptSample[tm.size()];
                int i4 = 0;
                int[] event = new int[subviews.length];
                Sample[] sampleVals = new Sample[subviews.length];
                Iterator iterator = tm.keySet().iterator();
                while (iterator.hasNext()) {
                    double t;
                    times[i4] = t = ((Double)iterator.next()).doubleValue();
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator2 = hs.iterator();
                    while (iterator2.hasNext()) {
                        int v = (Integer)iterator2.next();
                        assert (subviews[v].getTime(event[v]) == t);
                        Object rs = subviews[v].getSample(event[v]);
                        if (rs != null) {
                            sampleVals[v] = rs;
                        }
                        int n2 = v;
                        event[n2] = event[n2] + 1;
                    }
                    vals[i4] = new SweptSample(sampleVals);
                    ++i4;
                }
                return new Signal.View<SweptSample<SS>>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public SweptSample<SS> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public double getMinTime() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinTime());
                }
                return min;
            }

            @Override
            public double getMaxTime() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxTime());
                }
                return max;
            }

            @Override
            public double getMinValue() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinValue());
                }
                return min;
            }

            @Override
            public double getMaxValue() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxValue());
                }
                return max;
            }

            @Override
            public void plot(Panel panel, Graphics g2, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                for (int i2 = 0; i2 < subsignals.length; ++i2) {
                    if (!panel.getWaveWindow().isSweepSignalIncluded(scName, i2)) continue;
                    ScalarSample.plotSig((MutableSignal)subsignals[i2], panel, g2, ws, light, forPs, bounds, selectedObjects, xAxisSignal);
                }
            }
        };
    }
}

