/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.btree.unboxed.LatticeOperation;
import com.sun.electric.database.geometry.btree.unboxed.Unboxed;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedHalfDouble;
import com.sun.electric.tool.simulation.BTreeSignal;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class ComplexSample
extends ScalarSample
implements Sample {
    private double real;
    private double imag;
    private double hypot;
    public static final Unboxed<ComplexSample> unboxer = new Unboxed<ComplexSample>(){

        @Override
        public int getSize() {
            return UnboxedHalfDouble.instance.getSize() * 2;
        }

        @Override
        public ComplexSample deserialize(byte[] buf, int ofs) {
            return new ComplexSample(UnboxedHalfDouble.instance.deserialize(buf, ofs), UnboxedHalfDouble.instance.deserialize(buf, ofs + UnboxedHalfDouble.instance.getSize()));
        }

        @Override
        public void serialize(ComplexSample v, byte[] buf, int ofs) {
            UnboxedHalfDouble.instance.serialize(v.real, buf, ofs);
            UnboxedHalfDouble.instance.serialize(v.imag, buf, ofs + UnboxedHalfDouble.instance.getSize());
        }
    };
    private static final LatticeOperation<ComplexSample> latticeOp = new LatticeOperation<ComplexSample>(unboxer){
        private final int sz = UnboxedHalfDouble.instance.getSize();

        @Override
        public void glb(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
            ScalarSample.latticeOp.glb(buf1, ofs1, buf2, ofs2, dest, dest_ofs);
            ScalarSample.latticeOp.glb(buf1, ofs1 + this.sz, buf2, ofs2 + this.sz, dest, dest_ofs + this.sz);
        }

        @Override
        public void lub(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
            ScalarSample.latticeOp.lub(buf1, ofs1, buf2, ofs2, dest, dest_ofs);
            ScalarSample.latticeOp.lub(buf1, ofs1 + this.sz, buf2, ofs2 + this.sz, dest, dest_ofs + this.sz);
        }
    };

    public ComplexSample(double real, double imag) {
        super(Math.hypot(real, imag));
        this.hypot = Math.hypot(real, imag);
        this.real = real;
        this.imag = imag;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == null || !(o2 instanceof ComplexSample)) {
            return false;
        }
        ComplexSample cs = (ComplexSample)o2;
        return cs.real == this.real && cs.imag == this.imag;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)(l2 & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l2 >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean isLogicX() {
        return false;
    }

    @Override
    public boolean isLogicZ() {
        return false;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof ComplexSample)) {
            throw new RuntimeException("tried to call ComplexSample.lub(" + s.getClass().getName() + ")");
        }
        ComplexSample cs = (ComplexSample)s;
        if (cs.real >= this.real && cs.imag >= this.imag) {
            return cs;
        }
        if (cs.real <= this.real && cs.imag <= this.imag) {
            return this;
        }
        return new ComplexSample(Math.max(this.real, cs.real), Math.max(this.imag, cs.imag));
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof ComplexSample)) {
            throw new RuntimeException("tried to call ComplexSample.glb(" + s.getClass().getName() + ")");
        }
        ComplexSample cs = (ComplexSample)s;
        if (cs.real >= this.real && cs.imag >= this.imag) {
            return this;
        }
        if (cs.real <= this.real && cs.imag <= this.imag) {
            return cs;
        }
        return new ComplexSample(Math.min(this.real, cs.real), Math.min(this.imag, cs.imag));
    }

    @Override
    public double getMinValue() {
        return this.hypot;
    }

    @Override
    public double getMaxValue() {
        return this.hypot;
    }

    public static Signal<ComplexSample> createComplexSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext) {
        BTreeSignal<ComplexSample> ret = new BTreeSignal<ComplexSample>(sc, sd, signalName, signalContext, false, BTreeSignal.getTree(unboxer, latticeOp, sd)){

            @Override
            public void plot(Panel panel, Graphics g2, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                ScalarSample.plotSig(this, panel, g2, ws, light, forPs, bounds, selectedObjects, xAxisSignal);
            }
        };
        return ret;
    }
}

