/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sandbox;

import com.sun.electric.Electric;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TechExplorerDriver {
    private final Process process;
    private final PrintWriter commandsWriter;
    private static final char HEADER_CHAR = '\u007f';
    private static final int STRLEN_WIDTH = Integer.toString(Integer.MAX_VALUE).length();

    public TechExplorerDriver(String jarPath, OutputStream redirect) throws IOException {
        this(new ProcessBuilder("java", "-cp", Electric.getJarLocation(), "-ss2m", "-ea", "-mx128m", "com.sun.electric.tool.sandbox.TechExplorer", jarPath), redirect);
    }

    public TechExplorerDriver(ProcessBuilder processBuilder, final OutputStream redirect) throws IOException {
        this.process = processBuilder.start();
        this.commandsWriter = new PrintWriter(this.process.getOutputStream());
        Thread stdErrReader = new Thread(this){
            final /* synthetic */ TechExplorerDriver this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                PrintWriter pw = redirect != null ? new PrintWriter(redirect) : null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.this$0.process.getErrorStream()));
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        if (pw == null) continue;
                        pw.println(line);
                        pw.flush();
                    }
                    reader.close();
                }
                catch (IOException e2) {
                    ActivityLogger.logException(e2);
                }
            }
        };
        stdErrReader.start();
        new StdOutThread().start();
    }

    public void putCommand(String cmd) {
        this.commandsWriter.println(cmd);
        this.commandsWriter.flush();
    }

    public void putCommand(String cmd, String args) {
        this.commandsWriter.println(cmd + " " + args);
        this.commandsWriter.flush();
    }

    protected void terminateOk(Object result) {
        System.out.println("Result " + String.valueOf(result));
    }

    protected void terminateFail(Exception e2) {
        System.out.println("Exception " + String.valueOf(e2));
        e2.printStackTrace(System.out);
    }

    public void closeCommands() {
        this.commandsWriter.close();
    }

    private class StdOutThread
    extends Thread {
        private byte[] buf = new byte[128];
        private DataInputStream resultsStream;

        private StdOutThread() {
            this.resultsStream = new DataInputStream(new BufferedInputStream(TechExplorerDriver.this.process.getInputStream()));
        }

        @Override
        public void run() {
            try {
                int c2;
                while ((c2 = this.resultsStream.read()) >= 0) {
                    if (c2 == 127) {
                        boolean isException;
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        int status = this.resultsStream.read();
                        if (status == 82) {
                            isException = false;
                        } else if (status == 69) {
                            isException = true;
                        } else {
                            throw new IOException();
                        }
                        int len = 0;
                        for (int i2 = 0; i2 < STRLEN_WIDTH; ++i2) {
                            int cc = this.resultsStream.read();
                            if (cc < 48 || cc > 57) {
                                throw new IOException();
                            }
                            len = len * 10 + cc - 48;
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        byte[] b2 = new byte[len];
                        this.resultsStream.readFully(b2);
                        Object result = null;
                        try {
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(b2));
                            result = in.readObject();
                            in.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        if (this.resultsStream.read() != 33) {
                            throw new IOException();
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        if (isException) {
                            TechExplorerDriver.this.terminateFail((Exception)result);
                            continue;
                        }
                        TechExplorerDriver.this.terminateOk(result);
                        continue;
                    }
                    if (c2 >= 32 && c2 < 127) {
                        int len = c2 - 32 + 1;
                        this.readBuf(len);
                        System.out.write(this.buf, 0, len);
                        continue;
                    }
                    System.out.write(c2);
                }
                this.resultsStream.close();
            }
            catch (IOException e2) {
                ActivityLogger.logException(e2);
            }
        }

        private void readBuf(int len) throws IOException {
            if (this.buf.length < len) {
                this.buf = new byte[Math.max(this.buf.length * 2, len)];
            }
            this.resultsStream.readFully(this.buf, 0, len);
        }
    }
}

