/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.util.math.Orientation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class SeaOfGatesCellBuilder {
    private static final boolean FINDEXISTINGCELLS = true;
    private final EditingPreferences ep;
    private final Snapshot oldSnapshot;
    private final Tool oldTool;
    private final Environment oldEnvironment;
    private final CellTree oldCellTree;
    private final CellBackup oldCellBackup;
    private final TechPool oldTechPool;
    private final CellRevision oldCellRevision;
    private final ImmutableCell oldCell;
    final CellId cellId;
    final String resultCellName;
    final Routing.SoGContactsStrategy contactPlacementAction;
    private Snapshot curSnapshot;
    private final List<CellBackup> curCellBackups;
    private CellBackup curCellBackup;
    private Map<SeaOfGatesHandlers.ContactKey, SeaOfGatesHandlers.ContactTemplate> contactTemplates = new HashMap<SeaOfGatesHandlers.ContactKey, SeaOfGatesHandlers.ContactTemplate>();
    private final BitSet curNodes = new BitSet();
    private int curNodesCount;
    private int lastNodeId;
    private final TreeMap<Name, MaxNodeSuffix> maxNodeSuffixesOrdered = new TreeMap(Name.STRING_NUMBER_ORDER);
    private final IdentityHashMap<PrimitiveNodeId, MaxNodeSuffix> maxNodeSuffixes = new IdentityHashMap();
    private final IdentityHashMap<SeaOfGatesEngine.RouteNode, ImmutableNodeInst> addedNodesToNodeInst = new IdentityHashMap();
    private final IdentityHashMap<SeaOfGatesEngine.RouteNode, PortProtoId> addedNodesToPortProtoId = new IdentityHashMap();
    private final List<ImmutableArcInst> curArcs = new ArrayList<ImmutableArcInst>();
    private int maxArcSuffix;
    private final MyShapeBuilder resultShapeBuilder;

    SeaOfGatesCellBuilder(Snapshot snapshot, CellId cellId, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, EditingPreferences ep) {
        Object resultCellId;
        this.ep = ep;
        this.cellId = cellId;
        this.resultCellName = resultCellName;
        this.contactPlacementAction = contactPlacementAction;
        this.oldSnapshot = snapshot;
        this.oldTool = this.oldSnapshot.tool;
        this.oldEnvironment = this.oldSnapshot.environment;
        this.oldCellTree = snapshot.getCellTree(cellId);
        this.oldCellBackup = this.oldCellTree.top;
        this.oldTechPool = this.oldCellTree.techPool;
        this.oldCellRevision = this.oldCellBackup.cellRevision;
        this.oldCell = this.oldCellRevision.d;
        this.curCellBackups = new ArrayList<CellBackup>();
        if (resultCellName != null) {
            resultCellId = cellId.libId.newCellId(CellName.newName(resultCellName, View.LAYOUT, 1));
            while (this.curCellBackups.size() <= ((CellId)resultCellId).cellIndex) {
                this.curCellBackups.add(null);
            }
            this.resultShapeBuilder = new MyShapeBuilder((CellId)resultCellId);
        } else {
            this.resultShapeBuilder = null;
        }
        for (CellTree cellTree : this.oldSnapshot.cellTrees) {
            if (cellTree == null) continue;
            int cellIndex = cellTree.top.cellRevision.d.cellId.cellIndex;
            while (this.curCellBackups.size() <= cellIndex) {
                this.curCellBackups.add(null);
            }
            this.curCellBackups.set(cellIndex, cellTree.top);
        }
        this.lastNodeId = -1;
        for (ImmutableNodeInst n2 : this.oldCellRevision.nodes) {
            int nodeId = n2.nodeId;
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            this.lastNodeId = Math.max(this.lastNodeId, nodeId);
        }
        this.curNodesCount = this.oldCellRevision.nodes.size();
        if (this.resultShapeBuilder != null) {
            resultCellId = this.resultShapeBuilder.cellId;
            this.curCellBackups.set(((CellId)resultCellId).cellIndex, this.resultShapeBuilder.commit());
            int nodeId = ++this.lastNodeId;
            Name baseName = ((CellId)resultCellId).cellName.getBasename();
            MaxNodeSuffix maxSuffix = this.maxNodeSuffixesOrdered.get(baseName);
            if (maxSuffix == null) {
                maxSuffix = new MaxNodeSuffix(this, baseName);
                this.maxNodeSuffixesOrdered.put(baseName, maxSuffix);
            }
            Name name = maxSuffix.getNextName();
            TextDescriptor nameTd = ep.getNodeTextDescriptor();
            Orientation orient = Orientation.IDENT;
            EPoint anchor = EPoint.ORIGIN;
            EPoint size = EPoint.ORIGIN;
            int flags = 0;
            int techBits = 0;
            TextDescriptor protoTd = ep.getInstanceTextDescriptor();
            ImmutableNodeInst n3 = ImmutableNodeInst.newInst(nodeId, (NodeProtoId)resultCellId, name, nameTd, orient, anchor, size, flags, techBits, protoTd);
            maxSuffix.add(n3);
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            ++this.curNodesCount;
        }
        this.maxArcSuffix = -1;
        for (ImmutableArcInst a2 : this.oldCellRevision.arcs) {
            int arcId = a2.arcId;
            while (this.curArcs.size() <= arcId) {
                this.curArcs.add(null);
            }
            assert (this.curArcs.get(arcId) == null);
            this.curArcs.set(arcId, a2);
            Name name = a2.name;
            if (!name.isTempname()) continue;
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        this.curSnapshot = this.oldSnapshot;
        this.curCellBackup = this.oldCellBackup;
    }

    private SeaOfGatesHandlers.ContactTemplate getTemplateForContact(PrimitiveNode pNp, EPoint size, int techBits) {
        SeaOfGatesHandlers.ContactKey contactKey = new SeaOfGatesHandlers.ContactKey(pNp, size, techBits);
        return this.contactTemplates.get(contactKey);
    }

    private void makeTemplateForContact(PrimitiveNode pNp, EPoint size, int techBits) {
        CellId contactCellId;
        assert (pNp.getFunction().isContact());
        SeaOfGatesHandlers.ContactKey contactKey = new SeaOfGatesHandlers.ContactKey(pNp, size, techBits);
        Name nodeName = pNp.getPrimitiveFunction(techBits).getBasename().findSuffixed(0);
        nodeName = this.contactPlacementAction == Routing.SoGContactsStrategy.SOGCONTACTSUSEEXISTINGSUBCELLS ? pNp.getPrimitiveFunction(techBits).getBasename().findSuffixed(0) : Name.findName(contactKey.toString());
        CellBackup contactCellBackup = null;
        Orientation contactTemplateOrientation = Orientation.IDENT;
        if (this.contactPlacementAction != Routing.SoGContactsStrategy.SOGCONTACTSFORCESUBCELLS) {
            ImmutableNodeInst n2 = ImmutableNodeInst.newInst(0, pNp.getId(), nodeName, TextDescriptor.EMPTY, Orientation.IDENT, EPoint.ORIGIN, size, 0, techBits, TextDescriptor.EMPTY);
            MyShapeBuilder conShape = new MyShapeBuilder();
            pNp.genShape(conShape, n2);
            MyShapeBuilder conShapeRot = new MyShapeBuilder();
            pNp.genShape(conShapeRot, n2.withOrient(Orientation.R));
            for (CellBackup cellBackup : this.curCellBackups) {
                if (cellBackup == null || cellBackup.cellRevision.d.cellId.libId != this.cellId.libId) continue;
                if (this.doesCellMatch(cellBackup, conShape)) {
                    contactCellBackup = cellBackup;
                    break;
                }
                if (!this.doesCellMatch(cellBackup, conShapeRot)) continue;
                contactCellBackup = cellBackup;
                contactTemplateOrientation = Orientation.R;
                break;
            }
        }
        if (contactCellBackup != null) {
            contactCellId = contactCellBackup.cellRevision.d.cellId;
            if (!contactCellBackup.cellRevision.exports.isEmpty()) {
                ExportId eId = contactCellBackup.cellRevision.exports.iterator().next().exportId;
                SeaOfGatesHandlers.ContactTemplate contactTemplate = new SeaOfGatesHandlers.ContactTemplate(contactCellId, contactTemplateOrientation, eId);
                this.contactTemplates.put(contactKey, contactTemplate);
                return;
            }
            pNp = Generic.tech().universalPinNode;
            nodeName = this.contactPlacementAction == Routing.SoGContactsStrategy.SOGCONTACTSUSEEXISTINGSUBCELLS ? pNp.getPrimitiveFunction(techBits).getBasename().findSuffixed(0) : Name.findName(contactKey.toString());
        } else {
            if (this.contactPlacementAction == Routing.SoGContactsStrategy.SOGCONTACTSUSEEXISTINGSUBCELLS) {
                return;
            }
            contactCellId = this.cellId.libId.newCellId(contactKey.getDefaultCellName());
            while (this.curCellBackups.size() <= contactCellId.cellIndex) {
                this.curCellBackups.add(null);
            }
            ImmutableCell c2 = ImmutableCell.newInst(contactCellId, System.currentTimeMillis()).withTechId(this.oldCell.techId);
            contactCellBackup = CellBackup.newInst(c2, this.oldTechPool);
            this.curCellBackups.set(contactCellId.cellIndex, contactCellBackup);
        }
        int nodeId = contactCellBackup.cellRevision.getMaxNodeId() + 1;
        TextDescriptor nameTd = this.ep.getNodeTextDescriptor();
        EPoint anchor = EPoint.ORIGIN;
        int flags = 0;
        TextDescriptor protoTd = this.ep.getInstanceTextDescriptor();
        ImmutableNodeInst n3 = ImmutableNodeInst.newInst(nodeId, pNp.getId(), nodeName, nameTd, Orientation.IDENT, anchor, size, flags, techBits, protoTd);
        String portName = "port";
        ExportId exportId = contactCellId.newPortId(portName);
        TextDescriptor portTd = this.ep.getExportTextDescriptor();
        boolean alwaysDrawn = false;
        boolean bodyOnly = false;
        ImmutableExport e2 = ImmutableExport.newInst(exportId, Name.findName(portName), portTd, nodeId, pNp.getPort(0).getId(), alwaysDrawn, bodyOnly, PortCharacteristic.UNKNOWN);
        ImmutableNodeInst[] nodesArray = new ImmutableNodeInst[contactCellBackup.cellRevision.nodes.size() + 1];
        ImmutableNodeInst nodeToInsert = n3;
        int nodeIndex = 0;
        for (ImmutableNodeInst nextN : contactCellBackup.cellRevision.nodes) {
            if (nodeToInsert != null && Name.STRING_NUMBER_ORDER.compare(nodeToInsert.name, nextN.name) <= 0) {
                assert (nodeToInsert.name != nextN.name);
                nodesArray[nodeIndex++] = nodeToInsert;
                nodeToInsert = null;
            }
            nodesArray[nodeIndex++] = nextN;
        }
        if (nodeToInsert != null) {
            nodesArray[nodeIndex++] = nodeToInsert;
        }
        assert (nodeIndex == nodesArray.length);
        ImmutableExport[] exportsArray = new ImmutableExport[]{e2};
        contactCellBackup = contactCellBackup.with(contactCellBackup.cellRevision.d, nodesArray, null, exportsArray, this.oldTechPool);
        this.curCellBackups.set(contactCellId.cellIndex, contactCellBackup);
        SeaOfGatesHandlers.ContactTemplate contactTemplate = new SeaOfGatesHandlers.ContactTemplate(contactCellId, contactTemplateOrientation, exportId);
        this.contactTemplates.put(contactKey, contactTemplate);
    }

    private boolean doesCellMatch(CellBackup contactCellBackup, MyShapeBuilder sb) {
        List<ImmutableNodeInst> shapeNodes = sb.nodes;
        BitSet matched = new BitSet();
        for (ImmutableNodeInst n2 : contactCellBackup.cellRevision.nodes) {
            PrimitiveNode pn;
            if (!(n2.protoId instanceof PrimitiveNodeId) || (pn = this.oldTechPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId)).getTechnology() == Generic.tech()) continue;
            if (pn.getFunction() != PrimitiveNode.Function.NODE) {
                return false;
            }
            if (n2.getTrace() != null) {
                return false;
            }
            boolean foundMatch = false;
            for (int i2 = 0; i2 < shapeNodes.size(); ++i2) {
                if (matched.get(i2)) continue;
                ImmutableNodeInst sn = shapeNodes.get(i2);
                if (n2.protoId != sn.protoId || !n2.size.equals(sn.size) || !n2.anchor.equals(sn.anchor)) continue;
                matched.set(i2);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return matched.cardinality() == shapeNodes.size();
    }

    synchronized void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
        if (this.contactPlacementAction != Routing.SoGContactsStrategy.SOGCONTACTSATTOPLEVEL) {
            for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
                SeaOfGatesHandlers.ContactTemplate contactTemplate;
                PrimitiveNodeId protoId;
                PrimitiveNode pNp;
                if (rn.exists() || !(pNp = this.oldTechPool.getPrimitiveNode(protoId = (PrimitiveNodeId)rn.getProtoId())).getFunction().isContact() || (contactTemplate = this.getTemplateForContact(pNp, rn.getSize(), rn.getTechBits())) != null) continue;
                this.makeTemplateForContact(pNp, rn.getSize(), rn.getTechBits());
            }
        }
        if (this.resultShapeBuilder == null) {
            Iterator<Serializable> iterator = resolution.nodesIDsToKill.iterator();
            while (iterator.hasNext()) {
                int nodeId = (Integer)iterator.next();
                assert (this.curNodes.get(nodeId));
                this.curNodes.clear(nodeId);
                --this.curNodesCount;
            }
            iterator = resolution.arcsIDsToKill.iterator();
            while (iterator.hasNext()) {
                int arcId = (Integer)iterator.next();
                assert (this.curArcs.get(arcId) != null);
                this.curArcs.set(arcId, null);
            }
        }
        for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
            MaxNodeSuffix maxSuffix;
            SeaOfGatesHandlers.ContactTemplate contactTemplate;
            PrimitiveNodeId pnId;
            if (rn.exists()) continue;
            int nodeId = ++this.lastNodeId;
            NodeProtoId protoId = pnId = (PrimitiveNodeId)rn.getProtoId();
            PortProtoId ppId = pnId.getPortId(0);
            PrimitiveNode pNp = this.oldTechPool.getPrimitiveNode(pnId);
            Orientation orient = Orientation.IDENT;
            if (pNp.getFunction().isContact() && (contactTemplate = this.getTemplateForContact(pNp, rn.getSize(), rn.getTechBits())) != null) {
                protoId = contactTemplate.cellId;
                orient = contactTemplate.orient;
                ppId = contactTemplate.exportId;
            }
            if ((maxSuffix = this.maxNodeSuffixes.get(pnId)) == null) {
                Name baseName = rn.getBaseName();
                maxSuffix = this.maxNodeSuffixesOrdered.get(baseName);
                if (maxSuffix == null) {
                    maxSuffix = new MaxNodeSuffix(this, baseName);
                    this.maxNodeSuffixesOrdered.put(baseName, maxSuffix);
                }
                this.maxNodeSuffixes.put(pnId, maxSuffix);
            }
            Name name = maxSuffix.getNextName();
            TextDescriptor nameTd = this.ep.getNodeTextDescriptor();
            orient = rn.getOrient().concatenate(orient);
            EPoint anchor = rn.getLoc();
            EPoint size = rn.getSize();
            int flags = 0;
            int techBits = rn.getTechBits();
            TextDescriptor protoTd = this.ep.getInstanceTextDescriptor();
            if (this.resultShapeBuilder != null && protoId != pnId) {
                nodeId = this.resultShapeBuilder.getNextNodeId();
                name = this.resultShapeBuilder.getNextName();
            }
            ImmutableNodeInst n2 = ImmutableNodeInst.newInst(nodeId, protoId, name, nameTd, orient, anchor, size, flags, techBits, protoTd);
            if (this.resultShapeBuilder != null) {
                if (protoId != pnId) {
                    this.resultShapeBuilder.nodes.add(n2);
                } else {
                    int startNodeId = this.resultShapeBuilder.getNextNodeId();
                    this.oldTechPool.getPrimitiveNode(pnId).genShape(this.resultShapeBuilder, n2);
                    n2 = this.resultShapeBuilder.nodes.get(startNodeId);
                }
            } else {
                maxSuffix.add(n2);
                assert (!this.curNodes.get(nodeId));
                this.curNodes.set(nodeId);
                ++this.curNodesCount;
            }
            rn.setTapConnection(n2);
            this.addedNodesToNodeInst.put(rn, n2);
            this.addedNodesToPortProtoId.put(rn, ppId);
        }
        for (SeaOfGatesEngine.RouteArc ra : resolution.arcsToRoute) {
            int arcId = this.curArcs.size();
            ArcProtoId protoId = ra.getProtoId();
            assert (this.maxArcSuffix < Integer.MAX_VALUE);
            Name name = null;
            Name newName = null;
            if (ra.getName() != null) {
                newName = Name.findName(ra.getName());
            }
            name = newName != null && !newName.isTempname() ? newName : ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            TextDescriptor nameTd = this.ep.getArcTextDescriptor();
            SeaOfGatesEngine.RouteNode tail = ra.getTail();
            int tailNodeId = tail.exists() ? tail.getNodeId() : this.addedNodesToNodeInst.get((Object)tail).nodeId;
            PortProtoId tailProtoId = tail.exists() ? tail.getPortProtoId() : this.addedNodesToPortProtoId.get(tail);
            EPoint tailLocation = tail.getLoc();
            SeaOfGatesEngine.RouteNode head = ra.getHead();
            int headNodeId = head.exists() ? head.getNodeId() : this.addedNodesToNodeInst.get((Object)head).nodeId;
            PortProtoId headProtoId = head.exists() ? head.getPortProtoId() : this.addedNodesToPortProtoId.get(head);
            EPoint headLocation = head.getLoc();
            long gridExtendOverMin = ra.getGridExtendOverMin();
            int angle = -1;
            int flags = ra.getFlags(this.ep);
            ImmutableArcInst a2 = ImmutableArcInst.newInst(arcId, protoId, name, nameTd, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            if (this.resultShapeBuilder != null) {
                this.resultShapeBuilder.genShapeOfArc(a2);
                continue;
            }
            this.curArcs.add(a2);
        }
        if (this.resultShapeBuilder != null) {
            return;
        }
        ArcProtoId unroutedId = this.oldTechPool.getGeneric().unrouted_arc.getId();
        long unroutedGridExtend = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst(this.ep).getGridExtendOverMin();
        int unroutedFlags = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst((EditingPreferences)this.ep).flags;
        HashSet<String> namesGiven = new HashSet<String>();
        for (SeaOfGatesEngine.RouteAddUnrouted rau : resolution.unroutedToAdd.keySet()) {
            Name name;
            int arcId = this.curArcs.size();
            ArcProtoId protoId = unroutedId;
            String newName = resolution.unroutedToAdd.get(rau);
            int breakPos = newName.indexOf(32);
            if (breakPos > 0) {
                newName = newName.substring(0, breakPos);
            }
            if (namesGiven.contains(newName)) {
                assert (this.maxArcSuffix < Integer.MAX_VALUE);
                name = ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            } else {
                name = Name.findName(newName);
                namesGiven.add(newName);
            }
            TextDescriptor nameTd = this.ep.getArcTextDescriptor();
            int tailNodeId = rau.getTailId();
            PortProtoId tailProtoId = rau.getTailPortProtoId();
            EPoint tailLocation = rau.getTailLocation();
            int headNodeId = rau.getHeadId();
            PortProtoId headProtoId = rau.getHeadPortProtoId();
            EPoint headLocation = rau.getHeadLocation();
            long gridExtendOverMin = unroutedGridExtend;
            int angle = -1;
            int flags = unroutedFlags;
            ImmutableArcInst a3 = ImmutableArcInst.newInst(arcId, protoId, name, nameTd, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            this.curArcs.add(a3);
        }
        resolution.clearRoutes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot commit() {
        ImmutableArcInst[] newArcs;
        ImmutableNodeInst[] newNodes;
        SeaOfGatesCellBuilder seaOfGatesCellBuilder = this;
        synchronized (seaOfGatesCellBuilder) {
            newNodes = new ImmutableNodeInst[this.curNodesCount];
            int oldNodeIndex = 0;
            int newNodeIndex = 0;
            for (MaxNodeSuffix maxSuffix : this.maxNodeSuffixesOrdered.values()) {
                while (oldNodeIndex < maxSuffix.insertionPoint) {
                    ImmutableNodeInst n2 = this.oldCellRevision.nodes.get(oldNodeIndex++);
                    if (!this.curNodes.get(n2.nodeId)) continue;
                    newNodes[newNodeIndex++] = n2;
                }
                for (ImmutableNodeInst n3 : maxSuffix.addedNodes) {
                    assert (this.curNodes.get(n3.nodeId));
                    newNodes[newNodeIndex++] = n3;
                }
            }
            while (oldNodeIndex < this.oldCellRevision.nodes.size()) {
                ImmutableNodeInst n4 = this.oldCellRevision.nodes.get(oldNodeIndex++);
                if (!this.curNodes.get(n4.nodeId)) continue;
                newNodes[newNodeIndex++] = n4;
            }
            assert (newNodeIndex == newNodes.length);
            int arcCount = 0;
            for (ImmutableArcInst a2 : this.curArcs) {
                if (a2 == null) continue;
                ++arcCount;
            }
            newArcs = new ImmutableArcInst[arcCount];
            arcCount = 0;
            for (ImmutableArcInst a2 : this.curArcs) {
                if (a2 == null) continue;
                newArcs[arcCount++] = a2;
            }
            assert (arcCount == newArcs.length);
            Arrays.sort(newArcs, ImmutableArcInst.ARCS_ORDER);
        }
        this.curCellBackup = this.curCellBackup.with(this.oldCell, newNodes, newArcs, null, this.oldTechPool);
        this.curCellBackups.set(this.cellId.cellIndex, this.curCellBackup);
        if (this.resultShapeBuilder != null) {
            this.curCellBackups.set(this.resultShapeBuilder.cellId.cellIndex, this.resultShapeBuilder.commit());
        }
        this.curSnapshot = this.curSnapshot.with(this.oldTool, this.oldEnvironment, this.curCellBackups.toArray(CellBackup.NULL_ARRAY), null);
        return this.curSnapshot;
    }

    private int searchNodeInsertionPoint(String basename) {
        assert (basename.endsWith("@0"));
        char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
        String nextName = basename.substring(0, basename.length() - 2) + nextChar;
        int index = this.oldCellRevision.nodes.searchByName(nextName);
        return index >= 0 ? index : -(index + 1);
    }

    private class MyShapeBuilder
    extends AbstractShapeBuilder {
        private final CellId cellId;
        private final TextDescriptor nameTd;
        private final TextDescriptor protoTd;
        private CellBackup cellBackup;
        private final List<ImmutableNodeInst> nodes;

        MyShapeBuilder() {
            this.nameTd = SeaOfGatesCellBuilder.this.ep.getNodeTextDescriptor();
            this.protoTd = SeaOfGatesCellBuilder.this.ep.getInstanceTextDescriptor();
            this.nodes = new ArrayList<ImmutableNodeInst>();
            this.cellId = null;
            this.cellBackup = null;
        }

        MyShapeBuilder(CellId cellId) {
            this.nameTd = SeaOfGatesCellBuilder.this.ep.getNodeTextDescriptor();
            this.protoTd = SeaOfGatesCellBuilder.this.ep.getInstanceTextDescriptor();
            this.nodes = new ArrayList<ImmutableNodeInst>();
            this.setup(SeaOfGatesCellBuilder.this.oldTechPool);
            this.cellId = cellId;
            Date creationDate = new Date();
            ImmutableCell resultCell = ImmutableCell.newInst(cellId, creationDate.getTime()).withTechId(SeaOfGatesCellBuilder.this.oldCellBackup.cellRevision.d.techId);
            this.cellBackup = CellBackup.newInst(resultCell, SeaOfGatesCellBuilder.this.oldTechPool);
        }

        int getNextNodeId() {
            return this.nodes.size();
        }

        Name getNextName() {
            return Name.findName("plnode@" + this.getNextNodeId());
        }

        @Override
        protected void addPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            if (style != Poly.Type.CROSSED || numPoints == 0) {
                if (Job.getDebug()) {
                    System.out.println("ERROR: Poly style is not cross or numPoints is zero: " + String.valueOf((Object)style) + ", " + numPoints);
                }
                return;
            }
            assert (style == Poly.Type.CROSSED && numPoints > 0);
            long fixpLX = Long.MAX_VALUE;
            long fixpLY = Long.MAX_VALUE;
            long fixpHX = Long.MIN_VALUE;
            long fixpHY = Long.MIN_VALUE;
            for (int i2 = 0; i2 < numPoints; ++i2) {
                long x = this.coords[i2 * 2];
                long y = this.coords[i2 * 2 + 1];
                fixpLX = Math.min(fixpLX, x);
                fixpLY = Math.min(fixpLY, y);
                fixpHX = Math.max(fixpHX, x);
                fixpHY = Math.max(fixpHY, y);
            }
            assert (fixpLX <= fixpHX && fixpLY <= fixpHY);
            int nodeId = this.getNextNodeId();
            PrimitiveNodeId protoId = layer.getPureLayerNode().getId();
            Name name = this.getNextName();
            EPoint anchor = EPoint.fromFixp(fixpLX + fixpHX >> 1, fixpLY + fixpHY >> 1);
            EPoint size = EPoint.fromFixp(fixpHX - fixpLX, fixpHY - fixpLY);
            this.nodes.add(ImmutableNodeInst.newInst(nodeId, protoId, name, this.nameTd, Orientation.IDENT, anchor, size, 0, 0, this.protoTd));
        }

        @Override
        protected void addBox(Layer layer) {
            int nodeId = this.getNextNodeId();
            PrimitiveNodeId protoId = layer.getPureLayerNode().getId();
            Name name = this.getNextName();
            long fixpLX = this.coords[0];
            long fixpLY = this.coords[1];
            long fixpHX = this.coords[2];
            long fixpHY = this.coords[3];
            EPoint anchor = EPoint.fromFixp(fixpLX + fixpHX >> 1, fixpLY + fixpHY >> 1);
            EPoint size = EPoint.fromFixp(fixpHX - fixpLX, fixpHY - fixpLY);
            this.nodes.add(ImmutableNodeInst.newInst(nodeId, protoId, name, this.nameTd, Orientation.IDENT, anchor, size, 0, 0, this.protoTd));
        }

        CellBackup commit() {
            this.cellBackup = this.cellBackup.with(this.cellBackup.cellRevision.d, this.nodes.toArray(new ImmutableNodeInst[this.nodes.size()]), null, null, SeaOfGatesCellBuilder.this.oldTechPool);
            return this.cellBackup;
        }
    }

    private static class MaxNodeSuffix {
        final Name basename;
        final int insertionPoint;
        int maxSuffix;
        List<ImmutableNodeInst> addedNodes = new ArrayList<ImmutableNodeInst>();

        private MaxNodeSuffix(SeaOfGatesCellBuilder b2, Name basename) {
            Name name;
            this.basename = basename;
            this.insertionPoint = b2.searchNodeInsertionPoint(basename.toString());
            this.maxSuffix = -1;
            if (this.insertionPoint > 0 && (name = b2.oldCellRevision.nodes.get((int)(this.insertionPoint - 1)).name).isTempname() && name.getBasename() == basename) {
                this.maxSuffix = name.getNumSuffix();
            }
        }

        private Name getNextName() {
            return this.basename.findSuffixed(this.maxSuffix + 1);
        }

        private void add(ImmutableNodeInst n2) {
            ++this.maxSuffix;
            assert (n2.name.getBasename() == this.basename);
            assert (n2.name.getNumSuffix() == this.maxSuffix);
            this.addedNodes.add(n2);
        }
    }
}

