/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore2.BenchmarkRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore2.DetailedRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RoutingFrameLeeMoore
extends BenchmarkRouter {
    static final boolean IS_DEBUG = false;
    private RoutingFrame.RoutingLayer[] metalLayers;
    List<RoutingFrame.RoutingContact> allContacts;

    @Override
    public String getAlgorithmName() {
        return "Lee/Moore - 2";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        this.allContacts = allContacts;
        long startTime = System.currentTimeMillis();
        int numMetalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++numMetalLayers;
        }
        this.metalLayers = new RoutingFrame.RoutingLayer[numMetalLayers + 1];
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            this.metalLayers[rl.getMetalNumber()] = rl;
        }
        double minWidth = Double.MIN_VALUE;
        for (RoutingFrame.RoutingLayer lay : this.metalLayers) {
            if (lay == null) continue;
            minWidth = Math.max(lay.getMinWidth(), minWidth);
        }
        double wireSpacing = Double.MIN_VALUE;
        for (RoutingFrame.RoutingLayer lay : this.metalLayers) {
            if (null == lay) continue;
            wireSpacing = Math.max(lay.getMinSpacing(lay), wireSpacing);
        }
        double maxSurr = Double.MIN_VALUE;
        for (RoutingFrame.RoutingLayer lay : this.metalLayers) {
            if (lay == null) continue;
            maxSurr = Math.max(lay.getMaxSurround(), maxSurr);
        }
        double tileSize = maxSurr + minWidth;
        List<Integer> unrouted = null;
        ArrayList<GlobalRouterV3.RouteToStitch> routes = new ArrayList<GlobalRouterV3.RouteToStitch>();
        GlobalRouterV3 global_router = null;
        DetailedRouter dr = null;
        long timeLeft = 0L;
        int lastUnroutedSize = segmentsToRoute.size();
        int noProgress = 0;
        do {
            if (global_router == null) {
                int num_regions = (int)Math.ceil(Math.sqrt(this.numThreads.getIntValue()));
                num_regions = num_regions <= 1 ? 2 : num_regions;
                global_router = new GlobalRouterV3(cell.getBounds(), num_regions, segmentsToRoute, this.numThreads.getIntValue(), tileSize);
            } else {
                global_router.Reinitialize(unrouted);
            }
            global_router.StartGlobalRouting();
            Collection<GlobalRouterV3.RouteToStitch> cur_routes = global_router.output_coarse_routes.values();
            GlobalRouterV3.RegionToRoute[] regions = global_router.output_regions;
            if (dr == null) {
                dr = new DetailedRouter(this.numThreads.getIntValue(), this.metalLayers, regions, tileSize, this.enableOutput.getBooleanValue());
            }
            dr.setRegions(regions);
            timeLeft = (long)this.maxRuntime.getIntValue() - (System.currentTimeMillis() - startTime) / 1000L;
            dr.setTimeout(timeLeft);
            dr.start();
            dr.writeSolution();
            unrouted = dr.getUnroutables();
            for (GlobalRouterV3.RouteToStitch single_route : cur_routes) {
                if (unrouted.contains(single_route.id)) continue;
                routes.add(single_route);
            }
            timeLeft = (long)this.maxRuntime.getIntValue() - (System.currentTimeMillis() - startTime) / 1000L;
            noProgress = global_router.wiried_routes.size() == lastUnroutedSize ? ++noProgress : 0;
            lastUnroutedSize = global_router.wiried_routes.size();
        } while (unrouted.size() > 0 && timeLeft > 0L && noProgress <= 10);
        for (GlobalRouterV3.RouteToStitch to_stitch : routes) {
            Iterator<SegPart> ts_it = to_stitch.coarse_route.iterator();
            List<Coordinate> stitched_list = new ArrayList<Coordinate>();
            while (ts_it.hasNext()) {
                SegPart cur_patch = ts_it.next();
                Iterator<Coordinate> i2 = cur_patch.segment_part.iterator();
                while (i2.hasNext()) {
                    Coordinate co = i2.next();
                    if (!i2.hasNext() && ts_it.hasNext()) continue;
                    stitched_list.add(co);
                }
            }
            global_router.Retransform(stitched_list);
            stitched_list = this.minimizeCoordinateRoute(stitched_list);
            this.correctStartEnd(stitched_list);
            this.doWiring(to_stitch.seg_head_tail, stitched_list);
        }
    }

    private void correctStartEnd(List<Coordinate> route) {
        Coordinate start = route.get(0);
        Coordinate start_succ = route.get(1);
        Coordinate start_link = this.addCornerPoint(start, start_succ);
        route.add(1, start_link);
        if (route.size() > 3) {
            Coordinate end = route.get(route.size() - 1);
            Coordinate end_prev = route.get(route.size() - 2);
            Coordinate end_link = this.addCornerPoint(end, end_prev);
            route.add(route.size() - 1, end_link);
        }
    }

    private Coordinate addCornerPoint(Coordinate precise, Coordinate non_precise) {
        Coordinate ret = new Coordinate(-1.0, -1.0, precise.layer);
        if (precise.layer % 2 == 0) {
            ret.x = non_precise.x;
            ret.y = precise.y;
        } else {
            ret.x = precise.x;
            ret.y = non_precise.y;
        }
        return ret;
    }

    public void adjustLayers(Collection<GlobalRouterV3.RouteToStitch> routes, double tileSize) {
        for (GlobalRouterV3.RouteToStitch rts : routes) {
            int lastLayer = rts.coarse_route.get((int)0).segment_part.get(0).getLayer();
            int finishLayer = rts.coarse_route.get((int)(rts.coarse_route.size() - 1)).segment_part.get(1).getLayer();
            for (int i2 = 0; i2 < rts.coarse_route.size() - 1; ++i2) {
                SegPart sp = rts.coarse_route.get(i2);
                assert (sp.segment_part.size() == 2);
                Coordinate c2 = sp.segment_part.get(1);
                assert (rts.coarse_route.get((int)(i2 + 1)).segment_part.get((int)0).alignment == c2.alignment);
                assert (rts.coarse_route.get((int)(i2 + 1)).segment_part.get(0) == c2);
                assert (c2.alignment != ManhattenAlignment.ma_undefined);
                if ((c2.alignment != ManhattenAlignment.ma_horizontal || c2.layer % 2 == 1) && (c2.alignment != ManhattenAlignment.ma_vertical || c2.layer % 2 == 0)) continue;
                this.incOrDecLayer(c2, lastLayer, finishLayer);
                lastLayer = c2.getLayer();
            }
        }
    }

    public void incOrDecLayer(Coordinate c2, int lastLayer, int finishLayer) {
        int dz = (int)Math.signum(finishLayer - lastLayer);
        if (dz == 0) {
            dz = -1;
        }
        if (0 < c2.layer + dz && c2.layer + dz < this.metalLayers.length) {
            c2.layer += dz;
        } else if (0 < c2.layer - dz && c2.layer - dz < this.metalLayers.length) {
            c2.layer -= dz;
        }
    }

    private void doWiring(RoutingFrame.RoutingSegment rs, List<Coordinate> coords) {
        RoutingFrame.RoutePoint rpStart = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, coords.get(0).getLocation(), 0);
        rs.addWireEnd(rpStart);
        RoutingFrame.RoutePoint fromRP = rpStart;
        RoutingFrame.RoutingLayer fromLayer = this.metalLayers[coords.get((int)0).layer];
        for (int i2 = 1; i2 < coords.size() - 1; ++i2) {
            RoutingFrame.RoutingLayer toLayer = this.metalLayers[coords.get(i2).getLayer()];
            RoutingFrame.RoutingContact rc = this.getContact(coords, i2);
            RoutingFrame.RoutePoint toRP = new RoutingFrame.RoutePoint(rc, coords.get(i2).getLocation(), 0);
            RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(toLayer, toRP, fromRP, toLayer.getMinWidth());
            if (fromLayer == toLayer || this.isVia(coords, i2)) {
                rs.addWireEnd(toRP);
                rs.addWire(rw);
                fromRP = toRP;
            }
            fromLayer = toLayer;
        }
        RoutingFrame.RoutePoint rpFinish = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, coords.get(coords.size() - 1).getLocation(), 0);
        rs.addWireEnd(rpFinish);
        RoutingFrame.RoutingLayer layer = this.metalLayers[coords.get(coords.size() - 1).getLayer()];
        RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(layer, rpFinish, fromRP, layer.getMinWidth());
        rs.addWire(rw);
    }

    private List<Coordinate> minimizeCoordinateRoute(List<Coordinate> lc) {
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        result.add(lc.get(0));
        for (int i2 = 1; i2 < lc.size() - 1; ++i2) {
            Coordinate pre = lc.get(i2 - 1);
            Coordinate c2 = lc.get(i2);
            Coordinate succ = lc.get(i2 + 1);
            if (pre.layer != c2.layer || c2.layer != succ.layer) {
                result.add(c2);
                continue;
            }
            if (Math.abs(pre.x - c2.x) < 0.001 && Math.abs(c2.x - succ.x) < 0.001 || Math.abs(pre.y - c2.y) < 0.001 && Math.abs(c2.y - succ.y) < 0.001) continue;
            result.add(c2);
        }
        result.add(lc.get(lc.size() - 1));
        return result;
    }

    public RoutingFrame.RoutingContact getVia(RoutingFrame.RoutingLayer l1, RoutingFrame.RoutingLayer l2) {
        for (RoutingFrame.RoutingContact rc : this.allContacts) {
            if ((!rc.getFirstLayer().equals(l1) || !rc.getSecondLayer().equals(l2)) && (!rc.getFirstLayer().equals(l2) || !rc.getSecondLayer().equals(l1))) continue;
            return rc;
        }
        return null;
    }

    public RoutingFrame.RoutingContact getContact(List<Coordinate> coords, int i2) {
        if (this.isVia(coords, i2)) {
            return this.getVia(this.metalLayers[coords.get(i2).getLayer()], this.metalLayers[coords.get(i2 + 1).getLayer()]);
        }
        return this.metalLayers[coords.get(i2).getLayer()].getPin();
    }

    public boolean isVia(List<Coordinate> coords, int i2) {
        return i2 < coords.size() - 1 && coords.get(i2).getLayer() != coords.get(i2 + 1).getLayer();
    }

    public static class Coordinate {
        double x;
        double y;
        int layer;
        ManhattenAlignment alignment = ManhattenAlignment.ma_undefined;

        public Coordinate(double x, double y, int z, ManhattenAlignment alignment) {
            this.x = x;
            this.y = y;
            this.layer = z;
            this.alignment = alignment;
        }

        public Coordinate(double x, double y, int z) {
            this.x = x;
            this.y = y;
            this.layer = z;
        }

        public Point2D getLocation() {
            return new Point2D.Double(this.x, this.y);
        }

        public int getLayer() {
            return this.layer;
        }
    }

    static enum ManhattenAlignment {
        ma_horizontal,
        ma_vertical,
        ma_undefined;

    }

    class RoutingIterationAnalysis {
        int iteration;
        long global_ns;
        long detailed_ns;
        int wires_routed;

        RoutingIterationAnalysis() {
        }
    }
}

