/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.concurrency;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarRegionNode;
import com.sun.electric.tool.routing.experimentalAStar2.concurrency.GlobalRouteJob;
import com.sun.electric.tool.routing.experimentalAStar2.concurrency.LocalRouteJob;
import com.sun.electric.tool.routing.experimentalAStar2.concurrency.LocalRouteJobComparator;
import com.sun.electric.tool.routing.experimentalAStar2.concurrency.RouteJob;
import com.sun.electric.tool.routing.experimentalAStar2.datastructures.Point3D;
import com.sun.electric.tool.routing.experimentalAStar2.map.FieldMap;
import com.sun.electric.tool.routing.experimentalAStar2.map.RegionBoundingBox;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.AStarNodeObjectPool;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.AStarRegionNodeObjectPool;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.LinkedListObjectPool;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectFactory;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMain {
    private static Logger logger = LoggerFactory.getLogger(RoutingMain.class);
    public static final int MAX_REVOLUTIONS = 300000;
    private static final int MAX_RETRIES = 1;
    private int layerCount;
    private AStarMapBase<AStarRegionNode> regionGrid;
    private int numRegionsPerSide;
    public static int regionWidth;
    public static int regionHeight;
    private long maxRuntimeMillis;
    private ExecutorService threadPool;
    private ExecutorCompletionService<GlobalRouteJob> globalCompletionService;
    private ExecutorCompletionService<LocalRouteJob> localCompletionService;
    ObjectPool<GlobalRouteJob> globalRouteJobPool;
    private int routeJobCount;
    private int completedRouteJobCount;
    private List<RouteJob> waitingRouteJobs = new LinkedList<RouteJob>();

    public int getProgress() {
        return Math.min(this.completedRouteJobCount * 100 / this.routeJobCount, 100);
    }

    public void setMaxRuntimeMillis(long maxRuntimeMillis) {
        this.maxRuntimeMillis = maxRuntimeMillis;
    }

    public RoutingMain(int width, int height, int layerCount, int threadPoolSize) {
        assert (layerCount > 0);
        this.layerCount = layerCount;
        this.numRegionsPerSide = Math.min(16, Math.max(1, threadPoolSize / 2));
        regionWidth = width / this.numRegionsPerSide;
        regionHeight = height / this.numRegionsPerSide;
        FieldMap<AStarRegionNode> newGrid = new FieldMap<AStarRegionNode>(this.numRegionsPerSide, this.numRegionsPerSide, layerCount, 0, 0, 0);
        newGrid.setObjectPool(new AStarRegionNodeObjectPool());
        this.regionGrid = newGrid;
        for (int x = 0; x < this.numRegionsPerSide; ++x) {
            for (int y = 0; y < this.numRegionsPerSide; ++y) {
                for (int z = 0; z < layerCount; ++z) {
                    FieldMap<AStarNode> newRoutingMap = new FieldMap<AStarNode>(regionWidth, regionHeight, 1, 0, 0, 0);
                    newRoutingMap.setObjectPool(new AStarNodeObjectPool());
                    AStarRegionNode node = new AStarRegionNode(newRoutingMap, regionWidth, regionHeight, x, y, z);
                    newGrid.setNode(x, y, z, node);
                }
            }
        }
        this.threadPool = Executors.newFixedThreadPool(threadPoolSize);
        this.localCompletionService = new ExecutorCompletionService(this.threadPool);
        this.globalCompletionService = new ExecutorCompletionService(this.threadPool);
        this.globalRouteJobPool = new LinkedListObjectPool<GlobalRouteJob>(50, new ObjectFactory<GlobalRouteJob>(){

            @Override
            public GlobalRouteJob create() {
                return new GlobalRouteJob();
            }
        });
        this.routeJobCount = 0;
        this.completedRouteJobCount = 0;
    }

    public void submitRouteJob(RouteJob job) {
        RegionBoundingBox boundingBox;
        Point3D from = job.from;
        Point3D to = job.to;
        this.setTileBlocked(from.getX(), from.getY(), from.getZ(), true);
        this.setTileBlocked(to.getX(), to.getY(), to.getZ(), true);
        assert (this.regionGrid != null);
        job.boundingBox = boundingBox = new RegionBoundingBox(this.regionGrid, this.nodeToRegionX(from.getX()), this.nodeToRegionY(from.getY()), from.getZ(), this.nodeToRegionX(to.getX()), this.nodeToRegionY(to.getY()), to.getZ());
        ++this.routeJobCount;
        this.waitingRouteJobs.add(job);
    }

    private void submitPossibleGlobalJobs() {
        Iterator<RouteJob> i2 = this.waitingRouteJobs.iterator();
        while (i2.hasNext()) {
            RouteJob job = i2.next();
            if (!job.boundingBox.isBoundingBoxFree()) continue;
            i2.remove();
            job.boundingBox.occupyBoundingBox();
            GlobalRouteJob globalJob = this.globalRouteJobPool.acquire();
            this.setTileBlocked(job.from.getX(), job.from.getY(), job.from.getZ(), false);
            this.setTileBlocked(job.to.getX(), job.to.getY(), job.to.getZ(), false);
            Point3D from = new Point3D(this.nodeToRegionX(job.from.getX()), this.nodeToRegionY(job.from.getY()), job.from.getZ());
            Point3D to = new Point3D(this.nodeToRegionX(job.to.getX()), this.nodeToRegionY(job.to.getY()), job.to.getZ());
            Point3D fromInsideRegion = new Point3D(this.nodeGlobalToLocalX(job.from.getX()), this.nodeGlobalToLocalY(job.from.getY()), 0);
            Point3D toInsideRegion = new Point3D(this.nodeGlobalToLocalX(job.to.getX()), this.nodeGlobalToLocalY(job.to.getY()), 0);
            globalJob.initialize(job, from, to, fromInsideRegion, toInsideRegion);
            this.globalCompletionService.submit(globalJob);
        }
    }

    public void handleLocalRouteJobFinished(LocalRouteJob finishedJob) {
        if (finishedJob.path != null) {
            for (Point3D pt : finishedJob.path) {
                pt.setZ(finishedJob.regionalNode.getZ());
            }
        }
        finishedJob.routeJob.localRouteJobsCompleted.add(finishedJob);
        if (finishedJob.routeJob.localRouteJobsList.size() != finishedJob.routeJob.localRouteJobsCompleted.size()) {
            return;
        }
        this.setTileBlocked(finishedJob.routeJob.from.getX(), finishedJob.routeJob.from.getY(), finishedJob.routeJob.from.getZ(), true);
        this.setTileBlocked(finishedJob.routeJob.to.getX(), finishedJob.routeJob.to.getY(), finishedJob.routeJob.to.getZ(), true);
        Collections.sort(finishedJob.routeJob.localRouteJobsCompleted, new LocalRouteJobComparator());
        ArrayList<Point3D> totalPath = new ArrayList<Point3D>();
        for (LocalRouteJob lrj : finishedJob.routeJob.localRouteJobsCompleted) {
            if (lrj.getPath() == null) {
                finishedJob.path = null;
                finishedJob.routeJob.path = null;
                ++this.completedRouteJobCount;
                finishedJob.routeJob.onCompletion();
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                this.submitPossibleGlobalJobs();
                return;
            }
            for (Point3D pt : lrj.getPath()) {
                Point3D pt2 = new Point3D(this.nodeLocalToGlobalX(pt.getX(), lrj.regionalNode), this.nodeLocalToGlobalY(pt.getY(), lrj.regionalNode), pt.getZ());
                totalPath.add(pt2);
            }
        }
        for (Point3D pt : totalPath) {
            this.setTileBlocked(pt.getX(), pt.getY(), pt.getZ(), true);
        }
        finishedJob.routeJob.path = totalPath;
        ++this.completedRouteJobCount;
        finishedJob.routeJob.boundingBox.releaseBoundingBox();
        this.submitPossibleGlobalJobs();
        finishedJob.routeJob.onCompletion();
    }

    public void handleGlobalRouteJobFinished(GlobalRouteJob finishedJob) {
        List<AStarRegionNode> path = finishedJob.resultPath;
        if (path == null) {
            if (finishedJob.routeJob.retries < 1) {
                ++finishedJob.routeJob.retries;
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                finishedJob.routeJob.boundingBox.enlarge();
                this.waitingRouteJobs.add(finishedJob.routeJob);
            } else {
                this.setTileBlocked(finishedJob.routeJob.from.getX(), finishedJob.routeJob.from.getY(), finishedJob.routeJob.from.getZ(), true);
                this.setTileBlocked(finishedJob.routeJob.to.getX(), finishedJob.routeJob.to.getY(), finishedJob.routeJob.to.getZ(), true);
                ++this.completedRouteJobCount;
                finishedJob.routeJob.boundingBox.releaseBoundingBox();
                finishedJob.routeJob.path = null;
                finishedJob.routeJob.onCompletion();
            }
        } else {
            int i2 = 0;
            while (i2 < path.size()) {
                AStarRegionNode rn = path.get(i2);
                if (i2 < path.size() - 1) {
                    AStarRegionNode nextRegion = path.get(i2 + 1);
                    AStarNode entryPoint = path.get(i2 + 1).getEntryPoint();
                    if (nextRegion.getX() < rn.getX()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(0, entryPoint.getY(), 0));
                    } else if (nextRegion.getX() > rn.getX()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(regionWidth - 1, entryPoint.getY(), 0));
                    } else if (nextRegion.getY() < rn.getY()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), 0, 0));
                    } else if (nextRegion.getY() > rn.getY()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), regionHeight - 1, 0));
                    } else if (nextRegion.getZ() != rn.getZ()) {
                        rn.setExitPoint(rn.getMap(true).nodeAt(entryPoint.getX(), entryPoint.getY(), 0));
                    }
                }
                LocalRouteJob localRoute = new LocalRouteJob();
                localRoute.from = new Point3D(rn.getEntryPoint().getX(), rn.getEntryPoint().getY(), rn.getEntryPoint().getZ());
                localRoute.to = new Point3D(rn.getExitPoint().getX(), rn.getExitPoint().getY(), rn.getExitPoint().getZ());
                localRoute.routeJob = finishedJob.getRouteJob();
                localRoute.regionalNode = rn;
                localRoute.numberInGlobalPath = i2++;
                localRoute.routeJob.localRouteJobsList.add(localRoute);
                this.localCompletionService.submit(localRoute);
            }
        }
        this.globalRouteJobPool.release(finishedJob);
        this.submitPossibleGlobalJobs();
    }

    public void waitForCompletion() {
        long startTimeMillis;
        long currentTimeMillis = startTimeMillis = System.currentTimeMillis();
        this.submitPossibleGlobalJobs();
        while (this.completedRouteJobCount < this.routeJobCount) {
            if (currentTimeMillis - startTimeMillis > this.maxRuntimeMillis) {
                logger.debug("timeout ...");
                break;
            }
            try {
                Future<GlobalRouteJob> globalJob;
                Future<LocalRouteJob> localJob = this.localCompletionService.poll();
                if (localJob != null) {
                    this.handleLocalRouteJobFinished(localJob.get());
                }
                if ((globalJob = this.globalCompletionService.poll()) != null) {
                    this.handleGlobalRouteJobFinished(globalJob.get());
                }
                currentTimeMillis = System.currentTimeMillis();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            catch (ExecutionException e3) {
                e3.printStackTrace();
            }
        }
        this.shutDown();
    }

    public void shutDown() {
        this.threadPool.shutdownNow();
    }

    public void setBlockage(int sx, int sy, int ex, int ey) {
        for (int x = sx; x <= ex; ++x) {
            this.setTileBlockedAllLayers(x, sy);
            this.setTileBlockedAllLayers(x, ey);
        }
        for (int y = sy; y <= ey; ++y) {
            this.setTileBlockedAllLayers(sx, y);
            this.setTileBlockedAllLayers(ex, y);
        }
    }

    public void setBlockage(int sx, int sy, int ex, int ey, int z) {
        for (int x = sx; x <= ex; ++x) {
            this.setTileBlocked(x, sy, z, true);
            this.setTileBlocked(x, ey, z, true);
        }
        for (int y = sy; y <= ey; ++y) {
            this.setTileBlocked(sx, y, z, true);
            this.setTileBlocked(ex, y, z, true);
        }
    }

    private void setTileBlocked(int x, int y, int z, boolean blockedStatus) {
        AStarRegionNode node = this.nodeCoordsToRegion(x, y, z);
        assert (node != null);
        node.routingMap.setTileBlocked(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0, blockedStatus);
    }

    private void setTileBlockedAllLayers(int x, int y) {
        for (int z = 0; z < this.layerCount; ++z) {
            AStarRegionNode node = this.nodeCoordsToRegion(x, y, z);
            assert (node != null);
            node.routingMap.setTileBlocked(this.nodeGlobalToLocalX(x), this.nodeGlobalToLocalY(y), 0, true);
        }
    }

    public void placePortals() {
        int maxXNodes = this.regionGrid.getMaxXNodes();
        int maxYNodes = this.regionGrid.getMaxYNodes();
        int maxZNodes = this.regionGrid.getMaxZNodes();
        for (int x = 0; x < maxXNodes; ++x) {
            for (int y = 0; y < maxYNodes; ++y) {
                for (int z = 0; z < maxZNodes; ++z) {
                    int rX;
                    AStarRegionNode neighbourRegion;
                    AStarRegionNode myRegion = this.regionGrid.nodeAt(x, y, z);
                    if (x + 1 < maxXNodes) {
                        neighbourRegion = this.regionGrid.nodeAt(x + 1, y, z);
                        for (rY = 0; rY < regionHeight; ++rY) {
                            if (myRegion.isTileBlocked(regionWidth - 1, rY) || neighbourRegion.isTileBlocked(0, rY)) continue;
                            myRegion.setPortal(regionWidth - 1, rY, false);
                            neighbourRegion.setPortal(0, rY, false);
                        }
                        if (x == 0) {
                            for (rY = 0; rY < regionHeight; ++rY) {
                                if (myRegion.isTileBlocked(0, rY)) continue;
                                myRegion.setPortal(0, rY, false);
                            }
                        }
                    } else {
                        for (rY = 0; rY < regionHeight; ++rY) {
                            if (myRegion.isTileBlocked(regionWidth - 1, rY)) continue;
                            myRegion.setPortal(regionWidth - 1, rY, false);
                        }
                    }
                    if (y > 0) {
                        neighbourRegion = this.regionGrid.nodeAt(x, y - 1, z);
                        for (rX = 0; rX < regionWidth; ++rX) {
                            if (myRegion.isTileBlocked(rX, 0) || neighbourRegion.isTileBlocked(rX, regionHeight - 1)) continue;
                            myRegion.setPortal(rX, 0, true);
                            neighbourRegion.setPortal(rX, regionHeight - 1, true);
                        }
                        if (y != maxYNodes - 1) continue;
                        for (rX = 0; rX < regionWidth; ++rX) {
                            if (myRegion.isTileBlocked(rX, regionHeight - 1)) continue;
                            myRegion.setPortal(rX, regionHeight - 1, true);
                        }
                        continue;
                    }
                    for (rX = 0; rX < regionWidth; ++rX) {
                        if (myRegion.isTileBlocked(rX, 0)) continue;
                        myRegion.setPortal(rX, 0, true);
                    }
                }
            }
        }
    }

    private int nodeToRegionX(int x) {
        return (int)Math.floor(x / regionWidth);
    }

    private int nodeToRegionY(int y) {
        return (int)Math.floor(y / regionHeight);
    }

    private int nodeGlobalToLocalX(int x) {
        return x % regionWidth;
    }

    private int nodeGlobalToLocalY(int y) {
        return y % regionHeight;
    }

    private int nodeLocalToGlobalX(int x, AStarRegionNode whichRegion) {
        return x + this.regionToNodeX(whichRegion.getX());
    }

    private int nodeLocalToGlobalY(int y, AStarRegionNode whichRegion) {
        return y + this.regionToNodeY(whichRegion.getY());
    }

    private int regionToNodeX(int x) {
        return x * regionWidth;
    }

    private int regionToNodeY(int y) {
        return y * regionHeight;
    }

    private AStarRegionNode nodeCoordsToRegion(int x, int y, int z) {
        return this.regionGrid.nodeAt(this.nodeToRegionX(x), this.nodeToRegionY(y), z);
    }
}

