/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.QuadTree;

public class Map {
    private int[][][] map;
    private QuadTree[] quadTrees;
    static final int X = -3;
    static final int CLEAR = 0;
    private int dispX;
    private int dispY;
    private double scalingFactor;
    private int width;
    private int height;

    public Map(double minWidth, int widthUnscaled, int heightUnscaled, int layers, int dispX, int dispY) {
        this.scalingFactor = minWidth;
        assert (this.scalingFactor >= 1.0) : this.scalingFactor;
        this.width = (int)Math.ceil((double)widthUnscaled / this.scalingFactor);
        this.height = (int)Math.ceil((double)heightUnscaled / this.scalingFactor);
        this.map = new int[layers][this.width][this.height];
        this.quadTrees = new QuadTree[layers];
        for (int i2 = 0; i2 < layers; ++i2) {
            this.quadTrees[i2] = new QuadTree(this.width, this.height);
        }
        this.dispX = dispX;
        this.dispY = dispY;
    }

    public int getDispX() {
        return this.dispX;
    }

    public int getDispY() {
        return this.dispY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public int getLayers() {
        return this.map.length;
    }

    public int getStatus(int x, int y, int z) {
        return this.map[z][x][y];
    }

    public int getSpaceAround(int x, int y, int z) {
        return this.quadTrees[z].spaceAt(x, y);
    }

    public void setStatus(int x, int y, int z, int status) {
        this.map[z][x][y] = status;
        assert (status != 0);
        this.quadTrees[z].add(x, y);
    }

    public void setStatus(int[] x, int[] y, int[] z, int status) {
        assert (status != 0);
        for (int i2 = 0; i2 < x.length; ++i2) {
            this.map[z[i2]][x[i2]][y[i2]] = status;
            this.quadTrees[z[i2]].add(x[i2], y[i2]);
        }
    }
}

