/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.EndPoint;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import com.sun.electric.tool.routing.experimentalAStar1.Net;
import com.sun.electric.tool.routing.experimentalAStar1.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class EndPointMarker {
    private boolean DEBUG = false;
    private static final int CLEAR = 0;
    private static final int CORE_BLOCKED = -1;
    private static final int CORE_FREE_SURROUNDING_BLOCKED = -2;
    private static Random random = new Random(8682522807148012L);
    Map map;

    public EndPointMarker(Map map) {
        this.map = map;
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
    }

    public void markStartAndFinish(List<Net> netList) {
        int netID;
        long start = 0L;
        if (this.DEBUG) {
            start = System.currentTimeMillis();
        }
        ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
        for (Net net : netList) {
            net.initialize();
            List<Path> paths = net.getPaths();
            for (int pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
                Path path = paths.get(pathIndex);
                EndPoint startPoint = new EndPoint(path, net, -1);
                List<RoutingFrame.RoutingLayer> layers = path.segment.getStartLayers();
                startPoint.possibleLayers = new int[layers.size()];
                startPoint.fullyMarkedLayers = new int[layers.size()];
                for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
                    int z;
                    RoutingFrame.RoutingLayer rl = layers.get(layerIndex);
                    startPoint.possibleLayers[layerIndex] = z = rl.getMetalNumber() - 1;
                }
                endPoints.add(startPoint);
                EndPoint finishPoint = new EndPoint(path, net, -2);
                layers = path.segment.getFinishLayers();
                finishPoint.possibleLayers = new int[layers.size()];
                finishPoint.fullyMarkedLayers = new int[layers.size()];
                for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
                    int z;
                    RoutingFrame.RoutingLayer rl = layers.get(layerIndex);
                    finishPoint.possibleLayers[layerIndex] = z = rl.getMetalNumber() - 1;
                }
                endPoints.add(finishPoint);
                this.findPreferredLayer(startPoint, finishPoint);
            }
        }
        boolean repeat = true;
        while (repeat) {
            repeat = false;
            for (EndPoint endPoint : endPoints) {
                netID = endPoint.net.getNetID();
                while (endPoint.markingIndex < endPoint.possibleLayers.length) {
                    int z = endPoint.possibleLayers[endPoint.markingIndex];
                    ++endPoint.markingIndex;
                    int status = this.isEndpointFree(endPoint, z, netID, true);
                    if (status != 0) continue;
                    this.setEndpoint(endPoint, z, netID);
                    endPoint.fullyMarkedLayers[endPoint.fullyMarkedCount] = z;
                    ++endPoint.fullyMarkedCount;
                    break;
                }
                if (endPoint.markingIndex >= endPoint.possibleLayers.length) continue;
                repeat = true;
            }
        }
        for (EndPoint endPoint : endPoints) {
            netID = endPoint.net.getNetID();
            for (int i2 = 0; i2 < endPoint.possibleLayers.length; ++i2) {
                int z = endPoint.possibleLayers[i2];
                int status = this.map.getStatus(endPoint.getX(), endPoint.getY(), z);
                if (status != 0) continue;
                assert (this.isEndpointFree(endPoint, z, netID, true) == -2) : this.isEndpointFree(endPoint, z, netID, true);
                this.map.setStatus(endPoint.getX(), endPoint.getY(), z, netID);
            }
        }
        for (EndPoint endPoint : endPoints) {
            if (endPoint.fullyMarkedCount == 0) {
                endPoint.path.pathUnroutable = true;
                ++endPoint.fullyMarkedCount;
                endPoint.fullyMarkedLayers[0] = endPoint.possibleLayers[0];
            }
            endPoint.setZ();
        }
        if (this.DEBUG) {
            System.out.printf("Master: markStartAndFinish() took %d ms for %d nets\n", System.currentTimeMillis() - start, netList.size());
        }
    }

    private int isEndpointFree(EndPoint endPoint, int z, int netID, boolean checkSurrounding) {
        int x = endPoint.getX();
        int y = endPoint.getY();
        int xDiff = endPoint.isRight() ? 1 : -1;
        int yDiff = endPoint.isAbove() ? 1 : -1;
        int[] xArgs = new int[4];
        int[] yArgs = new int[4];
        xArgs[0] = x;
        yArgs[0] = y;
        xArgs[1] = x + xDiff;
        yArgs[1] = y;
        xArgs[2] = x;
        yArgs[2] = y + yDiff;
        xArgs[3] = x + xDiff;
        yArgs[3] = y + yDiff;
        int status = this.map.getStatus(xArgs[0], yArgs[0], z);
        if (status != 0 && status != netID) {
            return -1;
        }
        if (checkSurrounding) {
            for (int i2 = 1; i2 < 4; ++i2) {
                status = this.map.getStatus(xArgs[i2], yArgs[i2], z);
                if (status == 0 || status == netID) continue;
                return -2;
            }
        }
        return 0;
    }

    private void setEndpoint(EndPoint endPoint, int z, int netID) {
        int x = endPoint.getX();
        int y = endPoint.getY();
        int xDiff = endPoint.isRight() ? 1 : -1;
        int yDiff = endPoint.isAbove() ? 1 : -1;
        int[] xArgs = new int[4];
        int[] yArgs = new int[4];
        xArgs[0] = x;
        yArgs[0] = y;
        xArgs[1] = x + xDiff;
        yArgs[1] = y;
        xArgs[2] = x;
        yArgs[2] = y + yDiff;
        xArgs[3] = x + xDiff;
        yArgs[3] = y + yDiff;
        this.map.setStatus(xArgs[0], yArgs[0], z, netID);
        this.map.setStatus(xArgs[1], yArgs[1], z, netID);
        this.map.setStatus(xArgs[2], yArgs[2], z, netID);
        this.map.setStatus(xArgs[3], yArgs[3], z, netID);
        if (this.DEBUG) {
            for (int i2 = 0; i2 < 4; ++i2) {
                System.out.printf("EndPointMarker: Marking (%.2f, %.2f)(%d,%d) as #%d for net %d\n", (double)xArgs[i2] * this.map.getScalingFactor() - (double)this.map.getDispX() + this.map.getScalingFactor() / 2.0, (double)yArgs[i2] * this.map.getScalingFactor() - (double)this.map.getDispY() + this.map.getScalingFactor() / 2.0, xArgs[i2], yArgs[i2], i2, endPoint.net.getElectricNetID());
            }
        }
    }

    public void findPreferredLayer(EndPoint startPoint, EndPoint finishPoint) {
        int[] startLayerNums = startPoint.possibleLayers;
        int[] finishLayerNums = finishPoint.possibleLayers;
        int minS = startLayerNums[0];
        int maxS = startLayerNums[startLayerNums.length - 1];
        int minF = finishLayerNums[0];
        int maxF = finishLayerNums[finishLayerNums.length - 1];
        Arrays.sort(startLayerNums);
        Arrays.sort(finishLayerNums);
        int[] common = new int[startLayerNums.length];
        int commonCount = 0;
        int iFinish = 0;
        for (int iStart = 0; iStart < startLayerNums.length && iFinish != finishLayerNums.length; ++iFinish, ++iStart) {
            if (startLayerNums[iStart] != finishLayerNums[iFinish]) continue;
            common[commonCount++] = startLayerNums[iStart];
        }
        if (this.DEBUG) {
            System.out.printf("EndPointMarker.initStartFinishZ: minS:%d, maxS:%d, minF:%d, maxF:%d\n", minS, maxS, minF, maxF);
            System.out.printf("there are %d common layers: %s\n", commonCount, Arrays.toString(common));
        }
        if (commonCount > 0) {
            int idx = random.nextInt(commonCount);
            startPoint.preferLayer(common[idx]);
            finishPoint.preferLayer(common[idx]);
        }
    }
}

