/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import java.util.List;

public class CellPrinter {
    public static void printLayers(List<RoutingFrame.RoutingLayer> allLayers) {
        for (RoutingFrame.RoutingLayer layer : allLayers) {
            System.out.printf("Layer: %s, metal:%b\n", layer.getName(), layer.isMetal());
            RoutingFrame.RoutingContact pin = layer.getPin();
            if (pin == null) continue;
            System.out.printf("Pin: %s, firstLayer:%s, secondLayer:%s\n", pin.getName(), pin.getFirstLayer().getName(), pin.getSecondLayer().getName());
        }
    }

    public static void printContacts(List<RoutingFrame.RoutingContact> allContacts) {
        for (RoutingFrame.RoutingContact contact : allContacts) {
            double viaSpacing = contact.getViaSpacing();
            System.out.printf("Contact: %s, firstLayer:%s, secondLayer:%s, viaSpacing=%f\n", contact.getName(), contact.getFirstLayer().getName(), contact.getSecondLayer().getName(), viaSpacing);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printChipStatistics(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        int i2;
        void var13_16;
        int metalLayers = 0;
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            ++metalLayers;
        }
        int[] layerDistance = new int[metalLayers];
        int[] layerMembership = new int[metalLayers];
        int[][] crossLayerMembership = new int[metalLayers][metalLayers];
        int singleLayer = 0;
        int crossLayer = 0;
        int maxNetID = Integer.MIN_VALUE;
        for (RoutingFrame.RoutingSegment routingSegment : segmentsToRoute) {
            int distance;
            maxNetID = Math.max(maxNetID, routingSegment.getNetID());
            int minStart = Integer.MAX_VALUE;
            int maxStart = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : routingSegment.getStartLayers()) {
                minStart = Math.min(minStart, rl.getMetalNumber());
                maxStart = Math.max(maxStart, rl.getMetalNumber());
            }
            int minFinish = Integer.MAX_VALUE;
            int maxFinish = Integer.MIN_VALUE;
            for (RoutingFrame.RoutingLayer rl : routingSegment.getFinishLayers()) {
                minFinish = Math.min(minFinish, rl.getMetalNumber());
                maxFinish = Math.max(maxFinish, rl.getMetalNumber());
            }
            if (minStart != maxStart || minFinish != maxFinish) continue;
            int n2 = distance = Math.abs(minStart - minFinish);
            layerDistance[n2] = layerDistance[n2] + 1;
            if (minStart == minFinish) {
                ++singleLayer;
                int n3 = minStart - 1;
                layerMembership[n3] = layerMembership[n3] + 1;
                continue;
            }
            int min = Math.min(minStart, minFinish);
            int max = Math.max(minStart, minFinish);
            int[] nArray = crossLayerMembership[min - 1];
            int n4 = max - 1;
            nArray[n4] = nArray[n4] + 1;
            ++crossLayer;
        }
        int[] nets = new int[maxNetID + 1];
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int n5 = rs.getNetID();
            nets[n5] = nets[n5] + 1;
        }
        boolean bl = false;
        int maxSegments = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < nets.length; ++i3) {
            if (nets[i3] != 0) {
                ++var13_16;
            }
            maxSegments = Math.max(maxSegments, nets[i3]);
        }
        int[] numberOfSegments = new int[maxSegments];
        for (int i4 = 0; i4 < nets.length; ++i4) {
            if (nets[i4] == 0) continue;
            int n6 = nets[i4] - 1;
            numberOfSegments[n6] = numberOfSegments[n6] + 1;
        }
        int[] blockagesOnLayer = new int[metalLayers];
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            int n7 = rg.getLayer().getMetalNumber() - 1;
            blockagesOnLayer[n7] = blockagesOnLayer[n7] + 1;
        }
        System.out.println();
        System.out.println();
        System.out.print("#Metal-Layers: " + metalLayers + " { ");
        for (RoutingFrame.RoutingLayer rl : allLayers) {
            if (!rl.isMetal()) continue;
            System.out.print(rl.getMetalNumber() + ", ");
        }
        System.out.println("}\n");
        System.out.println("#Segments: " + segmentsToRoute.size());
        System.out.println("\t on one layer:  " + singleLayer);
        for (int i22 = 0; i22 < layerMembership.length; ++i22) {
            if (layerMembership[i22] == 0) continue;
            System.out.println("\t\t Metal-" + (i22 + 1) + ": " + layerMembership[i22]);
        }
        System.out.println("\t on two layers: " + crossLayer);
        for (i2 = 0; i2 < crossLayerMembership.length; ++i2) {
            for (int j2 = 0; j2 < crossLayerMembership[0].length; ++j2) {
                if (crossLayerMembership[i2][j2] == 0) continue;
                System.out.println("\t\t Metal-" + (i2 + 1) + " - Metal-" + (j2 + 1) + ": " + crossLayerMembership[i2][j2]);
            }
        }
        System.out.println();
        System.out.println("layer distance distribution");
        for (i2 = 0; i2 < layerDistance.length; ++i2) {
            if (layerDistance[i2] == 0) continue;
            System.out.println("\t distance " + i2 + ": " + layerDistance[i2]);
        }
        System.out.println();
        System.out.println("#Blockages: " + blockages.size());
        for (i2 = 0; i2 < blockagesOnLayer.length; ++i2) {
            if (blockagesOnLayer[i2] == 0) continue;
            System.out.println("\t on Metal-" + (i2 + 1) + ": " + blockagesOnLayer[i2]);
        }
        System.out.println();
        int countNumSegments = 0;
        System.out.println("#Nets: " + (int)var13_16);
        for (int i5 = 0; i5 < numberOfSegments.length; ++i5) {
            if (numberOfSegments[i5] == 0) continue;
            countNumSegments += numberOfSegments[i5] * (i5 + 1);
            System.out.print("\t " + (i5 + 1) + " segments: " + numberOfSegments[i5] + "{ ");
            for (int j3 = 0; j3 < nets.length; ++j3) {
                if (nets[j3] != i5 + 1) continue;
                System.out.print(j3 + ", ");
            }
            System.out.println("}");
        }
        System.out.println("\tsum: " + countNumSegments + " segments");
    }
}

