/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.AStarBlockageWorker;
import com.sun.electric.tool.routing.experimentalAStar1.AStarMaster;
import com.sun.electric.tool.routing.experimentalAStar1.BenchmarkRouter;
import com.sun.electric.tool.routing.experimentalAStar1.CellPrinter;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import com.sun.electric.tool.routing.experimentalAStar1.Node;
import com.sun.electric.tool.routing.experimentalAStar1.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar1.Storage;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AStarRoutingFrame
extends BenchmarkRouter {
    private boolean DEBUG = false;
    private boolean PERFORMANCE = true;
    private boolean outputEnabled = false;
    private static final long CLEANUP_TIME = 250L;
    private static AStarRoutingFrame instance;
    private int threadCount = 1;
    private int timeout = Integer.MAX_VALUE;
    private ExecutorService service;
    private Map map;
    private List<ObjectPool<Node>> nodePools;
    private List<ObjectPool<Storage>> storagePools;
    private RoutingFrame.RoutingLayer[] metalLayers;
    private RoutingFrame.RoutingContact[] metalPins;
    private int metalLayerCount;
    private int metalLayerNumMax;
    private double scalingFactor;

    public AStarRoutingFrame() {
        instance = this;
    }

    @Override
    public String getAlgorithmName() {
        return "A* - 1";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        if (segmentsToRoute.isEmpty()) {
            return;
        }
        long startTime = 0L;
        if (this.PERFORMANCE) {
            startTime = System.currentTimeMillis();
        }
        this.threadCount = this.numThreads.getIntValue();
        this.timeout = this.maxRuntime.getIntValue();
        this.outputEnabled = this.enableOutput.getBooleanValue();
        this.PERFORMANCE &= this.isOutputEnabled();
        this.DEBUG &= this.isOutputEnabled();
        long shutdownTime = System.currentTimeMillis() + (long)(this.timeout * 1000) - 250L;
        this.service = Executors.newFixedThreadPool(this.threadCount);
        this.nodePools = new ArrayList<ObjectPool<Node>>(this.threadCount);
        this.storagePools = new ArrayList<ObjectPool<Storage>>(this.threadCount);
        for (int i2 = 0; i2 < this.threadCount; ++i2) {
            this.nodePools.add(new ObjectPool<Node>(Node.class));
            this.storagePools.add(new ObjectPool<Storage>(Storage.class));
        }
        if (this.DEBUG) {
            CellPrinter.printContacts(allContacts);
            CellPrinter.printLayers(allLayers);
            CellPrinter.printChipStatistics(cell, segmentsToRoute, allLayers, allContacts, blockages);
        }
        this.processLayers(allLayers);
        this.processSpacing(allContacts);
        this.map = this.findBoundingBox(blockages, cell, segmentsToRoute);
        this.addBlockagesToMap(blockages);
        AStarMaster master = new AStarMaster(this.service, this.map, this.nodePools, this.storagePools, this.metalLayers, this.metalPins, this.threadCount, shutdownTime);
        master.runRouting(cell, segmentsToRoute, allLayers, allContacts, blockages);
        if (this.PERFORMANCE) {
            long totalTime = System.currentTimeMillis() - startTime;
            System.out.println("AStarRouting Settings: threadCount:" + this.threadCount + ", timeout:" + this.timeout);
            System.out.printf("AStarRouting total time: %d ms\n", totalTime);
        }
        this.map = null;
        this.nodePools = null;
        this.storagePools = null;
        this.metalLayers = null;
        this.metalPins = null;
    }

    private void processSpacing(List<RoutingFrame.RoutingContact> allContacts) {
        this.scalingFactor = 0.0;
        for (RoutingFrame.RoutingLayer rl : this.metalLayers) {
            double layerMin = rl.getMinWidth();
            this.scalingFactor = Math.max(this.scalingFactor, layerMin);
            if (!this.DEBUG) continue;
            double h2 = rl.getPin().getDefHeight();
            double w = rl.getPin().getDefWidth();
            double viaSpacing = rl.getPin().getViaSpacing();
            System.out.printf("Layer %d: minWireWidth is %f, defHeight=%f, defWidth=%f, viaSpacing=%f\n", rl.getMetalNumber(), rl.getMinWidth(), h2, w, viaSpacing);
        }
        this.scalingFactor *= 2.0;
        for (RoutingFrame.RoutingContact rc : allContacts) {
            double contactSpacing = rc.getViaSpacing();
            this.scalingFactor = Math.max(this.scalingFactor, contactSpacing);
            if (!this.DEBUG) continue;
            double h3 = rc.getDefHeight();
            double w = rc.getDefWidth();
            double viaSpacing = rc.getViaSpacing();
            System.out.printf("Contact %d-%d: defHeight=%f, defWidth=%f, viaSpacing=%f\n", rc.getFirstLayer().getMetalNumber(), rc.getSecondLayer().getMetalNumber(), h3, w, viaSpacing);
            for (RoutingFrame.RoutingGeometry geo : rc.getGeometry()) {
                h3 = geo.getBounds().getHeight();
                w = geo.getBounds().getWidth();
                double minX = geo.getBounds().getMinX();
                double maxX = geo.getBounds().getMaxX();
                double minY = geo.getBounds().getMinY();
                double maxY = geo.getBounds().getMaxY();
                int id = geo.getNetID();
                System.out.printf("Contact %d-%d has RoutingGeometry on Layer %d, netID %d: defHeight=%f, defWidth=%f, minX=%f, maxX=%f, minY=%f, maxY=%f\n", rc.getFirstLayer().getMetalNumber(), rc.getSecondLayer().getMetalNumber(), geo.getLayer().getMetalNumber(), id, h3, w, minX, maxX, minY, maxY);
            }
        }
        this.scalingFactor = Math.max(this.scalingFactor, 1.0);
    }

    private void processLayers(List<RoutingFrame.RoutingLayer> allLayers) {
        RoutingFrame.RoutingLayer rl;
        int i2;
        this.metalLayerCount = 0;
        this.metalLayerNumMax = 0;
        int invalidLayerMin = Integer.MAX_VALUE;
        boolean invalidLayerFound = false;
        for (i2 = 0; i2 < allLayers.size(); ++i2) {
            rl = allLayers.get(i2);
            if (!rl.isMetal()) continue;
            if (rl.getMinWidth() < 0.001) {
                invalidLayerFound = true;
                invalidLayerMin = Math.min(invalidLayerMin, rl.getMetalNumber());
                continue;
            }
            if (invalidLayerFound && rl.getMetalNumber() > invalidLayerMin) continue;
            ++this.metalLayerCount;
            this.metalLayerNumMax = Math.max(this.metalLayerNumMax, rl.getMetalNumber());
        }
        if (this.DEBUG) {
            System.out.println("metalLayers: " + this.metalLayerCount + ", maxMetalLayer: " + this.metalLayerNumMax + ", invalidLayerMin: " + invalidLayerMin);
        }
        this.metalLayers = new RoutingFrame.RoutingLayer[this.metalLayerNumMax];
        this.metalPins = new RoutingFrame.RoutingContact[this.metalLayerNumMax];
        for (i2 = 0; i2 < allLayers.size(); ++i2) {
            rl = allLayers.get(i2);
            if (!rl.isMetal()) continue;
            int num = rl.getMetalNumber();
            if (invalidLayerFound && num >= invalidLayerMin) continue;
            this.metalLayers[num - 1] = rl;
            this.metalPins[num - 1] = rl.getPin();
        }
    }

    private Map findBoundingBox(List<RoutingFrame.RoutingGeometry> blockages, Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute) {
        Rectangle2D rec;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        double dMinX = minX;
        double dMinY = minY;
        double dMaxX = maxX;
        double dMaxY = maxY;
        for (RoutingFrame.RoutingGeometry routingGeometry : blockages) {
            rec = routingGeometry.getBounds();
            dMinX = Math.min(rec.getMinX(), dMinX);
            dMinY = Math.min(rec.getMinX(), dMinY);
            dMaxX = Math.max(rec.getMaxX(), dMaxX);
            dMaxY = Math.max(rec.getMaxY(), dMaxY);
        }
        rec = cell.getBounds();
        dMinX = Math.min(rec.getMinX(), dMinX);
        dMinY = Math.min(rec.getMinY(), dMinY);
        dMaxX = Math.max(rec.getMaxX(), dMaxX);
        dMaxY = Math.max(rec.getMaxY(), dMaxY);
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            Point2D endPoint = rs.getStartEnd().getLocation();
            dMinX = Math.min(endPoint.getX(), dMinX);
            dMinY = Math.min(endPoint.getY(), dMinY);
            dMaxX = Math.max(endPoint.getX(), dMaxX);
            dMaxY = Math.max(endPoint.getY(), dMaxY);
            endPoint = rs.getFinishEnd().getLocation();
            dMinX = Math.min(endPoint.getX(), dMinX);
            dMinY = Math.min(endPoint.getY(), dMinY);
            dMaxX = Math.max(endPoint.getX(), dMaxX);
            dMaxY = Math.max(endPoint.getY(), dMaxY);
        }
        minX = (int)(Math.floor(dMinX / this.scalingFactor) * this.scalingFactor);
        minY = (int)(Math.floor(dMinY / this.scalingFactor) * this.scalingFactor);
        maxX = (int)(Math.ceil(dMaxX / this.scalingFactor) * this.scalingFactor);
        maxY = (int)(Math.ceil(dMaxY / this.scalingFactor) * this.scalingFactor);
        int numOfSafetyPoints = 5;
        int padding = (int)((double)numOfSafetyPoints * this.scalingFactor);
        int margin = 2 * padding + 1;
        int width = maxX - minX + margin;
        int height = maxY - minY + margin;
        int n2 = -minX + padding;
        int dispY = -minY + padding;
        if (this.DEBUG) {
            System.out.printf("minx: %d, miny: %d, maxx: %d, maxy: %d\n", minX, minY, maxX, maxY);
            System.out.printf("dispx: %d, dispy: %d, width: %d, height: %d\n", n2, dispY, width, height);
        }
        return new Map(this.scalingFactor, width, height, this.metalLayerNumMax, n2, dispY);
    }

    public static AStarRoutingFrame getInstance() {
        return instance;
    }

    public boolean isOutputEnabled() {
        return this.outputEnabled;
    }

    private void addBlockagesToMap(List<RoutingFrame.RoutingGeometry> blockages) {
        CountDownLatch latch = new CountDownLatch(blockages.size());
        for (RoutingFrame.RoutingGeometry block : blockages) {
            AStarBlockageWorker worker = new AStarBlockageWorker(this.map, block, latch);
            this.service.execute(worker);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            System.out.println("addBlockages(): Interrupted: " + String.valueOf(e2));
        }
    }
}

