/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.AStarWorker;
import com.sun.electric.tool.routing.experimentalAStar1.EndPointMarker;
import com.sun.electric.tool.routing.experimentalAStar1.Goal;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import com.sun.electric.tool.routing.experimentalAStar1.Net;
import com.sun.electric.tool.routing.experimentalAStar1.Node;
import com.sun.electric.tool.routing.experimentalAStar1.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar1.Path;
import com.sun.electric.tool.routing.experimentalAStar1.Storage;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class AStarMaster {
    private boolean DEBUG = false;
    private final int dispX;
    private final int dispY;
    private ExecutorCompletionService<Net> netCompletionService;
    private List<Net> netList;
    private List<Net> unroutedNetList;
    private List<Net> activeNetList = new LinkedList<Net>();
    private List<ObjectPool<Node>> nodePools;
    private List<ObjectPool<Storage>> storagePools;
    private RoutingFrame.RoutingLayer[] metalLayers;
    private RoutingFrame.RoutingContact[] metalPins;
    private List<RoutingFrame.RoutingContact> allContacts;
    private final Map map;
    private int poolSize;
    private int totalNumPaths;
    private int threadCount;
    private long shutdownTime;
    private int unroutableNetCount = 0;
    private int unroutablePathCount = 0;

    public AStarMaster(ExecutorService service, Map map, List<ObjectPool<Node>> nodePools, List<ObjectPool<Storage>> storagePools, RoutingFrame.RoutingLayer[] metalLayers, RoutingFrame.RoutingContact[] metalPins, int threadCount, long shutDownTime) {
        this.netCompletionService = new ExecutorCompletionService(service);
        this.nodePools = nodePools;
        this.storagePools = storagePools;
        this.map = map;
        this.metalLayers = metalLayers;
        this.metalPins = metalPins;
        this.threadCount = threadCount;
        this.dispX = map.getDispX();
        this.dispY = map.getDispY();
        this.poolSize = nodePools.size();
        this.shutdownTime = shutDownTime;
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        long startTime = 0L;
        long masterTimeActiveStart = 0L;
        long masterTimeWaitingStart = 0L;
        long masterTimeActiveSum = 0L;
        long masterTimeWaitingSum = 0L;
        if (this.DEBUG) {
            long currentTime;
            masterTimeActiveStart = currentTime = System.currentTimeMillis();
            startTime = currentTime;
        }
        int invalidLength = 0;
        int invalidPathSum = 0;
        int completedNetCount = 0;
        int completedPathCount = 0;
        int invalidNetSum = 0;
        EndPointMarker marker = new EndPointMarker(this.map);
        marker.markStartAndFinish(this.netList);
        this.processUnroutables();
        for (int i2 = 0; i2 < this.threadCount; ++i2) {
            this.scheduleUnroutedNet();
        }
        boolean shutdown = false;
        while (!(completedNetCount >= this.netList.size() || this.activeNetList.isEmpty() && shutdown)) {
            try {
                if (this.DEBUG) {
                    long currentTime = System.currentTimeMillis();
                    masterTimeActiveSum += currentTime - masterTimeActiveStart;
                    masterTimeWaitingStart = currentTime;
                }
                Future<Net> future = this.netCompletionService.take();
                Net net = future.get();
                if (this.DEBUG) {
                    long currentTime = System.currentTimeMillis();
                    masterTimeWaitingSum += currentTime - masterTimeWaitingStart;
                    masterTimeActiveStart = currentTime;
                }
                while (this.netList.size() - completedNetCount < this.poolSize) {
                    List<ObjectPool<Node>> currentTime = this.nodePools;
                    synchronized (currentTime) {
                        if (this.DEBUG) {
                            System.out.println("Master: removed a nodepool!");
                        }
                        this.nodePools.remove(0);
                        this.storagePools.remove(0);
                        --this.poolSize;
                    }
                }
                List<Path> paths = net.getPaths();
                boolean invalidFound = false;
                boolean[] pathInvalid = new boolean[paths.size()];
                boolean unroutablePathFound = false;
                for (int pathIdx = 0; pathIdx < paths.size(); ++pathIdx) {
                    Path path = paths.get(pathIdx);
                    if (path.pathDone) continue;
                    if (path.nodesX == null || path.pathUnroutable) {
                        if (this.DEBUG) {
                            System.err.printf("Net \"%s\": Path routing failure! totalCost %d, Path will be left untouched.\n", path.segment.getNetName(), path.totalCost);
                        }
                        if (!unroutablePathFound) {
                            ++this.unroutableNetCount;
                            unroutablePathFound = true;
                        }
                        ++this.unroutablePathCount;
                        path.pathUnroutable = true;
                        path.pathDone = true;
                        net.pathDone[pathIdx] = true;
                        continue;
                    }
                    for (int i3 = 0; i3 < path.nodesX.length; ++i3) {
                        int status = this.map.getStatus(path.nodesX[i3], path.nodesY[i3], path.nodesZ[i3]);
                        if (status == 0 || status == net.getNetID()) continue;
                        invalidFound = true;
                        pathInvalid[pathIdx] = true;
                        break;
                    }
                    if (pathInvalid[pathIdx]) continue;
                    net.pathDone[pathIdx] = true;
                    path.pathDone = true;
                    this.map.setStatus(path.nodesX, path.nodesY, path.nodesZ, net.getNetID());
                }
                boolean bl = shutdown = System.currentTimeMillis() > this.shutdownTime;
                if (invalidFound) {
                    ++invalidNetSum;
                    if (this.DEBUG) {
                        int netInvalidLength = 0;
                        int invalidPathCount = 0;
                        for (Path p : paths) {
                            if (p.pathDone || p.pathUnroutable) continue;
                            netInvalidLength += p.totalCost;
                            ++invalidPathCount;
                        }
                        invalidPathSum += invalidPathCount;
                        invalidLength += netInvalidLength;
                        System.out.printf("AStarMaster: Net %3d contains %d invalid paths, rerouting it, invalid length: %d (net est.: %4d), invalid nets: %d, completed:%d/%d\n", net.getElectricNetID(), invalidPathCount, netInvalidLength, net.getLengthEstimate(), invalidNetSum, completedNetCount, this.netList.size());
                    }
                    if (!shutdown) {
                        Goal goal = new Goal(net, this.map);
                        AStarWorker worker = new AStarWorker(net, this.nodePools, this.storagePools, this.map, goal, this.shutdownTime);
                        this.netCompletionService.submit(worker);
                        continue;
                    }
                    for (Path path : paths) {
                        if (path.pathDone && !path.pathUnroutable) {
                            this.routeSegment(path);
                        }
                        ++completedPathCount;
                    }
                    ++completedNetCount;
                    this.activeNetList.remove(net);
                    if (!this.DEBUG) continue;
                    System.out.printf("AStarMaster: shutdown now, time after shutdown threshold:%dms (Net %3d is complete, completed nets:%3d/%d, completed paths:%3d/%d)\n", System.currentTimeMillis() - this.shutdownTime, net.getElectricNetID(), completedNetCount, this.netList.size(), completedPathCount, this.totalNumPaths);
                    continue;
                }
                for (Path path : paths) {
                    if (path.pathDone && !path.pathUnroutable) {
                        this.routeSegment(path);
                    }
                    ++completedPathCount;
                }
                ++completedNetCount;
                if (this.DEBUG) {
                    System.out.printf("AStarMaster: Net %3d is complete, completed nets:%3d/%d, completed paths:%3d/%d\n", net.getElectricNetID(), completedNetCount, this.netList.size(), completedPathCount, this.totalNumPaths);
                }
                this.activeNetList.remove(net);
                if (shutdown) continue;
                this.scheduleUnroutedNet();
            }
            catch (InterruptedException e2) {
                System.err.printf("AStarMaster: Caught exception in Worker:\n%s\n", e2.toString());
                e2.getCause().printStackTrace();
                return;
            }
            catch (ExecutionException e3) {
                System.err.printf("AStarMaster: Caught exception in Worker:\n%s\n", e3.toString());
                e3.getCause().printStackTrace();
                return;
            }
        }
        assert (this.activeNetList.isEmpty());
        if (this.DEBUG) {
            long currentTime = System.currentTimeMillis();
            System.out.printf("\nAStarMaster: Routing completed after %d ms, invalid/completed nets: %d/%d (%.1f %%), invalid/completed paths: %d/%d (%.1f %%)\n", currentTime - startTime, invalidNetSum, completedNetCount, Float.valueOf(100.0f * (float)invalidNetSum / (float)completedNetCount), invalidPathSum, completedPathCount, Float.valueOf(100.0f * (float)invalidPathSum / (float)completedPathCount));
            System.out.printf("AStarMaster: Master thread waiting time: %d, active time: %d (%.1f%%)\n", masterTimeWaitingSum, masterTimeActiveSum += currentTime - masterTimeActiveStart, Float.valueOf((float)masterTimeActiveSum * 100.0f / (float)(currentTime - startTime)));
        }
        if (this.DEBUG) {
            if (this.unroutableNetCount > 0) {
                System.err.printf("Error: %d nets not routed, containing %d paths\n", this.unroutableNetCount, this.unroutablePathCount);
            }
            this.evaluateRouting(invalidLength);
        }
    }

    private void processUnroutables() {
        for (Net net : this.netList) {
            List<Path> paths = net.getPaths();
            boolean unroutablePathFound = false;
            for (int pathIdx = 0; pathIdx < paths.size(); ++pathIdx) {
                Path path = paths.get(pathIdx);
                assert (!path.pathDone) : "processUnroutables(): pathDone was already set!";
                if (!path.pathUnroutable) continue;
                if (this.DEBUG) {
                    System.err.printf("Net \"%s\": Path unroutable, Path will be left untouched.\n", path.segment.getNetName());
                }
                if (!unroutablePathFound) {
                    ++this.unroutableNetCount;
                    unroutablePathFound = true;
                }
                ++this.unroutablePathCount;
                path.pathUnroutable = true;
                path.pathDone = true;
                net.pathDone[pathIdx] = true;
            }
        }
    }

    private void scheduleUnroutedNet() {
        if (this.unroutedNetList.isEmpty()) {
            return;
        }
        long startTime = 0L;
        if (this.DEBUG) {
            startTime = System.nanoTime();
        }
        Net net = null;
        int minSum = Integer.MAX_VALUE;
        for (Net unroutedNet : this.unroutedNetList) {
            int sum = 0;
            for (Net activeNet : this.activeNetList) {
                sum += activeNet.getOverlapSum(unroutedNet);
            }
            if (sum >= minSum) continue;
            minSum = sum;
            net = unroutedNet;
            if (minSum != 0) continue;
            break;
        }
        if (this.DEBUG && minSum > 0) {
            System.out.printf("AStarMaster: Net %d scheduled with overlap %d after %.3f ms\n", net.getElectricNetID(), minSum, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f));
        }
        this.unroutedNetList.remove(net);
        this.activeNetList.add(net);
        Goal goal = new Goal(net, this.map);
        AStarWorker worker = new AStarWorker(net, this.nodePools, this.storagePools, this.map, goal, this.shutdownTime);
        this.netCompletionService.submit(worker);
    }

    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> blockages) {
        this.netList = new ArrayList<Net>();
        HashMap<Integer, Net> netMap = new HashMap<Integer, Net>();
        this.totalNumPaths = segmentsToRoute.size();
        for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            int netID = rs.getNetID();
            Net net = (Net)netMap.get(netID);
            if (net == null) {
                net = new Net(rs.getNetID());
                netMap.put(rs.getNetID(), net);
                this.netList.add(net);
            }
            net.getPaths().add(new Path(rs, this.dispX, this.dispY, this.map.getScalingFactor()));
        }
        this.sortNets();
        this.unroutedNetList = new LinkedList<Net>(this.netList);
        this.allContacts = allContacts;
        this.run();
    }

    private void evaluateRouting(int invalidLength) {
        int sum = 0;
        int estimate = 0;
        for (Net net : this.netList) {
            int netSum = 0;
            for (Path p : net.getPaths()) {
                if (!p.pathDone || p.pathUnroutable) continue;
                netSum += p.totalCost;
            }
            sum += netSum;
            int netEstimate = net.getRoutableLengthEstimate();
            estimate += netEstimate;
        }
        int diff = sum - estimate;
        System.out.printf("total routing cost: %d, estimated: %d, diff: %d (%.02f%%), invalid length: %d (%.02f%%)\n", sum, estimate, diff, Float.valueOf((float)diff * 100.0f / (float)estimate), invalidLength, Float.valueOf((float)invalidLength * 100.0f / (float)sum));
    }

    private void sortNets() {
        long start = 0L;
        if (this.DEBUG) {
            start = System.currentTimeMillis();
        }
        Collections.sort(this.netList, new Comparator<Net>(){

            @Override
            public int compare(Net n1, Net n2) {
                int len1 = n1.getLengthEstimate();
                int len2 = n2.getLengthEstimate();
                return len1 - len2;
            }
        });
        if (this.DEBUG) {
            System.out.printf("Master: sortNets() took %d ms for %d nets\n", System.currentTimeMillis() - start, this.netList.size());
        }
    }

    private void routeSegment(Path path) {
        RoutingFrame.RoutingSegment segment = path.segment;
        int[] nodesX = path.nodesX;
        int[] nodesY = path.nodesY;
        int[] nodesZ = path.nodesZ;
        Point2D startLocation = segment.getStartEnd().getLocation();
        Point2D finishLocation = segment.getFinishEnd().getLocation();
        RoutingFrame.RoutePoint previous = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, startLocation, 0);
        segment.addWireEnd(previous);
        RoutingFrame.RoutingLayer layer = this.metalLayers[nodesZ[0]];
        RoutingFrame.RoutingContact contact = this.metalPins[nodesZ[0]];
        double scalingFactor = this.map.getScalingFactor();
        boolean startRight = path.startRight;
        boolean startAbove = path.startAbove;
        boolean finishRight = path.finishRight;
        boolean finishAbove = path.finishAbove;
        if (nodesX.length < 4) {
            int connectionMode;
            assert (nodesX.length >= 1) : nodesX.length;
            if (nodesX.length == 1) {
                connectionMode = startRight != finishRight && startAbove != finishAbove ? 2 : 1;
            } else if (nodesX.length == 2) {
                boolean sameSide;
                boolean startInside;
                boolean vertical;
                boolean horizontal = nodesY[0] == nodesY[1];
                boolean bl = vertical = nodesX[0] == nodesX[1];
                boolean bl2 = horizontal && nodesX[0] < nodesX[1] == startRight || vertical && nodesY[0] < nodesY[1] == startAbove ? true : (startInside = false);
                boolean finishInside = horizontal && nodesX[0] > nodesX[1] == finishRight || vertical && nodesY[0] > nodesY[1] == finishAbove;
                boolean bl3 = sameSide = vertical && startRight == finishRight || horizontal && startAbove == finishAbove;
                connectionMode = startInside && finishInside || sameSide ? 1 : (horizontal ? 2 : 3);
            } else {
                assert (nodesX.length == 3) : nodesX.length;
                if (nodesX[0] == nodesX[2]) {
                    connectionMode = 3;
                } else if (nodesY[0] == nodesY[2]) {
                    connectionMode = 2;
                } else {
                    int quadrantStartX = (int)((startLocation.getX() + (double)this.dispX) / (scalingFactor / 2.0));
                    int quadrantStartY = (int)((startLocation.getY() + (double)this.dispY) / (scalingFactor / 2.0));
                    int quadrantFinishX = (int)((finishLocation.getX() + (double)this.dispX) / (scalingFactor / 2.0));
                    int quadrantFinishY = (int)((finishLocation.getY() + (double)this.dispY) / (scalingFactor / 2.0));
                    double middleX = this.getUnscaledCoordinate(nodesX[1], this.dispX, scalingFactor);
                    double middleY = this.getUnscaledCoordinate(nodesY[1], this.dispY, scalingFactor);
                    connectionMode = Math.abs(quadrantStartX - quadrantFinishX) <= 1 || Math.abs(quadrantStartY - quadrantFinishY) <= 1 ? 1 : (Math.abs(startLocation.getX() - middleX) <= scalingFactor || Math.abs(finishLocation.getX() - middleX) <= scalingFactor ? 3 : (Math.abs(startLocation.getY() - middleY) <= scalingFactor || Math.abs(finishLocation.getY() - middleY) <= scalingFactor ? 2 : 4));
                }
            }
            if (connectionMode == 1) {
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), finishLocation.getY()), 0);
                segment.addWireEnd(point);
                RoutingFrame.RouteWire wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            } else if (connectionMode == 2) {
                double pointY = this.getUnscaledCoordinate(nodesX.length == 3 ? nodesY[1] : nodesY[0], this.dispY, scalingFactor);
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), pointY), 0);
                segment.addWireEnd(point);
                RoutingFrame.RouteWire wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), pointY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            } else if (connectionMode == 3) {
                double pointX = this.getUnscaledCoordinate(nodesX.length == 3 ? nodesX[1] : nodesX[0], this.dispX, scalingFactor);
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, startLocation.getY()), 0);
                segment.addWireEnd(point);
                RoutingFrame.RouteWire wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, finishLocation.getY()), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            } else if (connectionMode == 4) {
                assert (nodesX.length == 3);
                double pointX = this.getUnscaledCoordinate(nodesX[1], this.dispX, scalingFactor);
                double pointY = this.getUnscaledCoordinate(nodesY[1], this.dispY, scalingFactor);
                RoutingFrame.RoutePoint point = nodesX[0] == nodesX[1] ? new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, startLocation.getY()), 0) : new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), pointY), 0);
                segment.addWireEnd(point);
                RoutingFrame.RouteWire wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, pointY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = nodesX[2] == nodesX[1] ? new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, finishLocation.getY()), 0) : new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), pointY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            }
        } else {
            RoutingFrame.RouteWire wire;
            int startOuterX = startRight ? nodesX[0] - 1 : nodesX[0] + 1;
            int startInnerX = startRight ? nodesX[0] + 1 : nodesX[0] - 1;
            int startOuterY = startAbove ? nodesY[0] - 1 : nodesY[0] + 1;
            int startInnerY = startAbove ? nodesY[0] + 1 : nodesY[0] - 1;
            int finishOuterX = finishRight ? nodesX[nodesX.length - 1] - 1 : nodesX[nodesX.length - 1] + 1;
            int finishInnerX = finishRight ? nodesX[nodesX.length - 1] + 1 : nodesX[nodesX.length - 1] - 1;
            int finishOuterY = finishAbove ? nodesY[nodesX.length - 1] - 1 : nodesY[nodesX.length - 1] + 1;
            int finishInnerY = finishAbove ? nodesY[nodesX.length - 1] + 1 : nodesY[nodesX.length - 1] - 1;
            double startGridX = this.getUnscaledCoordinate(nodesX[0], this.dispX, scalingFactor);
            double startGridY = this.getUnscaledCoordinate(nodesY[0], this.dispY, scalingFactor);
            double startInnerGridY = this.getUnscaledCoordinate(startInnerY, this.dispY, scalingFactor);
            double finishGridX = this.getUnscaledCoordinate(nodesX[nodesX.length - 1], this.dispX, scalingFactor);
            double finishGridY = this.getUnscaledCoordinate(nodesY[nodesX.length - 1], this.dispY, scalingFactor);
            double finishInnerGridY = this.getUnscaledCoordinate(finishInnerY, this.dispY, scalingFactor);
            if (nodesX[1] == startOuterX) {
                if (nodesX[2] == nodesX[1]) {
                    point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else if (nodesY[1] == startOuterY) {
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                if (nodesY[2] == nodesY[1]) {
                    point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startGridX, startGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else if (nodesX[1] == startInnerX) {
                if (nodesY[2] == startInnerY) {
                    if (nodesY[3] != nodesY[2]) {
                        point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startInnerGridY), 0);
                        segment.addWireEnd(point);
                        wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                        segment.addWire(wire);
                        previous = point;
                    }
                } else if (nodesX[2] == nodesX[1]) {
                    point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else if (nodesY[1] == startInnerY) {
                if (nodesX[2] == nodesX[1]) {
                    point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startInnerGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else {
                assert (nodesZ[1] != nodesZ[0]);
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startLocation.getX(), startGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(startGridX, startGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            }
            for (int i2 = 1; i2 < nodesX.length - 1; ++i2) {
                if (nodesZ[i2 - 1] == nodesZ[i2]) {
                    int y;
                    int x;
                    if (i2 > 1 && i2 < nodesX.length - 2 && ((x = nodesX[i2]) == nodesX[i2 - 1] && x == nodesX[i2 + 1] || (y = nodesY[i2]) == nodesY[i2 - 1] && y == nodesY[i2 + 1])) continue;
                    contact = this.metalPins[nodesZ[i2]];
                } else {
                    contact = this.getVia(this.metalLayers[nodesZ[i2 - 1]], this.metalLayers[nodesZ[i2]]);
                }
                double pointX = this.getUnscaledCoordinate(nodesX[i2], this.dispX, scalingFactor);
                double pointY = this.getUnscaledCoordinate(nodesY[i2], this.dispY, scalingFactor);
                if (i2 == 1) {
                    if (nodesX[1] == startOuterX) {
                        if (nodesX[2] != nodesX[1]) {
                            pointX = startLocation.getX();
                        }
                    } else if (nodesY[1] == startOuterY) {
                        if (nodesY[2] != nodesY[1]) {
                            pointY = startGridY;
                        }
                    } else if (nodesX[1] == startInnerX) {
                        if (nodesY[2] == startInnerY) {
                            if (nodesY[3] != nodesY[2]) {
                                pointY = startInnerGridY;
                            } else {
                                pointX = startLocation.getX();
                                pointY = startInnerGridY;
                            }
                        } else if (nodesX[2] != nodesX[1]) {
                            pointX = startLocation.getX();
                        }
                    } else if (nodesY[1] == startInnerY && nodesX[2] != nodesX[1]) {
                        pointX = startLocation.getX();
                    }
                } else if (i2 == nodesX.length - 2) {
                    if (nodesX[nodesX.length - 2] == finishOuterX) {
                        if (nodesX[nodesX.length - 3] != nodesX[nodesX.length - 2]) {
                            pointX = finishLocation.getX();
                        }
                    } else if (nodesY[nodesX.length - 2] == finishOuterY) {
                        if (nodesY[nodesX.length - 3] != nodesY[nodesX.length - 2]) {
                            pointY = finishGridY;
                        }
                    } else if (nodesX[nodesX.length - 2] == finishInnerX) {
                        if (nodesY[nodesX.length - 3] == finishInnerY) {
                            if (nodesY[nodesX.length - 4] != nodesY[nodesX.length - 3]) {
                                pointY = finishInnerGridY;
                            } else {
                                pointX = finishLocation.getX();
                                pointY = finishInnerGridY;
                            }
                        } else if (nodesX[nodesX.length - 3] != nodesX[nodesX.length - 2]) {
                            pointX = finishLocation.getX();
                        }
                    } else if (nodesY[nodesX.length - 2] == finishInnerY && nodesX[nodesX.length - 3] != nodesX[nodesX.length - 2]) {
                        pointX = finishLocation.getX();
                    }
                }
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(pointX, pointY), 0);
                segment.addWireEnd(point);
                RoutingFrame.RouteWire wire2 = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire2);
                layer = this.metalLayers[nodesZ[i2]];
                previous = point;
            }
            layer = this.metalLayers[nodesZ[nodesX.length - 1]];
            contact = this.metalPins[nodesZ[nodesX.length - 1]];
            if (nodesX[nodesX.length - 2] == finishOuterX) {
                if (nodesX[nodesX.length - 3] == nodesX[nodesX.length - 2]) {
                    RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else if (nodesY[nodesX.length - 2] == finishOuterY) {
                if (nodesY[nodesX.length - 3] == nodesY[nodesX.length - 2]) {
                    RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishGridX, finishGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            } else if (nodesX[nodesX.length - 2] == finishInnerX) {
                if (nodesY[nodesX.length - 3] == finishInnerY) {
                    if (nodesY[nodesX.length - 4] != nodesY[nodesX.length - 3]) {
                        RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishInnerGridY), 0);
                        segment.addWireEnd(point);
                        wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                        segment.addWire(wire);
                        previous = point;
                    }
                } else if (nodesX[nodesX.length - 3] == nodesX[nodesX.length - 2]) {
                    RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else if (nodesY[nodesX.length - 2] == finishInnerY) {
                if (nodesX[nodesX.length - 3] == nodesX[nodesX.length - 2]) {
                    RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishInnerGridY), 0);
                    segment.addWireEnd(point);
                    wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                    segment.addWire(wire);
                    previous = point;
                }
            } else {
                assert (nodesZ[nodesX.length - 2] != nodesZ[nodesX.length - 1]);
                RoutingFrame.RoutePoint point = new RoutingFrame.RoutePoint(this.getVia(this.metalLayers[nodesZ[nodesX.length - 2]], this.metalLayers[nodesZ[nodesX.length - 1]]), new Point2D.Double(finishGridX, finishGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(this.metalLayers[nodesZ[nodesX.length - 2]], previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
                point = new RoutingFrame.RoutePoint(contact, new Point2D.Double(finishLocation.getX(), finishGridY), 0);
                segment.addWireEnd(point);
                wire = new RoutingFrame.RouteWire(layer, previous, point, layer.getMinWidth());
                segment.addWire(wire);
                previous = point;
            }
        }
        RoutingFrame.RoutePoint finishPoint = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, finishLocation, 0);
        segment.addWireEnd(finishPoint);
        RoutingFrame.RouteWire wire = new RoutingFrame.RouteWire(layer, previous, finishPoint, layer.getMinWidth());
        segment.addWire(wire);
    }

    private double getUnscaledCoordinate(int scaledCoord, int disp, double scalingFactor) {
        double shift = scalingFactor / 2.0;
        return (double)scaledCoord * scalingFactor - (double)disp + shift;
    }

    private RoutingFrame.RoutingContact getVia(RoutingFrame.RoutingLayer l1, RoutingFrame.RoutingLayer l2) {
        for (RoutingFrame.RoutingContact rc : this.allContacts) {
            if ((!rc.getFirstLayer().equals(l1) || !rc.getSecondLayer().equals(l2)) && (!rc.getFirstLayer().equals(l2) || !rc.getSecondLayer().equals(l1))) continue;
            return rc;
        }
        return null;
    }
}

