/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Routing
extends Listener {
    private Activity current;
    private Activity past = null;
    private boolean checkAutoStitch = false;
    private static Routing tool = new Routing();
    private static boolean sunRouterChecked = false;
    private static Class<?> sunRouterClass = null;
    private static Method sunRouterMethod;
    private static Cell copiedTopologyCell;
    private static Pref cachePreferredRoutingArc;
    private static Pref cacheAutoStitchOn;
    private static Pref cacheAutoStitchCreateExports;
    private static Pref cacheMimicStitchOn;
    private static Pref cacheMimicStitchInteractive;
    private static Pref cacheMimicStitchPinsKept;
    private static Pref cacheMimicStitchMatchPorts;
    private static Pref cacheMimicStitchMatchPortWidth;
    private static Pref cacheMimicStitchMatchNumArcs;
    private static Pref cacheMimicStitchMatchNodeSize;
    private static Pref cacheMimicStitchMatchNodeType;
    private static Pref cacheMimicStitchNoOtherArcsSameDir;
    private static Pref cacheMimicStitchOnlyNewTopology;
    private static Pref cacheSOGMaxWidth;
    private static Pref cacheSOGComplexityLimit;
    private static Pref cacheSOGRerunComplexityLimit;
    private static Pref cacheSOGMaxDistance;
    private static Pref cacheSOGUseGlobalRouting;
    private static Pref cacheSOGRerunFailedRoutes;
    private static Pref cacheSOGRunOnConnectedRoutes;
    private static Pref cacheSOGNetOrder;
    private static Pref cacheSOGContactPlacementAction;
    private static Pref cacheSOGEnableSpineRouting;
    private static Pref cacheSOGForcedProcessorCount;
    private static Pref cacheSOGUseParallelFromToRoutes;
    private static Pref cacheSOGUseParallelRoutes;
    private static Pref cacheSLRVerboseLevel;
    private static Pref cacheSLRCostLimit;
    private static Pref cacheSLRCutlineDeviation;
    private static Pref cacheSLRDelta;
    private static Pref cacheSLRXBitSize;
    private static Pref cacheSLRYBitSize;
    private static Pref cacheSLRXTileSize;
    private static Pref cacheSLRYTileSize;
    private static Pref cacheSLRLayerAssgnCapF;
    private static Pref cacheSLRLengthLongNet;
    private static Pref cacheSLRLengthMedNet;
    private static Pref cacheSLRTilesPerPinLongNet;
    private static Pref cacheSLRTilesPerPinMedNet;
    private static Pref cacheSLROneTileFactor;
    private static Pref cacheSLROverloadLimit;
    private static Pref cacheSLRPinFactor;
    private static Pref cacheSLRUPinDensityF;
    private static Pref cacheSLRWindow;
    private static Pref cacheWireOffset;
    private static Pref cacheWireModulo;
    private static Pref cacheWireBlockageFactor;
    private static Pref cacheRipUpMaximum;
    private static Pref cacheRipUpPenalty;
    private static Pref cacheRipUpExpansion;
    private static Pref cacheZRipUpExpansion;
    private static Pref cacheRipUpSearches;
    private static Pref cacheGlobalPathExpansion;
    private static Pref cacheSourceAccessExpansion;
    private static Pref cacheSinkAccessExpansion;
    private static Pref cacheDenseViaAreaSize;
    private static Pref cacheRetryExpandRouting;
    private static Pref cacheRetryDenseViaAreaSize;
    private static Pref cachePathSearchControl;
    private static Pref cacheSparseViaModulo;
    private static Pref cacheLowPathSearchCost;
    private static Pref cacheMediumPathSearchCost;
    private static Pref cacheHighPathSearchCost;
    private static Pref cacheTakenPathSearchCost;

    private Routing() {
        super("routing");
    }

    @Override
    public void init() {
        this.setOn();
    }

    public static Routing getRoutingTool() {
        return tool;
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        if (undoRedo) {
            return;
        }
        if (newSnapshot.tool == tool) {
            return;
        }
        this.current = new Activity();
        this.checkAutoStitch = false;
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            Object n22;
            CellBackup newBackup;
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            if (oldBackup == null || (newBackup = newSnapshot.getCell(cellId)) == null || oldBackup == newBackup) continue;
            CellRevision oldRevision = oldBackup.cellRevision;
            CellRevision newRevision = newBackup.cellRevision;
            ArrayList<Object> oldNodes = new ArrayList<Object>();
            for (Object n22 : oldRevision.nodes) {
                while (((ImmutableNodeInst)n22).nodeId >= oldNodes.size()) {
                    oldNodes.add(null);
                }
                oldNodes.set(((ImmutableNodeInst)n22).nodeId, n22);
            }
            ArrayList<Object> oldArcs = new ArrayList<Object>();
            n22 = oldRevision.arcs.iterator();
            while (n22.hasNext()) {
                ImmutableArcInst a2 = (ImmutableArcInst)n22.next();
                while (a2.arcId >= oldArcs.size()) {
                    oldArcs.add(null);
                }
                oldArcs.set(a2.arcId, a2);
            }
            BitSet newNodes = new BitSet();
            for (ImmutableNodeInst d2 : newRevision.nodes) {
                ImmutableNodeInst oldD;
                newNodes.set(d2.nodeId);
                ImmutableNodeInst immutableNodeInst = oldD = d2.nodeId < oldNodes.size() ? (ImmutableNodeInst)oldNodes.get(d2.nodeId) : null;
                if (oldD == null) {
                    if (this.current.numCreatedNodes >= 3) continue;
                    this.current.createdNodes[this.current.numCreatedNodes++] = d2;
                    continue;
                }
                if (oldD == d2) continue;
                this.checkAutoStitch = true;
            }
            BitSet newArcs = new BitSet();
            for (ImmutableArcInst d3 : newRevision.arcs) {
                newArcs.set(d3.arcId);
                ImmutableArcInst oldD = d3.arcId < oldArcs.size() ? (ImmutableArcInst)oldArcs.get(d3.arcId) : null;
                if (oldD != null || this.current.numCreatedArcs >= 3) continue;
                this.current.createdArcsParents[this.current.numCreatedArcs] = cellId;
                this.current.createdArcs[this.current.numCreatedArcs++] = d3;
            }
            for (ImmutableNodeInst nid : oldRevision.nodes) {
                if (newNodes.get(nid.nodeId)) continue;
                ++this.current.numDeletedNodes;
            }
            for (ImmutableArcInst aid : oldRevision.arcs) {
                if (newArcs.get(aid.arcId)) continue;
                if (this.current.numDeletedArcs == 0) {
                    this.current.deletedArc = aid;
                    this.current.deletedArcParent = cellId;
                    this.current.deletedPorts[0] = aid.headPortId;
                    this.current.deletedPorts[1] = aid.tailPortId;
                }
                ++this.current.numDeletedArcs;
            }
        }
        if (this.current.numCreatedArcs > 0 || this.current.numCreatedNodes > 0 || this.current.deletedArc != null) {
            this.past = this.current;
            if (Routing.isMimicStitchOn()) {
                MimicStitch.mimicStitch(UserInterfaceMain.getEditingPreferences(), false);
                return;
            }
        }
        if (this.checkAutoStitch && Routing.isAutoStitchOn()) {
            AutoStitch.autoStitch(false, false);
        }
        this.current = null;
    }

    public void mimicSelected(EditingPreferences ep) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ArcInst ai = (ArcInst)wnd.getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        this.past = new Activity();
        this.past.createdArcsParents[this.past.numCreatedArcs] = ai.getParent().getId();
        this.past.createdArcs[this.past.numCreatedArcs++] = ai.getD();
        MimicStitch.mimicStitch(ep, true);
    }

    public static void unrouteCurrent() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() == 0) {
            System.out.println("Must select networks to unroute");
            return;
        }
        Routing.unrouteCell(cell, nets);
    }

    public static void unrouteCell(Cell c2, Set<Network> nets) {
        new UnrouteNetsJob(c2, nets);
    }

    public static ArcProto getPreferredRoutingArcProto() {
        ArcProto curAp;
        ArcProto preferredArc = null;
        String preferredName = Routing.getPreferredRoutingArc();
        if (preferredName.length() > 0) {
            preferredArc = ArcProto.findArcProto(preferredName);
        }
        if (preferredArc == null && (curAp = User.getUserTool().getCurrentArcProto()) != null) {
            preferredArc = curAp;
        }
        return preferredArc;
    }

    public static List<Connection> findNetEnds(Network net, Map<Network, ArcInst[]> arcMap, Set<ArcInst> arcsToDelete, Set<NodeInst> nodesToDelete, Netlist netList, boolean deleteOnlyUnrouted) {
        ArrayList<Connection> endList = new ArrayList<Connection>();
        HashMap<NodeInst, ArrayList<Connection>> endListByNode = new HashMap<NodeInst, ArrayList<Connection>>();
        ArcInst[] arcsOnNet = null;
        if (arcMap != null) {
            arcsOnNet = arcMap.get(net);
        } else {
            ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
            Iterator<ArcInst> aIt = net.getArcs();
            while (aIt.hasNext()) {
                arcList.add(aIt.next());
            }
            arcsOnNet = arcList.toArray(new ArcInst[0]);
        }
        for (ArcInst ai : arcsOnNet) {
            if (deleteOnlyUnrouted && ai.getProto() != Generic.tech().unrouted_arc) continue;
            arcsToDelete.add(ai);
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean deleteNode;
                Connection thisCon = ai.getConnection(i2);
                PortInst pi = thisCon.getPortInst();
                NodeInst ni = pi.getNodeInst();
                boolean term = true;
                if (!ni.hasExports() && !ni.isCellInstance()) {
                    PrimitiveNode.Function fun = ni.getFunction();
                    if (ni.getNumConnections() != 1 && (fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT)) {
                        term = false;
                    } else if (fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.WELL) {
                        Iterator<Connection> cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = cIt.next();
                            ArcInst conAi = con.getArc();
                            if (deleteOnlyUnrouted && conAi.getProto() != Generic.tech().unrouted_arc || conAi == ai || netList.getNetwork(conAi, 0) != net) continue;
                            term = false;
                            break;
                        }
                    }
                }
                if (term) {
                    boolean found = false;
                    Netlist nl = null;
                    List consOnNode = (List)endListByNode.get(ni);
                    if (consOnNode != null) {
                        for (Connection lCon : consOnNode) {
                            PortInst otherPI = lCon.getPortInst();
                            if (otherPI == pi) {
                                found = true;
                                break;
                            }
                            if (ni.isCellInstance()) {
                                Network otherSubNet;
                                Network subNet;
                                if (nl == null) {
                                    nl = ((Cell)ni.getProto()).getNetlist();
                                }
                                if (nl == null || (subNet = nl.getNetwork((Export)pi.getPortProto(), 0)) != (otherSubNet = nl.getNetwork((Export)otherPI.getPortProto(), 0))) continue;
                                found = true;
                                break;
                            }
                            PrimitivePort subPP = (PrimitivePort)pi.getPortProto();
                            PrimitivePort otherSubPP = (PrimitivePort)otherPI.getPortProto();
                            if (subPP.getTopology() != otherSubPP.getTopology()) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    endList.add(thisCon);
                    ArrayList<Connection> consByNode = (ArrayList<Connection>)endListByNode.get(ni);
                    if (consByNode == null) {
                        consByNode = new ArrayList<Connection>();
                        endListByNode.put(ni, consByNode);
                    }
                    consByNode.add(thisCon);
                    continue;
                }
                boolean bl = deleteNode = !deleteOnlyUnrouted;
                if (ni.getProto().getFunction().isPin()) {
                    deleteNode = true;
                }
                if (!deleteNode) continue;
                nodesToDelete.add(ni);
            }
        }
        return endList;
    }

    public Activity getLastActivity() {
        return this.past;
    }

    public static void unrouteCurrentSegment() {
        EditWindow wnd = EditWindow.getCurrent();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        List<Geometric> selected = wnd.getHighlightedEObjs(false, true);
        if (selected == null || selected.size() == 0) {
            Job.getUserInterface().showErrorMessage("Must select an arc to unroute", "Nothing is Selected");
            return;
        }
        for (Geometric geom : selected) {
            if (!(geom instanceof ArcInst)) continue;
            new UnrouteSegJob(cell, (ArcInst)geom);
        }
    }

    public static boolean hasSunRouter() {
        if (!sunRouterChecked) {
            sunRouterChecked = true;
            try {
                sunRouterClass = Class.forName("com.sun.electric.plugins.sunRouter.SunRouter");
            }
            catch (ClassNotFoundException e2) {
                TextUtils.recordMissingPrivateComponent("Sun Router");
                sunRouterClass = null;
                return false;
            }
            try {
                sunRouterMethod = sunRouterClass.getMethod("routeCell", Cell.class);
            }
            catch (NoSuchMethodException e3) {
                sunRouterClass = null;
                return false;
            }
        }
        return sunRouterClass != null;
    }

    public static void sunRouteCurrentCell() {
        if (!Routing.hasSunRouter()) {
            return;
        }
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        try {
            sunRouterMethod.invoke(sunRouterClass, curCell);
        }
        catch (Exception e2) {
            System.out.println("Unable to run the Sun Router module");
            e2.printStackTrace(System.out);
        }
    }

    public static void copyRoutingTopology() {
        UserInterface ui = Job.getUserInterface();
        Cell np = ui.needCurrentCell();
        if (np == null) {
            return;
        }
        copiedTopologyCell = np;
        System.out.println("Cell " + np.describe(true) + " will have its connectivity remembered");
    }

    public static void pasteRoutingTopology() {
        if (copiedTopologyCell == null) {
            System.out.println("Must copy topology before pasting it");
            return;
        }
        if (!copiedTopologyCell.isLinked()) {
            System.out.println("Copied cell is no longer valid");
            return;
        }
        UserInterface ui = Job.getUserInterface();
        Cell toCell = ui.needCurrentCell();
        if (toCell == null) {
            return;
        }
        if (copiedTopologyCell == toCell) {
            System.out.println("Topology must be copied to a different cell");
            return;
        }
        new CopyRoutingTopology(copiedTopologyCell, toCell);
    }

    public static boolean copyTopology(Cell fromCell, Cell toCell, EditingPreferences ep) {
        System.out.println("Copying topology from " + fromCell.describe(false) + " to " + toCell.describe(false));
        Netlist nl = fromCell.getNetlist();
        Map<Network, ArcInst[]> arcMap = null;
        if (fromCell.getView() != View.SCHEMATIC) {
            arcMap = nl.getArcInstsByNetwork();
        }
        HashMap nodeMap = new HashMap();
        HashSet<NodeInst> alreadyMatched = new HashSet<NodeInst>();
        ArrayList<Object> unmatched = new ArrayList<Object>();
        Iterator<NodeInst> it = fromCell.getNodes();
        while (it.hasNext()) {
            PrimitiveNode.Function fun;
            NodeInst ni = it.next();
            if (Generic.isCellCenterOrEssentialBnd(ni) || !ni.isCellInstance() && !ni.hasExports() && ((fun = ni.getFunction()) == PrimitiveNode.Function.UNKNOWN || fun.isPin() || fun.isContact() || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.NODE) || ni.isIconOfParent()) continue;
            ArrayList<Object> matches = new ArrayList<Object>();
            Iterator<Nodable> noIt = nl.getNodables();
            while (noIt.hasNext()) {
                Nodable no = noIt.next();
                if (no.getNodeInst() != ni) continue;
                NodeMatch nm = new NodeMatch(ni);
                nm.findEquivalentByName(toCell, alreadyMatched);
                if (nm.otherNi == null) {
                    unmatched.add(nm);
                }
                matches.add(nm);
                alreadyMatched.add(nm.otherNi);
            }
            nodeMap.put(ni, matches);
        }
        if (unmatched.size() > 0) {
            HashSet<NodeInst> availableToNodes = new HashSet<NodeInst>();
            Iterator<NodeInst> it2 = toCell.getNodes();
            while (it2.hasNext()) {
                availableToNodes.add(it2.next());
            }
            it2 = fromCell.getNodes();
            while (it2.hasNext()) {
                List associated = (List)nodeMap.get(it2.next());
                if (associated == null) continue;
                for (NodeMatch nm : associated) {
                    if (nm.otherNi == null) continue;
                    availableToNodes.remove(nm.otherNi);
                }
            }
            for (int i2 = 0; i2 < unmatched.size(); ++i2) {
                Object nmTest2;
                NodeMatch nm = (NodeMatch)unmatched.get(i2);
                NodeProto fromNp = nm.ni.getProto();
                ArrayList<Object> fromNm = new ArrayList<Object>();
                for (Object nmTest2 : unmatched) {
                    if (((NodeMatch)nmTest2).ni.getProto() != fromNp) continue;
                    fromNm.add(nmTest2);
                }
                ArrayList<NodeInst> toNi = new ArrayList<NodeInst>();
                nmTest2 = availableToNodes.iterator();
                while (nmTest2.hasNext()) {
                    NodeInst ni = (NodeInst)nmTest2.next();
                    if (ni.isCellInstance()) {
                        if (!(fromNp instanceof Cell) || ((Cell)fromNp).getCellGroup() != ((Cell)ni.getProto()).getCellGroup()) continue;
                        toNi.add(ni);
                        continue;
                    }
                    if (!(fromNp instanceof PrimitiveNode) || nm.ni.getFunction() != ni.getFunction()) continue;
                    toNi.add(ni);
                }
                if (fromNm.size() != toNi.size()) {
                    if (!(fromNp instanceof Cell)) continue;
                    System.out.println("Error: there are " + fromNm.size() + " instances of " + fromNp.describe(false) + " in source and " + toNi.size() + " in destination");
                    continue;
                }
                if (fromNm.size() == 0) continue;
                Collections.sort(fromNm, new NameMatchSpatially());
                Collections.sort(toNi, new InstancesSpatially());
                for (int j2 = 0; j2 < fromNm.size(); ++j2) {
                    NodeInst niAssoc;
                    NodeMatch nmAssoc = (NodeMatch)fromNm.get(j2);
                    nmAssoc.otherNi = niAssoc = (NodeInst)toNi.get(j2);
                    unmatched.remove(nmAssoc);
                    availableToNodes.remove(niAssoc);
                }
            }
        }
        int wiresMade = 0;
        Iterator<Network> it3 = nl.getNetworks();
        block9: while (it3.hasNext()) {
            Network net = it3.next();
            HashSet<PortInst> endSet = new HashSet<PortInst>();
            Iterator<Export> eIt = net.getExports();
            while (eIt.hasNext()) {
                Export e2 = eIt.next();
                int eWidth = nl.getBusWidth(e2);
                for (int i3 = 0; i3 < eWidth; ++i3) {
                    if (net != nl.getNetwork(e2, i3)) continue;
                    String eName = e2.getNameKey().subname(i3).toString();
                    Iterator<Export> oEIt = toCell.getExports();
                    while (oEIt.hasNext()) {
                        Export oE = oEIt.next();
                        if (!oE.getName().equalsIgnoreCase(eName)) continue;
                        endSet.add(oE.getOriginalPort());
                    }
                }
            }
            ArcInst[] arcsOnNet = null;
            if (arcMap != null) {
                arcsOnNet = arcMap.get(net);
            } else {
                ArcInst[] arcList = new ArrayList();
                Iterator<ArcInst> aIt = net.getArcs();
                while (aIt.hasNext()) {
                    arcList.add(aIt.next());
                }
                arcsOnNet = arcList.toArray(new ArcInst[0]);
            }
            for (ArcInst ai : arcsOnNet) {
                int busWidth = nl.getBusWidth(ai);
                for (int b2 = 0; b2 < busWidth; ++b2) {
                    Network busNet = nl.getNetwork(ai, b2);
                    if (busNet != net) continue;
                    for (int e3 = 0; e3 < 2; ++e3) {
                        PortProto pp;
                        PortInst piDest;
                        PortProto p;
                        PortInst pi = ai.getPortInst(e3);
                        NodeInst ni = pi.getNodeInst();
                        List possibleNodes = (List)nodeMap.get(ni);
                        if (possibleNodes == null) continue;
                        if (possibleNodes.size() > 1) {
                            NodeMatch nm2;
                            p = pi.getPortProto();
                            int portWidth = p.getNameKey().busWidth();
                            if (busWidth == portWidth) {
                                Name portName = p.getNameKey().subname(b2);
                                for (NodeMatch nm2 : possibleNodes) {
                                    if (nm2.otherNi == null || (piDest = nm2.otherNi.findPortInstFromEquivalentProto(pp = nm2.otherNi.getProto().findPortProto(portName))) == null) continue;
                                    endSet.add(piDest);
                                }
                                continue;
                            }
                            int nodeIndex = b2 / portWidth;
                            int portIndex = b2 % portWidth;
                            nm2 = (NodeMatch)possibleNodes.get(nodeIndex);
                            if (nm2.otherNi == null) continue;
                            Name portName = p.getNameKey().subname(portIndex);
                            PortProto pp2 = nm2.otherNi.getProto().findPortProto(portName);
                            PortInst piDest2 = nm2.otherNi.findPortInstFromEquivalentProto(pp2);
                            if (piDest2 == null) continue;
                            endSet.add(piDest2);
                            continue;
                        }
                        if (possibleNodes.size() != 1) continue;
                        p = pi.getPortProto();
                        int nodeIndex = 0;
                        int portIndex = b2;
                        NodeMatch nm = (NodeMatch)possibleNodes.get(nodeIndex);
                        if (nm.otherNi == null) continue;
                        Name portName = p.getNameKey().subname(portIndex);
                        pp = nm.otherNi.getProto().findPortProto(portName);
                        piDest = null;
                        if (pp != null) {
                            piDest = nm.otherNi.findPortInstFromEquivalentProto(pp);
                        }
                        if (piDest == null && nm.otherNi.getNumPortInsts() == 1) {
                            piDest = nm.otherNi.getOnlyPortInst();
                        }
                        if (piDest == null) continue;
                        endSet.add(piDest);
                    }
                }
            }
            ArrayList<PortInst> sortedPorts = new ArrayList<PortInst>();
            for (PortInst pi : endSet) {
                sortedPorts.add(pi);
            }
            Collections.sort(sortedPorts, new PortsByName());
            PortInst lastPi = null;
            for (PortInst pi : sortedPorts) {
                if (lastPi != null) {
                    Point2D.Double pt;
                    Poly lPoly = lastPi.getPoly();
                    Poly poly = pi.getPoly();
                    Point2D.Double lPt = new Point2D.Double(lPoly.getCenterX(), lPoly.getCenterY());
                    ArcInst newAi = ArcInst.makeInstance(Generic.tech().unrouted_arc, ep, lastPi, pi, lPt, pt = new Point2D.Double(poly.getCenterX(), poly.getCenterY()), null);
                    if (newAi == null) continue block9;
                    ++wiresMade;
                }
                lastPi = pi;
            }
        }
        if (wiresMade == 0) {
            System.out.println("No topology was copied");
        } else {
            System.out.println("Created " + wiresMade + " arcs to copy the topology");
        }
        return true;
    }

    public static String getPreferredRoutingArc() {
        return cachePreferredRoutingArc.getString();
    }

    public static void setPreferredRoutingArc(String arcName) {
        cachePreferredRoutingArc.setString(arcName);
    }

    public static String getFactoryPreferredRoutingArc() {
        return cachePreferredRoutingArc.getStringFactoryValue();
    }

    public static boolean isAutoStitchOn() {
        return cacheAutoStitchOn.getBoolean();
    }

    public static void setAutoStitchOn(boolean on) {
        cacheAutoStitchOn.setBoolean(on);
    }

    public static boolean isFactoryAutoStitchOn() {
        return cacheAutoStitchOn.getBooleanFactoryValue();
    }

    public static boolean isAutoStitchCreateExports() {
        return cacheAutoStitchCreateExports.getBoolean();
    }

    public static void setAutoStitchCreateExports(boolean on) {
        cacheAutoStitchCreateExports.setBoolean(on);
    }

    public static boolean isFactoryAutoStitchCreateExports() {
        return cacheAutoStitchCreateExports.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchOn() {
        return cacheMimicStitchOn.getBoolean();
    }

    public static void setMimicStitchOn(boolean on) {
        cacheMimicStitchOn.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchOn() {
        return cacheMimicStitchOn.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchInteractive() {
        return cacheMimicStitchInteractive.getBoolean();
    }

    public static void setMimicStitchInteractive(boolean on) {
        cacheMimicStitchInteractive.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchInteractive() {
        return cacheMimicStitchInteractive.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchPinsKept() {
        return cacheMimicStitchPinsKept.getBoolean();
    }

    public static void setMimicStitchPinsKept(boolean on) {
        cacheMimicStitchPinsKept.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchPinsKept() {
        return cacheMimicStitchPinsKept.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchMatchPorts() {
        return cacheMimicStitchMatchPorts.getBoolean();
    }

    public static void setMimicStitchMatchPorts(boolean on) {
        cacheMimicStitchMatchPorts.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchMatchPorts() {
        return cacheMimicStitchMatchPorts.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchMatchPortWidth() {
        return cacheMimicStitchMatchPortWidth.getBoolean();
    }

    public static void setMimicStitchMatchPortWidth(boolean on) {
        cacheMimicStitchMatchPortWidth.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchMatchPortWidth() {
        return cacheMimicStitchMatchPortWidth.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchMatchNumArcs() {
        return cacheMimicStitchMatchNumArcs.getBoolean();
    }

    public static void setMimicStitchMatchNumArcs(boolean on) {
        cacheMimicStitchMatchNumArcs.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchMatchNumArcs() {
        return cacheMimicStitchMatchNumArcs.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchMatchNodeSize() {
        return cacheMimicStitchMatchNodeSize.getBoolean();
    }

    public static void setMimicStitchMatchNodeSize(boolean on) {
        cacheMimicStitchMatchNodeSize.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchMatchNodeSize() {
        return cacheMimicStitchMatchNodeSize.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchMatchNodeType() {
        return cacheMimicStitchMatchNodeType.getBoolean();
    }

    public static void setMimicStitchMatchNodeType(boolean on) {
        cacheMimicStitchMatchNodeType.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchMatchNodeType() {
        return cacheMimicStitchMatchNodeType.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchNoOtherArcsSameDir() {
        return cacheMimicStitchNoOtherArcsSameDir.getBoolean();
    }

    public static void setMimicStitchNoOtherArcsSameDir(boolean on) {
        cacheMimicStitchNoOtherArcsSameDir.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchNoOtherArcsSameDir() {
        return cacheMimicStitchNoOtherArcsSameDir.getBooleanFactoryValue();
    }

    public static boolean isMimicStitchOnlyNewTopology() {
        return cacheMimicStitchOnlyNewTopology.getBoolean();
    }

    public static void setMimicStitchOnlyNewTopology(boolean on) {
        cacheMimicStitchOnlyNewTopology.setBoolean(on);
    }

    public static boolean isFactoryMimicStitchOnlyNewTopology() {
        return cacheMimicStitchOnlyNewTopology.getBooleanFactoryValue();
    }

    public static double getSeaOfGatesMaxWidth() {
        return cacheSOGMaxWidth.getDouble();
    }

    public static void setSeaOfGatesMaxWidth(double w) {
        cacheSOGMaxWidth.setDouble(w);
    }

    public static double getFactorySeaOfGatesMaxWidth() {
        return cacheSOGMaxWidth.getDoubleFactoryValue();
    }

    public static int getSeaOfGatesComplexityLimit() {
        return cacheSOGComplexityLimit.getInt();
    }

    public static void setSeaOfGatesComplexityLimit(int c2) {
        cacheSOGComplexityLimit.setInt(c2);
    }

    public static int getFactorySeaOfGatesComplexityLimit() {
        return cacheSOGComplexityLimit.getIntFactoryValue();
    }

    public static int getSeaOfGatesRerunComplexityLimit() {
        return cacheSOGRerunComplexityLimit.getInt();
    }

    public static void setSeaOfGatesRerunComplexityLimit(int c2) {
        cacheSOGRerunComplexityLimit.setInt(c2);
    }

    public static int getFactorySeaOfGatesRerunComplexityLimit() {
        return cacheSOGRerunComplexityLimit.getIntFactoryValue();
    }

    public static int getSeaOfGatesMaxDistance() {
        return cacheSOGMaxDistance.getInt();
    }

    public static void setSeaOfGatesMaxDistance(int c2) {
        cacheSOGMaxDistance.setInt(c2);
    }

    public static int getFactorySeaOfGatesMaxDistance() {
        return cacheSOGMaxDistance.getIntFactoryValue();
    }

    public static boolean isSeaOfGatesUseGlobalRouting() {
        return cacheSOGUseGlobalRouting.getBoolean();
    }

    public static void setSeaOfGatesUseGlobalRouting(boolean p) {
        cacheSOGUseGlobalRouting.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesUseGlobalRouting() {
        return cacheSOGUseGlobalRouting.getBooleanFactoryValue();
    }

    public static boolean isSeaOfGatesRerunFailedRoutes() {
        return cacheSOGRerunFailedRoutes.getBoolean();
    }

    public static void setSeaOfGatesRerunFailedRoutes(boolean p) {
        cacheSOGRerunFailedRoutes.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesRerunFailedRoutes() {
        return cacheSOGRerunFailedRoutes.getBooleanFactoryValue();
    }

    public static boolean isSeaOfGatesRunOnConnectedRoutes() {
        return cacheSOGRunOnConnectedRoutes.getBoolean();
    }

    public static void setSeaOfGatesRunOnConnectedRoutes(boolean p) {
        cacheSOGRunOnConnectedRoutes.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesRunOnConnectedRoutes() {
        return cacheSOGRunOnConnectedRoutes.getBooleanFactoryValue();
    }

    public static SoGNetOrder getSeaOfGatesNetOrder() {
        return SoGNetOrder.findByValue(cacheSOGNetOrder.getInt());
    }

    public static void setSeaOfGatesNetOrder(SoGNetOrder p) {
        cacheSOGNetOrder.setInt(p.getValue());
    }

    public static SoGNetOrder getFactorySeaOfGatesNetOrder() {
        return SoGNetOrder.findByValue(cacheSOGNetOrder.getIntFactoryValue());
    }

    public static int getSeaOfGatesContactPlacementAction() {
        return cacheSOGContactPlacementAction.getInt();
    }

    public static void setSeaOfGatesContactPlacementAction(int a2) {
        cacheSOGContactPlacementAction.setInt(a2);
    }

    public static int getFactorySeaOfGatesContactPlacementAction() {
        return cacheSOGContactPlacementAction.getIntFactoryValue();
    }

    public static boolean isSeaOfGatesEnableSpineRouting() {
        return cacheSOGEnableSpineRouting.getBoolean();
    }

    public static void setSeaOfGatesEnableSpineRouting(boolean p) {
        cacheSOGEnableSpineRouting.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesEnableSpineRouting() {
        return cacheSOGEnableSpineRouting.getBooleanFactoryValue();
    }

    public static int getSeaOfGatesForcedProcessorCount() {
        return cacheSOGForcedProcessorCount.getInt();
    }

    public static void setSeaOfGatesForcedProcessorCount(int c2) {
        cacheSOGForcedProcessorCount.setInt(c2);
    }

    public static int getFactorySeaOfGatesForcedProcessorCount() {
        return cacheSOGForcedProcessorCount.getIntFactoryValue();
    }

    public static boolean isSeaOfGatesUseParallelFromToRoutes() {
        return cacheSOGUseParallelFromToRoutes.getBoolean();
    }

    public static void setSeaOfGatesUseParallelFromToRoutes(boolean p) {
        cacheSOGUseParallelFromToRoutes.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesUseParallelFromToRoutes() {
        return cacheSOGUseParallelFromToRoutes.getBooleanFactoryValue();
    }

    public static boolean isSeaOfGatesUseParallelRoutes() {
        return cacheSOGUseParallelRoutes.getBoolean();
    }

    public static void setSeaOfGatesUseParallelRoutes(boolean p) {
        cacheSOGUseParallelRoutes.setBoolean(p);
    }

    public static boolean isFactorySeaOfGatesUseParallelRoutes() {
        return cacheSOGUseParallelRoutes.getBooleanFactoryValue();
    }

    public static int getSunRouterVerboseLevel() {
        return cacheSLRVerboseLevel.getInt();
    }

    public static void setSunRouterVerboseLevel(int v) {
        cacheSLRVerboseLevel.setInt(v);
    }

    public static int getFactorySunRouterVerboseLevel() {
        return cacheSLRVerboseLevel.getIntFactoryValue();
    }

    public static double getSunRouterCostLimit() {
        return cacheSLRCostLimit.getDouble();
    }

    public static void setSunRouterCostLimit(double r) {
        cacheSLRCostLimit.setDouble(r);
    }

    public static double getFactorySunRouterCostLimit() {
        return cacheSLRCostLimit.getDoubleFactoryValue();
    }

    public static double getSunRouterCutlineDeviation() {
        return cacheSLRCutlineDeviation.getDouble();
    }

    public static void setSunRouterCutlineDeviation(double r) {
        cacheSLRCutlineDeviation.setDouble(r);
    }

    public static double getFactorySunRouterCutlineDeviation() {
        return cacheSLRCutlineDeviation.getDoubleFactoryValue();
    }

    public static double getSunRouterDelta() {
        return cacheSLRDelta.getDouble();
    }

    public static void setSunRouterDelta(double r) {
        cacheSLRDelta.setDouble(r);
    }

    public static double getFactorySunRouterDelta() {
        return cacheSLRDelta.getDoubleFactoryValue();
    }

    public static int getSunRouterXBitSize() {
        return cacheSLRXBitSize.getInt();
    }

    public static void setSunRouterXBitSize(int r) {
        cacheSLRXBitSize.setInt(r);
    }

    public static int getFactorySunRouterXBitSize() {
        return cacheSLRXBitSize.getIntFactoryValue();
    }

    public static int getSunRouterYBitSize() {
        return cacheSLRYBitSize.getInt();
    }

    public static void setSunRouterYBitSize(int r) {
        cacheSLRYBitSize.setInt(r);
    }

    public static int getFactorySunRouterYBitSize() {
        return cacheSLRYBitSize.getIntFactoryValue();
    }

    public static int getSunRouterXTileSize() {
        return cacheSLRXTileSize.getInt();
    }

    public static void setSunRouterXTileSize(int r) {
        cacheSLRXTileSize.setInt(r);
    }

    public static int getFactorySunRouterXTileSize() {
        return cacheSLRXTileSize.getIntFactoryValue();
    }

    public static int getSunRouterYTileSize() {
        return cacheSLRYTileSize.getInt();
    }

    public static void setSunRouterYTileSize(int r) {
        cacheSLRYTileSize.setInt(r);
    }

    public static int getFactorySunRouterYTileSize() {
        return cacheSLRYTileSize.getIntFactoryValue();
    }

    public static double getSunRouterLayerAssgnCapF() {
        return cacheSLRLayerAssgnCapF.getDouble();
    }

    public static void setSunRouterLayerAssgnCapF(double r) {
        cacheSLRLayerAssgnCapF.setDouble(r);
    }

    public static double getFactorySunRouterLayerAssgnCapF() {
        return cacheSLRLayerAssgnCapF.getDoubleFactoryValue();
    }

    public static double getSunRouterLengthLongNet() {
        return cacheSLRLengthLongNet.getDouble();
    }

    public static void setSunRouterLengthLongNet(double r) {
        cacheSLRLengthLongNet.setDouble(r);
    }

    public static double getFactorySunRouterLengthLongNet() {
        return cacheSLRLengthLongNet.getDoubleFactoryValue();
    }

    public static double getSunRouterLengthMedNet() {
        return cacheSLRLengthMedNet.getDouble();
    }

    public static void setSunRouterLengthMedNet(double r) {
        cacheSLRLengthMedNet.setDouble(r);
    }

    public static double getFactorySunRouterLengthMedNet() {
        return cacheSLRLengthMedNet.getDoubleFactoryValue();
    }

    public static double getSunRouterTilesPerPinLongNet() {
        return cacheSLRTilesPerPinLongNet.getDouble();
    }

    public static void setSunRouterTilesPerPinLongNet(double r) {
        cacheSLRTilesPerPinLongNet.setDouble(r);
    }

    public static double getFactorySunRouterTilesPerPinLongNet() {
        return cacheSLRTilesPerPinLongNet.getDoubleFactoryValue();
    }

    public static double getSunRouterTilesPerPinMedNet() {
        return cacheSLRTilesPerPinMedNet.getDouble();
    }

    public static void setSunRouterTilesPerPinMedNet(double r) {
        cacheSLRTilesPerPinMedNet.setDouble(r);
    }

    public static double getFactorySunRouterTilesPerPinMedNet() {
        return cacheSLRTilesPerPinMedNet.getDoubleFactoryValue();
    }

    public static double getSunRouterOneTileFactor() {
        return cacheSLROneTileFactor.getDouble();
    }

    public static void setSunRouterOneTileFactor(double r) {
        cacheSLROneTileFactor.setDouble(r);
    }

    public static double getFactorySunRouterOneTileFactor() {
        return cacheSLROneTileFactor.getDoubleFactoryValue();
    }

    public static int getSunRouterOverloadLimit() {
        return cacheSLROverloadLimit.getInt();
    }

    public static void setSunRouterOverloadLimit(int r) {
        cacheSLROverloadLimit.setInt(r);
    }

    public static int getFactorySunRouterOverloadLimit() {
        return cacheSLROverloadLimit.getIntFactoryValue();
    }

    public static int getSunRouterPinFactor() {
        return cacheSLRPinFactor.getInt();
    }

    public static void setSunRouterPinFactor(int r) {
        cacheSLRPinFactor.setInt(r);
    }

    public static int getFactorySunRouterPinFactor() {
        return cacheSLRPinFactor.getIntFactoryValue();
    }

    public static double getSunRouterUPinDensityF() {
        return cacheSLRUPinDensityF.getDouble();
    }

    public static void setSunRouterUPinDensityF(double r) {
        cacheSLRUPinDensityF.setDouble(r);
    }

    public static double getFactorySunRouterUPinDensityF() {
        return cacheSLRUPinDensityF.getDoubleFactoryValue();
    }

    public static int getSunRouterWindow() {
        return cacheSLRWindow.getInt();
    }

    public static void setSunRouterWindow(int r) {
        cacheSLRWindow.setInt(r);
    }

    public static int getFactorySunRouterWindow() {
        return cacheSLRWindow.getIntFactoryValue();
    }

    public static int getSunRouterWireOffset() {
        return cacheWireOffset.getInt();
    }

    public static void setSunRouterWireOffset(int r) {
        cacheWireOffset.setInt(r);
    }

    public static int getFactorySunRouterWireOffset() {
        return cacheWireOffset.getIntFactoryValue();
    }

    public static int getSunRouterWireModulo() {
        return cacheWireModulo.getInt();
    }

    public static void setSunRouterWireModulo(int r) {
        cacheWireModulo.setInt(r);
    }

    public static int getFactorySunRouterWireModulo() {
        return cacheWireModulo.getIntFactoryValue();
    }

    public static double getSunRouterWireBlockageFactor() {
        return cacheWireBlockageFactor.getDouble();
    }

    public static void setSunRouterWireBlockageFactor(double r) {
        cacheWireBlockageFactor.setDouble(r);
    }

    public static double getFactorySunRouterWireBlockageFactor() {
        return cacheWireBlockageFactor.getDoubleFactoryValue();
    }

    public static int getSunRouterRipUpMaximum() {
        return cacheRipUpMaximum.getInt();
    }

    public static void setSunRouterRipUpMaximum(int r) {
        cacheRipUpMaximum.setInt(r);
    }

    public static int getFactorySunRouterRipUpMaximum() {
        return cacheRipUpMaximum.getIntFactoryValue();
    }

    public static int getSunRouterRipUpPenalty() {
        return cacheRipUpPenalty.getInt();
    }

    public static void setSunRouterRipUpPenalty(int r) {
        cacheRipUpPenalty.setInt(r);
    }

    public static int getFactorySunRouterRipUpPenalty() {
        return cacheRipUpPenalty.getIntFactoryValue();
    }

    public static int getSunRouterRipUpExpansion() {
        return cacheRipUpExpansion.getInt();
    }

    public static void setSunRouterRipUpExpansion(int r) {
        cacheRipUpExpansion.setInt(r);
    }

    public static int getFactorySunRouterRipUpExpansion() {
        return cacheRipUpExpansion.getIntFactoryValue();
    }

    public static int getSunRouterZRipUpExpansion() {
        return cacheZRipUpExpansion.getInt();
    }

    public static void setSunRouterZRipUpExpansion(int r) {
        cacheZRipUpExpansion.setInt(r);
    }

    public static int getFactorySunRouterZRipUpExpansion() {
        return cacheZRipUpExpansion.getIntFactoryValue();
    }

    public static int getSunRouterRipUpSearches() {
        return cacheRipUpSearches.getInt();
    }

    public static void setSunRouterRipUpSearches(int r) {
        cacheRipUpSearches.setInt(r);
    }

    public static int getFactorySunRouterRipUpSearches() {
        return cacheRipUpSearches.getIntFactoryValue();
    }

    public static int getSunRouterGlobalPathExpansion() {
        return cacheGlobalPathExpansion.getInt();
    }

    public static void setSunRouterGlobalPathExpansion(int r) {
        cacheGlobalPathExpansion.setInt(r);
    }

    public static int getFactorySunRouterGlobalPathExpansion() {
        return cacheGlobalPathExpansion.getIntFactoryValue();
    }

    public static int getSunRouterSourceAccessExpansion() {
        return cacheSourceAccessExpansion.getInt();
    }

    public static void setSunRouterSourceAccessExpansion(int r) {
        cacheSourceAccessExpansion.setInt(r);
    }

    public static int getFactorySunRouterSourceAccessExpansion() {
        return cacheSourceAccessExpansion.getIntFactoryValue();
    }

    public static int getSunRouterSinkAccessExpansion() {
        return cacheSinkAccessExpansion.getInt();
    }

    public static void setSunRouterSinkAccessExpansion(int r) {
        cacheSinkAccessExpansion.setInt(r);
    }

    public static int getFactorySunRouterSinkAccessExpansion() {
        return cacheSinkAccessExpansion.getIntFactoryValue();
    }

    public static int getSunRouterDenseViaAreaSize() {
        return cacheDenseViaAreaSize.getInt();
    }

    public static void setSunRouterDenseViaAreaSize(int r) {
        cacheDenseViaAreaSize.setInt(r);
    }

    public static int getFactorySunRouterDenseViaAreaSize() {
        return cacheDenseViaAreaSize.getIntFactoryValue();
    }

    public static int getSunRouterRetryExpandRouting() {
        return cacheRetryExpandRouting.getInt();
    }

    public static void setSunRouterRetryExpandRouting(int r) {
        cacheRetryExpandRouting.setInt(r);
    }

    public static int getFactorySunRouterRetryExpandRouting() {
        return cacheRetryExpandRouting.getIntFactoryValue();
    }

    public static int getSunRouterRetryDenseViaAreaSize() {
        return cacheRetryDenseViaAreaSize.getInt();
    }

    public static void setSunRouterRetryDenseViaAreaSize(int r) {
        cacheRetryDenseViaAreaSize.setInt(r);
    }

    public static int getFactorySunRouterRetryDenseViaAreaSize() {
        return cacheRetryDenseViaAreaSize.getIntFactoryValue();
    }

    public static int getSunRouterPathSearchControl() {
        return cachePathSearchControl.getInt();
    }

    public static void setSunRouterPathSearchControl(int r) {
        cachePathSearchControl.setInt(r);
    }

    public static int getFactorySunRouterPathSearchControl() {
        return cachePathSearchControl.getIntFactoryValue();
    }

    public static int getSunRouterSparseViaModulo() {
        return cacheSparseViaModulo.getInt();
    }

    public static void setSunRouterSparseViaModulo(int r) {
        cacheSparseViaModulo.setInt(r);
    }

    public static int getFactorySunRouterSparseViaModulo() {
        return cacheSparseViaModulo.getIntFactoryValue();
    }

    public static int getSunRouterLowPathSearchCost() {
        return cacheLowPathSearchCost.getInt();
    }

    public static void setSunRouterLowPathSearchCost(int r) {
        cacheLowPathSearchCost.setInt(r);
    }

    public static int getFactorySunRouterLowPathSearchCost() {
        return cacheLowPathSearchCost.getIntFactoryValue();
    }

    public static int getSunRouterMediumPathSearchCost() {
        return cacheMediumPathSearchCost.getInt();
    }

    public static void setSunRouterMediumPathSearchCost(int r) {
        cacheMediumPathSearchCost.setInt(r);
    }

    public static int getFactorySunRouterMediumPathSearchCost() {
        return cacheMediumPathSearchCost.getIntFactoryValue();
    }

    public static int getSunRouterHighPathSearchCost() {
        return cacheHighPathSearchCost.getInt();
    }

    public static void setSunRouterHighPathSearchCost(int r) {
        cacheHighPathSearchCost.setInt(r);
    }

    public static int getFactorySunRouterHighPathSearchCost() {
        return cacheHighPathSearchCost.getIntFactoryValue();
    }

    public static int getSunRouterTakenPathSearchCost() {
        return cacheTakenPathSearchCost.getInt();
    }

    public static void setSunRouterTakenPathSearchCost(int r) {
        cacheTakenPathSearchCost.setInt(r);
    }

    public static int getFactorySunRouterTakenPathSearchCost() {
        return cacheTakenPathSearchCost.getIntFactoryValue();
    }

    static {
        cachePreferredRoutingArc = Pref.makeStringPref("PreferredRoutingArc", Routing.tool.prefs, "");
        cacheAutoStitchOn = Pref.makeBooleanPref("AutoStitchOn", Routing.tool.prefs, false);
        cacheAutoStitchCreateExports = Pref.makeBooleanPref("AutoStitchCreateExports", Routing.tool.prefs, false);
        cacheMimicStitchOn = Pref.makeBooleanPref("MimicStitchOn", Routing.tool.prefs, false);
        cacheMimicStitchInteractive = Pref.makeBooleanPref("MimicStitchInteractive", Routing.tool.prefs, false);
        cacheMimicStitchPinsKept = Pref.makeBooleanPref("MimicStitchPinsKept", Routing.tool.prefs, false);
        cacheMimicStitchMatchPorts = Pref.makeBooleanPref("MimicStitchMatchPorts", Routing.tool.prefs, false);
        cacheMimicStitchMatchPortWidth = Pref.makeBooleanPref("MimicStitchMatchPortWidth", Routing.tool.prefs, true);
        cacheMimicStitchMatchNumArcs = Pref.makeBooleanPref("MimicStitchMatchNumArcs", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeSize = Pref.makeBooleanPref("MimicStitchMatchNodeSize", Routing.tool.prefs, false);
        cacheMimicStitchMatchNodeType = Pref.makeBooleanPref("MimicStitchMatchNodeType", Routing.tool.prefs, true);
        cacheMimicStitchNoOtherArcsSameDir = Pref.makeBooleanPref("MimicStitchNoOtherArcsSameDir", Routing.tool.prefs, true);
        cacheMimicStitchOnlyNewTopology = Pref.makeBooleanPref("MimicStitchOnlyNewTopology", Routing.tool.prefs, true);
        cacheSOGMaxWidth = Pref.makeDoublePref("SeaOfGatesMaxWidth", Routing.getRoutingTool().prefs, 10.0);
        cacheSOGComplexityLimit = Pref.makeIntPref("SeaOfGatesComplexityLimit", Routing.getRoutingTool().prefs, 200000);
        cacheSOGRerunComplexityLimit = Pref.makeIntPref("SeaOfGatesRerunComplexityLimit", Routing.getRoutingTool().prefs, 400000);
        cacheSOGMaxDistance = Pref.makeIntPref("SeaOfGatesMaxDistance", Routing.getRoutingTool().prefs, 10);
        cacheSOGUseGlobalRouting = Pref.makeBooleanPref("SeaOfGatesUseGlobalRouting", Routing.getRoutingTool().prefs, false);
        cacheSOGRerunFailedRoutes = Pref.makeBooleanPref("SeaOfGatesRerunFailedRoutes", Routing.getRoutingTool().prefs, true);
        cacheSOGRunOnConnectedRoutes = Pref.makeBooleanPref("SeaOfGatesRunOnConnectedRoutes", Routing.getRoutingTool().prefs, true);
        cacheSOGNetOrder = Pref.makeIntPref("SeaOfGatesNetOrder", Routing.getRoutingTool().prefs, SoGNetOrder.SOGNETORDERORIGINAL.getValue());
        cacheSOGContactPlacementAction = Pref.makeIntPref("SeaOfGatesContactPlacementAction", Routing.getRoutingTool().prefs, SoGContactsStrategy.SOGCONTACTSATTOPLEVEL.getLevel());
        cacheSOGEnableSpineRouting = Pref.makeBooleanPref("SeaOfGatesEnableSpineRouting", Routing.getRoutingTool().prefs, false);
        cacheSOGForcedProcessorCount = Pref.makeIntPref("SeaOfGatesForcedProcessorCount", Routing.getRoutingTool().prefs, 0);
        cacheSOGUseParallelFromToRoutes = Pref.makeBooleanPref("SeaOfGatesUseParallelFromToRoutes", Routing.getRoutingTool().prefs, true);
        cacheSOGUseParallelRoutes = Pref.makeBooleanPref("SeaOfGatesUseParallelRoutes", Routing.getRoutingTool().prefs, false);
        cacheSLRVerboseLevel = Pref.makeIntPref("SunRouterVerboseLevel", Routing.getRoutingTool().prefs, 2);
        cacheSLRCostLimit = Pref.makeDoublePref("SunRouterCostLimit", Routing.getRoutingTool().prefs, 10.0);
        cacheSLRCutlineDeviation = Pref.makeDoublePref("SunRouterCutlineDeviation", Routing.getRoutingTool().prefs, 0.1);
        cacheSLRDelta = Pref.makeDoublePref("SunRouterDelta", Routing.getRoutingTool().prefs, 1.0);
        cacheSLRXBitSize = Pref.makeIntPref("SunRouterXBitSize", Routing.getRoutingTool().prefs, 20);
        cacheSLRYBitSize = Pref.makeIntPref("SunRouterYBitSize", Routing.getRoutingTool().prefs, 20);
        cacheSLRXTileSize = Pref.makeIntPref("SunRouterXTileSize", Routing.getRoutingTool().prefs, 40);
        cacheSLRYTileSize = Pref.makeIntPref("SunRouterYTileSize", Routing.getRoutingTool().prefs, 40);
        cacheSLRLayerAssgnCapF = Pref.makeDoublePref("SunRouterLayerAssgnCapF", Routing.getRoutingTool().prefs, 0.9);
        cacheSLRLengthLongNet = Pref.makeDoublePref("SunRouterLengthLongNet", Routing.getRoutingTool().prefs, 0.0);
        cacheSLRLengthMedNet = Pref.makeDoublePref("SunRouterLengthMedNet", Routing.getRoutingTool().prefs, 0.0);
        cacheSLRTilesPerPinLongNet = Pref.makeDoublePref("SunRouterTilesPerPinLongNet", Routing.getRoutingTool().prefs, 5.0);
        cacheSLRTilesPerPinMedNet = Pref.makeDoublePref("SunRouterTilesPerPinMedNet", Routing.getRoutingTool().prefs, 3.0);
        cacheSLROneTileFactor = Pref.makeDoublePref("SunRouterOneTileFactor", Routing.getRoutingTool().prefs, 2.65);
        cacheSLROverloadLimit = Pref.makeIntPref("SunRouterOverloadLimit", Routing.getRoutingTool().prefs, 10);
        cacheSLRPinFactor = Pref.makeIntPref("SunRouterPinFactor", Routing.getRoutingTool().prefs, 10);
        cacheSLRUPinDensityF = Pref.makeDoublePref("SunRouterUPinDensityF", Routing.getRoutingTool().prefs, 100.0);
        cacheSLRWindow = Pref.makeIntPref("SunRouterWindow", Routing.getRoutingTool().prefs, 30);
        cacheWireOffset = Pref.makeIntPref("SunRouterWireOffset", Routing.getRoutingTool().prefs, 0);
        cacheWireModulo = Pref.makeIntPref("SunRouterWireModulo", Routing.getRoutingTool().prefs, -1);
        cacheWireBlockageFactor = Pref.makeDoublePref("SunRouterWireBlockageFactor", Routing.getRoutingTool().prefs, 0.0);
        cacheRipUpMaximum = Pref.makeIntPref("SunRouterRipUpMaximum", Routing.getRoutingTool().prefs, 3);
        cacheRipUpPenalty = Pref.makeIntPref("SunRouterRipUpPenalty", Routing.getRoutingTool().prefs, 10);
        cacheRipUpExpansion = Pref.makeIntPref("SunRouterRipUpExpansion", Routing.getRoutingTool().prefs, 10);
        cacheZRipUpExpansion = Pref.makeIntPref("SunRouterZRipUpExpansion", Routing.getRoutingTool().prefs, 2);
        cacheRipUpSearches = Pref.makeIntPref("SunRouterRipUpSearches", Routing.getRoutingTool().prefs, 1);
        cacheGlobalPathExpansion = Pref.makeIntPref("SunRouterGlobalPathExpansion", Routing.getRoutingTool().prefs, 5);
        cacheSourceAccessExpansion = Pref.makeIntPref("SunRouterSourceAccessExpansion", Routing.getRoutingTool().prefs, 10);
        cacheSinkAccessExpansion = Pref.makeIntPref("SunRouterSinkAccessExpansion", Routing.getRoutingTool().prefs, 10);
        cacheDenseViaAreaSize = Pref.makeIntPref("SunRouterDenseViaAreaSize", Routing.getRoutingTool().prefs, 60);
        cacheRetryExpandRouting = Pref.makeIntPref("SunRouterRetryExpandRouting", Routing.getRoutingTool().prefs, 50);
        cacheRetryDenseViaAreaSize = Pref.makeIntPref("SunRouterRetryDenseViaAreaSize", Routing.getRoutingTool().prefs, 100);
        cachePathSearchControl = Pref.makeIntPref("SunRouterPathSearchControl", Routing.getRoutingTool().prefs, 10000);
        cacheSparseViaModulo = Pref.makeIntPref("SunRouterSparseViaModulo", Routing.getRoutingTool().prefs, 31);
        cacheLowPathSearchCost = Pref.makeIntPref("SunRouterLowPathSearchCost", Routing.getRoutingTool().prefs, 5);
        cacheMediumPathSearchCost = Pref.makeIntPref("SunRouterMediumPathSearchCost", Routing.getRoutingTool().prefs, 20);
        cacheHighPathSearchCost = Pref.makeIntPref("SunRouterHighPathSearchCost", Routing.getRoutingTool().prefs, 100);
        cacheTakenPathSearchCost = Pref.makeIntPref("SunRouterTakenPathSearchCost", Routing.getRoutingTool().prefs, 10000);
    }

    public static class Activity {
        int numCreatedArcs;
        int numCreatedNodes;
        ImmutableArcInst[] createdArcs = new ImmutableArcInst[3];
        CellId[] createdArcsParents = new CellId[3];
        ImmutableNodeInst[] createdNodes = new ImmutableNodeInst[3];
        int numDeletedArcs;
        int numDeletedNodes;
        ImmutableArcInst deletedArc;
        CellId deletedArcParent;
        PortProtoId[] deletedPorts = new PortProtoId[2];

        Activity() {
        }
    }

    private static class UnrouteNetsJob
    extends Job {
        private Cell cell;
        private Set<Network> nets;
        private List<ArcInst> highlightThese;

        private UnrouteNetsJob(Cell cell, Set<Network> nets) {
            super("Unroute Network", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nets = nets;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Netlist netList = this.cell.getNetlist();
            if (netList == null) {
                throw new JobException("Sorry, a deadlock aborted unrouting (network information unavailable).  Please try again");
            }
            this.highlightThese = new ArrayList<ArcInst>();
            Map<Network, ArcInst[]> arcMap = null;
            if (this.cell.getView() != View.SCHEMATIC) {
                arcMap = netList.getArcInstsByNetwork();
            }
            int total = this.nets.size();
            Network[] netsToUnroute = new Network[total];
            ArrayList<UnroutePort[]> netEnds = new ArrayList<UnroutePort[]>();
            HashSet<NodeInst> deleteAllNodes = new HashSet<NodeInst>();
            HashSet<ArcInst> deleteAllArcs = new HashSet<ArcInst>();
            int i2 = 0;
            Iterator<Network> iterator = this.nets.iterator();
            while (iterator.hasNext()) {
                Network net;
                netsToUnroute[i2] = net = iterator.next();
                HashSet<ArcInst> arcs = new HashSet<ArcInst>();
                HashSet<NodeInst> nodes = new HashSet<NodeInst>();
                List<Connection> netCons = Routing.findNetEnds(net, arcMap, arcs, nodes, netList, false);
                UnroutePort[] netUnroutePorts = new UnroutePort[netCons.size()];
                for (int j2 = 0; j2 < netCons.size(); ++j2) {
                    netUnroutePorts[j2] = new UnroutePort(netCons.get(j2));
                }
                netEnds.add(netUnroutePorts);
                for (NodeInst ni : nodes) {
                    deleteAllNodes.add(ni);
                }
                for (ArcInst ai : arcs) {
                    deleteAllArcs.add(ai);
                }
                ++i2;
            }
            this.cell.killArcs(deleteAllArcs);
            this.cell.killNodes(deleteAllNodes);
            for (int j3 = 0; j3 < total && !this.makeUnroutedNet(netsToUnroute[j3], (UnroutePort[])netEnds.get(j3), netList, this.highlightThese); ++j3) {
            }
            this.fieldVariableChanged("highlightThese");
            return true;
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            wnd.clearHighlighting();
            for (ArcInst ai : this.highlightThese) {
                wnd.addElectricObject(ai, ai.getParent());
            }
            wnd.finishedHighlighting();
        }

        private boolean makeUnroutedNet(Network net, UnroutePort[] netEnds, Netlist netList, List<ArcInst> highlightThese) {
            EditingPreferences ep = this.getEditingPreferences();
            TextDescriptor td = ep.getArcTextDescriptor();
            Cell cell = net.getNetlist().getCell();
            ImmutableArcInst a2 = Generic.tech().unrouted_arc.getDefaultInst(ep);
            long gridExtend = a2.getGridExtendOverMin();
            int count = netEnds.length;
            if (count >= 1000) {
                double x = 0.0;
                double y = 0.0;
                for (int i2 = 0; i2 < count; ++i2) {
                    x += netEnds[i2].center.getX();
                    y += netEnds[i2].center.getY();
                }
                EPoint center = EPoint.fromLambda(x / (double)count, y / (double)count);
                PrimitiveNode centerNp = Generic.tech().unroutedPinNode;
                double width = centerNp.getDefWidth(ep);
                double height = centerNp.getDefHeight(ep);
                NodeInst centerNi = NodeInst.makeInstance(centerNp, ep, center, width, height, net.getParent());
                PortInst tail = centerNi.getOnlyPortInst();
                for (int i3 = 0; i3 < count; ++i3) {
                    PortInst head = netEnds[i3].pi;
                    EPoint headP = netEnds[i3].center;
                    ArcInst ai = ArcInst.newInstanceNoCheck(cell, Generic.tech().unrouted_arc, null, td, head, tail, headP, center, gridExtend, -1, a2.flags);
                    if (ai == null) {
                        System.out.println("Could not create unrouted arc");
                        return true;
                    }
                    highlightThese.add(ai);
                }
            } else {
                int[] covered = new int[count];
                for (int i4 = 0; i4 < count; ++i4) {
                    covered[i4] = 0;
                }
                int first = 0;
                while (true) {
                    boolean found = true;
                    double bestdist = 0.0;
                    int besti = 0;
                    int bestj = 0;
                    for (int i5 = 0; i5 < count; ++i5) {
                        for (int j2 = i5 + 1; j2 < count; ++j2) {
                            if (first != 0 && covered[i5] + covered[j2] != 1) continue;
                            double dist = netEnds[i5].center.distance(netEnds[j2].center);
                            if (!found && dist >= bestdist) continue;
                            found = false;
                            bestdist = dist;
                            besti = i5;
                            bestj = j2;
                        }
                    }
                    if (found) break;
                    covered[bestj] = 1;
                    covered[besti] = 1;
                    PortInst head = netEnds[besti].pi;
                    PortInst tail = netEnds[bestj].pi;
                    EPoint headP = netEnds[besti].center;
                    EPoint tailP = netEnds[bestj].center;
                    ArcInst ai = ArcInst.newInstanceNoCheck(cell, Generic.tech().unrouted_arc, null, td, head, tail, headP, tailP, gridExtend, -1, a2.flags);
                    if (ai == null) {
                        System.out.println("Could not create unrouted arc");
                        return true;
                    }
                    highlightThese.add(ai);
                    ++first;
                }
            }
            return false;
        }

        private static class UnroutePort {
            final PortInst pi;
            final EPoint center;

            UnroutePort(Connection con) {
                this.pi = con.getPortInst();
                this.center = this.pi.getCenter();
            }
        }
    }

    private static class UnrouteSegJob
    extends Job {
        private Cell cell;
        private ArcInst ai;

        private UnrouteSegJob(Cell cell, ArcInst ai) {
            super("Unroute Segment", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.ai = ai;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Connection newEnd;
            Connection newEnd2;
            HashSet<ArcInst> arcsToUnroute = new HashSet<ArcInst>();
            HashSet<NodeInst> nodesToUnroute = new HashSet<NodeInst>();
            arcsToUnroute.add(this.ai);
            Connection end1 = this.ai.getHead();
            while ((newEnd2 = this.pushEnd(end1, arcsToUnroute, nodesToUnroute)) != null) {
                end1 = newEnd2;
            }
            Connection end2 = this.ai.getTail();
            while ((newEnd = this.pushEnd(end2, arcsToUnroute, nodesToUnroute)) != null) {
                end2 = newEnd;
            }
            PortInst pi1 = end1.getPortInst();
            PortInst pi2 = end2.getPortInst();
            this.cell.killArcs(arcsToUnroute);
            this.cell.killNodes(nodesToUnroute);
            EditingPreferences ep = this.getEditingPreferences();
            this.ai = ArcInst.makeInstance(Generic.tech().unrouted_arc, ep, pi1, pi2);
            if (this.ai == null) {
                System.out.println("FAILED TO MAKE UNROUTED ARC");
            }
            this.fieldVariableChanged("ai");
            return true;
        }

        private Connection pushEnd(Connection end, Set<ArcInst> arcsToUnroute, Set<NodeInst> nodesToUnroute) {
            NodeInst ni = end.getPortInst().getNodeInst();
            if (nodesToUnroute.contains(ni)) {
                return null;
            }
            if (ni.hasExports()) {
                return null;
            }
            if (ni.isCellInstance()) {
                return null;
            }
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.CONNECT && fun != PrimitiveNode.Function.SUBSTRATE && fun != PrimitiveNode.Function.WELL) {
                return null;
            }
            if (ni.getNumConnections() != 2) {
                return null;
            }
            Connection oCon = null;
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection c2 = it.next();
                if (c2.getArc() == end.getArc() || arcsToUnroute.contains(c2.getArc())) continue;
                oCon = c2;
                break;
            }
            if (oCon == null) {
                return null;
            }
            nodesToUnroute.add(ni);
            arcsToUnroute.add(oCon.getArc());
            return oCon.getArc().getConnection(1 - oCon.getEndIndex());
        }

        @Override
        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            if (this.ai != null) {
                wnd.clearHighlighting();
                wnd.addElectricObject(this.ai, this.ai.getParent());
                wnd.finishedHighlighting();
            }
        }
    }

    private static class CopyRoutingTopology
    extends Job {
        private Cell fromCell;
        private Cell toCell;

        protected CopyRoutingTopology(Cell fromCell, Cell toCell) {
            super("Copy Routing Topology", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toCell = toCell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            return Routing.copyTopology(this.fromCell, this.toCell, this.getEditingPreferences());
        }
    }

    private static class NodeMatch {
        NodeInst ni;
        NodeInst otherNi;

        NodeMatch(NodeInst ni) {
            this.ni = ni;
        }

        void findEquivalentByName(Cell other, Set<NodeInst> alreadyMatched) {
            Iterator<ElectricObject> it;
            String thisName = this.ni.getName();
            int busdelim = 91;
            int busstart = thisName.lastIndexOf(91);
            if (busstart > 0) {
                it = other.getNodes();
                while (it.hasNext()) {
                    String aname;
                    int busoni;
                    oNi = it.next();
                    if (alreadyMatched.contains(oNi) || (busoni = (aname = oNi.getName()).lastIndexOf(91)) != busstart || !aname.regionMatches(0, thisName, 0, busstart)) continue;
                    this.otherNi = oNi;
                    return;
                }
            } else {
                it = other.getNodes();
                while (it.hasNext()) {
                    oNi = it.next();
                    if (alreadyMatched.contains(oNi) || !oNi.getName().equals(thisName)) continue;
                    this.otherNi = oNi;
                    return;
                }
            }
            if (!this.ni.isCellInstance() && this.ni.hasExports()) {
                it = this.ni.getExports();
                while (it.hasNext()) {
                    Export e2 = (Export)it.next();
                    String eName = e2.getName();
                    Iterator<Export> oIt = other.getExports();
                    while (oIt.hasNext()) {
                        Export oE = oIt.next();
                        if (!eName.equalsIgnoreCase(oE.getName())) continue;
                        this.otherNi = oE.getOriginalPort().getNodeInst();
                        return;
                    }
                }
            }
        }
    }

    private static class NameMatchSpatially
    implements Comparator<NodeMatch> {
        private NameMatchSpatially() {
        }

        @Override
        public int compare(NodeMatch nm1, NodeMatch nm2) {
            NodeInst n1 = nm1.ni;
            NodeInst n2 = nm2.ni;
            double x1 = n1.getAnchorCenterX();
            double y1 = n1.getAnchorCenterY();
            double x2 = n2.getAnchorCenterX();
            double y2 = n2.getAnchorCenterY();
            if (y1 == y2) {
                if (x1 == x2) {
                    return 0;
                }
                if (x1 > x2) {
                    return 1;
                }
                return -1;
            }
            if (y1 == y2) {
                return 0;
            }
            if (y1 > y2) {
                return 1;
            }
            return -1;
        }
    }

    private static class InstancesSpatially
    implements Comparator<NodeInst> {
        private InstancesSpatially() {
        }

        @Override
        public int compare(NodeInst n1, NodeInst n2) {
            double x1 = n1.getAnchorCenterX();
            double y1 = n1.getAnchorCenterY();
            double x2 = n2.getAnchorCenterX();
            double y2 = n2.getAnchorCenterY();
            if (y1 == y2) {
                if (x1 == x2) {
                    return 0;
                }
                if (x1 > x2) {
                    return 1;
                }
                return -1;
            }
            if (y1 == y2) {
                return 0;
            }
            if (y1 > y2) {
                return 1;
            }
            return -1;
        }
    }

    private static class PortsByName
    implements Comparator<PortInst> {
        private PortsByName() {
        }

        @Override
        public int compare(PortInst p1, PortInst p2) {
            NodeInst n1 = p1.getNodeInst();
            NodeInst n2 = p2.getNodeInst();
            return n1.getName().compareToIgnoreCase(n2.getName());
        }
    }

    public static final class SoGNetOrder
    extends Enum<SoGNetOrder> {
        public static final /* enum */ SoGNetOrder SOGNETORDERDESCENDING = new SoGNetOrder(1);
        public static final /* enum */ SoGNetOrder SOGNETORDERASCENDING = new SoGNetOrder(2);
        public static final /* enum */ SoGNetOrder SOGNETORDERGIVEN = new SoGNetOrder(3);
        public static final /* enum */ SoGNetOrder SOGNETORDERBUS = new SoGNetOrder(4);
        public static final /* enum */ SoGNetOrder SOGNETORDERPERCENTAGE = new SoGNetOrder(5);
        public static final /* enum */ SoGNetOrder SOGNETORDERORIGINAL = new SoGNetOrder(0);
        private int value = -1;
        private static final /* synthetic */ SoGNetOrder[] $VALUES;

        public static SoGNetOrder[] values() {
            return (SoGNetOrder[])$VALUES.clone();
        }

        public static SoGNetOrder valueOf(String name) {
            return Enum.valueOf(SoGNetOrder.class, name);
        }

        private SoGNetOrder(int val) {
            this.value = val;
        }

        int getValue() {
            return this.value;
        }

        public static SoGNetOrder findByValue(int level) {
            for (SoGNetOrder s : SoGNetOrder.values()) {
                if (s.getValue() != level) continue;
                return s;
            }
            assert (false);
            return null;
        }

        private static /* synthetic */ SoGNetOrder[] $values() {
            return new SoGNetOrder[]{SOGNETORDERDESCENDING, SOGNETORDERASCENDING, SOGNETORDERGIVEN, SOGNETORDERBUS, SOGNETORDERPERCENTAGE, SOGNETORDERORIGINAL};
        }

        static {
            $VALUES = SoGNetOrder.$values();
        }
    }

    public static final class SoGContactsStrategy
    extends Enum<SoGContactsStrategy> {
        public static final /* enum */ SoGContactsStrategy SOGCONTACTSATTOPLEVEL = new SoGContactsStrategy(0, "Contacts at top level");
        public static final /* enum */ SoGContactsStrategy SOGCONTACTSUSEEXISTINGSUBCELLS = new SoGContactsStrategy(1, "Contacts use existing subcells or place at top");
        public static final /* enum */ SoGContactsStrategy SOGCONTACTSALWAYSINSUBCELLS = new SoGContactsStrategy(2, "Contacts use existing subcells or create new ones");
        public static final /* enum */ SoGContactsStrategy SOGCONTACTSFORCESUBCELLS = new SoGContactsStrategy(3, "Contacts create new subcells");
        String explanation;
        int level;
        private static final /* synthetic */ SoGContactsStrategy[] $VALUES;

        public static SoGContactsStrategy[] values() {
            return (SoGContactsStrategy[])$VALUES.clone();
        }

        public static SoGContactsStrategy valueOf(String name) {
            return Enum.valueOf(SoGContactsStrategy.class, name);
        }

        private SoGContactsStrategy(int num, String name) {
            this.level = num;
            this.explanation = name;
        }

        int getLevel() {
            return this.level;
        }

        public static SoGContactsStrategy findByLevel(int level) {
            for (SoGContactsStrategy s : SoGContactsStrategy.values()) {
                if (s.getLevel() != level) continue;
                return s;
            }
            assert (false);
            return null;
        }

        public String toString() {
            return this.explanation;
        }

        private static /* synthetic */ SoGContactsStrategy[] $values() {
            return new SoGContactsStrategy[]{SOGCONTACTSATTOPLEVEL, SOGCONTACTSUSEEXISTINGSUBCELLS, SOGCONTACTSALWAYSINSUBCELLS, SOGCONTACTSFORCESUBCELLS};
        }

        static {
            $VALUES = SoGContactsStrategy.$values();
        }
    }
}

