/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing2.Metric;
import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import java.util.Arrays;
import java.util.Map;

public final class MSTMetric
extends Metric {
    Edge[] edges = null;
    UnionFind connected = null;

    public MSTMetric(PlacementFrame.PlacementNetwork net, Map<PlacementFrame.PlacementNode, ProxyNode> hm, ProxyNode[] originals, ProxyNode[] replacements) {
        PlacementFrame.PlacementPort[] ports = new PlacementFrame.PlacementPort[net.getPortsOnNet().size()];
        ports = net.getPortsOnNet().toArray(ports);
        this.connected = new UnionFind(ports.length);
        this.edges = new Edge[(ports.length - 1) * ports.length / 2];
        int c2 = 0;
        for (int i2 = 0; i2 < ports.length; ++i2) {
            int j2 = i2 + 1;
            while (j2 < ports.length) {
                this.edges[c2] = new Edge(ports[i2], ports[j2], i2, j2, hm, originals, replacements);
                ++j2;
                ++c2;
            }
        }
    }

    public MSTMetric(PlacementFrame.PlacementNetwork net) {
        this(net, null, new ProxyNode[0], new ProxyNode[0]);
    }

    public double compute() {
        double length = 0.0;
        int unions = this.connected.nodes.length - 1;
        Arrays.sort(this.edges);
        for (int i2 = 0; i2 < this.edges.length && unions > 0; ++i2) {
            int subgraph1 = this.edges[i2].from;
            int subgraph2 = this.edges[i2].to;
            if (this.connected.find(subgraph1) == this.connected.find(subgraph2)) continue;
            this.connected.union(subgraph1, subgraph2);
            --unions;
            length += Math.sqrt((double)this.edges[i2].length / 1000.0);
        }
        return length;
    }

    @Override
    public double netLength(PlacementFrame.PlacementNetwork network) {
        MSTMetric foo = new MSTMetric(network);
        return foo.compute();
    }

    @Override
    public double netLength(PlacementFrame.PlacementNetwork network, Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap, ProxyNode[] originals, ProxyNode[] replacements) {
        MSTMetric foo = new MSTMetric(network, proxyMap, originals, replacements);
        return foo.compute();
    }

    private class Edge
    implements Comparable<Edge> {
        int from;
        int to;
        int length;

        public Edge(PlacementFrame.PlacementPort from, PlacementFrame.PlacementPort to, int fi, int ti, Map<PlacementFrame.PlacementNode, ProxyNode> hm, ProxyNode[] originals, ProxyNode[] replacements) {
            double y_2;
            double x_2;
            double y_1;
            double x_1;
            this.from = fi;
            this.to = ti;
            if (hm == null) {
                x_1 = from.getRotatedOffX() + from.getPlacementNode().getPlacementX();
                y_1 = from.getRotatedOffY() + from.getPlacementNode().getPlacementY();
                x_2 = to.getRotatedOffX() + to.getPlacementNode().getPlacementX();
                y_2 = to.getRotatedOffY() + to.getPlacementNode().getPlacementY();
            } else {
                ProxyNode fromNode = hm.get(from.getPlacementNode());
                ProxyNode toNode = hm.get(to.getPlacementNode());
                for (int i2 = 0; i2 < originals.length; ++i2) {
                    if (fromNode == originals[i2]) {
                        fromNode = replacements[i2];
                    }
                    if (toNode != originals[i2]) continue;
                    toNode = replacements[i2];
                }
                x_1 = from.getRotatedOffX() + fromNode.getPlacementX();
                y_1 = from.getRotatedOffY() + fromNode.getPlacementY();
                x_2 = to.getRotatedOffX() + toNode.getPlacementX();
                y_2 = to.getRotatedOffY() + toNode.getPlacementY();
            }
            this.length = (int)(((x_1 - x_2) * (x_1 - x_2) + (y_1 - y_2) * (y_1 - y_2)) * 1000.0);
        }

        @Override
        public int compareTo(Edge other) {
            return this.length - other.length;
        }
    }

    static class UnionFind {
        Node[] nodes;
        Node[] stack;

        public UnionFind(int size) {
            this.nodes = new Node[size];
            this.stack = new Node[size];
        }

        private Node findNode(int a2) {
            Node na = this.nodes[a2];
            if (na == null) {
                Node root = new Node(a2);
                root.child = new Node(a2);
                root.child.parent = root;
                this.nodes[a2] = root.child;
                return root;
            }
            return this.findNode(na);
        }

        public int find(int a2) {
            return this.findNode((int)a2).value;
        }

        private Node findNode(Node node) {
            int top = 0;
            while (node.parent.child == null) {
                this.stack[top++] = node;
                node = node.parent;
            }
            Node rootChild = node;
            while (top > 0) {
                node = this.stack[--top];
                node.parent = rootChild;
            }
            return rootChild.parent;
        }

        public boolean isEquiv(int a2, int b2) {
            return this.findNode(a2) == this.findNode(b2);
        }

        public void union(int a2, int b2) {
            Node nb;
            Node na = this.findNode(a2);
            if (na == (nb = this.findNode(b2))) {
                return;
            }
            if (na.rank > nb.rank) {
                nb.child.parent = na.child;
                na.value = b2;
            } else {
                na.child.parent = nb.child;
                nb.value = b2;
                if (na.rank == nb.rank) {
                    ++nb.rank;
                }
            }
        }

        static class Node {
            Node parent;
            Node child;
            int value;
            int rank;

            public Node(int v) {
                this.value = v;
                this.rank = 0;
            }
        }
    }
}

