/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import java.util.List;

public class BBMetric {
    private double currentScore;
    private List<PlacementFrame.PlacementNetwork> allNetworks;

    public BBMetric(List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.allNetworks = allNetworks;
    }

    public double getScore() {
        this.currentScore = 0.0;
        for (int i2 = 0; i2 < this.allNetworks.size(); ++i2) {
            PlacementFrame.PlacementNetwork n2 = this.allNetworks.get(i2);
            this.currentScore += this.calculateBoundingBoxScore(n2);
        }
        return this.currentScore;
    }

    protected double calculateBoundingBoxScore(PlacementFrame.PlacementNetwork n2) {
        List<PlacementFrame.PlacementPort> l2 = n2.getPortsOnNet();
        if (l2.size() == 0) {
            return 0.0;
        }
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        for (PlacementFrame.PlacementPort p : l2) {
            PlacementFrame.PlacementNode originalPlacementNode = p.getPlacementNode();
            double movedX = 0.0;
            double movedY = 0.0;
            double x = movedX + originalPlacementNode.getPlacementX();
            double y = movedY + originalPlacementNode.getPlacementY();
            if (x < xMin) {
                xMin = x;
            }
            if (x > xMax) {
                xMax = x;
            }
            if (y < yMin) {
                yMin = y;
            }
            if (!(y > yMax)) continue;
            yMax = y;
        }
        double score = xMax - xMin + (yMax - yMin);
        return score;
    }
}

