/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing1.metrics.AreaOverlapMetric;
import com.sun.electric.tool.placement.simulatedAnnealing1.metrics.MSTMetric;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SimulatedAnnealing
extends PlacementFrame {
    public final int STEP_THREAD = 20;
    public final int INNER_LOOP_TOTAL = 800;
    public PlacementFrame.PlacementParameter maxThreadsParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("threads", "Number of threads:", 4);
    public PlacementFrame.PlacementParameter maxRuntimeParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("runtime", "Runtime (seconds):", 240);
    private Temperature temp;
    private Random rand = new Random();
    private Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, MutableInteger>> connectivityMap;

    @Override
    public String getAlgorithmName() {
        return "Simulated-Annealing-1";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        this.setParamterValues(this.maxThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue());
        System.out.println("Simulated annealing started.");
        this.createAndFillConnectivityMap(nodesToPlace, allNetworks);
        this.temp = new Temperature(nodesToPlace);
        System.out.println("Temperature = " + this.temp.getTemperature());
        int numInnerSteps = 800 / (this.numOfThreads * 20);
        System.out.println("Inner Steps = " + numInnerSteps);
        System.out.println("Running placement, please wait...");
        ExecutorService threadPool = Executors.newFixedThreadPool(this.numOfThreads);
        LinkedList<PlacementThread> workforce = new LinkedList<PlacementThread>();
        for (int i2 = 0; i2 < this.numOfThreads; ++i2) {
            PlacementThread worker = new PlacementThread(numInnerSteps, nodesToPlace, allNetworks);
            workforce.add(worker);
        }
        while (this.temp.nextIteration()) {
            for (int middleStep = 0; middleStep < numInnerSteps; ++middleStep) {
                List results = null;
                for (int i3 = 0; i3 < this.numOfThreads; ++i3) {
                    ((PlacementThread)workforce.get(i3)).reset();
                }
                double minScore = Double.MAX_VALUE;
                int bestThread = -1;
                try {
                    results = threadPool.invokeAll(workforce);
                    minScore = Double.MAX_VALUE;
                    bestThread = -1;
                    for (int i4 = 0; i4 < this.numOfThreads; ++i4) {
                        Double threadScore = (Double)results.get(i4).get();
                        if (!(threadScore < minScore)) continue;
                        minScore = threadScore;
                        bestThread = i4;
                    }
                    ((PlacementThread)workforce.get(bestThread)).getIncState().makeGlobal();
                    continue;
                }
                catch (Exception e2) {
                    System.out.println("An error occured. Aborting. Message:" + e2.getMessage());
                    e2.printStackTrace(System.out);
                    return;
                }
            }
        }
    }

    private double getMinChipArea(List<PlacementFrame.PlacementNode> nodesToPlace) {
        double area = 0.0;
        for (PlacementFrame.PlacementNode node : nodesToPlace) {
            area += node.getHeight() * node.getWidth();
        }
        return area;
    }

    private void createAndFillConnectivityMap(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.connectivityMap = new HashMap<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, MutableInteger>>();
        for (PlacementFrame.PlacementNetwork plNet : allNetworks) {
            List<PlacementFrame.PlacementPort> portsInNetwork = plNet.getPortsOnNet();
            for (int i2 = 0; i2 < portsInNetwork.size(); ++i2) {
                PlacementFrame.PlacementPort plPort1 = portsInNetwork.get(i2);
                PlacementFrame.PlacementNode plNode1 = plPort1.getPlacementNode();
                for (int j2 = i2 + 1; j2 < portsInNetwork.size(); ++j2) {
                    PlacementFrame.PlacementPort plPort2 = portsInNetwork.get(j2);
                    PlacementFrame.PlacementNode plNode2 = plPort2.getPlacementNode();
                    this.incrementMap(plNode1, plNode2);
                    this.incrementMap(plNode2, plNode1);
                }
            }
        }
    }

    private void incrementMap(PlacementFrame.PlacementNode plNode1, PlacementFrame.PlacementNode plNode2) {
        MutableInteger mi;
        Map<PlacementFrame.PlacementNode, MutableInteger> destMap = this.connectivityMap.get(plNode1);
        if (destMap == null) {
            destMap = new HashMap<PlacementFrame.PlacementNode, MutableInteger>();
            this.connectivityMap.put(plNode1, destMap);
        }
        if ((mi = destMap.get(plNode2)) == null) {
            mi = new MutableInteger(0);
            destMap.put(plNode2, mi);
        }
        mi.increment();
    }

    private int getConnectivity(PlacementFrame.PlacementNode plNode1, PlacementFrame.PlacementNode plNode2) {
        Map<PlacementFrame.PlacementNode, MutableInteger> destMap = this.connectivityMap.get(plNode1);
        if (destMap == null) {
            return 0;
        }
        MutableInteger mi = destMap.get(plNode2);
        if (mi == null) {
            return 0;
        }
        return mi.intValue();
    }

    public PlacementFrame.PlacementNode getHighestConnectedNode(PlacementFrame.PlacementNode node) {
        PlacementFrame.PlacementNode highestConnected = null;
        MutableInteger highest = new MutableInteger(0);
        Map<PlacementFrame.PlacementNode, MutableInteger> conn = this.connectivityMap.get(node);
        if (conn == null) {
            return null;
        }
        for (PlacementFrame.PlacementNode n2 : conn.keySet()) {
            if (conn.get(n2).intValue() <= highest.intValue()) continue;
            highest = conn.get(n2);
            highestConnected = n2;
        }
        return highestConnected;
    }

    public class Temperature {
        private double temperature;
        private final double initialTemperature = 5000.0;
        private final double threshholdTemperature = 0.1;
        private Random rand = new Random();
        private double initialChipLength;

        public Temperature(List<PlacementFrame.PlacementNode> nodesToPlace) {
            this.rand.setSeed(System.currentTimeMillis());
            this.initialChipLength = Math.sqrt(SimulatedAnnealing.this.getMinChipArea(nodesToPlace)) * 2.0;
            System.out.println("Initial Chip Length = " + this.initialChipLength);
            this.temperature = 5000.0;
        }

        public double getCurrentSwapDistance() {
            double newSwapDisttance = this.initialChipLength * (Math.log(this.temperature) / Math.log(5000.0));
            return newSwapDisttance;
        }

        public void setTemperature(double newTemperature) {
            this.temperature = newTemperature;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public void reset() {
            this.temperature = 5000.0;
        }

        public boolean nextIteration() {
            this.decTempQuadratically();
            return this.temperature > 0.1;
        }

        private void decTempQuadratically() {
            double x = 1.0 / Math.log(1.0 + this.temperature) * 2.0 - 1.0;
            double xSquared = x * x;
            double alpha = 0.95 - xSquared * 0.1499999999999999;
            this.temperature = alpha * this.temperature;
        }

        public boolean accept(double deltaE) {
            return deltaE < 0.0;
        }
    }

    public class PlacementThread
    implements Callable<Double> {
        private IncrementalState incState = null;
        private int numSteps = 0;

        public PlacementThread(int numSteps, List<PlacementFrame.PlacementNode> allNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
            this.numSteps = numSteps;
            this.incState = new IncrementalState(allNodes, allNetworks);
        }

        @Override
        public Double call() throws Exception {
            for (int i2 = 0; i2 < this.numSteps; ++i2) {
                double r = SimulatedAnnealing.this.rand.nextDouble();
                if (!(r < 0.2 ? !this.incState.chooseAndSwapNodes() : !this.incState.moveNode())) continue;
            }
            return this.incState.getScore();
        }

        public IncrementalState getIncState() {
            return this.incState;
        }

        public void reset() {
            this.incState.reset();
        }
    }

    public class IncrementalState {
        private HashMap<Integer, PlacementNodePosition> changedNodes = new HashMap(20);
        private List<PlacementFrame.PlacementNode> originalNodes;
        private List<PlacementFrame.PlacementNetwork> allNetworks;
        private double currentC1;
        private double currentC2;
        private MSTMetric C1Metric;
        private AreaOverlapMetric C2Metric;

        public IncrementalState(List<PlacementFrame.PlacementNode> allNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
            this.originalNodes = allNodes;
            this.allNetworks = allNetworks;
            this.C1Metric = new MSTMetric(allNodes, allNetworks, this);
            this.C2Metric = new AreaOverlapMetric(allNodes, this);
            this.currentC1 = this.C1Metric.init(allNetworks);
            this.currentC2 = this.C2Metric.init(allNodes);
        }

        public double addNode(int index, PlacementNodePosition newNode) {
            this.changedNodes.put(index, newNode);
            this.currentC1 = this.C1Metric.update(index);
            this.currentC2 = this.C2Metric.update(index);
            return this.currentC1 + this.currentC2;
        }

        public double removeNode(int index) {
            this.changedNodes.remove(index);
            this.currentC1 = this.C1Metric.update(index);
            this.currentC2 = this.C2Metric.update(index);
            return this.currentC1 + this.currentC2;
        }

        public boolean moveNode() {
            int index = (int)Math.round(SimulatedAnnealing.this.rand.nextDouble() * (double)(this.originalNodes.size() - 1));
            PlacementNodePosition theOne = this.getNodeFromState(index);
            double x = theOne.getPlacementX();
            double y = theOne.getPlacementY();
            double maxDistance = 100.0;
            double newX = x - SimulatedAnnealing.this.rand.nextDouble() * maxDistance / 2.0 + SimulatedAnnealing.this.rand.nextDouble() * maxDistance;
            double newY = y - SimulatedAnnealing.this.rand.nextDouble() * maxDistance / 2.0 + SimulatedAnnealing.this.rand.nextDouble() * maxDistance;
            PlacementFrame.PlacementNode bestPartner = SimulatedAnnealing.this.getHighestConnectedNode(this.originalNodes.get(index));
            if (bestPartner != null) {
                double pX = bestPartner.getPlacementX();
                double pY = bestPartner.getPlacementY();
                if (SimulatedAnnealing.this.rand.nextBoolean()) {
                    newX = pX + (double)(SimulatedAnnealing.this.rand.nextBoolean() ? 1 : -1) * bestPartner.getWidth();
                    newY = pY;
                } else {
                    newX = pX;
                    newY = pY + (double)(SimulatedAnnealing.this.rand.nextBoolean() ? 1 : -1) * bestPartner.getHeight();
                }
            }
            theOne.setPlacement(newX, newY);
            double metricBeforeMove = this.getScore();
            this.addNode(index, theOne);
            double metricAfterMove = this.getScore();
            double deltaE = (metricAfterMove - metricBeforeMove) / metricAfterMove;
            if (SimulatedAnnealing.this.temp.accept(deltaE)) {
                return true;
            }
            theOne.setPlacement(x, y);
            this.addNode(index, theOne);
            return false;
        }

        public boolean chooseAndSwapNodes() {
            double maxDistance = SimulatedAnnealing.this.temp.getCurrentSwapDistance() / 10.0;
            double maxDistanceSquared = maxDistance * maxDistance;
            int numNodes = this.originalNodes.size();
            int index1 = (int)Math.round(SimulatedAnnealing.this.rand.nextDouble() * (double)(numNodes - 1));
            int index2 = 0;
            boolean partnerFound = false;
            for (int i2 = 0; i2 < numNodes / 10; ++i2) {
                double node2Y;
                double node1Y;
                double node2X;
                double node1X;
                double distance;
                double distanceSquared;
                index2 = (int)Math.round(SimulatedAnnealing.this.rand.nextDouble() * (double)(numNodes - 1));
                if (index2 == index1 || SimulatedAnnealing.this.getConnectivity(this.originalNodes.get(index1), this.originalNodes.get(index2)) > 4 || !((distanceSquared = (distance = ((node1X = this.getNodeFromState(index1).getPlacementX()) - (node2X = this.getNodeFromState(index2).getPlacementX())) * (node1X - node2X) + ((node1Y = this.getNodeFromState(index1).getPlacementY()) - (node2Y = this.getNodeFromState(index2).getPlacementY())) * (node1Y - node2Y)) * distance) < maxDistanceSquared)) continue;
                partnerFound = true;
                break;
            }
            if (!partnerFound) {
                return false;
            }
            PlacementNodePosition n1 = this.getNodeFromState(index1);
            PlacementNodePosition n2 = this.getNodeFromState(index2);
            double tempX = n1.getPlacementX();
            double tempY = n1.getPlacementY();
            n1.setPlacementX(n2.getPlacementX());
            n1.setPlacementY(n2.getPlacementY());
            n2.setPlacementX(tempX);
            n2.setPlacementY(tempY);
            double metricBeforeSwap = this.getScore();
            this.addNode(index1, n1);
            this.addNode(index2, n2);
            double metricAfterSwap = this.getScore();
            double deltaE = (metricAfterSwap - metricBeforeSwap) / metricAfterSwap;
            if (SimulatedAnnealing.this.temp.accept(deltaE)) {
                return true;
            }
            n2.setPlacementX(n1.getPlacementX());
            n2.setPlacementY(n1.getPlacementY());
            n1.setPlacementX(tempX);
            n1.setPlacementY(tempY);
            this.addNode(index1, n1);
            this.addNode(index2, n2);
            return false;
        }

        public PlacementNodePosition getNodeFromState(int index) {
            Integer ii = index;
            if (this.changedNodes.containsKey(ii)) {
                return this.changedNodes.get(ii);
            }
            return new PlacementNodePosition(this.originalNodes, index);
        }

        public boolean isNodeChanged(int index) {
            return this.changedNodes.containsKey(index);
        }

        public List<PlacementFrame.PlacementNode> getOriginalNodes() {
            return this.originalNodes;
        }

        public double getC1() {
            return this.currentC1;
        }

        public double getC2() {
            return this.currentC2;
        }

        public double getScore() {
            return this.currentC1 + 1000000.0 * this.currentC2;
        }

        public double reset() {
            this.changedNodes.clear();
            this.currentC1 = this.C1Metric.init(this.allNetworks);
            this.currentC2 = this.C2Metric.init(this.originalNodes);
            return this.getScore();
        }

        public double makeGlobal() {
            for (Map.Entry<Integer, PlacementNodePosition> entry : this.changedNodes.entrySet()) {
                int index = entry.getKey();
                PlacementNodePosition n2 = entry.getValue();
                PlacementFrame.PlacementNode originalPlacementNode = this.originalNodes.get(index);
                originalPlacementNode.setPlacement(n2.getPlacementX(), n2.getPlacementY());
                originalPlacementNode.setOrientation(n2.getPlacementOrientation());
            }
            this.changedNodes.clear();
            return this.getScore();
        }
    }

    public class PlacementNodePosition {
        private double x;
        private double y;
        private int index;
        private Orientation orientation = Orientation.IDENT;

        public PlacementNodePosition(List<PlacementFrame.PlacementNode> allNodes, int index) {
            PlacementFrame.PlacementNode originalNode = allNodes.get(index);
            this.x = originalNode.getPlacementX();
            this.y = originalNode.getPlacementY();
            this.index = index;
            this.orientation = originalNode.getPlacementOrientation();
        }

        public double getPlacementX() {
            return this.x;
        }

        public void setPlacementX(double x) {
            this.x = x;
        }

        public double getPlacementY() {
            return this.y;
        }

        public void setPlacementY(double y) {
            this.y = y;
        }

        public void setPlacement(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Orientation getPlacementOrientation() {
            return this.orientation;
        }

        public void setPlacementOrientation(Orientation o2) {
            this.orientation = o2;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

