/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Evolver;
import com.sun.electric.tool.placement.genetic2.Individual;
import java.util.List;
import java.util.Random;

public class UnifiedPopulation<I extends Individual> {
    private I[] indis;
    private Evolver[] evolvers;
    private Random rand;
    private long evolutionStepTime;
    double p;

    UnifiedPopulation(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, I[] indis, long evoStepTime, int numThreads, Random rand) {
        this.evolutionStepTime = evoStepTime;
        this.rand = rand;
        this.indis = indis;
        this.evolvers = new Evolver[numThreads];
        Random[] rands = new Random[numThreads];
        int n2 = 0;
        for (int i2 = 0; i2 < numThreads; ++i2) {
            rands[i2] = new Random(n2 += rand.nextInt());
            this.evolvers[i2] = new Evolver((Individual[])indis, this.evolutionStepTime, rands[i2]);
        }
    }

    public int getSize() {
        return this.indis.length;
    }

    public void setProgress(double p) {
        this.p = p;
        ((Individual)this.indis[0]).ref.setProgress(p);
        for (int i2 = 0; i2 < this.indis.length; ++i2) {
            ((Individual)this.indis[i2]).setProgress(p);
        }
    }

    public long getEvolverSteps() {
        long steps = 0L;
        for (Evolver e2 : this.evolvers) {
            steps += e2.getSteps();
        }
        return steps;
    }

    public void insert(Individual immigrant) {
        this.indis[this.indis.length - 1].copyFrom((Individual)immigrant);
    }

    public void reboot() {
        for (I i2 : this.indis) {
            ((Individual)i2).reboot(this.rand);
        }
    }

    public void evolveLocalMT(int numThreads) {
        int i2;
        Thread[] threads = new Thread[numThreads];
        for (i2 = 0; i2 < numThreads; ++i2) {
            threads[i2] = new Thread(this.evolvers[i2]);
            threads[i2].start();
        }
        for (i2 = 0; i2 < numThreads; ++i2) {
            try {
                threads[i2].join();
                continue;
            }
            catch (InterruptedException e2) {
                System.exit(-3333);
            }
        }
    }

    public void reEvaluateAll() {
        for (I i2 : this.indis) {
            ((Individual)i2).evaluate();
        }
    }

    public Individual getChampion() {
        int pos = 0;
        int c2 = 0;
        double badness = ((Individual)this.indis[0]).getBadness();
        for (I i2 : this.indis) {
            if (((Individual)i2).getBadness() < badness) {
                pos = c2;
                badness = ((Individual)i2).getBadness();
            }
            ++c2;
        }
        return this.indis[pos];
    }

    public Individual getRandomOne() {
        return this.indis[this.rand.nextInt(this.indis.length)];
    }

    public Individual getAt(int pos) {
        return this.indis[pos];
    }
}

