/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.DeltaIndividual;
import com.sun.electric.tool.placement.genetic2.UniformGrid;
import com.sun.electric.tool.placement.genetic2.metrics.DeltaBBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Reference {
    double p = 0.0;
    public double[] badnessComponents;
    public double[] overlaps;
    public double[] netLengths;
    public double overlap;
    public double netLength;
    public double spread;
    public UniformGrid grid;
    public List<PlacementFrame.PlacementNode> nodesToPlace;
    public List<PlacementFrame.PlacementNetwork> allNetworks;
    Random rand;
    public double avgW;

    public Reference(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, Random rand) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
        this.rand = rand;
        this.overlap = 0.0;
        this.overlaps = new double[nodesToPlace.size()];
        this.netLengths = new double[allNetworks.size()];
        this.badnessComponents = new double[3];
        this.init();
        this.createGrid();
        this.calculateRefOverlap();
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
    }

    public void init() {
        int i2;
        PlacementFrame.PlacementNode n2;
        for (int i3 = 0; i3 < this.nodesToPlace.size(); ++i3) {
            n2 = this.nodesToPlace.get(i3);
            this.avgW += Math.max(n2.getWidth(), n2.getHeight()) / (double)this.nodesToPlace.size();
        }
        int l2 = (int)Math.sqrt(this.nodesToPlace.size());
        double s = 0.0;
        double m2 = 0.0;
        for (i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            m2 = Math.max(this.nodesToPlace.get(i2).getHeight(), this.nodesToPlace.get(i2).getWidth());
            s = Math.max(s, m2);
        }
        for (i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            n2 = this.nodesToPlace.get(i2);
            n2.setPlacement((double)(-l2 / 2) * s + (double)(i2 % l2) * s, (double)(-l2 / 2) * s + (double)((int)((double)i2 / (double)l2)) * s);
            n2.setOrientation(Orientation.IDENT);
        }
    }

    public double getSemiperimeterLength() {
        Block b2 = new Block();
        b2.valuesFrom(this.nodesToPlace.get(0));
        double left = b2.getLeft();
        double top = b2.getTop();
        double right = b2.getRight();
        double bottom = b2.getBottom();
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            b2.valuesFrom(this.nodesToPlace.get(i2));
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (!(b2.getBottom() < bottom)) continue;
            bottom = b2.getBottom();
        }
        return top - bottom + (right - left);
    }

    public double calculateSpread() {
        this.spread = 0.0;
        Block b2 = new Block();
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            b2.valuesFrom(this.nodesToPlace.get(i2));
            this.spread += Math.sqrt(b2.getX() * b2.getX() + b2.getY() * b2.getY()) * b2.getWidth() * b2.getHeight();
        }
        return this.spread;
    }

    public void setProgress(double p) {
        this.p = p;
    }

    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * (1.0 + 300.0 * this.p * this.p);
        return badness += 1.0E-5 * this.spread;
    }

    public double[] getBadnessComponents() {
        return this.badnessComponents;
    }

    public void calculateFirstTime() {
        this.createGrid();
        this.calculateRefOverlap();
        this.calculateRefNetLength();
        this.calculateSpread();
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
    }

    public void calculateRefOverlap() {
        this.overlap = 0.0;
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            this.overlap += this.grid.collide(i2, this.nodesToPlace, this.overlaps);
        }
    }

    public double getNaiveOverlap() {
        Block a2 = new Block();
        Block b2 = new Block();
        double naiveOverlap = 0.0;
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            PlacementFrame.PlacementNode n1 = this.nodesToPlace.get(i2);
            a2.valuesFrom(n1);
            for (int j2 = 0; j2 < i2; ++j2) {
                if (i2 == j2) continue;
                PlacementFrame.PlacementNode n2 = this.nodesToPlace.get(j2);
                b2.valuesFrom(n2);
                naiveOverlap += a2.intersectionArea(b2);
            }
        }
        return naiveOverlap;
    }

    public void calculateRefNetLength() {
        this.netLength = DeltaBBMetric.compute();
    }

    public void update(DeltaIndividual indi) {
        int i2;
        this.netLength = indi.getBadnessComponents()[0];
        this.overlap = indi.getBadnessComponents()[1];
        this.netLengths = new double[indi.netLengths.length];
        for (i2 = 0; i2 < indi.netLengths.length; ++i2) {
            this.netLengths[i2] = indi.netLengths[i2];
        }
        this.overlaps = new double[indi.overlaps.length];
        for (i2 = 0; i2 < indi.overlaps.length; ++i2) {
            this.overlaps[i2] = indi.overlaps[i2];
        }
        this.spread = indi.getBadnessComponents()[2];
        for (Block b2 : indi.blocks) {
            this.grid.remove(b2.getNr());
            Collections.sort(this.grid.insert(b2.getNr(), b2.getX(), b2.getY()));
            this.nodesToPlace.get(b2.getNr()).setPlacement(b2.getX(), b2.getY());
            this.nodesToPlace.get(b2.getNr()).setOrientation(b2.getOrientation());
        }
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
        this.badnessComponents[2] = this.spread;
    }

    public void createGrid() {
        double left = Double.POSITIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double maxW = 0.0;
        ArrayList<Double> xPositions = new ArrayList<Double>();
        ArrayList<Double> yPositions = new ArrayList<Double>();
        Block b2 = new Block();
        for (PlacementFrame.PlacementNode n2 : this.nodesToPlace) {
            b2.valuesFrom(n2);
            xPositions.add(b2.getX());
            yPositions.add(b2.getY());
            if (b2.getWidth() > maxW) {
                maxW = b2.getWidth();
            }
            if (!(b2.getHeight() > maxW)) continue;
            maxW = b2.getHeight();
        }
        Collections.sort(xPositions);
        Collections.sort(yPositions);
        left = (Double)xPositions.get(xPositions.size() / 10);
        right = (Double)xPositions.get(xPositions.size() - xPositions.size() / 10 - 1);
        bottom = (Double)yPositions.get(yPositions.size() / 10);
        top = (Double)yPositions.get(yPositions.size() - yPositions.size() / 10 - 1);
        this.grid = new UniformGrid(this.nodesToPlace, left, right, top, bottom, maxW);
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            this.grid.insert(i2, this.nodesToPlace.get(i2).getPlacementX(), this.nodesToPlace.get(i2).getPlacementY());
        }
    }
}

