/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Reference;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class Individual<I extends Individual>
implements Comparable<I> {
    protected double[] badnessComponents = new double[3];
    private double[] hashes;
    List<PlacementFrame.PlacementNode> nodesToPlace;
    List<PlacementFrame.PlacementNetwork> allNetworks;
    public ReadWriteLock rwLock;
    double p;
    public Reference ref;

    Individual(Reference ref) {
        this.ref = ref;
        this.nodesToPlace = ref.nodesToPlace;
        this.allNetworks = ref.allNetworks;
        this.rwLock = new ReentrantReadWriteLock();
    }

    public abstract void evaluate();

    public abstract void reboot(Random var1);

    public double distance() {
        return 0.0;
    }

    public void setProgress(double p) {
        this.p = p;
    }

    public double getSize() {
        return 5.0;
    }

    public abstract double distance(I var1);

    public abstract void writeToPlacement(List<PlacementFrame.PlacementNode> var1);

    @Override
    public int compareTo(I other) {
        if (this.getBadness() < ((Individual)other).getBadness()) {
            return -1;
        }
        return 1;
    }

    public abstract void copyFrom(I var1);

    public abstract void mutate(Random var1);

    public abstract void deriveFrom(I var1, I var2, Random var3);

    public abstract double calculateOverlap();

    public abstract double getBoundingBoxArea();

    public abstract double getSemiperimeterLength();

    public abstract double getNetLength();

    public double[] getBadnessComponents() {
        return this.badnessComponents;
    }

    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * 20.0;
        return badness += this.badnessComponents[2] * 20.0;
    }

    public void setBadness(double[] otherComponents) {
        for (int i2 = 0; i2 < this.badnessComponents.length; ++i2) {
            this.badnessComponents[i2] = otherComponents[i2];
        }
    }

    public double getXHash() {
        return 0.0;
    }

    public double getYHash() {
        return 0.0;
    }

    public double getRotHash() {
        return 0.0;
    }

    public double[] getHashes() {
        return this.hashes;
    }

    public double getHash() {
        return 0.0;
    }
}

