/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.ChromosomeMutation;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import java.util.Random;

public class ChromosomeMutationPadding
implements ChromosomeMutation {
    static int nbrOfPlaceHoldersToMutate = -1;
    static short maxChangePerStep;

    public ChromosomeMutationPadding(short maxChangePerStep) {
        ChromosomeMutationPadding.maxChangePerStep = maxChangePerStep;
    }

    @Override
    public void mutate(Chromosome c2, Random r) {
        assert (nbrOfPlaceHoldersToMutate > -1) : "set nbr of placeholders before using mutation";
        for (int i2 = 0; i2 < nbrOfPlaceHoldersToMutate; ++i2) {
            int indexOfPlaceholder = r.nextInt(c2.GeneXPadding.length);
            if (r.nextBoolean()) {
                int n2 = indexOfPlaceholder;
                c2.GeneXPadding[n2] = (short)(c2.GeneXPadding[n2] + r.nextInt(maxChangePerStep));
                if (c2.GeneXPadding[indexOfPlaceholder] >= 0) continue;
                c2.GeneXPadding[indexOfPlaceholder] = 0;
                continue;
            }
            int n3 = indexOfPlaceholder;
            c2.GeneYPadding[n3] = (short)(c2.GeneYPadding[n3] + r.nextInt(maxChangePerStep));
            if (c2.GeneYPadding[indexOfPlaceholder] >= 0) continue;
            c2.GeneYPadding[indexOfPlaceholder] = 0;
        }
    }

    @Override
    public void setMutationRate(double mutationRate) {
        nbrOfPlaceHoldersToMutate = (int)((double)GeneticPlacement.nodeProxies.length * mutationRate);
        if (nbrOfPlaceHoldersToMutate < 1) {
            nbrOfPlaceHoldersToMutate = 1;
        }
    }
}

