/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.CalculateForcesStageWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.EndWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.OverlapWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlaceNodesStageWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.StartUpStage;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.BBMetric;
import com.sun.electric.tool.placement.forceDirected2.utils.PlacementProperties;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.Stage;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import com.sun.electric.tool.placement.forceDirected2.utils.output.PNGOutput;
import com.sun.electric.util.math.MutableInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class StartUpStageWorker
extends StageWorker {
    protected static Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, MutableInteger>> connectivityMap = null;
    private double velocityFactor;
    private List<PlacementFrame.PlacementNode> nodesToPlace;
    private List<PlacementFrame.PlacementNetwork> allNetworks;
    private int widthCheckBoarding;
    private int heightCheckBoarding;
    private double fieldSize;
    private CheckboardingPattern checkPattern;

    public StartUpStageWorker(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
    }

    protected double bestSize() {
        double result = 0.0;
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            double cellMax = node.getHeight() > node.getWidth() ? node.getHeight() : node.getWidth();
            result = cellMax > result ? cellMax : result;
        }
        return result;
    }

    protected void calculateVelocityFactor() {
        this.velocityFactor = 1.0;
        double tmp = this.nodesToPlace.size();
        while (tmp > 1.0) {
            tmp /= 10.0;
            this.velocityFactor /= 10.0;
        }
    }

    protected void createCheckboardingPattern() {
        int findBestSizeMax = (int)Math.ceil(Math.sqrt(this.nodesToPlace.size()));
        int bestField = this.nodesToPlace.size() * 2;
        int bestIdx = 0;
        int divergence = PlacementProperties.getInstance().getDivergence();
        int start = findBestSizeMax - divergence < 1 ? 1 : findBestSizeMax - divergence;
        int end = findBestSizeMax + divergence > this.nodesToPlace.size() ? this.nodesToPlace.size() : findBestSizeMax + divergence;
        for (int i2 = start; i2 < end; ++i2) {
            int field = i2 * (int)Math.ceil((double)this.nodesToPlace.size() / (double)i2);
            if (field >= bestField) continue;
            bestField = field;
            bestIdx = i2;
        }
        this.widthCheckBoarding = bestIdx * 1;
        this.heightCheckBoarding = (int)(Math.ceil((double)this.nodesToPlace.size() / (double)bestIdx) * 1.0);
        this.checkPattern = new CheckboardingPattern(this.widthCheckBoarding, this.heightCheckBoarding, this.fieldSize, this.fieldSize);
    }

    protected void fillCheckboardingPattern() {
        Random rand = new Random(System.currentTimeMillis());
        ArrayList<Integer> places = new ArrayList<Integer>(this.heightCheckBoarding * this.widthCheckBoarding);
        for (int i2 = 0; i2 < this.heightCheckBoarding * this.widthCheckBoarding; ++i2) {
            places.add(i2);
        }
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            int listPos = rand.nextInt(places.size());
            int nodePos = (Integer)places.remove(listPos);
            int x = nodePos % this.widthCheckBoarding;
            int y = nodePos / this.widthCheckBoarding;
            CheckboardingField field = this.checkPattern.getField(x, y);
            node.setPlacement(field.getLocation().getX(), field.getLocation().getY());
            field.setNode(node);
        }
    }

    @Override
    public void run() {
        this.calculateVelocityFactor();
        this.fieldSize = this.bestSize();
        this.createCheckboardingPattern();
        this.fillCheckboardingPattern();
        PlacementForceDirectedStaged.setCheckboardingPattern(this.checkPattern);
        if (PlacementProperties.getInstance().getIterations() != 0) {
            PlacementProperties properties = PlacementProperties.getInstance();
            ArrayList<StageWorker> forces = new ArrayList<StageWorker>();
            ArrayList<StageWorker> move = new ArrayList<StageWorker>();
            ArrayList<StageWorker> overlap = new ArrayList<StageWorker>();
            ArrayList<StageWorker> endWorker = new ArrayList<StageWorker>();
            double threshold = PlacementProperties.getInstance().getOverlappingThreshold();
            for (int i2 = 0; i2 < properties.getNumOfThreads(); ++i2) {
                forces.add(new CalculateForcesStageWorker(connectivityMap, this.allNetworks));
                move.add(new PlaceNodesStageWorker(this.velocityFactor));
                overlap.add(new OverlapWorker(threshold, i2));
            }
            long finalTimeStamp = System.currentTimeMillis() + (long)(PlacementProperties.getInstance().getTimeout() * 1000);
            BBMetric bb = new BBMetric(this.nodesToPlace, this.allNetworks);
            PNGOutput out = new PNGOutput(this.nodesToPlace, this.allNetworks);
            endWorker.add(new EndWorker(PlacementProperties.getInstance().getIterations(), (StartUpStage)this.stage, this.widthCheckBoarding, this.heightCheckBoarding, this.checkPattern, this.velocityFactor, out, bb, finalTimeStamp));
            Stage calculateForces = new Stage(forces);
            Stage moveNodes = new Stage(move);
            Stage resolveOverlap = new Stage(overlap);
            Stage endStage = new Stage(endWorker);
            calculateForces.getNextStages().add(moveNodes);
            moveNodes.getNextStages().add(resolveOverlap);
            resolveOverlap.getNextStages().add(endStage);
            endStage.getNextStages().add(calculateForces);
            ((StartUpStage)this.stage).getStages().add(calculateForces);
            ((StartUpStage)this.stage).getStages().add(moveNodes);
            ((StartUpStage)this.stage).getStages().add(resolveOverlap);
            ((StartUpStage)this.stage).getStages().add(endStage);
            calculateForces.start();
            moveNodes.start();
            resolveOverlap.start();
            endStage.start();
            int stepWidth = 10;
            for (int i3 = 0; i3 < this.heightCheckBoarding; i3 += stepWidth) {
                for (int j2 = 0; j2 < this.widthCheckBoarding; j2 += stepWidth) {
                    CheckboardingField[][] fields = this.checkPattern.getFields(j2, i3, stepWidth, stepWidth);
                    calculateForces.getInput(this).add(new PlacementDTO(fields, i3 * this.widthCheckBoarding + j2));
                }
            }
            try {
                calculateForces.join();
                moveNodes.join();
                resolveOverlap.join();
                endStage.join();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        } else {
            this.stage.stop();
        }
    }

    public void setStage(StartUpStage stage) {
        this.stage = stage;
    }
}

