/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

public abstract class CustomMetric {
    protected List<PlacementFrame.PlacementNode> nodesToPlace;
    protected List<PlacementFrame.PlacementNetwork> allNetworks;

    public CustomMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
    }

    public abstract double compute();

    public abstract String getMetricName();

    public String toString() {
        DecimalFormat formater = new DecimalFormat("###,###.#");
        String output = "Result of " + this.getMetricName() + ": " + formater.format(this.compute());
        return output;
    }

    protected List<Point2D.Double[]> getPositionsOfPorts(List<PlacementFrame.PlacementNetwork> placementNets) {
        LinkedList<Point2D.Double[]> posOfPorts = new LinkedList<Point2D.Double[]>();
        int numberOfPorts = 0;
        for (int i2 = 0; i2 < placementNets.size(); ++i2) {
            PlacementFrame.PlacementNetwork net = placementNets.get(i2);
            if (net == null) continue;
            numberOfPorts = net.getPortsOnNet().size();
            Point2D.Double[] allPositionsOfNet = new Point2D.Double[numberOfPorts];
            for (int j2 = 0; j2 < numberOfPorts; ++j2) {
                Point2D.Double absPosOf;
                allPositionsOfNet[j2] = absPosOf = this.getAbsolutePositionOf(net.getPortsOnNet().get(j2));
            }
            posOfPorts.add(allPositionsOfNet);
        }
        return posOfPorts;
    }

    private Point2D.Double getAbsolutePositionOf(PlacementFrame.PlacementPort placementPort) {
        return new Point2D.Double(placementPort.getRotatedOffX() + placementPort.getPlacementNode().getPlacementX(), placementPort.getRotatedOffY() + placementPort.getPlacementNode().getPlacementY());
    }
}

