/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.math.Orientation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class Placement
extends Tool {
    private static Placement tool = new Placement();

    private Placement() {
        super("placement");
    }

    @Override
    public void init() {
    }

    public static Placement getPlacementTool() {
        return tool;
    }

    public static void placeCurrentCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        PlacementPreferences pp = new PlacementPreferences(false);
        new PlaceJob(cell, pp);
    }

    public static void floorplanCurrentCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        PlacementPreferences pp = new PlacementPreferences(false);
        pp.placementAlgorithm = PlacementAdapter.GEN.getAlgorithmName();
        new PlaceJob(cell, pp);
    }

    public static Cell placeCellNoJob(Cell cell, EditingPreferences ep, PlacementFrame pla, PlacementPreferences prefs, boolean quiet, Job job) {
        if (!quiet) {
            Job.getUserInterface().startProgressDialog("Placing cell " + cell.describe(false), null);
            Job.getUserInterface().setProgressNote("Acquiring netlist...");
        }
        System.out.println();
        Netlist netList = cell.getNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return null;
        }
        NodeProto iconToPlace = null;
        ArrayList<PlacementAdapter.PlacementNode> nodesToPlace = CollectionFactory.createArrayList();
        HashMap convertedNodes = CollectionFactory.createHashMap();
        ArrayList<PlacementAdapter.PlacementExport> exportsToPlace = CollectionFactory.createArrayList();
        int total = cell.getNumNodes();
        if (!quiet) {
            Job.getUserInterface().setProgressNote("Converting " + total + " nodes");
            Job.getUserInterface().setProgressValue(0);
        }
        int soFar = 0;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni;
            if (!quiet && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / total);
            }
            if ((ni = it.next()).isIconOfParent()) {
                iconToPlace = ni.getProto();
                continue;
            }
            boolean validNode = ni.isCellInstance();
            if (!validNode) {
                PrimitiveNode.Function fun;
                if (ni.getProto().getTechnology() != Generic.tech() && (fun = ni.getFunction()) != PrimitiveNode.Function.CONNECT && fun != PrimitiveNode.Function.CONTACT && !fun.isPin()) {
                    validNode = true;
                }
                if (ni.hasExports()) {
                    validNode = true;
                }
            }
            if (!validNode) continue;
            NodeProto np = ni.getProto();
            ArrayList<PlacementAdapter.PlacementPort> pl = new ArrayList<PlacementAdapter.PlacementPort>();
            HashMap<PortProto, PlacementAdapter.PlacementPort> placedPorts = new HashMap<PortProto, PlacementAdapter.PlacementPort>();
            if (ni.isCellInstance()) {
                Cell instCell = (Cell)np;
                Iterator<Export> eIt = instCell.getExports();
                while (eIt.hasNext()) {
                    Export e2 = eIt.next();
                    poly = e2.getPoly();
                    double pX = poly.getCenterX();
                    double pY = poly.getCenterY();
                    PlacementAdapter.PlacementPort placementPort = new PlacementAdapter.PlacementPort(pX -= instCell.getBounds().getCenterX(), pY -= instCell.getBounds().getCenterY(), e2);
                    pl.add(placementPort);
                    placedPorts.put(e2, placementPort);
                }
            } else {
                NodeInst niDummy = NodeInst.makeDummyInstance(np, ep);
                Iterator<PortInst> pIt = niDummy.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    poly = pi.getPoly();
                    double offX = poly.getCenterX() - niDummy.getTrueCenterX();
                    double offY = poly.getCenterY() - niDummy.getTrueCenterY();
                    PlacementAdapter.PlacementPort placementPort = new PlacementAdapter.PlacementPort(offX, offY, pi.getPortProto());
                    pl.add(placementPort);
                    placedPorts.put(pi.getPortProto(), placementPort);
                }
            }
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e3 = eIt.next();
                PlacementAdapter.PlacementPort plPort = (PlacementAdapter.PlacementPort)placedPorts.get(e3.getOriginalPort().getPortProto());
                PlacementAdapter.PlacementExport plExport = new PlacementAdapter.PlacementExport(plPort, e3.getName(), e3.getCharacteristic());
                exportsToPlace.add(plExport);
            }
            double paddingRatio = ((double)prefs.placementPadding + 100.0) / 100.0;
            double width = np.getDefWidth(ep) * paddingRatio;
            double height = np.getDefHeight(ep) * paddingRatio;
            PlacementAdapter.PlacementNode plNode = new PlacementAdapter.PlacementNode(ni, null, null, ni.getTechSpecific(), width, height, pl, ni.isLocked());
            nodesToPlace.add(plNode);
            for (PlacementFrame.PlacementPort placementPort : pl) {
                placementPort.setPlacementNode(plNode);
            }
            for (int i2 = 1; i2 < pl.size(); ++i2) {
                PlacementAdapter.PlacementPort placementPort = (PlacementAdapter.PlacementPort)pl.get(i2);
                for (int j2 = 0; j2 < i2; ++j2) {
                    PlacementAdapter.PlacementPort pJ = (PlacementAdapter.PlacementPort)pl.get(j2);
                    if (!netList.portsConnected(ni, placementPort.getPortProto(), pJ.getPortProto())) continue;
                    plNode.addEquivalentPorts(placementPort, pJ);
                }
            }
            plNode.setOrientation(Orientation.IDENT);
            convertedNodes.put(ni, (NodeInst)((Object)placedPorts));
        }
        Map<Network, PortInst[]> portInstsByNetwork = null;
        if (cell.getView() != View.SCHEMATIC) {
            portInstsByNetwork = netList.getPortInstsByNetwork();
        }
        ArrayList<PlacementFrame.PlacementNetwork> allNetworks = new ArrayList<PlacementFrame.PlacementNetwork>();
        total = netList.getNumNetworks();
        if (!quiet) {
            Job.getUserInterface().setProgressNote("Converting " + total + " nets");
            Job.getUserInterface().setProgressValue(0);
        }
        soFar = 0;
        Iterator<Network> it2 = netList.getNetworks();
        while (it2.hasNext()) {
            if (!quiet && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / total);
            }
            Network net = it2.next();
            ArrayList<PlacementFrame.PlacementPort> portsOnNet = new ArrayList<PlacementFrame.PlacementPort>();
            PortInst[] portInsts = null;
            portInsts = portInstsByNetwork != null ? portInstsByNetwork.get(net) : net.getPortsList().toArray(new PortInst[0]);
            for (int i3 = 0; i3 < portInsts.length; ++i3) {
                PlacementAdapter.PlacementPort plPort;
                PortInst pi = portInsts[i3];
                NodeInst ni = pi.getNodeInst();
                PortProto pp = pi.getPortProto();
                Map convertedPorts = (Map)convertedNodes.get(ni);
                if (convertedPorts == null || (plPort = (PlacementAdapter.PlacementPort)convertedPorts.get(pp)) == null) continue;
                portsOnNet.add(plPort);
            }
            if (portsOnNet.size() <= 1) continue;
            boolean isRail = ImmutableExport.isNamedPower(net.getName()) || ImmutableExport.isNamedGround(net.getName());
            PlacementFrame.PlacementNetwork plNet = new PlacementFrame.PlacementNetwork(portsOnNet, isRail);
            for (PlacementFrame.PlacementPort plPort : portsOnNet) {
                plPort.setPlacementNetwork(plNet);
            }
            allNetworks.add(plNet);
        }
        if (!quiet) {
            Job.getUserInterface().stopProgressDialog();
        }
        pla.setOriginalCell(cell);
        pla.setFailure(false);
        Cell newCell = PlacementAdapter.doPlacement(pla, cell.getLibrary(), cell.noLibDescribe(), nodesToPlace, allNetworks, exportsToPlace, iconToPlace, ep, prefs, quiet ? 0 : 1, job);
        return newCell;
    }

    public static PlacementFrame getCurrentPlacementAlgorithm(PlacementPreferences prefs) {
        String algName = prefs.placementAlgorithm;
        for (PlacementFrame pfObj : PlacementAdapter.getPlacementAlgorithms()) {
            if (!algName.equals(pfObj.getAlgorithmName())) continue;
            return pfObj;
        }
        return PlacementAdapter.getPlacementAlgorithms()[0];
    }

    public static class PlacementPreferences
    extends PrefPackage
    implements Serializable {
        private static final String PLACEMENT_NODE = "tool/placement";
        @PrefPackage.StringPref(node="tool/placement", key="AlgorithmName", factory="Min-Cut")
        public String placementAlgorithm;
        @PrefPackage.IntegerPref(node="tool/placement", key="PlacementPadding", factory=0)
        public int placementPadding;
        @PrefPackage.BooleanPref(node="tool/placement", key="PlacementRunRouting", factory=false)
        public boolean placementRunRouting;
        private Object[][] values;

        public PlacementPreferences(boolean factory) {
            super(factory);
            Preferences prefs = (factory ? PlacementPreferences.getFactoryPrefRoot() : PlacementPreferences.getPrefRoot()).node(PLACEMENT_NODE);
            this.values = new Object[PlacementAdapter.placementAlgorithms.length][];
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                PlacementFrame pf = PlacementAdapter.placementAlgorithms[i2];
                this.values[i2] = new Object[pf.getParameters().size()];
                for (int j2 = 0; j2 < pf.getParameters().size(); ++j2) {
                    PlacementFrame.PlacementParameter par = pf.getParameters().get(j2);
                    String key = pf.getAlgorithmName() + "-" + par.key;
                    Object value = switch (par.getType()) {
                        case 1 -> prefs.getInt(key, (Integer)par.factoryValue);
                        case 2 -> String.valueOf(prefs.get(key, (String)par.factoryValue));
                        case 3 -> prefs.getDouble(key, (Double)par.factoryValue);
                        case 4 -> prefs.getBoolean(key, (Boolean)par.factoryValue);
                        default -> throw new AssertionError();
                    };
                    if (value.equals(par.factoryValue)) {
                        value = par.factoryValue;
                    }
                    this.values[i2][j2] = value;
                }
            }
        }

        @Override
        protected void putPrefs(Preferences prefRoot, boolean removeDefaults) {
            super.putPrefs(prefRoot, removeDefaults);
            Preferences prefs = prefRoot.node(PLACEMENT_NODE);
            assert (this.values.length == PlacementAdapter.placementAlgorithms.length);
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                PlacementFrame pf = PlacementAdapter.placementAlgorithms[i2];
                assert (this.values[i2].length == pf.getParameters().size());
                block7: for (int j2 = 0; j2 < pf.getParameters().size(); ++j2) {
                    PlacementFrame.PlacementParameter par = pf.getParameters().get(j2);
                    String key = pf.getAlgorithmName() + "-" + par.key;
                    Object v = this.values[i2][j2];
                    if (removeDefaults && v.equals(par.factoryValue)) {
                        prefs.remove(key);
                        continue;
                    }
                    switch (par.getType()) {
                        case 1: {
                            prefs.putInt(key, (Integer)v);
                            continue block7;
                        }
                        case 2: {
                            prefs.put(key, (String)v);
                            continue block7;
                        }
                        case 3: {
                            prefs.putDouble(key, (Double)v);
                            continue block7;
                        }
                        case 4: {
                            prefs.putBoolean(key, (Boolean)v);
                            continue block7;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            }
        }

        public Object getParameter(PlacementFrame.PlacementParameter par) {
            int i2 = this.indexOfFrame(par);
            PlacementFrame pf = PlacementAdapter.placementAlgorithms[i2];
            int j2 = PlacementPreferences.indexOfParameter(pf, par.key);
            return this.values[i2][j2];
        }

        public void setParameter(PlacementFrame.PlacementParameter par, Object value) {
            PlacementFrame pf;
            int j2;
            int i2 = this.indexOfFrame(par);
            Object oldValue = this.values[i2][j2 = PlacementPreferences.indexOfParameter(pf = PlacementAdapter.placementAlgorithms[i2], par.key)];
            if (oldValue.equals(value)) {
                return;
            }
            assert (value.getClass() == par.factoryValue.getClass());
            if (value.equals(par.factoryValue)) {
                value = par.factoryValue;
            }
            this.values[i2][j2] = value;
        }

        private int indexOfFrame(PlacementFrame.PlacementParameter par) {
            PlacementFrame rf = par.getOwner();
            for (int i2 = 0; i2 < PlacementAdapter.placementAlgorithms.length; ++i2) {
                if (rf.getClass() != PlacementAdapter.placementAlgorithms[i2].getClass()) continue;
                return i2;
            }
            return -1;
        }

        private static int indexOfParameter(PlacementFrame pf, String parameterKey) {
            for (int j2 = 0; j2 < pf.getParameters().size(); ++j2) {
                if (!parameterKey.equals(pf.getParameters().get((int)j2).key)) continue;
                return j2;
            }
            return -1;
        }
    }

    private static class PlaceJob
    extends Job {
        private Cell cell;
        private PlacementPreferences prefs;
        private Cell newCell;

        private PlaceJob(Cell cell, PlacementPreferences prefs) {
            super("Place cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.prefs = prefs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            PlacementFrame pla = Placement.getCurrentPlacementAlgorithm(this.prefs);
            this.newCell = Placement.placeCellNoJob(this.cell, this.getEditingPreferences(), pla, this.prefs, false, this);
            Cell redispCell = pla.getRedispCell();
            if (redispCell != null) {
                this.newCell = redispCell;
            }
            this.fieldVariableChanged("newCell");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.newCell != null) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (User.isShowCellsInNewWindow()) {
                    wf = null;
                }
                if (wf == null) {
                    wf = WindowFrame.createEditWindow(this.newCell);
                }
                wf.setCellWindow(this.newCell, null);
                ArrayList<Cell> cellsToRoute = new ArrayList<Cell>();
                HashSet<Cell> cellsScheduled = new HashSet<Cell>();
                if (this.prefs.placementRunRouting) {
                    if (this.prefs.placementAlgorithm.equals(PlacementAdapter.GEN.getAlgorithmName())) {
                        Iterator<NodeInst> it = this.newCell.getNodes();
                        while (it.hasNext()) {
                            Cell cell;
                            NodeInst ni = it.next();
                            if (!ni.isCellInstance() || !(cell = (Cell)ni.getProto()).getName().startsWith("CLUSTER") || cellsScheduled.contains(cell)) continue;
                            cellsScheduled.add(cell);
                            cellsToRoute.add(cell);
                        }
                    }
                    cellsToRoute.add(this.newCell);
                    new AllRoutingJob(cellsToRoute);
                }
            }
        }
    }

    private static class AllRoutingJob
    extends Job {
        private final List<Cell> cells;
        private final SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();

        protected AllRoutingJob(List<Cell> cells) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cells = cells;
            this.prefs.getOptionsFromPreferences(false);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell cell = this.cells.get(0);
            SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            router.setPrefs(this.prefs);
            SeaOfGatesEngine.Handler handler = SeaOfGatesHandlers.getDefault(cell, null, this.prefs.contactPlacementAction, this, this.getEditingPreferences(), SeaOfGatesHandlers.Save.SAVE_ONCE);
            router.routeIt(handler, cell, true);
            return true;
        }

        @Override
        public void terminateOK() {
            this.cells.remove(0);
            if (this.cells.size() > 0) {
                new AllRoutingJob(this.cells);
            }
        }
    }
}

