/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Circuit {
    private EquivRecord myParent;
    private ArrayList<NetObject> netObjs = new ArrayList();

    private Circuit() {
    }

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Circuit please(List<NetObject> netObjs) {
        Circuit ckt = new Circuit();
        for (NetObject n2 : netObjs) {
            ckt.adopt(n2);
        }
        return ckt;
    }

    public void putInFinalForm() {
        HashSet<NetObject> goodObjs = new HashSet<NetObject>();
        for (NetObject n2 : this.netObjs) {
            if (n2.isDeleted()) continue;
            Circuit.error(goodObjs.contains(n2), "duplicate NetObj in Circuit!???");
            goodObjs.add(n2);
            if (!(n2 instanceof Wire)) continue;
            ((Wire)n2).putInFinalForm();
        }
        this.netObjs = new ArrayList();
        this.netObjs.addAll(goodObjs);
        this.netObjs.trimToSize();
    }

    public Iterator<NetObject> getNetObjs() {
        return this.netObjs.iterator();
    }

    public int numNetObjs() {
        return this.netObjs.size();
    }

    public int numUndeletedNetObjs() {
        int count = 0;
        Iterator<NetObject> it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject n2 = it.next();
            if (n2.isDeleted()) continue;
            ++count;
        }
        return count;
    }

    public void adopt(NetObject n2) {
        this.netObjs.add(n2);
        n2.setParent(this);
    }

    public void checkMe(EquivRecord parent) {
        Circuit.error(this.getParent() != parent, "wrong parent");
    }

    public String nameString() {
        return "Circuit code=" + this.getCode() + " size=" + this.numNetObjs();
    }

    public int getCode() {
        return this.myParent != null ? this.myParent.getCode() : 0;
    }

    public EquivRecord getParent() {
        return this.myParent;
    }

    public void setParent(EquivRecord p) {
        this.myParent = p;
    }

    public HashMap<Integer, List<NetObject>> apply(Strategy js) {
        HashMap<Integer, List<NetObject>> codeToNetObjs = new HashMap<Integer, List<NetObject>>();
        Iterator<NetObject> it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject no = it.next();
            Integer code = js.doFor(no);
            Circuit.error(code == null, "null is no longer a legal code");
            ArrayList<NetObject> ns = (ArrayList<NetObject>)codeToNetObjs.get(code);
            if (ns == null) {
                ns = new ArrayList<NetObject>();
                codeToNetObjs.put(code, ns);
            }
            ns.add(no);
        }
        return codeToNetObjs;
    }
}

