/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import java.util.Arrays;

public class Permutation {
    private int[] perm;

    public Permutation(int size) {
        int[] permutation = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            permutation[i2] = i2;
        }
        this.perm = permutation;
    }

    public Permutation(int[] permutation) {
        this.perm = (int[])permutation.clone();
    }

    public Permutation(Permutation p) {
        this.perm = (int[])p.perm.clone();
    }

    public int getPermTo(int i2) {
        return this.perm[i2];
    }

    public int getPermFrom(int val) {
        int i2;
        for (i2 = 0; i2 < this.perm.length && this.perm[i2] != val; ++i2) {
        }
        return i2;
    }

    public boolean isIdentity() {
        for (int i2 = 0; i2 < this.perm.length; ++i2) {
            if (this.perm[i2] == i2) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.perm.length;
    }

    public void set(int entry, int to) {
        this.perm[entry] = to;
    }

    public Permutation product(Permutation h2) {
        Permutation g2 = this;
        return Permutation.product(g2, h2);
    }

    public static Permutation product(Permutation g2, Permutation h2) {
        int size = g2.size();
        assert (h2.size() == size);
        Permutation newperm = new Permutation(size);
        for (int i2 = 0; i2 < size; ++i2) {
            newperm.set(i2, h2.getPermTo(g2.getPermTo(i2)));
        }
        return newperm;
    }

    public Permutation inverse() {
        int[] invMap = new int[this.perm.length];
        for (int i2 = 0; i2 < this.perm.length; ++i2) {
            invMap[this.perm[i2]] = i2;
        }
        return new Permutation(invMap);
    }

    public String toString() {
        return Arrays.toString(this.perm);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Permutation) {
            Permutation p = (Permutation)arg0;
            return Arrays.equals(p.perm, this.perm);
        }
        return false;
    }
}

