/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.HashMap;
import java.util.Map;

public class Subcircuit
extends Part {
    private final int[] pinCoeffs;
    private final Map<Wire, Integer> wireToCoeffSum;
    private final SubcircuitInfo subcircuitInfo;

    private String getPortName(int i2) {
        return this.subcircuitInfo.getPortName(i2);
    }

    private Map<Wire, Integer> computeWireToCoeffSum(Wire[] pins, int[] coeffs) {
        HashMap<Wire, Integer> wireToCoeffs = new HashMap<Wire, Integer>();
        for (int i2 = 0; i2 < pins.length; ++i2) {
            Wire w = pins[i2];
            int coeff = this.pinCoeffs[i2];
            Integer coeffSum = (Integer)wireToCoeffs.get(w);
            if (coeffSum == null) {
                coeffSum = 0;
            }
            coeffSum = coeffSum + coeff;
            wireToCoeffs.put(w, coeffSum);
        }
        return wireToCoeffs;
    }

    @Override
    public String valueDescription() {
        return "";
    }

    @Override
    public int[] getPinCoeffs() {
        return this.pinCoeffs;
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        Job.error(true, "we never parallel merge subcircuits so don't call this method");
        return false;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        Job.error(true, "we never parallel merge subcircuits so don't call this method");
        int hc = this.pins.length;
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            hc += this.pins[i2].hashCode() * this.pinCoeffs[i2];
        }
        hc += this.getClass().hashCode();
        return hc += this.subcircuitInfo.getID();
    }

    @Override
    public String typeString() {
        return this.subcircuitInfo.getName();
    }

    @Override
    public int typeCode() {
        return this.type().ordinal() + (this.subcircuitInfo.getID() << Part.TYPE_FIELD_WIDTH);
    }

    @Override
    public PinType getPinTypeOfNthPin(int n2) {
        PinType[] pinTypes = this.subcircuitInfo.getPinTypes();
        return pinTypes[n2];
    }

    @Override
    public String connectionDescription(Wire w) {
        Object msg = "";
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            if (this.pins[i2] != w) continue;
            if (((String)msg).length() != 0) {
                msg = (String)msg + ",";
            }
            msg = (String)msg + this.getPortName(i2);
        }
        return msg;
    }

    @Override
    public String connectionDescription(int maxCon) {
        Object msg = "";
        for (int i2 = 0; i2 < maxCon && i2 < this.pins.length; ++i2) {
            if (((String)msg).length() != 0) {
                msg = (String)msg + " ";
            }
            msg = (String)msg + this.getPortName(i2) + "=" + this.pins[i2].getName();
        }
        return msg;
    }

    @Override
    public int getHashFor(Wire w) {
        Integer coeffSum = this.wireToCoeffSum.get(w);
        Job.error(coeffSum == null, "Wire not found");
        return coeffSum * this.getCode();
    }

    public Subcircuit(NccNameProxy.PartNameProxy instName, VarContext cont, SubcircuitInfo subcircuitInfo, Wire[] pins) {
        super(instName, cont, PrimitiveNode.Function.UNKNOWN, pins);
        this.subcircuitInfo = subcircuitInfo;
        this.pinCoeffs = subcircuitInfo.getPortCoeffs();
        this.wireToCoeffSum = this.computeWireToCoeffSum(pins, this.pinCoeffs);
    }

    public static class SubcircuitPinType
    implements PinType {
        private String description;

        public SubcircuitPinType(int typeCode, int portIndex, String description) {
            this.description = description;
        }

        @Override
        public String description() {
            return this.description;
        }
    }
}

