/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.netlist.ExportGlobal;
import com.sun.electric.tool.ncc.netlist.ExportGlobalConflict;
import com.sun.electric.tool.user.ncc.ExportConflict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class NccCellInfo
extends HierarchyEnumerator.CellInfo {
    private NccGlobals globals;
    private boolean gotAnnotations = false;
    private NccCellAnnotations annotations;

    public NccCellInfo(NccGlobals globals) {
        this.globals = globals;
    }

    public NccCellAnnotations getAnnotations() {
        if (!this.gotAnnotations) {
            this.annotations = NccCellAnnotations.getAnnotations(this.getCell());
        }
        this.gotAnnotations = true;
        return this.annotations;
    }

    public Iterator<ExportGlobal> getExportsAndGlobals() {
        String nm;
        HashMap<String, ExportGlobal> nameToExport = new HashMap<String, ExportGlobal>();
        Iterator<PortProto> it = this.getCell().getPorts();
        while (it.hasNext()) {
            Export e2 = (Export)it.next();
            if (this.ignoreExport(e2.getName(), this.getAnnotations())) continue;
            int[] expNetIDs = this.getExportNetIDs(e2);
            for (int i2 = 0; i2 < expNetIDs.length; ++i2) {
                nm = e2.getNameKey().subname(i2).toString();
                if (this.ignoreExport(nm, this.getAnnotations())) continue;
                ExportGlobal eg = new ExportGlobal(nm, expNetIDs[i2], e2.getCharacteristic(), this.getNetlist().getNetwork(e2, i2), e2);
                nameToExport.put(nm, eg);
            }
        }
        ArrayList<Object> expGlob = new ArrayList<Object>();
        expGlob.addAll(nameToExport.values());
        Global.Set globNets = this.getNetlist().getGlobals();
        for (int i3 = 0; i3 < globNets.size(); ++i3) {
            Global g2 = globNets.get(i3);
            nm = g2.getName();
            if (this.ignoreExport(g2.getName(), this.getAnnotations())) continue;
            Network net = this.getNetlist().getNetwork(g2);
            int netID = this.getNetID(net);
            PortCharacteristic type = globNets.getCharacteristic(g2);
            ExportGlobal eg = (ExportGlobal)nameToExport.get(nm);
            if (eg != null) {
                ExportConflict conf;
                if (eg.netID == netID && eg.type == type) continue;
                if (eg.netID != netID) {
                    this.globals.prln("  Error! Cell: " + this.getCell().libDescribe() + " has both an Export and a global signal named: " + nm + " but their networks differ");
                    conf = new ExportConflict.NetworkConflict(this.getCell(), this.getContext(), nm, eg.network, net);
                    this.globals.getNccGuiInfo().addNetworkExportConflict((ExportConflict.NetworkConflict)conf);
                }
                if (eg.type != type) {
                    this.globals.prln("  Error! Cell: " + this.getCell().libDescribe() + " has both an Export and a global signal named: " + nm + " but their Characteristics differ");
                    conf = new ExportConflict.CharactConflict(this.getCell(), this.getContext(), nm, type.getFullName(), eg.type.getFullName(), eg.getExport());
                    this.globals.getNccGuiInfo().addCharactExportConflict((ExportConflict.CharactConflict)conf);
                }
                throw new ExportGlobalConflict();
            }
            eg = new ExportGlobal(nm, netID, type, net);
            expGlob.add(eg);
        }
        return expGlob.iterator();
    }

    private boolean ignoreExport(String name, NccCellAnnotations ann) {
        if (ann == null) {
            return false;
        }
        Iterator<List<NccCellAnnotations.NamePattern>> patit = ann.getExportsToIgnore();
        while (patit.hasNext()) {
            List<NccCellAnnotations.NamePattern> patterns = patit.next();
            for (NccCellAnnotations.NamePattern pat : patterns) {
                if (!pat.matches(name)) continue;
                return true;
            }
        }
        return false;
    }
}

