/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Map;

public class Josephson
extends Part {
    private static final JosephsonPinTypeCache TYPE_TO_PINTYPE = new JosephsonPinTypeCache();
    private static final int[] PIN_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    private final double area;

    public Josephson(PrimitiveNode.Function type, NccNameProxy.PartNameProxy name, VarContext cont, double area, Wire w1, Wire w2) {
        super(name, cont, type, new Wire[]{w1, w2});
        this.area = area;
    }

    @Override
    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    @Override
    public String valueDescription() {
        String sz = "JJ=" + this.area;
        return sz;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return hc;
    }

    @Override
    public double getLength() {
        return this.area;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        return false;
    }

    @Override
    public int typeCode() {
        return this.type().ordinal();
    }

    @Override
    public PinType getPinTypeOfNthPin(int n2) {
        return TYPE_TO_PINTYPE.get(this.type());
    }

    @Override
    public String typeString() {
        return this.type().getShortName();
    }

    @Override
    public String connectionDescription(int n2) {
        String s = this.pins[0].getName();
        String e2 = this.pins[1].getName();
        return "S= " + s + " E= " + e2;
    }

    @Override
    public String connectionDescription(Wire w) {
        Object s = "";
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            if (this.pins[i2] != w) continue;
            if (((String)s).length() != 0) {
                s = (String)s + ",";
            }
            s = (String)s + (i2 == 0 ? "S" : "E");
        }
        return s;
    }

    private static class JosephsonPinTypeCache {
        private final Map<PrimitiveNode.Function, JosephsonPinType> typeToPinType = new HashMap<PrimitiveNode.Function, JosephsonPinType>();

        private JosephsonPinTypeCache() {
        }

        synchronized JosephsonPinType get(PrimitiveNode.Function f2) {
            JosephsonPinType t = this.typeToPinType.get((Object)f2);
            if (t == null) {
                t = new JosephsonPinType(f2);
                this.typeToPinType.put(f2, t);
            }
            return t;
        }
    }

    private static class JosephsonPinType
    implements PinType {
        private PrimitiveNode.Function type;

        public JosephsonPinType(PrimitiveNode.Function t) {
            this.type = t;
        }

        @Override
        public String description() {
            return this.type.getShortName();
        }
    }
}

