/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Map;

public class Bipolar
extends Part {
    private static final BipolarPinTypeCache TYPE_TO_PINTYPE_ARRAY = new BipolarPinTypeCache();
    private double area;
    private static final int[] PIN_COEFFS = new int[]{Primes.get(1), Primes.get(2), Primes.get(3)};

    @Override
    public PinType getPinTypeOfNthPin(int n2) {
        BipolarPinType[] pinTypeArray = TYPE_TO_PINTYPE_ARRAY.get(this.type());
        return pinTypeArray[n2];
    }

    private Bipolar(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, VarContext cont, double area, Wire[] pins) {
        super(name, cont, np, pins);
        Job.error(np == null, "null type?");
        this.area = area;
    }

    private boolean samePinsAs(Bipolar b2) {
        Job.error(b2.pins.length != this.pins.length, "different # pins?");
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            if (this.pins[i2] == b2.pins[i2]) continue;
            return false;
        }
        return true;
    }

    public Bipolar(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, VarContext cont, double area, Wire emit, Wire base, Wire coll) {
        this(np, name, cont, area, new Wire[]{emit, base, coll});
    }

    public double getArea() {
        return this.area;
    }

    @Override
    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.getClass().hashCode();
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            hc += this.pins[i2].hashCode() * PIN_COEFFS[i2];
        }
        return hc += this.type().hashCode();
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        if (!(p instanceof Bipolar)) {
            return false;
        }
        Bipolar b2 = (Bipolar)p;
        if (this == b2) {
            return false;
        }
        if (this.type() != b2.type()) {
            return false;
        }
        if (!this.samePinsAs(b2)) {
            return false;
        }
        this.area += b2.area;
        b2.setDeleted();
        return true;
    }

    @Override
    public int typeCode() {
        return this.type().ordinal();
    }

    @Override
    public String typeString() {
        return this.type().getShortName();
    }

    @Override
    public String valueDescription() {
        return "A=" + NccUtils.round(this.area, 2);
    }

    @Override
    public String connectionDescription(int n2) {
        return "E=" + this.pins[0].getName() + " B=" + this.pins[1].getName() + " C=" + this.pins[2].getName();
    }

    @Override
    public String connectionDescription(Wire w) {
        Object s = "";
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            if (this.pins[i2] != w) continue;
            if (((String)s).length() != 0) {
                s = (String)s + ",";
            }
            s = i2 == 0 ? (String)s + "E" : (i2 == 1 ? (String)s + "B" : (String)s + "C");
        }
        return s;
    }

    private static class BipolarPinTypeCache {
        private Map<PrimitiveNode.Function, BipolarPinType[]> typeToPinTypeArray = new HashMap<PrimitiveNode.Function, BipolarPinType[]>();

        private BipolarPinTypeCache() {
        }

        synchronized BipolarPinType[] get(PrimitiveNode.Function f2) {
            BipolarPinType[] bpt = this.typeToPinTypeArray.get((Object)f2);
            if (bpt == null) {
                bpt = new BipolarPinType[3];
                for (int p = 0; p < 3; ++p) {
                    bpt[p] = new BipolarPinType(f2, p);
                }
                this.typeToPinTypeArray.put(f2, bpt);
            }
            return bpt;
        }
    }

    private static class BipolarPinType
    implements PinType {
        private final PrimitiveNode.Function np;
        private final int pinIndex;
        private static final String[] PIN_NAMES = new String[]{"emitter", "base", "collector"};

        @Override
        public String description() {
            return this.np.getShortName() + " " + PIN_NAMES[this.pinIndex];
        }

        public BipolarPinType(PrimitiveNode.Function np, int pinIndex) {
            Job.error(np == null, "null type?");
            this.np = np;
            this.pinIndex = pinIndex;
        }
    }
}

