/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetlister1;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LETool
extends Tool {
    private static LETool tool = new LETool();
    private static final boolean DEBUG = false;
    private static final Pattern celecDefaultNamePattern = Pattern.compile("^(\\D+)(\\d+)$");
    private static AnalyzeCell lastLEJobExecuted = null;

    private LETool() {
        super("logeffort");
    }

    public static LETool getLETool() {
        return tool;
    }

    @Override
    public void init() {
        EvalJavaBsh.evalJavaBsh.setVariable("LE", tool);
    }

    public Object getdrive() throws VarContext.EvalException {
        return this.getdrive(null, Double.MIN_VALUE);
    }

    public Object getdrive(double defaultValue) throws VarContext.EvalException {
        return this.getdrive(null, defaultValue);
    }

    public Object getdrive(String varName, double defaultValue) throws VarContext.EvalException {
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            if (defaultValue != Double.MIN_VALUE) {
                return defaultValue;
            }
            throw new VarContext.EvalException("getdrive(): Not enough hierarchy");
        }
        VarContext context = EvalJavaBsh.evalJavaBsh.getCurrentContext();
        if (context == null) {
            throw new VarContext.EvalException("getdrive(): null VarContext");
        }
        Nodable ni = (Nodable)info;
        Object val = null;
        if (ni instanceof NodeInst && ni.getNameKey().busWidth() > 1) {
            Name name = ni.getNameKey();
            ArrayList<Object> sizes = new ArrayList<Object>();
            for (int i2 = 0; i2 < name.busWidth(); ++i2) {
                Nodable no = Netlist.getNodableFor((NodeInst)ni, i2);
                Variable var = this.getLEDRIVE(ni, context.push(no));
                Object size = null;
                if (defaultValue != Double.MIN_VALUE) {
                    size = defaultValue;
                }
                if (var != null) {
                    size = var.getObject();
                }
                if (varName != null && size instanceof String) {
                    size = this.getSCOTValue(var, varName);
                }
                sizes.add(size);
            }
            if (sizes.size() > 5) {
                Object[] objs = new Object[]{sizes.get(0), "...", sizes.get(sizes.size() - 1)};
                val = objs;
            } else {
                val = sizes.toArray();
            }
        } else {
            Variable var = this.getLEDRIVE(ni, context.push(ni));
            if (var == null) {
                var = this.getLEDRIVE_old(ni, context);
            }
            if (var == null && defaultValue != Double.MIN_VALUE) {
                return defaultValue;
            }
            if (var == null) {
                throw new VarContext.EvalException("getdrive(): no size");
            }
            val = var.getObject();
            if (varName != null && val instanceof String) {
                val = this.getSCOTValue(var, varName);
            }
        }
        if (val == null) {
            throw new VarContext.EvalException("getdrive(): size null");
        }
        return val;
    }

    public Object subdrive(String nodeName, String parName) throws VarContext.EvalException {
        VarContext context;
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy information");
        }
        Nodable no = (Nodable)info;
        if (no == null) {
            throw new VarContext.EvalException("subdrive(): Not enough hierarchy");
        }
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            Cell parent = no.getParent();
            if (parent == null) {
                throw new VarContext.EvalException("subdrive(): null parent");
            }
            int arrayIndex = 0;
            no = Netlist.getNodableFor(ni, arrayIndex);
            if (no == null) {
                throw new VarContext.EvalException("subdrive(): can't get equivalent schematic");
            }
        }
        if ((context = EvalJavaBsh.evalJavaBsh.getCurrentContext()) == null) {
            throw new VarContext.EvalException("subdrive(): null context");
        }
        NodeProto np = no.getProto();
        if (np == null) {
            throw new VarContext.EvalException("subdrive(): null nodeProto");
        }
        if (!no.isCellInstance()) {
            throw new VarContext.EvalException("subdrive(): NodeProto not a Cell");
        }
        Cell cell = (Cell)np;
        NodeInst ni = cell.findNode(nodeName);
        if (ni == null && (ni = cell.findNode(LETool.convertToJElectricDefaultName(nodeName))) == null) {
            throw new VarContext.EvalException("subdrive(): no nodeInst named " + nodeName);
        }
        Variable var = ni.getParameterOrVariable(parName);
        if (var == null) {
            throw new VarContext.EvalException(parName.replaceFirst("ATTR_", "") + " not found");
        }
        return context.push(no).evalVarRecurse(var, ni);
    }

    private Variable getLEDRIVE_old(Nodable no, VarContext context) {
        String drive = LETool.makeDriveStrOLDRecurse(context);
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive + ";0;S");
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i2 = drive.indexOf(59);
            if (i2 == -1) break;
            drive = drive.substring(i2 + 1);
        }
        if ((var = no.getVar(Variable.newKey("LEDRIVE_0;S"))) != null) {
            return var;
        }
        return null;
    }

    private Variable getLEDRIVE(Nodable no, VarContext context) {
        Variable var = null;
        var = this.getLEDRIVEtop(no, context);
        if (var == null) {
            var = this.getLEDRIVEleaf(no, context);
        }
        return var;
    }

    private Variable getLEDRIVEtop(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Nodable topno = no;
        while (context != VarContext.globalContext) {
            topno = context.getNodable();
            context = context.pop();
        }
        Cell parent = topno.getParent();
        Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
        if (key == null) {
            return null;
        }
        Variable var = parent.getVar(key);
        return var;
    }

    private Object getSCOTValue(Variable var, String varName) {
        String[] valsparts;
        if (var == null || varName == null) {
            return null;
        }
        Object val = var.getObject();
        if (!(val instanceof String)) {
            return null;
        }
        String vals = (String)val;
        for (String s : valsparts = vals.split("/")) {
            if (!(s = s.trim()).startsWith(varName)) continue;
            String[] parts = s.split("=");
            if (parts.length != 2) {
                return null;
            }
            return parts[1].trim();
        }
        return null;
    }

    private Variable getLEDRIVEleaf(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Variable var = null;
        while (!drive.equals("")) {
            Variable.Key key = Variable.findKey("LEDRIVE_" + drive);
            Variable variable = var = key != null ? no.getVar(key) : null;
            if (var != null) {
                return var;
            }
            int i2 = drive.indexOf(46);
            if (i2 == -1) {
                return null;
            }
            drive = drive.substring(i2 + 1);
        }
        return null;
    }

    private static String makeDriveStrOLDRecurse(VarContext context) {
        if (context == VarContext.globalContext) {
            return "";
        }
        String prefix = context.pop() == VarContext.globalContext ? "" : LETool.makeDriveStrOLDRecurse(context.pop());
        Nodable no = context.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        String name = LETool.getCElectricDefaultName(no);
        String me = name + ",0";
        if (prefix.equals("")) {
            return me;
        }
        return prefix + ";" + me;
    }

    private static String getCElectricDefaultName(Nodable no) {
        Object name = no.getNodeInst().getName();
        int at = ((String)name).indexOf(64);
        if (at != -1 && at + 1 < ((String)name).length()) {
            String num = ((String)name).substring(at + 1, ((String)name).length());
            try {
                Integer i2 = Integer.valueOf(num);
                name = ((String)name).substring(0, at) + (i2 + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name;
    }

    private static String convertToJElectricDefaultName(String celectricDefaultName) {
        Matcher mat = celecDefaultNamePattern.matcher((CharSequence)celectricDefaultName);
        if (mat.matches()) {
            try {
                Integer i2 = Integer.valueOf(mat.group(2));
                int ii = i2 - 1;
                if (ii >= 0) {
                    celectricDefaultName = mat.group(1) + "@" + ii;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return celectricDefaultName;
    }

    protected static Variable getMFactor(Nodable no) {
        Variable var = no.getVar(SimulationTool.M_FACTOR_KEY);
        if (var == null) {
            var = no.getParameter(SimulationTool.M_FACTOR_KEY);
        }
        return var;
    }

    public static double quantize(double d2, double error, double minValue) {
        if (d2 <= minValue) {
            return minValue;
        }
        double power = Math.log10(d2) / Math.log10(1.0 + error);
        long p = Math.round(power);
        long quan = Math.round(Math.pow(1.0 + error, p));
        return quan;
    }

    public void optimizeEqualGateDelays(Cell cell, VarContext context, boolean newAlg) {
        AnalyzeCell acjob = new AnalyzeCell(LESizer.Alg.EQUALGATEDELAYS, cell, context, newAlg);
        acjob.startJob(false);
    }

    public static void printResults(Nodable no, VarContext context) {
        LENetlister netlister;
        if (lastLEJobExecuted != null && (netlister = lastLEJobExecuted.getNetlister()).printResults(no, context)) {
            return;
        }
        System.out.println("No existing completed sizing jobs contain info about " + no.getName());
    }

    public static void clearStoredSizesJob(NodeInst ni) {
        new ClearStoredSizes(ni);
    }

    public static void clearStoredSizesJob(Library lib) {
        new ClearStoredSizesLibrary(lib);
    }

    private static void clearStoredSizes(Cell cell) {
        Iterator<Serializable> it = cell.getNodes();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
        it = cell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            cell.delVar(var.getKey());
        }
    }

    private static void clearStoredSizes(Library lib) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            LETool.clearStoredSizes(it.next());
        }
    }

    private static void clearStoredSizes(NodeInst ni) {
        Iterator<Variable> it = ni.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            ni.delVar(var.getKey());
        }
    }

    public static boolean isUseLocalSettings() {
        return LETool.getUseLocalSettingsSetting().getBoolean();
    }

    public static Setting getUseLocalSettingsSetting() {
        return ToolSettings.getUseLocalSettingsSetting();
    }

    public static double getGlobalFanout() {
        return LETool.getGlobalFanoutSetting().getDouble();
    }

    public static Setting getGlobalFanoutSetting() {
        return ToolSettings.getGlobalFanoutSetting();
    }

    public static double getConvergenceEpsilon() {
        return LETool.getConvergenceEpsilonSetting().getDouble();
    }

    public static Setting getConvergenceEpsilonSetting() {
        return ToolSettings.getConvergenceEpsilonSetting();
    }

    public static int getMaxIterations() {
        return LETool.getMaxIterationsSetting().getInt();
    }

    public static Setting getMaxIterationsSetting() {
        return ToolSettings.getMaxIterationsSetting();
    }

    public static double getKeeperRatio() {
        return LETool.getKeeperRatioSetting().getDouble();
    }

    public static Setting getKeeperRatioSetting() {
        return ToolSettings.getKeeperRatioSetting();
    }

    public static double getX1InverterNWidth() {
        return LETool.getX1InverterNWidthSetting().getDouble();
    }

    public static double getX1InverterPWidth() {
        return LETool.getX1InverterPWidthSetting().getDouble();
    }

    public static double getX1InverterLength() {
        return LETool.getX1InverterLengthSetting().getDouble();
    }

    public static Setting getX1InverterNWidthSetting() {
        return ToolSettings.getX1InverterNWidthSetting();
    }

    public static Setting getX1InverterPWidthSetting() {
        return ToolSettings.getX1InverterPWidthSetting();
    }

    public static Setting getX1InverterLengthSetting() {
        return ToolSettings.getX1InverterLengthSetting();
    }

    public static class AnalyzeCell
    extends Job {
        private Cell cell;
        private VarContext context;
        private LESizer.Alg algorithm;
        private LENetlister netlister;
        private boolean newAlg;

        public AnalyzeCell(LESizer.Alg algorithm, Cell cell, VarContext context, boolean newAlg) {
            super("Analyze " + String.valueOf(cell), tool, Job.Type.CLIENT_EXAMINE, null, cell, Job.Priority.USER);
            this.algorithm = algorithm;
            this.cell = cell;
            this.context = context;
            this.newAlg = newAlg;
        }

        @Override
        public boolean doIt() throws JobException {
            this.timer.start();
            if (lastLEJobExecuted != null) {
                lastLEJobExecuted.remove();
            }
            lastLEJobExecuted = this;
            this.setProgress("building equations");
            System.out.print("Building equations...");
            Technology layoutTech = this.cell.getTechnology();
            if (layoutTech == Schematics.tech()) {
                layoutTech = Schematics.getDefaultSchematicTechnology();
            }
            this.netlister = this.newAlg ? new LENetlister2(this, layoutTech) : new LENetlister1(this, layoutTech);
            boolean success = this.netlister.netlist(this.cell, this.context, true);
            if (!success) {
                return false;
            }
            this.timer.end();
            System.out.println("Done (took " + String.valueOf(this.timer) + ")");
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            System.out.println("Starting iterations: ");
            this.setProgress("iterating");
            boolean success2 = this.netlister.size(this.algorithm);
            if (this.checkAbort(null)) {
                this.netlister.done();
                return false;
            }
            if (success2) {
                System.out.println("Sizing finished, updating sizes...");
                this.netlister.printStatistics();
                ArrayList<Float> sizes = new ArrayList<Float>();
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<NodeInst> nodes = new ArrayList<NodeInst>();
                ArrayList<VarContext> contexts = new ArrayList<VarContext>();
                this.netlister.getSizes(sizes, varNames, nodes, contexts);
                for (int i2 = 0; i2 < sizes.size(); ++i2) {
                    float f2 = ((Float)sizes.get(i2)).floatValue();
                    NodeInst ni = (NodeInst)nodes.get(i2);
                    VarContext context = (VarContext)contexts.get(i2);
                    if (!(f2 < 1.0f)) continue;
                    String msg = "WARNING: Instance " + String.valueOf(ni) + " has size " + TextUtils.formatDouble(f2, 3) + " less than 1";
                    System.out.println(msg);
                    if (ni == null) continue;
                    this.netlister.getErrorLogger().logWarning(msg, ni, ni.getParent(), context, 2);
                }
                new UpdateSizes(sizes, varNames, nodes, contexts, this.cell, 0.1);
                this.netlister.getErrorLogger().termLogging(true);
            } else {
                System.out.println("Sizing failed, sizes unchanged");
                this.netlister.done();
            }
            return true;
        }

        protected boolean checkAbort(String msg) {
            boolean aborted = super.checkAbort();
            if (aborted) {
                if (msg != null) {
                    System.out.println("LETool aborted: " + msg);
                } else {
                    System.out.println("LETool aborted: no changes made");
                }
            }
            return aborted;
        }

        @Override
        public String getInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getInfo());
            if (this.getScheduledToAbort()) {
                buf.append("  Job aborted, no changes made\n");
            } else {
                buf.append("  Job completed successfully\n");
            }
            return buf.toString();
        }

        public LENetlister getNetlister() {
            return this.netlister;
        }
    }

    public static class ClearStoredSizes
    extends Job {
        private NodeInst ni;

        public ClearStoredSizes(NodeInst ni) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.ni);
            return true;
        }
    }

    public static class ClearStoredSizesLibrary
    extends Job {
        private Library lib;

        public ClearStoredSizesLibrary(Library lib) {
            super("Clear LE Sizes", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            LETool.clearStoredSizes(this.lib);
            return true;
        }
    }

    private static class UniqueCell {
        private Set<String> relevantNodeNames;
        private Map<String, Cell> uniqueCells;
        private Cell originalCell;
        private boolean verbose = false;

        private UniqueCell(Cell cell, Map<String, Cell> relevantNodes) {
            this.originalCell = cell;
            this.relevantNodeNames = relevantNodes.keySet();
            this.uniqueCells = new HashMap<String, Cell>();
            String key = this.getKey(relevantNodes);
            this.uniqueCells.put(key, cell);
            this.prMsg("Registering original cell " + this.originalCell.describe(false) + " under key " + key);
        }

        public String getKey(Map<String, Cell> relevantNodes) {
            StringBuffer buf = new StringBuffer();
            for (String s : this.relevantNodeNames) {
                Cell c2 = relevantNodes.get(s);
                if (c2 == null) continue;
                buf.append(c2.getLibrary().getName());
                buf.append(c2.getName());
            }
            return buf.toString();
        }

        public Cell getUniqueCell(Map<String, Cell> relevantNodes, EditingPreferences ep) {
            String key = this.getKey(relevantNodes);
            this.prMsg("Checking against original cell " + this.originalCell.describe(false) + " with new key " + key);
            Cell c2 = this.uniqueCells.get(key);
            if (c2 == null) {
                c2 = UniqueCell.duplicate(this.originalCell, ep);
                this.prMsg("Duplicating " + this.originalCell.describe(false));
                this.uniqueCells.put(key, c2);
            }
            return c2;
        }

        public static Cell duplicate(Cell cell, EditingPreferences ep) {
            assert (cell.isSchematic());
            Library lib = cell.getLibrary();
            String pname = cell.getName().replaceAll("_[0-9]+$", "");
            Object newpname = pname;
            int i2 = 1;
            for (i2 = 1; i2 < 100; ++i2) {
                String temp = pname + "_" + i2;
                if (lib.findNodeProto(temp) != null) continue;
                newpname = temp;
                break;
            }
            if (i2 == 100) {
                System.out.println("Error: Unable to uniquify cell " + cell.describe(false) + ", too many versions already");
                return cell;
            }
            Cell icon = cell.iconView();
            Cell newicon = null;
            if (icon != null && (newicon = Cell.copyNodeProto(icon, lib, (String)newpname, true)) == null) {
                System.out.println("Error: Unable to copy " + icon.describe(false) + " to " + (String)newpname);
                return cell;
            }
            Cell newcell = Cell.copyNodeProto(cell, lib, (String)newpname, true);
            if (newcell == null) {
                System.out.println("Error: Unable to copy " + cell.describe(false) + " to " + (String)newpname);
                return cell;
            }
            if (icon != null && newicon != null) {
                Iterator<NodeInst> it = newcell.getNodes();
                while (it.hasNext()) {
                    NodeInst nni = it.next();
                    if (nni.getProto() != icon) continue;
                    nni.replace(newicon, ep, true, true, false);
                }
            }
            return newcell;
        }

        public void prMsg(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }
    }

    private static class Uniquifier {
        private UniqueNodeMap uniqueNodeMap;
        private Map<Cell, UniqueCell> uniqueCellMap;
        private boolean hierarchyError = false;
        private boolean verbose = false;

        public Uniquifier(UniqueNodeMap leafCellNodeMap) {
            this.uniqueNodeMap = leafCellNodeMap;
            this.uniqueCellMap = new HashMap<Cell, UniqueCell>();
        }

        public void registerCellsToUniquify(Cell cell, VarContext context, EditingPreferences ep) {
            Netlist netlist = cell.getNetlist();
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                Cell subproto;
                Nodable no = it.next();
                if (!no.isCellInstance() || (subproto = (Cell)no.getProto()).isIconOf(cell)) continue;
                Cell schcell = subproto.getMainSchematicInGroup();
                this.registerCellsToUniquify(schcell, context.push(no), ep);
            }
            HashMap<String, Cell> relevantNodes = new HashMap<String, Cell>();
            HashMap<NodeInst, Cell> arrayedNodeConflicts = new HashMap<NodeInst, Cell>();
            Iterator<Nodable> it2 = netlist.getNodables();
            while (it2.hasNext()) {
                VarContext nocontext;
                Cell iconCell;
                Nodable no = it2.next();
                if (!no.isCellInstance() || (iconCell = this.uniqueNodeMap.get(nocontext = context.push(no))) == null) continue;
                this.prMsg("Found Cell " + iconCell.describe(false) + " for context " + nocontext.getInstPath("."));
                relevantNodes.put(no.getName(), iconCell);
                Cell mappedIconCell = (Cell)arrayedNodeConflicts.get(no.getNodeInst());
                if (mappedIconCell == null) {
                    arrayedNodeConflicts.put(no.getNodeInst(), iconCell);
                    continue;
                }
                if (mappedIconCell == iconCell) continue;
                System.out.println("ERROR: Arrayed node: " + nocontext.getInstPath("."));
                System.out.println("       Has different sizes or different sizes in sub nodes; array must be flattened");
                this.hierarchyError = true;
            }
            if (context == VarContext.globalContext) {
                return;
            }
            if (relevantNodes.size() > 0) {
                UniqueCell uniqueCell = this.uniqueCellMap.get(cell);
                if (uniqueCell == null) {
                    uniqueCell = new UniqueCell(cell, relevantNodes);
                    this.uniqueCellMap.put(cell, uniqueCell);
                }
                Cell newcell = uniqueCell.getUniqueCell(relevantNodes, ep);
                this.uniqueNodeMap.put(context, newcell.iconView());
            }
        }

        public void uniquify(Cell cell, VarContext context, EditingPreferences ep) {
            Netlist netlist = cell.getNetlist();
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                VarContext nocontext;
                Cell newIcon;
                Nodable no = it.next();
                if (!no.isCellInstance()) continue;
                NodeInst ni = no.getNodeInst();
                Cell subcell = (Cell)no.getProto();
                if (subcell.isIconOf(cell) || (newIcon = this.uniqueNodeMap.get(nocontext = context.push(no))) == null || newIcon == ni.getProto()) continue;
                if (ni.isLinked()) {
                    ni.replace(newIcon, ep, true, true, false);
                    this.prMsg("Replaced " + nocontext.getInstPath(".") + " with " + newIcon.describe(false));
                }
                boolean found = false;
                Iterator<Nodable> it2 = netlist.getNodables();
                while (it2.hasNext()) {
                    Nodable no2 = it2.next();
                    if (no.getNameKey() != no2.getNameKey()) continue;
                    nocontext = context.push(no2);
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("ERROR: Could not find new nodable for " + context.getInstPath(".") + "." + no.getName());
            }
        }

        public boolean isHierarchyError() {
            return this.hierarchyError;
        }

        public void prMsg(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }
    }

    public static class UniqueNodeMap {
        private Map<String, Cell> nodeMap = new HashMap<String, Cell>();

        public void put(VarContext context, Cell cell) {
            this.nodeMap.put(UniqueNodeMap.getKey(context), cell);
        }

        public Cell get(VarContext context) {
            return this.nodeMap.get(UniqueNodeMap.getKey(context));
        }

        public int size() {
            return this.nodeMap.size();
        }

        private static String getKey(VarContext context) {
            return context.getInstPath(".");
        }
    }

    private static class UpdateSizes
    extends Job {
        private List<Float> sizes;
        private List<String> varNames;
        private List<NodeInst> nodes;
        private List<VarContext> contexts;
        private Cell cell;
        private double standardCellErrorTolerancePrint = 0.1;

        private UpdateSizes(List<Float> sizes, List<String> varNames, List<NodeInst> nodes, List<VarContext> contexts, Cell cell, double standardCellErrorTolerancePrint) {
            super("Update LE Sizes", tool, Job.Type.CHANGE, null, cell, Job.Priority.USER);
            this.sizes = sizes;
            this.varNames = varNames;
            this.nodes = nodes;
            this.contexts = contexts;
            this.cell = cell;
            this.standardCellErrorTolerancePrint = standardCellErrorTolerancePrint;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            UniqueNodeMap standardCellNodeMap = new UniqueNodeMap();
            boolean standardCellArrayError = false;
            System.out.println("Standard cell quantization errors over " + this.standardCellErrorTolerancePrint * 100.0 + "%:");
            StringBuffer errBuf = new StringBuffer();
            for (int i2 = 0; i2 < this.sizes.size(); ++i2) {
                Float f2;
                VarContext context;
                NodeInst ni = this.nodes.get(i2);
                Cell standardCell = this.getStandardCell(ni, context = this.contexts.get(i2), (f2 = this.sizes.get(i2)).doubleValue());
                if (standardCell != null) {
                    VarContext nicontext = context.push(ni);
                    Cell previousStandardCell = standardCellNodeMap.get(nicontext);
                    if (previousStandardCell != null && previousStandardCell != standardCell.iconView()) {
                        errBuf.append("ERROR: Arrayed Standard Cell " + context.getInstPath(".") + "." + ni.getName() + "\n");
                        errBuf.append("       cannot yield separate sizes for nodes in array: " + previousStandardCell.getName() + " vs " + standardCell.getName() + "\n");
                        standardCellArrayError = true;
                    }
                    VarContext nocontext = context.push(Netlist.getNodableFor(ni, 0));
                    standardCellNodeMap.put(nocontext, standardCell.iconView());
                    continue;
                }
                String varName = this.varNames.get(i2);
                this.cell.newVar(varName, (Object)f2, ep);
            }
            if (standardCellNodeMap.size() > 0) {
                Uniquifier uniquifier = new Uniquifier(standardCellNodeMap);
                uniquifier.registerCellsToUniquify(this.cell, VarContext.globalContext, ep);
                if (uniquifier.isHierarchyError() || standardCellArrayError) {
                    System.out.println(errBuf);
                    System.out.println("Error with hierarchy, please fix first: Standard Cell Sizes Not Updated");
                    return false;
                }
                uniquifier.uniquify(this.cell, VarContext.globalContext, ep);
            }
            System.out.println("Sizes updated. Sizing Finished.");
            this.fieldVariableChanged("cell");
            return true;
        }

        private Cell getStandardCell(NodeInst ni, VarContext context, double targetsize) {
            Cell mainSchematic;
            Cell np = null;
            if (ni.isCellInstance()) {
                np = (Cell)ni.getProto();
            }
            if (np != null && (mainSchematic = np.getMainSchematicInGroup()) != null && mainSchematic.getVar(SCLibraryGen.STANDARDCELL) != null) {
                int tail = np.getName().indexOf("_X");
                String type = np.getName().substring(0, tail);
                double diff = Double.MAX_VALUE;
                double chosensize = 0.0;
                Cell chosencell = null;
                Iterator<Cell> it = np.getLibrary().getCells();
                while (it.hasNext()) {
                    String cname;
                    Cell c2 = it.next();
                    if (!c2.isSchematic() || !(cname = c2.getName()).startsWith(type + "_X")) continue;
                    double size = 0.0;
                    try {
                        size = Double.parseDouble(cname.substring(type.length() + 2));
                    }
                    catch (NumberFormatException e2) {
                        continue;
                    }
                    double tempdiff = targetsize - size;
                    if (!(Math.abs(tempdiff) < Math.abs(diff))) continue;
                    diff = tempdiff;
                    chosensize = size;
                    chosencell = c2;
                }
                if (chosencell == null) {
                    System.out.println("Unable to find standard cell for " + ni.describe(false));
                    return null;
                }
                double percentdiff = diff / targetsize;
                if (Math.abs(percentdiff) > this.standardCellErrorTolerancePrint) {
                    String p = TextUtils.formatDouble(100.0 * percentdiff, 1);
                    String ideal = TextUtils.formatDouble(targetsize, 2);
                    String used = TextUtils.formatDouble(chosensize, 2);
                    String strcontext = context.push(ni).getInstPath(".");
                    System.out.println("  " + p + "%: " + ideal + " (ideal) vs " + used + " (used); for " + strcontext);
                }
                return chosencell;
            }
            return null;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.findWindow(this.cell);
            if (wnd != null) {
                wnd.fullRepaint();
            }
        }
    }
}

