/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Pads
extends Output {
    public static final Variable.Key REF_DES_KEY = Variable.newKey("ATTR_ref_des");
    public static final Variable.Key PKG_TYPE_KEY = Variable.newKey("ATTR_pkg_type");
    public static final Variable.Key PIN_KEY = Variable.newKey("ATTR_pin");
    private List<Output.NetNames> networks;

    private Pads(PadsPreferences pp) {
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        this.printWriter.println("!PADS-POWERPCB-V2");
        this.printWriter.println("");
        this.printWriter.println("*CLUSTER* ITEM");
        this.printWriter.println("");
        this.printWriter.println("*PART*");
        this.networks = new ArrayList<Output.NetNames>();
        PadsNetlister netlister = new PadsNetlister();
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)netlister, Netlist.ShortResistors.ALL);
        this.printWriter.println("");
        this.printWriter.println("*NET*");
        if (this.networks.size() == 0) {
            this.reportError("ERROR: no output produced.  Packages need attribute 'ref_des' and ports need attribute 'pin'");
        }
        Collections.sort(this.networks, new Output.NetNamesSort());
        for (int i2 = 0; i2 < this.networks.size(); ++i2) {
            Output.NetNames oNn;
            Output.NetNames nn = this.networks.get(i2);
            String baseName = nn.netName;
            int endPos = i2;
            int j2 = i2 + 1;
            while (j2 < this.networks.size()) {
                oNn = this.networks.get(j2);
                if (!oNn.netName.equals(baseName)) break;
                endPos = j2++;
            }
            if (endPos == i2) continue;
            this.printWriter.println("*SIGNAL* " + baseName);
            for (j2 = i2; j2 <= endPos; ++j2) {
                oNn = this.networks.get(j2);
                this.printWriter.println(oNn.nodeName + "." + oNn.portName);
            }
            this.printWriter.println("");
        }
        this.printWriter.println("*END*");
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private class PadsNetlister
    extends HierarchyEnumerator.Visitor {
        private PadsNetlister() {
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (!no.isCellInstance()) {
                return false;
            }
            Variable var = no.getVar(REF_DES_KEY);
            if (var == null) {
                return true;
            }
            Object context = "";
            Nodable pNo = info.getParentInst();
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null && pNo != null) {
                context = parentInfo.getUniqueNodableName(pNo, ".") + ".";
            }
            String nodeName = (String)context + var.getPureValue(-1);
            String pkgType = no.getProto().getName();
            Variable pkgName = no.getVar(PKG_TYPE_KEY);
            if (pkgName != null) {
                pkgType = pkgName.getPureValue(-1);
            }
            Pads.this.printWriter.println(nodeName + "  " + pkgType + "@" + pkgType);
            NodeInst ni = no.getNodeInst();
            Cell altProto = null;
            if (ni.isCellInstance() && ((Cell)ni.getProto()).getView() == View.ICON) {
                altProto = ((Cell)ni.getProto()).contentsView();
            }
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                PortProto pp = pi.getPortProto();
                Name busName = pp.getNameKey();
                String pName = null;
                Variable pVar = pi.getVar(PIN_KEY);
                if (pVar != null) {
                    pName = pVar.getPureValue(-1);
                } else {
                    Export other;
                    if (altProto != null && (other = ((Export)pp).findEquivalent(altProto)) != null) {
                        pp = other;
                    }
                    if ((pVar = ((Export)pp).getVar(PIN_KEY)) != null) {
                        pName = pVar.getPureValue(-1);
                    }
                }
                if (pName == null) continue;
                for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                    Name wireName = busName.subname(busIndex);
                    int netId = info.getPortNetID(no, wireName);
                    Output.NetNames nn = new Output.NetNames();
                    nn.netName = info.getUniqueNetName(netId, ".");
                    nn.nodeName = nodeName;
                    nn.portName = pName;
                    Pads.this.networks.add(nn);
                }
            }
            return false;
        }
    }

    public static class PadsPreferences
    extends Output.OutputPreferences {
        public PadsPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Pads out = new Pads(this);
            out.writeNetlist(cell, context, filePath);
            return out.finishWrite();
        }
    }
}

