/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class FlatRects
extends Output {
    private FlatRects() {
    }

    protected void start() {
    }

    protected void done(Cell cell) {
    }

    private FlatRectVisitor makeRectanglesVisitor(FlatRectPreferences rp) {
        return new FlatRectVisitor(rp);
    }

    private class FlatRectVisitor
    extends HierarchyEnumerator.Visitor {
        private FlatRectPreferences localPrefs;

        FlatRectVisitor(FlatRectPreferences rp) {
            this.localPrefs = rp;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            FixpTransform transToTop = info.getTransformToRoot();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                Technology tech = prim.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni);
                FixpTransform nodeTrans = ni.rotateOut(transToTop);
                for (int i2 = 0; i2 < polys.length; ++i2) {
                    Poly poly = polys[i2];
                    poly.transform(nodeTrans);
                    this.emitPoly(poly);
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i3 = 0; i3 < polys.length; ++i3) {
                    Poly poly = polys[i3];
                    poly.transform(transToTop);
                    this.emitPoly(poly);
                }
            }
        }

        private void emitPoly(PolyBase poly) {
            Poly.Type style = poly.getStyle();
            if (style == Poly.Type.FILLED) {
                FixpRectangle box = poly.getBox();
                if (box == null) {
                    return;
                }
                if (((RectangularShape)box).getWidth() == 0.0) {
                    return;
                }
                if (((RectangularShape)box).getHeight() == 0.0) {
                    return;
                }
                String replaceString = this.localPrefs.formatSpec;
                replaceString = replaceString.replaceAll("%l", poly.getLayer().getName());
                replaceString = replaceString.replaceAll("%x", TextUtils.formatDistance(((RectangularShape)box).getCenterX()));
                replaceString = replaceString.replaceAll("%y", TextUtils.formatDistance(((RectangularShape)box).getCenterY()));
                replaceString = replaceString.replaceAll("%w", TextUtils.formatDistance(((RectangularShape)box).getWidth()));
                replaceString = replaceString.replaceAll("%h", TextUtils.formatDistance(((RectangularShape)box).getHeight()));
                FlatRects.this.printWriter.println(replaceString);
            }
        }
    }

    public static class FlatRectPreferences
    extends Output.OutputPreferences {
        String formatSpec = Job.getUserInterface().askForInput("Specify format of rectangles:", "Rectangle Factors", "%l %x %y %w %h");

        public FlatRectPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            FlatRects out = new FlatRects();
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.printWriter.println("; Cell " + cell.noLibDescribe() + " from Library " + cell.getLibrary().getName());
            out.printWriter.println("; Generated automatically by the Electric VLSI Design System");
            out.printWriter.println("; Rectangles are described as: " + this.formatSpec);
            out.printWriter.println("; Where %l is layer, %x is X of center, %y is Y of center, %w is width, %h is height");
            FlatRectVisitor visitor = out.makeRectanglesVisitor(this);
            out.start();
            HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
            out.done(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

