/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.util.TextUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FastHenry
extends Output {
    private FastHenryPreferences localPrefs;

    FastHenry(FastHenryPreferences fp) {
        this.localPrefs = fp;
    }

    protected void writeFH(Cell cell, VarContext context) {
        this.printWriter.println("* FastHenry for " + String.valueOf(cell));
        this.emitCopyright("* ", "");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("* Cell created on " + TextUtils.formatDate(cell.getCreationDate()));
            this.printWriter.println("* Cell last modified on " + TextUtils.formatDate(cell.getRevisionDate()));
            this.printWriter.println("* Netlist written on " + TextUtils.formatDate(new Date()));
            this.printWriter.println("* Written by Electric VLSI Design System, version " + String.valueOf(Version.getVersion()));
        } else {
            this.printWriter.println("* Written by Electric VLSI Design System");
        }
        this.printWriter.println("\n* Units are microns");
        this.printWriter.println(".units um");
        this.printWriter.println("");
        this.printWriter.println("* Default number of subdivisions");
        this.printWriter.println(".Default nwinc=" + this.localPrefs.widthSubdivisions + " nhinc=" + this.localPrefs.heightSubdivisions + " h=" + TextUtils.formatDouble(this.localPrefs.defThickness));
        this.sim_writefhcell(cell);
        this.printWriter.println("");
        if (!this.localPrefs.useSingleFrequency) {
            this.printWriter.println(".freq fmin=" + TextUtils.formatDouble(this.localPrefs.startFrequency) + " fmax=" + TextUtils.formatDouble(this.localPrefs.endFrequency) + " ndec=" + Integer.toString(this.localPrefs.runsPerDecade));
        } else {
            this.printWriter.println(".freq fmin=" + TextUtils.formatDouble(this.localPrefs.startFrequency) + " fmax=" + TextUtils.formatDouble(this.localPrefs.endFrequency) + " ndec=1");
        }
        this.printWriter.println("");
        this.printWriter.println(".end");
    }

    private void sim_writefhcell(Cell cell) {
        this.printWriter.println("");
        this.printWriter.println("* Traces");
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            boolean found = false;
            double nodeZVal = 0.0;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst ai = con.getArc();
                FastHenryArcInfo fhai = new FastHenryArcInfo(ai, this.localPrefs);
                if (fhai.getGroupName() == null) continue;
                double zVal = fhai.getZDefault();
                if (fhai.getZ() >= 0.0) {
                    zVal = fhai.getZ();
                }
                if (found && zVal != nodeZVal) {
                    this.reportWarning("Warning: inconsistent z value at " + String.valueOf(ni));
                }
                nodeZVal = zVal;
                found = true;
            }
            if (!found) continue;
            String nname = ni.getName();
            if (ni.hasExports()) {
                Export e2 = ni.getExports().next();
                nname = e2.getName();
            }
            double x = TextUtils.convertDistance(ni.getTrueCenterX(), cell.getTechnology(), TextUtils.UnitScale.MICRO);
            double y = TextUtils.convertDistance(ni.getTrueCenterY(), cell.getTechnology(), TextUtils.UnitScale.MICRO);
            double z = TextUtils.convertDistance(nodeZVal, cell.getTechnology(), TextUtils.UnitScale.MICRO);
            this.printWriter.println("N_" + nname + " x=" + TextUtils.formatDouble(x) + " y=" + TextUtils.formatDouble(y) + " z=" + TextUtils.formatDouble(z));
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            FastHenryArcInfo fhai = new FastHenryArcInfo(ai, this.localPrefs);
            if (fhai.getGroupName() == null) continue;
            double wid = ai.getLambdaBaseWidth();
            NodeInst n1 = ai.getHeadPortInst().getNodeInst();
            String n1Name = n1.getName();
            if (n1.hasExports()) {
                n1Name = n1.getExports().next().getName();
            }
            NodeInst n2 = ai.getTailPortInst().getNodeInst();
            String n2Name = n2.getName();
            if (n2.hasExports()) {
                n2Name = n2.getExports().next().getName();
            }
            double w = TextUtils.convertDistance(wid, cell.getTechnology(), TextUtils.UnitScale.MICRO);
            StringBuffer sb = new StringBuffer();
            sb.append("E_" + n1Name + "_" + n2Name + " N_" + n1Name + " N_" + n2Name + " w=" + TextUtils.formatDouble(w));
            if (fhai.getThickness() > 0.0) {
                double h2 = TextUtils.convertDistance(fhai.getThickness(), cell.getTechnology(), TextUtils.UnitScale.MICRO);
                sb.append(" h=" + TextUtils.formatDouble(h2));
            }
            if (fhai.getWidthSubdivisions() > 0) {
                sb.append(" nwinc=" + Integer.toString(fhai.getWidthSubdivisions()));
            }
            if (fhai.getHeightSubdivisions() > 0) {
                sb.append(" nhinc=" + Integer.toString(fhai.getHeightSubdivisions()));
            }
            this.printWriter.println(sb.toString());
        }
        this.printWriter.println("");
        this.printWriter.println("* External connections");
        HashSet<ArcInst> arcsSeen = new HashSet<ArcInst>();
        HashSet<Export> portsSeen = new HashSet<Export>();
        Iterator<Object> it2 = cell.getPorts();
        while (it2.hasNext()) {
            Export e3 = (Export)it2.next();
            if (portsSeen.contains(e3)) continue;
            portsSeen.add(e3);
            NodeInst ni = e3.getOriginalPort().getNodeInst();
            Connection con = null;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext() && (con = cIt.next()).getArc().getVar(Schematics.INDUCTOR_NAME) == null) {
                con = null;
            }
            if (con == null) continue;
            int thatEnd = 1 - con.getEndIndex();
            Export oE = this.sim_fasthenryfindotherport(con.getArc(), thatEnd, arcsSeen);
            if (oE == null) {
                this.reportWarning("Warning: trace on export " + e3.getName() + " has no other end that is an export");
                continue;
            }
            portsSeen.add(oE);
            this.printWriter.println(".external N_" + e3.getName() + " N_" + oE.getName());
        }
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            if (arcsSeen.contains(ai) || ai.getVar(Schematics.INDUCTOR_NAME) == null) continue;
            this.reportWarning("Warning: " + String.valueOf(ai) + " is not connected to an export");
        }
    }

    private Export sim_fasthenryfindotherport(ArcInst ai, int end, Set<ArcInst> arcsSeen) {
        arcsSeen.add(ai);
        NodeInst ni = ai.getPortInst(end).getNodeInst();
        if (ni.hasExports()) {
            return ni.getExports().next();
        }
        Iterator<Connection> it = ni.getConnections();
        while (it.hasNext()) {
            int thatEnd;
            Export oE;
            Variable var;
            Connection con = it.next();
            ArcInst oAi = con.getArc();
            if (oAi == ai || (var = ai.getVar(Schematics.INDUCTOR_NAME)) == null || (oE = this.sim_fasthenryfindotherport(oAi, thatEnd = 1 - con.getEndIndex(), arcsSeen)) == null) continue;
            return oE;
        }
        return null;
    }

    public static class FastHenryPreferences
    extends Output.OutputPreferences {
        int widthSubdivisions = SimulationTool.getFactoryFastHenryWidthSubdivisions();
        int heightSubdivisions = SimulationTool.getFactoryFastHenryHeightSubdivisions();
        double defThickness = SimulationTool.getFactoryFastHenryDefThickness();
        boolean useSingleFrequency = SimulationTool.isFactoryFastHenryUseSingleFrequency();
        double startFrequency = SimulationTool.getFactoryFastHenryStartFrequency();
        double endFrequency = SimulationTool.getFactoryFastHenryEndFrequency();
        int runsPerDecade = SimulationTool.getFactoryFastHenryRunsPerDecade();

        public FastHenryPreferences(boolean factory) {
            super(factory);
            if (!factory) {
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.widthSubdivisions = SimulationTool.getFastHenryWidthSubdivisions();
            this.heightSubdivisions = SimulationTool.getFastHenryHeightSubdivisions();
            this.defThickness = SimulationTool.getFastHenryDefThickness();
            this.useSingleFrequency = SimulationTool.isFastHenryUseSingleFrequency();
            this.startFrequency = SimulationTool.getFastHenryStartFrequency();
            this.endFrequency = SimulationTool.getFastHenryEndFrequency();
            this.runsPerDecade = SimulationTool.getFastHenryRunsPerDecade();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            FastHenry out = new FastHenry(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.writeFH(cell, context);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }

    public static class FastHenryArcInfo {
        private String groupName;
        private double thickness;
        private int widthSubdivisions;
        private int heightSubdivisions;
        private double z;
        private double zDefault;

        public String getGroupName() {
            return this.groupName;
        }

        public double getThickness() {
            return this.thickness;
        }

        public int getWidthSubdivisions() {
            return this.widthSubdivisions;
        }

        public int getHeightSubdivisions() {
            return this.heightSubdivisions;
        }

        public double getZ() {
            return this.z;
        }

        public double getZDefault() {
            return this.zDefault;
        }

        public FastHenryArcInfo(ArcInst ai, FastHenryPreferences prefs) {
            Technology tech = ai.getProto().getTechnology();
            this.groupName = null;
            Variable var = ai.getVar(Schematics.INDUCTOR_NAME);
            if (var != null) {
                this.groupName = var.getPureValue(-1);
            }
            this.thickness = -1.0;
            var = ai.getVar(Schematics.INDUCTOR_THICKNESS);
            if (var != null) {
                this.thickness = var.getObject() instanceof Integer ? (double)((Integer)var.getObject()).intValue() / tech.getScale() : TextUtils.atof(var.getPureValue(-1));
            }
            this.widthSubdivisions = -1;
            var = ai.getVar(Schematics.INDUCTOR_WIDTH_SUBDIVS);
            if (var != null) {
                this.widthSubdivisions = TextUtils.atoi(var.getPureValue(-1));
            }
            this.heightSubdivisions = -1;
            var = ai.getVar(Schematics.INDUCTOR_HEIGHT_SUBDIVS);
            if (var != null) {
                this.heightSubdivisions = TextUtils.atoi(var.getPureValue(-1));
            }
            this.z = -1.0;
            var = ai.getVar(Schematics.INDUCTOR_Z);
            if (var != null) {
                this.z = var.getObject() instanceof Integer ? (double)((Integer)var.getObject()).intValue() / tech.getScale() : TextUtils.atof(var.getPureValue(-1));
            }
            this.zDefault = -1.0;
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i2 = 0; i2 < polys.length; ++i2) {
                Poly poly = polys[i2];
                Layer layer = poly.getLayer();
                if (layer == null) continue;
                this.zDefault = layer.getDepth();
                break;
            }
        }
    }
}

