/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.JavaCompatiblity;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DXF
extends Output {
    public static final Variable.Key DXF_LAYER_KEY = Variable.newKey("IO_dxf_layer");
    public static final Variable.Key DXF_HEADER_TEXT_KEY = Variable.newKey("IO_dxf_header_text");
    public static final Variable.Key DXF_HEADER_ID_KEY = Variable.newKey("IO_dxf_header_ID");
    private int dxfEntityHandle;
    private Set<Cell> cellsSeen;
    private TextUtils.UnitScale dxfDispUnit;
    private String defaultDXFLayerName;
    private static String[] ignorefromheader = new String[]{"$DWGCODEPAGE", "$HANDSEED", "$SAVEIMAGES"};
    private DXFPreferences localPrefs;

    DXF(DXFPreferences dp) {
        this.localPrefs = dp;
    }

    private void writeDXF(Cell cell) {
        this.dxfDispUnit = TextUtils.UnitScale.findFromIndex(this.localPrefs.dxfScale);
        Variable varheadertext = cell.getLibrary().getVar(DXF_HEADER_TEXT_KEY);
        Variable varheaderid = cell.getLibrary().getVar(DXF_HEADER_ID_KEY);
        Layer defLay = Artwork.tech().findLayer("Graphics");
        this.defaultDXFLayerName = defLay.getDXFLayer();
        if (varheadertext != null && varheaderid != null) {
            this.printWriter.print("  0\nSECTION\n");
            this.printWriter.print("  2\nHEADER\n");
            int len = Math.min(varheadertext.getLength(), varheaderid.getLength());
            for (int i2 = 0; i2 < len; ++i2) {
                String pt = (String)varheadertext.getObject(i2);
                int code = (Integer)varheaderid.getObject(i2);
                if (code == 9 && i2 <= len - 2) {
                    boolean found = false;
                    for (int j2 = 0; j2 < ignorefromheader.length; ++j2) {
                        if (!pt.equals(ignorefromheader[j2]) && !pt.substring(1).equals(ignorefromheader[j2])) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        ++i2;
                        continue;
                    }
                }
                if (pt.equals("$ACADVER") && i2 <= len - 2) {
                    this.printWriter.print(this.getThreeDigit(code) + "\n" + pt + "\n");
                    this.printWriter.print("  1\nAC1009\n");
                    ++i2;
                    continue;
                }
                this.printWriter.print(this.getThreeDigit(code) + "\n" + pt + "\n");
            }
            this.printWriter.print("  0\nENDSEC\n");
        }
        this.dxfEntityHandle = 256;
        this.printWriter.print("  0\nSECTION\n");
        this.printWriter.print("  2\nBLOCKS\n");
        this.cellsSeen = new HashSet<Cell>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeProto np;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || this.cellsSeen.contains(np = ni.getProto())) continue;
            this.writeDXFCell((Cell)np, true);
        }
        this.printWriter.print("  0\nENDSEC\n");
        this.printWriter.print("  0\nSECTION\n");
        this.printWriter.print("  2\nENTITIES\n");
        this.writeDXFCell(cell, false);
        this.printWriter.print("  0\nENDSEC\n");
        this.printWriter.print("  0\nEOF\n");
    }

    private String formatDoubleJavaVersion(double value) {
        double scale = JavaCompatiblity.JAVA8 ? 100 : 1000;
        double rounded = (double)Math.round(value * scale) / scale;
        String str = TextUtils.formatDouble(rounded);
        return str;
    }

    private void writeDXFCell(Cell cell, boolean subCells) {
        NodeProto np;
        NodeInst ni;
        Iterator<NodeInst> it;
        if (subCells) {
            this.cellsSeen.add(cell);
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                np = ni.getProto();
                if (!ni.isCellInstance() || this.cellsSeen.contains(np)) continue;
                this.writeDXFCell((Cell)np, true);
            }
            this.printWriter.print("  0\nBLOCK\n");
            this.printWriter.print("  2\n" + this.getDXFCellName(cell) + "\n");
            this.printWriter.print(" 10\n0\n");
            this.printWriter.print(" 20\n0\n");
            this.printWriter.print(" 30\n0\n");
            this.printWriter.print(" 70\n0\n");
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            double yC;
            double xC;
            ni = it.next();
            np = ni.getProto();
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)np;
                this.printWriter.print("  0\nINSERT\n");
                this.printWriter.print("  8\nUNKNOWN\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                this.printWriter.print("  2\n" + this.getDXFCellName(subCell) + "\n");
                ERectangle cellBounds = subCell.getBounds();
                xC = TextUtils.convertDistance(ni.getAnchorCenterX() - ((RectangularShape)cellBounds).getCenterX(), this.localPrefs.tech, this.dxfDispUnit);
                yC = TextUtils.convertDistance(ni.getAnchorCenterY() - ((RectangularShape)cellBounds).getCenterY(), this.localPrefs.tech, this.dxfDispUnit);
                this.printWriter.print(" 10\n" + this.formatDoubleJavaVersion(xC) + "\n");
                this.printWriter.print(" 20\n" + this.formatDoubleJavaVersion(yC) + "\n");
                this.printWriter.print(" 30\n0\n");
                double rot = (double)ni.getAngle() / 10.0;
                this.printWriter.print(" 50\n" + this.formatDoubleJavaVersion(rot) + "\n");
                continue;
            }
            String layerName = this.defaultDXFLayerName;
            Variable var = ni.getVar(DXF_LAYER_KEY);
            if (var != null) {
                layerName = var.getPureValue(-1);
            } else if (!ni.isCellInstance()) {
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology.NodeLayer[] nodeLayers = pNp.getNodeLayers();
                for (int i2 = 0; i2 < nodeLayers.length; ++i2) {
                    Technology.NodeLayer nl = nodeLayers[i2];
                    Layer layer = nl.getLayer();
                    String dxfLayerName = layer.getDXFLayer();
                    if (dxfLayerName == null || dxfLayerName.length() <= 0) continue;
                    layerName = dxfLayerName;
                    break;
                }
            }
            xC = ni.getAnchorCenterX();
            yC = ni.getAnchorCenterY();
            if (np instanceof PrimitiveNode && ((PrimitiveNode)np).isPartialCircle()) {
                double[] angles = ni.getArcDegrees();
                double startOffset = angles[0];
                double endAngle = angles[1];
                if (startOffset != 0.0 || endAngle != 0.0) {
                    this.printWriter.print("  0\nARC\n");
                } else {
                    this.printWriter.print("  0\nCIRCLE\n");
                }
                this.printWriter.print("  8\n" + layerName + "\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                xC = TextUtils.convertDistance(xC, this.localPrefs.tech, this.dxfDispUnit);
                yC = TextUtils.convertDistance(yC, this.localPrefs.tech, this.dxfDispUnit);
                double zC = TextUtils.convertDistance(ni.getYSize() / 2.0, this.localPrefs.tech, this.dxfDispUnit);
                this.printWriter.print(" 10\n" + this.formatDoubleJavaVersion(xC) + "\n");
                this.printWriter.print(" 20\n" + this.formatDoubleJavaVersion(yC) + "\n");
                this.printWriter.print(" 30\n0\n");
                this.printWriter.print(" 40\n" + this.formatDoubleJavaVersion(zC) + "\n");
                if (startOffset == 0.0 && endAngle == 0.0) continue;
                startOffset = startOffset * 180.0 / Math.PI;
                endAngle = endAngle * 180.0 / Math.PI;
                double startAngle = (double)ni.getAngle() / 10.0 + startOffset;
                if (ni.isXMirrored() != ni.isYMirrored() && (startAngle = 270.0 - startAngle - endAngle) < 0.0) {
                    startAngle += 360.0;
                }
                if ((endAngle += startAngle) >= 360.0) {
                    endAngle -= 360.0;
                }
                this.printWriter.print(" 50\n" + this.formatDoubleJavaVersion(startAngle) + "\n");
                this.printWriter.print(" 51\n" + this.formatDoubleJavaVersion(endAngle) + "\n");
                continue;
            }
            if (np == Artwork.tech().openedPolygonNode || np == Artwork.tech().openedDashedPolygonNode || np == Artwork.tech().closedPolygonNode) {
                double y;
                FixpTransform trans = ni.rotateOut();
                EPoint[] points = ni.getTrace();
                int len = points.length;
                if (len == 2 && np != Artwork.tech().closedPolygonNode) {
                    this.printWriter.print("  0\nLINE\n");
                    this.printWriter.print("  8\n" + layerName + "\n");
                    this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                    Point2D.Double pt = new Point2D.Double(((Point2D)points[0]).getX() + xC, ((Point2D)points[0]).getY() + yC);
                    trans.transform(pt, pt);
                    double x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                    y = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                    this.printWriter.print(" 10\n" + this.formatDoubleJavaVersion(x) + "\n");
                    this.printWriter.print(" 20\n" + this.formatDoubleJavaVersion(y) + "\n");
                    this.printWriter.print(" 30\n0\n");
                    pt = new Point2D.Double(((Point2D)points[1]).getX() + xC, ((Point2D)points[1]).getY() + yC);
                    trans.transform(pt, pt);
                    x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                    y = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                    this.printWriter.print(" 11\n" + this.formatDoubleJavaVersion(x) + "\n");
                    this.printWriter.print(" 21\n" + this.formatDoubleJavaVersion(y) + "\n");
                    this.printWriter.print(" 31\n0\n");
                    continue;
                }
                for (int i3 = 0; i3 < len - 1; ++i3) {
                    if (points[i3] == null || points[i3 + 1] == null) continue;
                    this.printWriter.print("  0\nLINE\n");
                    this.printWriter.print("  8\n" + layerName + "\n");
                    this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                    Point2D.Double pt = new Point2D.Double(((Point2D)points[i3]).getX() + xC, ((Point2D)points[i3]).getY() + yC);
                    trans.transform(pt, pt);
                    double x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                    double y2 = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                    this.printWriter.print(" 10\n" + this.formatDoubleJavaVersion(x) + "\n");
                    this.printWriter.print(" 20\n" + this.formatDoubleJavaVersion(y2) + "\n");
                    this.printWriter.print(" 30\n0\n");
                    pt = new Point2D.Double(((Point2D)points[i3 + 1]).getX() + xC, ((Point2D)points[i3 + 1]).getY() + yC);
                    trans.transform(pt, pt);
                    x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                    y2 = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                    this.printWriter.print(" 11\n" + this.formatDoubleJavaVersion(x) + "\n");
                    this.printWriter.print(" 21\n" + this.formatDoubleJavaVersion(y2) + "\n");
                    this.printWriter.print(" 31\n0\n");
                }
                if (np != Artwork.tech().closedPolygonNode) continue;
                this.printWriter.print("  0\nLINE\n");
                this.printWriter.print("  8\n" + layerName + "\n");
                this.printWriter.print("  5\n" + this.getThreeDigitHex(this.dxfEntityHandle++) + "\n");
                Point2D.Double pt = new Point2D.Double(((Point2D)points[len - 1]).getX() + xC, ((Point2D)points[len - 1]).getY() + yC);
                trans.transform(pt, pt);
                double x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                y = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                this.printWriter.print(" 10\n" + this.formatDoubleJavaVersion(x) + "\n");
                this.printWriter.print(" 20\n" + this.formatDoubleJavaVersion(y) + "\n");
                this.printWriter.print(" 30\n0\n");
                pt = new Point2D.Double(((Point2D)points[0]).getX() + xC, ((Point2D)points[0]).getY() + yC);
                trans.transform(pt, pt);
                x = TextUtils.convertDistance(((Point2D)pt).getX(), this.localPrefs.tech, this.dxfDispUnit);
                y = TextUtils.convertDistance(((Point2D)pt).getY(), this.localPrefs.tech, this.dxfDispUnit);
                this.printWriter.print(" 11\n" + this.formatDoubleJavaVersion(x) + "\n");
                this.printWriter.print(" 21\n" + this.formatDoubleJavaVersion(y) + "\n");
                this.printWriter.print(" 31\n0\n");
                continue;
            }
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            FixpTransform trans = ni.rotateOut();
            for (int i4 = 0; i4 < polys.length; ++i4) {
                Poly poly = polys[i4];
                poly.transform(trans);
                if (poly.getStyle() != Poly.Type.FILLED) continue;
                this.printWriter.print("  0\nSOLID\n");
                this.printWriter.print("  8\n" + layerName + "\n");
                PolyBase.Point[] points = poly.getPoints();
                for (int j2 = 0; j2 < points.length; ++j2) {
                    this.printWriter.print(" 1" + j2 + "\n" + this.formatDoubleJavaVersion(((Point2D)points[j2]).getX()) + "\n");
                    this.printWriter.print(" 2" + j2 + "\n" + this.formatDoubleJavaVersion(((Point2D)points[j2]).getY()) + "\n");
                    this.printWriter.print(" 3" + j2 + "\n0\n");
                }
            }
        }
        if (subCells) {
            this.printWriter.print("  0\nENDBLK\n");
        }
    }

    private String getDXFCellName(Cell cell) {
        if (cell.getName().equalsIgnoreCase(cell.getLibrary().getName())) {
            String buf = null;
            for (int i2 = 1; i2 < 1000; ++i2) {
                buf = cell.getName() + i2;
                boolean found = false;
                Iterator<Cell> it = cell.getLibrary().getCells();
                while (it.hasNext()) {
                    Cell oCell = it.next();
                    if (!oCell.getName().equalsIgnoreCase(buf)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
            }
            return buf;
        }
        return cell.getName();
    }

    private String getThreeDigit(int value) {
        Object result = Integer.toString(value);
        while (((String)result).length() < 3) {
            result = " " + (String)result;
        }
        return result;
    }

    private String getThreeDigitHex(int value) {
        Object result = Integer.toHexString(value).toUpperCase();
        while (((String)result).length() < 3) {
            result = " " + (String)result;
        }
        return result;
    }

    public static class DXFPreferences
    extends Output.OutputPreferences {
        int dxfScale = IOTool.getDXFScale();
        public Technology tech = Technology.getCurrent();

        public DXFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            DXF out = new DXF(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.writeDXF(cell);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

