/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SpiceModel {
    private final String modPrefix;
    private final String flag;
    private final Map<String, Map<String, String>> paramSets = new LinkedHashMap<String, Map<String, String>>();

    SpiceModel(String modPrefix, String flag) {
        this.modPrefix = modPrefix;
        this.flag = flag;
    }

    public String getModPrefix() {
        return this.modPrefix;
    }

    public String getFlag() {
        return this.flag;
    }

    public Map<String, String> newParams(String modSuffix) {
        modSuffix = modSuffix.toLowerCase();
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        this.paramSets.put(modSuffix, newParams);
        return newParams;
    }

    public void write(PrintStream out, Set<SpiceModel> usedModels) {
        if (usedModels != null && !usedModels.contains(this)) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> e2 : this.paramSets.entrySet()) {
            String modSuffix = e2.getKey();
            Map<String, String> paramSet = e2.getValue();
            StringBuilder buf = new StringBuilder();
            buf.append(".model ").append(this.modPrefix).append(modSuffix).append(" ").append(this.flag).append(" ");
            for (Map.Entry<String, String> e1 : paramSet.entrySet()) {
                String key = e1.getKey();
                String value = e1.getValue();
                buf.append(key);
                if (value != null) {
                    buf.append("=").append(value);
                }
                buf.append(" ");
            }
            buf.append("\n");
            SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
        }
    }
}

