/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceModel;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpiceInstance {
    private final char type;
    private final String name;
    private String modName;
    private SpiceModel model;
    private final List<String> nets = new ArrayList<String>();
    private final SpiceSubckt subckt;
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    public SpiceInstance(String typeAndName) {
        this.type = typeAndName.charAt(0);
        this.name = typeAndName.substring(1);
        this.subckt = null;
    }

    public SpiceInstance(SpiceSubckt subckt, String name) {
        this.type = (char)120;
        this.name = name;
        this.subckt = subckt;
    }

    public char getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNets() {
        return this.nets;
    }

    public void addModName(String modName) {
        this.modName = modName;
    }

    void linkModel(SpiceNetlistReader reader, List<SpiceSubckt> currentSubcktStack) {
        if (this.modName == null) {
            return;
        }
        for (int j2 = currentSubcktStack.size() - 1; this.model == null && j2 >= 0; --j2) {
            this.model = currentSubcktStack.get(j2).findModel(this.modName);
        }
        if (this.model == null) {
            this.model = reader.getGlobalModels().get(this.modName.toLowerCase());
        }
        if (this.model == null) {
            reader.prErr("Cannot find model for " + this.modName);
        }
    }

    public void addNet(String net) {
        this.nets.add(net);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public SpiceSubckt getSubckt() {
        return this.subckt;
    }

    void markUsed(Set<SpiceSubckt> usedSubckts, Set<SpiceModel> usedModels) {
        if (this.subckt != null) {
            this.subckt.markUsed(usedSubckts, usedModels);
        }
        if (this.model != null) {
            usedModels.add(this.model);
        }
    }

    public void write(PrintStream out) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type);
        buf.append(this.name);
        buf.append(" ");
        for (String net : this.nets) {
            buf.append(net);
            buf.append(" ");
        }
        if (this.model != null) {
            buf.append(this.model.getModPrefix()).append(" ");
        }
        if (this.subckt != null) {
            buf.append(this.subckt.getName());
            buf.append(" ");
        }
        for (String key : this.params.keySet()) {
            buf.append(key);
            String value = this.params.get(key);
            if (value != null) {
                buf.append("=").append(value);
            }
            buf.append(" ");
        }
        buf.append("\n");
        SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
    }
}

