/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class JoSimOut
extends Input<Stimuli> {
    JoSimOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openTextInput(fileURL)) {
            return sd;
        }
        System.out.println("Reading JoSIM output file: " + fileURL.getFile());
        JoSimOut.startProgressDialog("JoSIM output", fileURL.getFile());
        this.readJoSimFile(cell, sd);
        JoSimOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readJoSimFile(Cell cell, Stimuli sd) throws IOException {
        int i2;
        String line;
        boolean first = true;
        SignalCollection sc = Stimuli.newSignalCollection(sd, "SIGNALS");
        sd.setCell(cell);
        ArrayList<String> signalNames = new ArrayList<String>();
        List[] values = null;
        int numSignals = 0;
        while ((line = this.getLine()) != null) {
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a JoSIM file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
                int ptr = 0;
                do {
                    int start = ptr;
                    while (ptr < line.length() && line.charAt(ptr) != ',') {
                        ++ptr;
                    }
                    signalNames.add(line.substring(start, ptr));
                } while (++ptr < line.length());
                numSignals = signalNames.size();
                values = new List[numSignals];
                for (i2 = 0; i2 < numSignals; ++i2) {
                    values[i2] = new ArrayList();
                }
                continue;
            }
            int equalPos = line.indexOf("=");
            if (equalPos >= 0) {
                if (line.length() > equalPos + 3) {
                    line = line.substring(equalPos + 3);
                } else {
                    System.out.println("Missing value after '='.  This may not be a JoSIM output file.");
                    return;
                }
            }
            int ptr = 0;
            int position = 0;
            do {
                int start = ptr;
                while (ptr < line.length() && line.charAt(ptr) != ',') {
                    ++ptr;
                }
                double value = TextUtils.atof(line.substring(start, ptr));
                values[position++].add(value);
            } while (++ptr < line.length());
            if (position == numSignals) continue;
            System.out.println("Line of data has " + position + " values, but expect " + numSignals + ". Unable to recover from error.  This may not be a JoSIM output file.");
            return;
        }
        if (numSignals == 0) {
            System.out.println("No data found in the file.  This may not be a JoSIM output file.");
            return;
        }
        int numEvents = values[0].size();
        double[] time = new double[numEvents];
        for (i2 = 0; i2 < numEvents; ++i2) {
            time[i2] = (Double)values[0].get(i2);
        }
        for (int j2 = 1; j2 < numSignals; ++j2) {
            double[] doubleValues = new double[numEvents];
            for (int i3 = 0; i3 < numEvents; ++i3) {
                doubleValues[i3] = (Double)values[j2].get(i3);
            }
            ScalarSample.createSignal(sc, sd, (String)signalNames.get(j2), null, time, doubleValues);
        }
    }
}

