/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Pms2 {
    private static final double gY = 4.0;
    private static final double dY = 11.0;
    private static final double pmosBot = 9.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "pms2";
        sz = stdCell.checkMinStrength(sz, 0.25, nm);
        int nbStacked = 2;
        double spaceAvail = stdCell.getCellTop() - 1.5 - 5.0 - 2.0 - 9.0;
        FoldsAndWidth fw = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 6.0 * (double)nbStacked, 1);
        Pms2.error(fw == null, "can't make Pms2 this small: " + sz);
        double g2FromVddY = stdCell.getVddY() + stdCell.getVddWidth() / 2.0 + 3.0 + 2.0;
        double g2FromMosY = 9.0 + fw.physWid + 2.0 + 2.5;
        double g2Y = Math.max(g2FromVddY, g2FromMosY);
        Cell pms2 = stdCell.findPart(nm, sz);
        if (pms2 != null) {
            return pms2;
        }
        pms2 = stdCell.newPart(nm, sz);
        double gX = 3.5;
        LayoutLib.newExport(pms2, "g", ep, PortCharacteristic.IN, tech.m1(), 4.0, gX, 4.0);
        double mosX = gX + 2.0 + 3.0 + 2.0;
        double pmosY = 9.0 + fw.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fw.nbFolds, nbStacked, fw.gateWid, pms2, tech, ep);
        double g2X = StdCellParams.getRightDiffX(pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(pms2, "g2", ep, PortCharacteristic.IN, tech.m1(), 4.0, g2X, g2Y);
        double dX = g2X + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(pms2, "d", ep, PortCharacteristic.OUT, tech.m1(), 4.0, dX, 11.0);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, pms2);
        TrackRouterH g2 = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, pms2);
        TrackRouterH g22 = new TrackRouterH(tech.m1(), 3.0, g2Y, tech, ep, pms2);
        g2.connect(pms2.findExport("g"));
        g22.connect(pms2.findExport("g2"));
        for (int i2 = 0; i2 < pmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                ((TrackRouter)g2).connect(pmos.getGate(i2, 'B'), -4.0, tech.getPolyLShapeOffset());
                ((TrackRouter)g22).connect(pmos.getGate(i2 + 1, 'T'), 4.0, -tech.getPolyLShapeOffset());
                continue;
            }
            ((TrackRouter)g2).connect(pmos.getGate(i2 + 1, 'B'), 4.0, tech.getPolyLShapeOffset());
            ((TrackRouter)g22).connect(pmos.getGate(i2, 'T'), -4.0, -tech.getPolyLShapeOffset());
        }
        TrackRouterH d2 = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, pms2);
        d2.connect(pms2.findExport("d"));
        for (int i3 = 1; i3 < pmos.nbSrcDrns(); i3 += 2) {
            d2.connect(pmos.getSrcDrn(i3));
        }
        double wellMinX = 0.0;
        double wellMaxX = dX + 2.0 + 1.5;
        stdCell.addPmosWell(wellMinX, wellMaxX, pms2);
        stdCell.addPstackEssentialBounds(wellMinX, wellMaxX, pms2);
        stdCell.doNCC(pms2, nm + "{sch}");
        return pms2;
    }
}

