/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2en_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inaY = -4.0;
    private static final double inbY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i2;
        int i3;
        double lamPerSz;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "nand2en_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * (lamPerSz = 6.0), 1);
        Nand2en_sy.error(fwP == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(3.0, sz * lamPerSz * stdCell.getEnableGateStrengthRatio());
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        int nbSeriesN = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbSeriesN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2en_sy.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double nmosX = inbX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        int nbSeries = 2;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, nbSeries, fwN.gateWid, nand, tech, ep);
        FoldedMos[] pmoss = new FoldedMos[(int)Math.ceil((double)fwP.nbFolds / 2.0)];
        double pmosY = 9.0 + fwP.physWid / 2.0;
        for (int nbFoldsP = 0; nbFoldsP < fwP.nbFolds; nbFoldsP += 2) {
            int nbFolds = Math.min(2, fwP.nbFolds - nbFoldsP);
            nbSeries = 1;
            double pmosPitch = 26.0;
            double pmosX = nmosX + 2.0 + pmosPitch * (double)(nbFoldsP / 2);
            pmoss[nbFoldsP / 2] = new FoldedPmos(pmosX, pmosY, nbFolds, nbSeries, fwP.gateWid, nand, tech, ep);
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        double rightDiffX = StdCellParams.getRightDiffX(pmoss, nmos);
        double weakX = rightDiffX + 8.5;
        double weakY = 9.0 + fwW.physWid / 2.0;
        FoldedPmos weakPmos = new FoldedPmos(weakX, weakY, fwW.nbFolds, 1, fwW.gateWid, nand, tech, ep);
        FoldedMos[] stroWeakPmoss = new FoldedMos[pmoss.length + 1];
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            stroWeakPmoss[i4] = pmoss[i4];
        }
        stroWeakPmoss[pmoss.length] = weakPmos;
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(stroWeakPmoss, StdCellParams.EVEN, nand);
        LayoutLib.newExport(nand, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, nand);
        inb.connect(nand.findExport("inb"));
        block10: for (i3 = 0; i3 < nmos.nbGates(); ++i3) {
            switch (i3 % 4) {
                case 0: {
                    inb.connect(nmos.getGate(i3, 'T'));
                    continue block10;
                }
                case 2: {
                    inb.connect(nmos.getGate(i3, 'T'), -1.5);
                }
            }
        }
        for (i3 = 0; i3 < pmoss.length; ++i3) {
            block12: for (int j2 = 0; j2 < pmoss[i3].nbGates(); ++j2) {
                switch (j2) {
                    case 0: {
                        inb.connect(pmoss[i3].getGate(j2, 'B'), -2.0);
                        continue block12;
                    }
                    case 1: {
                        inb.connect(pmoss[i3].getGate(j2, 'B'), 1.5);
                    }
                }
            }
        }
        double inaX = StdCellParams.getRightDiffX(weakPmos, nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        TrackRouterH ina = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, nand);
        ina.connect(nand.findExport("ina"));
        for (i2 = 0; i2 < nmos.nbGates(); ++i2) {
            if (i2 % 2 != 1) continue;
            ina.connect(nmos.getGate(i2, 'T'), 1.5);
        }
        for (i2 = 0; i2 < weakPmos.nbGates(); ++i2) {
            ina.connect(weakPmos.getGate(i2, 'B'), 1.5);
        }
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, nand);
        outHi.connect(nand.findExport("out"));
        for (int i5 = 0; i5 < stroWeakPmoss.length; ++i5) {
            for (int j3 = 1; j3 < stroWeakPmoss[i5].nbSrcDrns(); j3 += 2) {
                outHi.connect(stroWeakPmoss[i5].getSrcDrn(j3));
            }
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nand);
        outLo.connect(nand.findExport("out"));
        for (int i6 = 1; i6 < nmos.nbSrcDrns(); i6 += 2) {
            outLo.connect(nmos.getSrcDrn(i6));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

