/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2PH {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double pGatesY = 4.0;
    private static final double nGatesY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double weakRatio = 10.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i2;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        sz = stdCell.roundSize(sz);
        String nm = "nand2PH";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 6.0 * 2.0, 2);
        Nand2PH.error(fwP == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2PH.error(fwN == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(3.0, totWid / 10.0);
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2PH.error(fwW == null, "can't make " + nm + " this small: " + sz);
        Cell gate = stdCell.findPart(nm, sz);
        if (gate != null) {
            return gate;
        }
        gate = stdCell.newPart(nm, sz);
        double resetNX = 3.5;
        double inbX = resetNX + 7.0;
        double resetNJogX = inbX + 7.0;
        double mosX = resetNJogX + 7.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, gate, tech, ep);
        double nmosWeakY = -9.0 - fwW.physWid / 2.0;
        FoldedNmos nmosB = new FoldedNmos(mosX, nmosWeakY, fwW.nbFolds, 1, fwW.gateWid, gate, tech, ep);
        double nmosBRightX = StdCellParams.getRightDiffX(nmosB);
        double nmosX = nmosBRightX + 11.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmosR = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, gate, tech, ep);
        double rstNmosRightX = StdCellParams.getRightDiffX(nmosR);
        double pmosRightX = StdCellParams.getRightDiffX(pmos);
        double nmosAX = Math.max(rstNmosRightX + 11.0, pmosRightX - (double)(fwW.nbFolds * 8));
        FoldedNmos nmosA = new FoldedNmos(nmosAX, nmosWeakY, fwW.nbFolds, 1, fwW.gateWid, gate, tech, ep);
        FoldedMos[] nmoss = new FoldedMos[]{nmosB, nmosR, nmosA};
        stdCell.fillDiffAndSelectNotches(new FoldedMos[]{nmosB, nmosR}, false);
        stdCell.fillDiffAndSelectNotches(new FoldedMos[]{nmosR, nmosA}, false);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, gate);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, gate);
        TrackRouterH bGates = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, gate);
        TrackRouterH aGatesHi = new TrackRouterH(tech.m1(), 4.0, 4.0, tech, ep, gate);
        int nbGates = pmos.nbGates() / 2;
        for (int i3 = 0; i3 < nbGates; ++i3) {
            bGates.connect(pmos.getGate(i3, 'B'));
            aGatesHi.connect(pmos.getGate(i3 + nbGates, 'B'));
        }
        TrackRouterH aGatesLo = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, gate);
        nbGates = nmosA.nbGates();
        for (int i4 = 0; i4 < nbGates; ++i4) {
            bGates.connect(nmosB.getGate(i4, 'T'));
            aGatesLo.connect(nmosA.getGate(i4, 'T'));
        }
        TrackRouterH resetHi = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, gate);
        for (int i5 = 0; i5 < nmosR.nbGates(); ++i5) {
            resetHi.connect(nmosR.getGate(i5, 'T'));
        }
        PortInst resetNjog = LayoutLib.newNodeInst(tech.m1pin(), ep, resetNJogX, -4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, gate).getOnlyPortInst();
        resetHi.connect(resetNjog);
        TrackRouterH resetLo = new TrackRouterH(tech.m2(), 3.0, -11.0, tech, ep, gate);
        resetLo.connect(resetNjog);
        LayoutLib.newExport(gate, "resetN", ep, PortCharacteristic.IN, tech.m1(), 4.0, resetNX, -11.0);
        resetLo.connect(gate.findExport("resetN"));
        PortInst jogA = LayoutLib.newNodeInst(tech.m1pin(), ep, LayoutLib.roundCenterX(nmosA.getGate(0, 'T')), 4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, gate).getOnlyPortInst();
        aGatesLo.connect(jogA);
        aGatesHi.connect(jogA);
        LayoutLib.newExport(gate, "inb", ep, PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        bGates.connect(gate.findExport("inb"));
        double rightDiffX = StdCellParams.getRightDiffX(pmos, nmosA);
        double inaX = rightDiffX + 7.0;
        LayoutLib.newExport(gate, "ina", ep, PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        aGatesLo.connect(gate.findExport("ina"));
        double outX = inaX + 7.0;
        LayoutLib.newExport(gate, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 0.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, gate);
        outHi.connect(gate.findExport("out"));
        for (int i6 = 1; i6 < pmos.nbSrcDrns(); i6 += 2) {
            outHi.connect(pmos.getSrcDrn(i6));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, gate);
        outLo.connect(gate.findExport("out"));
        for (i2 = 1; i2 < nmosB.nbSrcDrns(); i2 += 2) {
            outLo.connect(nmosB.getSrcDrn(i2));
            outLo.connect(nmosA.getSrcDrn(i2));
        }
        for (i2 = 1; i2 < nmosR.nbSrcDrns(); i2 += 2) {
            outLo.connect(nmosR.getSrcDrn(i2));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 3.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, gate);
        stdCell.addPmosWell(wellMinX, wellMaxX, gate);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, gate);
        stdCell.doNCC(gate, nm + "{sch}");
        return gate;
    }
}

