/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class InvCTLn {
    private static final double wellOverhangDiff = 6.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double wirePitch = 7.0;
    private static final double wireWithPolyPitch = 8.0;
    private static final double pmosBot = 8.5;
    private static final double nmosTop = -8.5;
    private static final double inY = 4.0;
    private static final double ctlY = -4.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i2;
        double totWid;
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        String nm = "invCTLn";
        sz = stdCell.roundSize(sz);
        sz = stdCell.checkMinStrength(sz, 0.5, nm);
        int nbSeriesN = 2;
        double spaceAvail = -8.5 - (stdCell.getCellBot() + 6.0);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * (double)nbSeriesN * 3.0, 1);
        InvCTLn.error(fwN == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = stdCell.getCellTop() - 6.0 - 8.5;
        totWid = sz * 6.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        InvCTLn.error(fwP == null, "can't make " + nm + " this small: " + sz);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double inX = 3.5;
        double pmosX = inX + 7.0;
        double pmosY = 8.5 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(fwP.nbFolds + 1) / 2];
        for (int nbFoldsP = 0; nbFoldsP < fwP.nbFolds; nbFoldsP += 2) {
            double pmosPitch = 26.0;
            double x = pmosX + (double)(nbFoldsP / 2) * pmosPitch;
            int nbFolds = Math.min(2, fwP.nbFolds - nbFoldsP);
            FoldedPmos pmos = new FoldedPmos(x, pmosY, nbFolds, 1, fwP.gateWid, inv, tech, ep);
            pmoss[nbFoldsP / 2] = pmos;
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        double nmosX = pmosX + 8.0;
        double nmosY = -8.5 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, nbSeriesN, fwN.gateWid, inv, tech, ep);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, inv);
        LayoutLib.newExport(inv, "in", ep, PortCharacteristic.IN, tech.m1(), 4.0, inX, 4.0);
        TrackRouterH in = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, ep, inv);
        in.connect(inv.findExport("in"));
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            FoldedMos pmos = pmoss[i2];
            ((TrackRouter)in).connect(pmos.getGate(0, 'B'), 4.0, tech.getPolyLShapeOffset());
            if (pmos.nbGates() != 2) continue;
            ((TrackRouter)in).connect(pmos.getGate(1, 'B'), -4.0, tech.getPolyLShapeOffset());
        }
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                ((TrackRouter)in).connect(nmos.getGate(i2, 'T'), -4.0, -tech.getPolyTShapeOffset());
                continue;
            }
            ((TrackRouter)in).connect(nmos.getGate(i2 + 1, 'T'), 4.0, -tech.getPolyTShapeOffset());
        }
        double rightDiffX = StdCellParams.getRightDiffX(nmos, pmoss);
        double ctlX = rightDiffX + 7.0;
        LayoutLib.newExport(inv, "ctl", ep, PortCharacteristic.IN, tech.m1(), 4.0, ctlX, -4.0);
        TrackRouterH ctl = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, ep, inv);
        ctl.connect(inv.findExport("ctl"));
        for (int i3 = 0; i3 < nmos.nbGates(); i3 += 2) {
            if (i3 / 2 % 2 == 0) {
                ((TrackRouter)ctl).connect(nmos.getGate(i3 + 1, 'T'), 4.0, -tech.getPolyLShapeOffset());
                continue;
            }
            ((TrackRouter)ctl).connect(nmos.getGate(i3, 'T'), -4.0, -tech.getPolyLShapeOffset());
        }
        double outX = ctlX + 7.0;
        LayoutLib.newExport(inv, "out", ep, PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, inv);
        outHi.connect(inv.findExport("out"));
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            outHi.connect(pmoss[i4].getSrcDrn(1));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, inv);
        outLo.connect(inv.findExport("out"));
        for (int i5 = 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

