/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapCellMosis;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.FillCell;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplanFlex;
import com.sun.electric.tool.generator.layout.fill.TiledCell;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class FillGeneratorTool
extends Tool {
    public FillGenConfig config;
    protected Library lib;
    private boolean libInitialized;
    public List<Cell> masters;
    protected CapCell capCell;
    protected Floorplan[] plans;
    private static FillGeneratorTool tool = FillGeneratorTool.getTool();
    public static final Units LAMBDA = Units.LAMBDA;
    public static final Units TRACKS = Units.TRACKS;
    public static final ExportConfig PERIMETER = ExportConfig.PERIMETER;
    public static final ExportConfig PERIMETER_AND_INTERNAL = ExportConfig.PERIMETER_AND_INTERNAL;

    public static FillGeneratorTool getTool() {
        FillGeneratorTool tool;
        if (FillGeneratorTool.tool != null) {
            return FillGeneratorTool.tool;
        }
        try {
            Class<?> extraClass = Class.forName("com.sun.electric.tool.generator.layout.fillCell.FillCellTool");
            Constructor<?> instance = extraClass.getDeclaredConstructor(new Class[0]);
            Object obj = instance.newInstance(new Object[0]);
            tool = (FillGeneratorTool)obj;
        }
        catch (Exception e2) {
            TextUtils.recordMissingComponent("Fill Cell Generator");
            tool = new FillGeneratorTool();
        }
        return tool;
    }

    public FillGeneratorTool() {
        super("Fill Generator");
    }

    public void setConfig(FillGenConfig config) {
        this.config = config;
        this.libInitialized = false;
    }

    protected boolean getOrientation() {
        return this.plans[this.plans.length - 1].horizontal;
    }

    private double reservedToLambda(int layer, double reserved, Units units) {
        if (units == LAMBDA) {
            return reserved;
        }
        double nbTracks = reserved;
        if (nbTracks == 0.0) {
            return 0.0;
        }
        return this.config.getTechType().reservedToLambda(layer, nbTracks);
    }

    private Floorplan[] makeFloorplans(boolean metalFlex, boolean hierFlex) {
        Job.error(this.config.width == Double.NaN, "width hasn't been specified. use setWidth()");
        Job.error(this.config.height == Double.NaN, "height hasn't been specified. use setHeight()");
        double w = this.config.width;
        double h2 = this.config.height;
        int numLayers = this.config.getTechType().getNumMetals() + 1;
        double[] vddRes = new double[numLayers];
        double[] gndRes = new double[numLayers];
        double[] vddW = new double[numLayers];
        double[] gndW = new double[numLayers];
        for (FillGenConfig.ReserveConfig c2 : this.config.reserves) {
            vddRes[c2.layer] = this.reservedToLambda(c2.layer, c2.vddReserved, c2.vddUnits);
            gndRes[c2.layer] = this.reservedToLambda(c2.layer, c2.gndReserved, c2.gndUnits);
            if (c2.vddWUnits != Units.NONE) {
                vddW[c2.layer] = this.reservedToLambda(c2.layer, c2.vddWidth, c2.vddWUnits);
            }
            if (c2.gndWUnits == Units.NONE) continue;
            gndW[c2.layer] = this.reservedToLambda(c2.layer, c2.gndWidth, c2.gndWUnits);
        }
        boolean evenHor = this.config.evenLayersHorizontal;
        boolean alignedMetals = true;
        double[] spacing = new double[numLayers];
        for (int i2 = 0; i2 < numLayers; ++i2) {
            spacing[i2] = this.config.drcSpacingRule;
        }
        if (alignedMetals) {
            int i3;
            double maxVddRes = 0.0;
            double maxGndRes = 0.0;
            double maxSpacing = 0.0;
            double maxVddW = 0.0;
            double maxGndW = 0.0;
            for (i3 = 0; i3 < vddRes.length; ++i3) {
                boolean vddOK = false;
                boolean gndOK = false;
                if (vddRes[i3] > 0.0) {
                    vddOK = true;
                    if (maxVddRes < vddRes[i3]) {
                        maxVddRes = vddRes[i3];
                    }
                }
                if (gndRes[i3] > 0.0) {
                    gndOK = true;
                    if (maxGndRes < gndRes[i3]) {
                        maxGndRes = gndRes[i3];
                    }
                }
                if ((gndOK || vddOK) && maxSpacing < this.config.drcSpacingRule) {
                    maxSpacing = this.config.drcSpacingRule;
                }
                if (maxVddW < vddW[i3]) {
                    maxVddW = vddW[i3];
                }
                if (!(maxGndW < gndW[i3])) continue;
                maxGndW = gndW[i3];
            }
            for (i3 = 0; i3 < vddRes.length; ++i3) {
                vddRes[i3] = maxVddRes;
                gndRes[i3] = maxGndRes;
                spacing[i3] = maxSpacing;
                vddW[i3] = maxVddW;
                gndW[i3] = maxGndW;
            }
        }
        Floorplan[] thePlans = new Floorplan[numLayers];
        thePlans[1] = new CapFloorplan(w, h2, !evenHor);
        if (metalFlex) {
            if (!hierFlex) {
                for (int i4 = 2; i4 < numLayers; ++i4) {
                    boolean horiz = i4 % 2 == 0;
                    thePlans[i4] = new MetalFloorplanFlex(w, h2, vddRes[i4], gndRes[i4], spacing[i4], vddW[i4], gndW[i4], horiz);
                }
                return thePlans;
            }
            w = this.config.width = this.config.minTileSizeX;
            h2 = this.config.height = this.config.minTileSizeY;
        }
        for (int i5 = 2; i5 < numLayers; ++i5) {
            boolean horiz = i5 % 2 == 0;
            thePlans[i5] = new MetalFloorplan(w, h2, vddRes[i5], gndRes[i5], spacing[i5], horiz);
        }
        return thePlans;
    }

    private void printCoverage(Floorplan[] plans) {
        for (int i2 = 2; i2 < plans.length; ++i2) {
            System.out.println("metal-" + i2 + " coverage: " + ((MetalFloorplan)plans[i2]).coverage);
        }
    }

    private static CapCell getCMOS90CapCell(Library lib, CapFloorplan plan, EditingPreferences ep) {
        CapCell c2;
        block2: {
            c2 = null;
            try {
                Class<?> cmos90Class = Class.forName("com.sun.electric.plugins.tsmc.fill90nm.CapCellCMOS90");
                Constructor<?> capCellC = cmos90Class.getDeclaredConstructor(Library.class, CapFloorplan.class, EditingPreferences.class);
                Object cell = capCellC.newInstance(lib, plan, ep);
                c2 = (CapCell)cell;
            }
            catch (Exception e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return c2;
    }

    protected void initFillParameters(boolean metalFlex, boolean hierFlex, EditingPreferences ep) {
        if (this.libInitialized) {
            return;
        }
        Job.error(this.config.fillLibName == null, "no library specified. Use setFillLibrary()");
        Job.error(this.config.width == Double.NaN || this.config.width <= 0.0, "no width specified. Use setFillCellWidth()");
        Job.error(this.config.height == Double.NaN || this.config.height <= 0.0, "no height specified. Use setFillCellHeight()");
        this.plans = this.makeFloorplans(metalFlex, hierFlex);
        if (!metalFlex) {
            this.printCoverage(this.plans);
        }
        this.lib = LayoutLib.openLibForWrite(this.config.fillLibName);
        if (!metalFlex) {
            this.capCell = this.config.getTechType().getTechnology() == Technology.getCMOS90Technology() ? FillGeneratorTool.getCMOS90CapCell(this.lib, (CapFloorplan)this.plans[1], ep) : new CapCellMosis(this.lib, (CapFloorplan)this.plans[1], this.config.getTechType(), ep);
        }
        this.libInitialized = true;
    }

    private void makeTiledCells(Cell cell, Floorplan[] plans, Library lib, int[] tiledSizes, EditingPreferences ep) {
        if (tiledSizes == null) {
            return;
        }
        for (int num : tiledSizes) {
            TiledCell.makeTiledCell(num, num, cell, plans, lib, ep);
        }
    }

    public static Cell makeFillCell(Library lib, Floorplan[] plans, int botLayer, int topLayer, CapCell capCell, TechType tech, EditingPreferences ep, ExportConfig expCfg, boolean metalFlex, boolean hierFlex) {
        FillCell fc = new FillCell(tech, ep);
        return fc.makeFillCell1(lib, plans, botLayer, topLayer, capCell, expCfg, metalFlex, hierFlex);
    }

    private Cell standardMakeAndTileCell(Library lib, Floorplan[] plans, int lowLay, int hiLay, CapCell capCell, TechType tech, EditingPreferences ep, ExportConfig expCfg, int[] tiledSizes, boolean metalFlex) {
        Cell master = FillGeneratorTool.makeFillCell(lib, plans, lowLay, hiLay, capCell, tech, ep, expCfg, metalFlex, false);
        this.masters = new ArrayList<Cell>();
        this.masters.add(master);
        this.makeTiledCells(master, plans, lib, tiledSizes, ep);
        return master;
    }

    public Cell standardMakeFillCell(int loLayer, int hiLayer, TechType tech, EditingPreferences ep, ExportConfig exportConfig, int[] tiledSizes, boolean metalFlex) {
        this.initFillParameters(metalFlex, false, ep);
        Job.error(loLayer < 1, "loLayer must be >=1");
        int maxNumMetals = this.config.getTechType().getNumMetals();
        Job.error(hiLayer > maxNumMetals, "hiLayer must be <=" + maxNumMetals);
        Job.error(loLayer > hiLayer, "loLayer must be <= hiLayer");
        Cell cell = null;
        cell = this.standardMakeAndTileCell(this.lib, this.plans, loLayer, hiLayer, this.capCell, tech, ep, exportConfig, tiledSizes, metalFlex);
        return cell;
    }

    public void makeGallery(EditingPreferences ep) {
        Gallery.makeGallery(this.lib, ep);
    }

    public void writeLibrary(int backupScheme) throws JobException {
        LayoutLib.writeLibrary(this.lib, backupScheme);
    }

    public static enum Units {
        NONE,
        LAMBDA,
        TRACKS;

    }

    public static enum FillTypeEnum {
        INVALID,
        TEMPLATE,
        CELL;

    }
}

