/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;

class ViaStack {
    private PortInst port1;
    private PortInst port2;
    private final TechType tech;
    private final EditingPreferences ep;

    private void swap() {
        PortInst tp = this.port1;
        this.port1 = this.port2;
        this.port2 = tp;
    }

    private void buildStack(int hLo, int hHi, double x, double y, double width, double height, Cell f2) {
        PortInst viaBelow = null;
        for (int h2 = hLo; h2 < hHi; ++h2) {
            PrimitiveNode via = this.tech.viaAbove(h2);
            double wid = Math.max(width, LayoutLib.getNodeProtoWidth(via, this.ep));
            double hei = Math.max(height, LayoutLib.getNodeProtoHeight(via, this.ep));
            PortInst viaAbove = LayoutLib.newNodeInst(via, this.ep, x, y, wid, hei, 0.0, f2).getOnlyPortInst();
            if (viaBelow == null) {
                this.port1 = viaAbove;
            } else {
                LayoutLib.newArcInst(this.tech.layerAtHeight(h2), this.ep, 1.0, viaBelow, viaAbove);
            }
            this.port2 = viaAbove;
            viaBelow = viaAbove;
        }
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x, double y, double width, TechType tech, EditingPreferences ep, Cell f2) {
        this(arc1, arc2, x, y, width, width, tech, ep, f2);
    }

    public ViaStack(ArcProto arc1, ArcProto arc2, double x, double y, double width, double height, TechType tech, EditingPreferences ep, Cell f2) {
        this.tech = tech;
        this.ep = ep;
        int h1 = tech.layerHeight(arc1);
        int h2 = tech.layerHeight(arc2);
        int deltaZ = h2 - h1;
        if (arc1 == arc2) {
            PrimitiveNode pin = arc1.findOverridablePinProto(ep);
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, ep, x, y, defSz, defSz, 0.0, f2);
            this.port1 = this.port2 = pinInst.getOnlyPortInst();
        } else if (deltaZ > 0) {
            this.buildStack(h1, h2, x, y, width, height, f2);
        } else {
            this.buildStack(h2, h1, x, y, width, height, f2);
            this.swap();
        }
    }

    public PortInst getPort1() {
        return this.port1;
    }

    public PortInst getPort2() {
        return this.port2;
    }

    public double getCenterX() {
        return this.port1.getCenter().getX();
    }

    public double getCenterY() {
        return this.port1.getCenter().getY();
    }
}

