/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.ViaStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class TrackRouter {
    private double shareableViaDist = 6.0;
    private List<ViaStack> vias = new ArrayList<ViaStack>();
    private int lastPos = 0;
    Cell parent;
    PortInst curPort;
    ArcProto layer;
    double width = 0.0;
    Double center = null;
    PortInst prevElbow;
    boolean endsExtend;
    final TechType tech;
    final EditingPreferences ep;

    static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private double getXY(ViaStack via) {
        return this instanceof TrackRouterH ? via.getCenterX() : via.getCenterY();
    }

    private void removeExistingArc(ViaStack prev, ViaStack next) {
        if (prev == null || next == null) {
            return;
        }
        PortInst prevPort = prev.getPort1();
        PortInst nextPort = next.getPort1();
        Iterator<ArcInst> it = LayoutLib.getArcInstsOnPortInst(prevPort);
        while (it.hasNext()) {
            ArcInst ai = it.next();
            PortInst end0 = ai.getHeadPortInst();
            PortInst end1 = ai.getTailPortInst();
            if (end0 != nextPort && end1 != nextPort) continue;
            ai.kill();
        }
    }

    private void addArc(ViaStack v1, ViaStack v2) {
        PortInst p1 = v1.getPort1();
        PortInst p2 = v2.getPort1();
        ArcInst ai = LayoutLib.newArcInst(this.layer, this.ep, this.width, p1, p2);
        ai.setHeadExtended(this.endsExtend);
        ai.setTailExtended(this.endsExtend);
    }

    private void addArcs(ViaStack prev, ViaStack via, ViaStack next) {
        if (prev != null) {
            this.addArc(prev, via);
        }
        if (next != null) {
            this.addArc(via, next);
        }
    }

    void insertVia(ViaStack via) {
        if (this.vias.isEmpty()) {
            this.vias.add(via);
            return;
        }
        double myXY = this.getXY(via);
        while (this.lastPos > 0 && this.getXY(this.vias.get(this.lastPos - 1)) > myXY) {
            --this.lastPos;
        }
        while (this.lastPos < this.vias.size() && this.getXY(this.vias.get(this.lastPos)) < myXY) {
            ++this.lastPos;
        }
        this.vias.add(this.lastPos, via);
        ViaStack prev = this.lastPos == 0 ? null : this.vias.get(this.lastPos - 1);
        ViaStack next = this.lastPos == this.vias.size() - 1 ? null : this.vias.get(this.lastPos + 1);
        this.removeExistingArc(prev, next);
        this.addArcs(prev, via, next);
    }

    ViaStack findSharableVia(double position, ArcProto lay) {
        PortInst pi;
        ViaStack v;
        double dist;
        int i2;
        if (this.vias.isEmpty()) {
            return null;
        }
        int closest = -1;
        double closestDist = Double.MAX_VALUE;
        for (i2 = this.lastPos; i2 >= 0 && !((dist = Math.abs(this.getXY(v = this.vias.get(i2)) - position)) > closestDist); --i2) {
            if (dist > this.shareableViaDist || !(pi = v.getPort2()).getPortProto().connectsTo(lay) || !(dist < closestDist)) continue;
            closest = i2;
            closestDist = dist;
        }
        for (i2 = this.lastPos + 1; i2 < this.vias.size() && !((dist = Math.abs(this.getXY(v = this.vias.get(i2)) - position)) > closestDist); ++i2) {
            if (dist > this.shareableViaDist || !(pi = v.getPort2()).getPortProto().connectsTo(lay) || !(dist < closestDist)) continue;
            closest = i2;
            closestDist = dist;
        }
        if (closestDist == Double.MAX_VALUE) {
            return null;
        }
        this.lastPos = closest;
        return this.vias.get(closest);
    }

    public TrackRouter(ArcProto lay, double wid, TechType tech, EditingPreferences ep, Cell parnt) {
        this.parent = parnt;
        this.layer = lay;
        this.width = wid;
        this.endsExtend = true;
        this.tech = tech;
        this.ep = ep;
    }

    public TrackRouter(ArcProto lay, double wid, double centerVal, TechType tech, EditingPreferences ep, Cell parnt) {
        this.parent = parnt;
        this.layer = lay;
        this.width = wid;
        this.center = centerVal;
        this.endsExtend = true;
        this.tech = tech;
        this.ep = ep;
    }

    public void setEndsExtend(boolean b2) {
        this.endsExtend = b2;
    }

    public boolean getEndsExtend() {
        return this.endsExtend;
    }

    public void connect(ArrayList<NodeInst> nodeInsts, String portNm) {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        for (int i2 = 0; i2 < nodeInsts.size(); ++i2) {
            PortInst p = nodeInsts.get(i2).findPortInst(portNm);
            if (p == null) continue;
            ports.add(p);
        }
        this.connect(ports);
    }

    public void connect(NodeInst[] nodeInsts, String portNm) {
        ArrayList<NodeInst> a2 = new ArrayList<NodeInst>();
        for (int i2 = 0; i2 < nodeInsts.length; ++i2) {
            a2.add(nodeInsts[i2]);
        }
        this.connect(a2, portNm);
    }

    public void connect(ArrayList<PortInst> ports) {
        for (int i2 = 0; i2 < ports.size(); ++i2) {
            this.connect(ports.get(i2));
        }
    }

    public void connect(PortInst[] ports) {
        ArrayList<PortInst> p = new ArrayList<PortInst>();
        for (int i2 = 0; i2 < ports.length; ++i2) {
            p.add(ports[i2]);
        }
        this.connect(p);
    }

    public void connect(PortInst newPort) {
        this.connect(newPort, 0.0);
    }

    public void connect(Export export) {
        this.connect(export.getOriginalPort(), 0.0);
    }

    public void connect(PortInst newPort, double viaOffset) {
        this.connect(newPort, viaOffset, 0.0);
    }

    public abstract void connect(PortInst var1, double var2, double var4);

    public void setShareableViaDist(double d2) {
        this.shareableViaDist = d2;
    }
}

