/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.WellTie;
import java.util.ArrayList;

class Placer {
    private static final boolean VERBOSE = false;
    public static final int P = 0;
    public static final int N = 1;
    public static final int PN = 2;
    private StdCellParams stdCell;
    private Cell part;
    private double rowHeight;
    private ArrayList<Inst> buildInsts = new ArrayList();
    private ArrayList<Net> buildNets = new ArrayList();

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private static void updateElectric(ArrayList<Inst> insts, double rowHeight) {
        for (int i2 = 0; i2 < insts.size(); ++i2) {
            insts.get(i2).updateElectric(rowHeight);
        }
    }

    private static void abutLeftRight(double leftX, ArrayList<Inst> insts) {
        double pX = leftX;
        double nX = leftX;
        for (int i2 = 0; i2 < insts.size(); ++i2) {
            Inst inst = insts.get(i2);
            if (inst.isN()) {
                inst.moveTo(nX, 0);
                nX += inst.getWidth();
                continue;
            }
            if (inst.isP()) {
                inst.moveTo(pX, 0);
                pX += inst.getWidth();
                continue;
            }
            double x = Math.max(nX, pX);
            inst.moveTo(x, 0);
            pX = nX = x + inst.getWidth();
        }
    }

    private static double getCostX(ArrayList<Net> nets) {
        double cost = 0.0;
        for (int i2 = 0; i2 < nets.size(); ++i2) {
            cost += nets.get(i2).getCostX();
        }
        return cost;
    }

    private static double getPlacedCostX(ArrayList<Net> nets, double maxX) {
        double cost = 0.0;
        for (int i2 = 0; i2 < nets.size(); ++i2) {
            cost += nets.get(i2).getPlacedCostX(maxX);
        }
        return cost;
    }

    private static boolean forEachPermutation1(int depth, boolean[] mask, int[] permutation, PermutationAction action) {
        int sz = mask.length;
        if (depth > sz - 1) {
            return action.usePermutation(permutation);
        }
        for (int i2 = 0; i2 < sz; ++i2) {
            if (mask[i2]) continue;
            permutation[depth] = i2;
            mask[i2] = true;
            if (!action.prunePermutation(permutation, mask, depth) && Placer.forEachPermutation1(depth + 1, mask, permutation, action)) {
                return true;
            }
            mask[i2] = false;
        }
        return false;
    }

    private static void forEachPermutation(int nb, PermutationAction action) {
        Placer.error(nb == 0, "permutations of nothing?");
        int[] permutation = new int[nb];
        boolean[] mask = new boolean[nb];
        for (int i2 = 0; i2 < nb; ++i2) {
            mask[i2] = false;
        }
        Placer.forEachPermutation1(0, mask, permutation, action);
    }

    private static long factorial(int i2) {
        if (i2 == 0) {
            return 0L;
        }
        if (i2 == 1) {
            return 1L;
        }
        return (long)i2 * Placer.factorial(i2 - 1);
    }

    private static ArrayList<Inst> exhaustive(ArrayList<Inst> insts, ArrayList<Net> nets, double leftX, int maxPerms) {
        PermChecker checker = new PermChecker(insts, nets, leftX, maxPerms);
        int nbGates = insts.size();
        if (nbGates == 0) {
            return new ArrayList<Inst>();
        }
        Placer.forEachPermutation(nbGates, checker);
        return checker.getBestPermutation();
    }

    private static ArrayList<Inst> insertWellTies(ArrayList<Inst> insts, StdCellParams stdCell, Cell part) {
        EditingPreferences ep = stdCell.getEditingPreferences();
        insts = (ArrayList)insts.clone();
        Inst dummy = new Inst(2, 0.0, null);
        insts.add(dummy);
        Cell pTie = WellTie.makePart(false, true, 0.0, stdCell);
        Cell nTie = WellTie.makePart(true, false, 0.0, stdCell);
        double tieWid = pTie.getBounds().getWidth();
        double tieEdgeToContDist = WellTie.edgeToContDist();
        double pX = 0.0;
        double nX = 0.0;
        double maxDist = stdCell.getWellTiePitch();
        double pSp = maxDist / 2.0;
        double nSp = maxDist / 2.0;
        for (int i2 = 0; i2 < insts.size(); ++i2) {
            NodeInst ni;
            Cell patch;
            double testDist;
            Inst inst = (Inst)insts.get(i2);
            double instWid = inst.getWidth();
            if (instWid > maxDist) {
                System.out.println("The gate: " + inst.getNodeInst().getProto().getName() + " is larger than the well tap spacing!!!");
            }
            boolean nAbuts = nX >= pX;
            double d2 = testDist = inst == dummy ? maxDist / 2.0 : maxDist;
            if (inst.isN() || inst.isPN() && nAbuts) {
                if (nSp + instWid > testDist && nSp != 0.0) {
                    NodeInst ni2 = LayoutLib.newNodeInst(nTie, ep, 0.0, 0.0, 0.0, 0.0, 0.0, part);
                    insts.add(i2, new Inst(1, tieWid, ni2));
                    nX += tieWid;
                    nSp = 0.0;
                    continue;
                }
                if (inst.isPN()) {
                    double gap = nX - pX;
                    if (gap > 0.0) {
                        patch = WellTie.makePart(false, true, gap, stdCell);
                        ni = LayoutLib.newNodeInst(patch, ep, 0.0, 0.0, 0.0, 0.0, 0.0, part);
                        insts.add(i2, new Inst(0, gap, ni));
                        ++i2;
                        pSp = gap >= tieWid ? tieEdgeToContDist : pSp + gap;
                    }
                    pX = nX += instWid;
                    nSp += instWid;
                    pSp += instWid;
                    continue;
                }
                nX += instWid;
                nSp += instWid;
                continue;
            }
            if (!inst.isP() && (!inst.isPN() || nAbuts)) continue;
            if (pSp + instWid > testDist && pSp != 0.0) {
                NodeInst ni3 = LayoutLib.newNodeInst(pTie, ep, 0.0, 0.0, 0.0, 0.0, 0.0, part);
                insts.add(i2, new Inst(0, tieWid, ni3));
                pX += tieWid;
                pSp = 0.0;
                continue;
            }
            if (inst.isPN()) {
                double gap = pX - nX;
                if (gap > 0.0) {
                    patch = WellTie.makePart(true, false, gap, stdCell);
                    ni = LayoutLib.newNodeInst(patch, ep, 0.0, 0.0, 0.0, 0.0, 0.0, part);
                    insts.add(i2, new Inst(1, gap, ni));
                    ++i2;
                    nSp = gap >= tieWid ? tieEdgeToContDist : nSp + gap;
                }
                pX = nX = pX + instWid;
                pSp += instWid;
                nSp += instWid;
                continue;
            }
            pX += instWid;
            pSp += instWid;
        }
        insts.remove(dummy);
        return insts;
    }

    private static ArrayList<Inst> threeRegionPlace(ArrayList<Inst> insts, ArrayList<Net> nets, int maxPerms) {
        ArrayList<Inst> nInsts = new ArrayList<Inst>();
        ArrayList<Inst> pInsts = new ArrayList<Inst>();
        ArrayList<Inst> pnInsts = new ArrayList<Inst>();
        for (int i2 = 0; i2 < insts.size(); ++i2) {
            Inst inst = insts.get(i2);
            if (inst.isN()) {
                nInsts.add(inst);
                continue;
            }
            if (inst.isP()) {
                pInsts.add(inst);
                continue;
            }
            pnInsts.add(inst);
        }
        ArrayList<Inst> allInsts = new ArrayList<Inst>(pnInsts);
        allInsts.addAll(nInsts);
        allInsts.addAll(pInsts);
        Placer.abutLeftRight(0.0, allInsts);
        Inst lastFull = (Inst)pnInsts.get(pnInsts.size() - 1);
        double rightFullX = lastFull.getX() + lastFull.getWidth();
        ArrayList<Inst> ans = new ArrayList<Inst>(Placer.exhaustive(pnInsts, nets, 0.0, maxPerms));
        ans.addAll(Placer.exhaustive(nInsts, nets, rightFullX, maxPerms));
        ans.addAll(Placer.exhaustive(pInsts, nets, rightFullX, maxPerms));
        return ans;
    }

    public Placer(StdCellParams stdCell, Cell part) {
        this.stdCell = stdCell;
        this.part = part;
        this.rowHeight = stdCell.getNmosWellHeight() + stdCell.getPmosWellHeight();
    }

    public Inst addInst(int type, double w, NodeInst nodeInst) {
        Inst inst = new Inst(type, w, nodeInst);
        this.buildInsts.add(inst);
        return inst;
    }

    public Net addNet() {
        Net net = new Net();
        this.buildNets.add(net);
        return net;
    }

    public ArrayList<NodeInst> place1row() {
        int maxPerms = this.stdCell.getNbPlacerPerms();
        ArrayList<Inst> insts = Placer.threeRegionPlace(this.buildInsts, this.buildNets, maxPerms);
        Placer.abutLeftRight(0.0, insts);
        double threeRegCost = Placer.getCostX(this.buildNets);
        if (this.stdCell.getExhaustivePlace()) {
            insts = Placer.exhaustive(insts, this.buildNets, 0.0, this.stdCell.getNbPlacerPerms());
            Placer.abutLeftRight(0.0, insts);
            double exhCost = Placer.getCostX(this.buildNets);
            double d2 = Math.rint(1000.0 * (threeRegCost - exhCost) / threeRegCost) / 10.0;
        }
        insts = Placer.insertWellTies(insts, this.stdCell, this.part);
        Placer.abutLeftRight(0.0, insts);
        Placer.updateElectric(insts, this.rowHeight);
        Inst rightInst = insts.get(insts.size() - 1);
        this.stdCell.addEssentialBounds(0.0, rightInst.getMaxX(), this.part);
        ArrayList<NodeInst> nodeInsts = new ArrayList<NodeInst>();
        for (int i2 = 0; i2 < insts.size(); ++i2) {
            nodeInsts.add(insts.get(i2).getNodeInst());
        }
        return nodeInsts;
    }

    public ArrayList place2row() {
        return new ArrayList();
    }

    public static class Inst {
        double x;
        int row;
        double w;
        boolean mirrorX;
        boolean mirrorY;
        int type;
        NodeInst nodeInst;
        ArrayList<Port> ports = new ArrayList();

        Inst(int type, double width, NodeInst nodeInst) {
            Placer.error(type != 0 && type != 1 && type != 2, "Placer.Inst: bad type: " + type);
            this.type = type;
            this.w = width;
            this.nodeInst = nodeInst;
        }

        int nbPorts() {
            return this.ports.size();
        }

        Port getPort(int i2) {
            return this.ports.get(i2);
        }

        public Port addPort(double ofstX, double ofstY) {
            Port p = new Port(this, ofstX, ofstY);
            this.ports.add(p);
            return p;
        }

        void moveTo(double x, int row) {
            this.x = x;
            this.row = row;
        }

        double getX() {
            return this.x;
        }

        double getMaxX() {
            return this.x + this.w;
        }

        int getRow() {
            return this.row;
        }

        void setMirrorX(boolean mirror) {
            this.mirrorX = mirror;
        }

        boolean getMirrorX() {
            return this.mirrorX;
        }

        void setMirrorY(boolean mirror) {
            this.mirrorY = mirror;
        }

        boolean getMirrorY() {
            return this.mirrorY;
        }

        boolean isN() {
            return this.type == 1;
        }

        boolean isP() {
            return this.type == 0;
        }

        boolean isPN() {
            return this.type == 2;
        }

        double getWidth() {
            return this.w;
        }

        NodeInst getNodeInst() {
            return this.nodeInst;
        }

        void updateElectric(double rowHeight) {
            LayoutLib.modNodeInst(this.nodeInst, this.x, (double)this.row * rowHeight, 0.0, 0.0, false, false, 0.0);
        }
    }

    public static class Net {
        ArrayList<Port> ports = new ArrayList();

        int nbPorts() {
            return this.ports.size();
        }

        Port getPort(int i2) {
            return this.ports.get(i2);
        }

        public void addPort(Port port) {
            this.ports.add(port);
        }

        double getCostX() {
            if (this.nbPorts() == 0) {
                return 0.0;
            }
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            for (int i2 = 0; i2 < this.ports.size(); ++i2) {
                double x = this.getPort(i2).getX();
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            return maxX - minX;
        }

        double getPlacedCostX(double unplacedX) {
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            for (int i2 = 0; i2 < this.ports.size(); ++i2) {
                double x = this.getPort(i2).getX();
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            maxX = Math.min(maxX, unplacedX);
            minX = Math.min(minX, unplacedX);
            return maxX - minX;
        }

        double getCost2row() {
            int i2;
            int nbRows = 2;
            double[] minX = new double[2];
            double[] maxX = new double[2];
            for (i2 = 0; i2 < 2; ++i2) {
                minX[i2] = Double.MAX_VALUE;
                maxX[i2] = Double.MIN_VALUE;
            }
            for (i2 = 0; i2 < this.ports.size(); ++i2) {
                Port port = this.getPort(i2);
                double x = port.getX();
                int r = port.getRow();
                minX[r] = Math.min(minX[r], x);
                maxX[r] = Math.max(maxX[r], x);
            }
            double cost = 0.0;
            for (int i3 = 0; i3 < 2; ++i3) {
                if (minX[i3] == Double.MAX_VALUE) continue;
                cost += maxX[i3] - minX[i3];
            }
            return cost;
        }
    }

    static interface PermutationAction {
        public boolean usePermutation(int[] var1);

        public boolean prunePermutation(int[] var1, boolean[] var2, int var3);
    }

    private static class PermChecker
    implements PermutationAction {
        int[] bestPermutation = null;
        double bestCost = Double.MAX_VALUE;
        ArrayList<Inst> insts;
        ArrayList<Net> nets;
        double leftX;
        ArrayList<Inst> permInsts = new ArrayList();
        long nbChecked;
        long maxPerms;

        private void abutLeftRight(int[] permutation) {
            for (int i2 = 0; i2 < permutation.length; ++i2) {
                this.permInsts.set(i2, this.insts.get(permutation[i2]));
            }
            Placer.abutLeftRight(this.leftX, this.permInsts);
        }

        @Override
        public boolean usePermutation(int[] permutation) {
            Placer.error(permutation.length != this.insts.size(), "wrong permutation size");
            this.abutLeftRight(permutation);
            double cost = Placer.getCostX(this.nets);
            if (cost < this.bestCost) {
                this.bestCost = cost;
                this.bestPermutation = (int[])permutation.clone();
            }
            ++this.nbChecked;
            return this.nbChecked >= this.maxPerms;
        }

        private double abutLeftRight(int[] permutation, boolean[] placed, int depth) {
            Inst inst;
            int i2;
            double pX = this.leftX;
            double nX = this.leftX;
            for (i2 = 0; i2 <= depth; ++i2) {
                inst = this.insts.get(permutation[i2]);
                if (inst.isN()) {
                    inst.moveTo(nX, 0);
                    nX += inst.getWidth();
                    continue;
                }
                if (inst.isP()) {
                    inst.moveTo(pX, 0);
                    pX += inst.getWidth();
                    continue;
                }
                double x = Math.max(nX, pX);
                inst.moveTo(x, 0);
                pX = nX = x + inst.getWidth();
            }
            if (pX != nX) {
                return -1.0;
            }
            for (i2 = 0; i2 < placed.length; ++i2) {
                if (placed[i2]) continue;
                inst = this.insts.get(i2);
                inst.moveTo(nX, 0);
            }
            return nX;
        }

        @Override
        public boolean prunePermutation(int[] permutation, boolean[] placed, int depth) {
            int nbUnplaced = placed.length - (depth + 1);
            if (nbUnplaced <= 2) {
                return false;
            }
            double maxX = this.abutLeftRight(permutation, placed, depth);
            if (maxX == -1.0) {
                return false;
            }
            double cost = Placer.getPlacedCostX(this.nets, maxX);
            boolean prune = cost >= this.bestCost;
            return prune;
        }

        private ArrayList<Inst> getBestPermutation() {
            ArrayList<Inst> best = new ArrayList<Inst>();
            for (int i2 = 0; i2 < this.bestPermutation.length; ++i2) {
                best.add(this.insts.get(this.bestPermutation[i2]));
            }
            return best;
        }

        PermChecker(ArrayList<Inst> insts, ArrayList<Net> nets, double leftX, int maxPerms) {
            this.insts = insts;
            this.nets = nets;
            this.leftX = leftX;
            this.maxPerms = maxPerms;
            this.nbChecked = 0L;
            for (int i2 = 0; i2 < insts.size(); ++i2) {
                this.permInsts.add(null);
            }
        }
    }

    public static class Port {
        Inst inst;
        double ofstX;
        double ofstY;

        Port(Inst inst, double ofstX, double ofstY) {
            this.inst = inst;
            this.ofstX = ofstX;
            this.ofstY = ofstY;
        }

        double getX() {
            double offset = this.inst.getMirrorX() ? this.inst.getWidth() - this.ofstX : this.ofstX;
            return this.inst.getX() + offset;
        }

        int getRow() {
            return this.inst.getRow();
        }

        Inst getInst() {
            return this.inst;
        }
    }
}

