/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import java.lang.reflect.Method;

public class GateRegression
extends Job {
    private Technology technology;
    private int backupScheme;
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        @Override
        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    private static void allSizes(StdCellParams stdCell, Technology technology) {
        double minSz = 0.1;
        double maxSz = 200.0;
        for (double d2 = minSz; d2 < maxSz; d2 *= 10.0) {
            for (double x = d2; x < Math.min(d2 * 10.0, maxSz); x *= 1.01) {
                GateRegression.aPass(x, stdCell, technology);
            }
        }
    }

    public static void aPass(double x, StdCellParams stdCell, Technology technology) {
        Technology cmos90 = Technology.getCMOS90Technology();
        if (cmos90 != null && technology == cmos90) {
            try {
                Class<?> cmos90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc.gates90nm.CMOS90Generator");
                Class[] parameterTypes = new Class[]{Double.class, StdCellParams.class};
                Method generateMethod = cmos90GeneratorClass.getDeclaredMethod("generateAllGates", parameterTypes);
                generateMethod.invoke(null, x, stdCell);
            }
            catch (Exception e2) {
                System.out.println("ERROR invoking the CMOS90 gate generator");
            }
        } else {
            MoCMOSGenerator.generateAllGates(x, stdCell);
        }
    }

    @Override
    public boolean doIt() throws JobException {
        Library scratchLib = LayoutLib.openLibForWrite("scratch" + this.technology.getTechName());
        GateRegression.runRegression(this.technology, scratchLib, this.backupScheme, this.getEditingPreferences());
        return true;
    }

    public static int runRegression(Technology technology, Library scratchLib, int backupScheme, EditingPreferences ep) throws JobException {
        StdCellParams stdCell;
        System.out.println("begin Gate Regression");
        Technology cmos90 = Technology.getCMOS90Technology();
        if (cmos90 != null && technology == cmos90) {
            stdCell = new StdCellParams(technology, ep);
            stdCell.setOutputLibrary(scratchLib);
            stdCell.enableNCC("purpleFour");
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setMaxMosWidth(1000.0);
        } else {
            stdCell = GateLayoutGenerator.dividerParams(technology, ep);
            stdCell.setOutputLibrary(scratchLib);
            stdCell.setSizeQuantizationError(0.05);
            stdCell.setSimpleName(false);
        }
        GateRegression.allSizes(stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() - 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() + 7.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setGndY(stdCell.getGndY() + 7.0);
        stdCell.setNmosWellHeight(stdCell.getNmosWellHeight() - 7.0);
        stdCell.setNmosWellHeight(50.0);
        stdCell.setPmosWellHeight(100.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(100.0);
        stdCell.setPmosWellHeight(50.0);
        GateRegression.aPass(10.0, stdCell, technology);
        GateRegression.aPass(200.0, stdCell, technology);
        stdCell.setNmosWellHeight(70.0);
        stdCell.setPmosWellHeight(70.0);
        Cell gallery = Gallery.makeGallery(scratchLib, ep);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        LayoutLib.writeLibrary(scratchLib, backupScheme);
        System.out.println("done.");
        return 0;
    }

    public GateRegression(Technology techNm) {
        super("Run Gate regression", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.technology = techNm;
        this.backupScheme = IOTool.getBackupRedundancy();
        this.startJob();
    }
}

