/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Channel;
import java.util.Collection;
import java.util.TreeSet;

public class LayerChannels {
    private TreeSet<Channel> channels = new TreeSet();

    private static void prln(String msg) {
        Utils.prln(msg);
    }

    private boolean isHorizontal() {
        Job.error(this.channels.size() == 0, "can't tell direction because no channels");
        return this.channels.first().isHorizontal();
    }

    public void add(Channel ch) {
        if (ch.hasTracks()) {
            this.channels.add(ch);
        }
    }

    public Collection<Channel> getChannels() {
        return this.channels;
    }

    public Channel findChanOverVertInterval(double x, double y1, double y2) {
        double yMin = Math.min(y1, y2);
        double yMax = Math.max(y1, y2);
        if (this.channels.size() == 0) {
            return null;
        }
        Job.error(!this.isHorizontal(), "not sure what this means yet");
        for (Channel c2 : this.channels) {
            Job.error(x < c2.getMinTrackEnd() || x > c2.getMaxTrackEnd(), "channels can't cover X");
            if (c2.getMaxTrackCenter() < yMin) continue;
            if (c2.getMinTrackCenter() > yMax) break;
            return c2;
        }
        return null;
    }

    public Channel findVertBridge(Channel horChan1, Channel horChan2, double x1, double x2) {
        if (this.channels.size() == 0) {
            return null;
        }
        Job.error(this.isHorizontal(), "layer must be vertical");
        double yMin = Math.min(horChan1.getMinTrackCenter(), horChan2.getMinTrackCenter());
        double yMax = Math.max(horChan1.getMaxTrackCenter(), horChan2.getMaxTrackCenter());
        double xMin = Math.min(x1, x2);
        double xMax = Math.max(x1, x2);
        double maxOverlap = -1.7976931348623157E308;
        Channel bestChan = null;
        for (Channel c2 : this.channels) {
            if (yMax > c2.getMaxTrackEnd() || yMin < c2.getMinTrackEnd()) {
                LayerChannels.prln("channels can't cover Y");
            }
            double startX = Math.max(xMin, c2.getMinTrackCenter());
            double endX = Math.min(xMax, c2.getMaxTrackCenter());
            double overlap = endX - startX;
            if (!(overlap > maxOverlap)) continue;
            maxOverlap = overlap;
            bestChan = c2;
        }
        return bestChan;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Channel c2 : this.channels) {
            sb.append(c2.toString());
        }
        return sb.toString();
    }

    public int numChannels() {
        return this.channels.size();
    }
}

