/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.hornFunnel2;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.hornFunnel2.BinaryTree;
import com.sun.electric.tool.generator.flag.hornFunnel2.Node;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.List;

public class SkewTree {
    private static final String OUT_LIB_NM = "treePictures";
    private int pass = 1;
    private final EditingPreferences ep;

    static void pr(String s) {
        System.out.print(s);
    }

    static void prln(String s) {
        System.out.println(s);
    }

    private void drawTree(Library outLib, BinaryTree tree, int pass) {
        Cell c2 = Cell.newInst(outLib, "skewTree" + tree.getHeight() + "pass" + pass + "{sch}");
        SkewTree.prln("");
        SkewTree.prln("Skewed tree height " + tree.getHeight() + " pass " + pass);
        tree.draw(c2);
    }

    private void printNodesToMove(List<Node> nodes, int h2) {
        SkewTree.prln("Nodes to move at height " + h2);
        for (Node n2 : nodes) {
            SkewTree.prln("  " + n2.toString());
        }
    }

    private void makeSpaceLeft(BinaryTree tree, int dstSlot, int moveableHeight) {
        Node n2 = tree.getNodeInSlot(dstSlot);
        Job.error(n2.getHeight() > moveableHeight, "can't make space because destintation is locked: " + n2.toString());
        for (int i2 = dstSlot; i2 >= 0; --i2) {
            Node hole = tree.getNodeInSlot(i2);
            if (hole.getHeight() >= moveableHeight) continue;
            tree.moveTo(hole, dstSlot, moveableHeight);
            return;
        }
        Job.error(true, "can't find a node with height < moveableHeight");
    }

    private void makeSpaceRight(BinaryTree tree, int dstSlot, int moveableHeight) {
        Node n2 = tree.getNodeInSlot(dstSlot);
        Job.error(n2.getHeight() > moveableHeight, "can't make space because destintation is locked: " + n2.toString());
        for (int i2 = dstSlot; i2 < tree.getNumSlots(); ++i2) {
            Node hole = tree.getNodeInSlot(i2);
            if (hole.getHeight() >= moveableHeight) continue;
            tree.moveTo(hole, dstSlot, moveableHeight);
            return;
        }
        Job.error(true, "can't find a node with height < moveableHeight");
    }

    private void moveNodesLeft(BinaryTree tree, List<Node> nodes, int dstSlot, int moveableHeight) {
        for (Node n2 : nodes) {
            this.makeSpaceLeft(tree, dstSlot, moveableHeight);
            tree.moveTo(n2, dstSlot, moveableHeight);
        }
    }

    private void moveNodesRight(BinaryTree tree, List<Node> nodes, int dstSlot, int moveableHeight) {
        for (Node n2 : nodes) {
            this.makeSpaceRight(tree, dstSlot, moveableHeight);
            tree.moveTo(n2, dstSlot, moveableHeight);
        }
    }

    private boolean isChildOf(Node child, Node subTree) {
        for (Node n2 = child; n2 != null; n2 = n2.getParent()) {
            if (n2 != subTree) continue;
            return true;
        }
        return false;
    }

    private List<Node> findNodesToMoveLeft(BinaryTree tree, int nodeHeight, int dstSlot, Node subTree) {
        ArrayList<Node> toMove = new ArrayList<Node>();
        for (int i2 = 0; i2 < tree.getNumSlots(); ++i2) {
            Node n2 = tree.getNodeInSlot(i2);
            if (n2.getHeight() != nodeHeight || n2.getSlot() <= dstSlot || !this.isChildOf(n2, subTree)) continue;
            toMove.add(n2);
        }
        return toMove;
    }

    private List<Node> findNodesToMoveRight(BinaryTree tree, int nodeHeight, int dstSlot, Node subTree) {
        ArrayList<Node> toMove = new ArrayList<Node>();
        for (int i2 = 0; i2 < tree.getNumSlots(); ++i2) {
            Node n2 = tree.getNodeInSlot(i2);
            if (n2.getHeight() != nodeHeight || n2.getSlot() >= dstSlot || !this.isChildOf(n2, subTree)) continue;
            toMove.add(n2);
        }
        return toMove;
    }

    private void shiftBoundaryNodesLeft(BinaryTree tree, Node subTree, int subTreeParentSlot, int firstSegLen, int restSegLen, Library outLib) {
        int height;
        for (int h2 = height = subTree.getHeight(); h2 >= 2; --h2) {
            int dstSlot = subTreeParentSlot + firstSegLen + restSegLen * (height - h2);
            List<Node> mustMove = this.findNodesToMoveLeft(tree, h2, dstSlot, subTree);
            this.printNodesToMove(mustMove, h2);
            if (mustMove.isEmpty()) continue;
            this.moveNodesLeft(tree, mustMove, dstSlot, h2);
            this.drawTree(outLib, tree, this.pass++);
        }
    }

    private void shiftBoundaryNodesRight(BinaryTree tree, Node subTree, int subTreeParentSlot, int firstSegLen, int restSegLen, Library outLib) {
        int height;
        for (int h2 = height = subTree.getHeight(); h2 >= 2; --h2) {
            int dstSlot = subTreeParentSlot - firstSegLen - restSegLen * (height - h2);
            List<Node> mustMove = this.findNodesToMoveRight(tree, h2, dstSlot, subTree);
            this.printNodesToMove(mustMove, h2);
            if (mustMove.isEmpty()) continue;
            this.moveNodesRight(tree, mustMove, dstSlot, h2);
            this.drawTree(outLib, tree, this.pass++);
        }
    }

    private void optimizeSubTree(BinaryTree tree, Node subTree, int segLen, Library outLib) {
        SkewTree.prln("Optimize subTree: " + subTree.toString());
        Node leftChild = subTree.getLeftChild();
        Node rightChild = subTree.getRightChild();
        int subTreeSlot = subTree.getSlot();
        int leftChildSlot = leftChild.getSlot();
        int rightChildSlot = rightChild.getSlot();
        if (subTreeSlot < leftChildSlot) {
            this.shiftBoundaryNodesLeft(tree, rightChild, subTreeSlot, segLen, segLen, outLib);
        } else if (subTreeSlot > rightChildSlot) {
            this.shiftBoundaryNodesRight(tree, leftChild, subTreeSlot, segLen, segLen, outLib);
        } else {
            int leftSegLen = segLen / 2;
            int rightSegLen = segLen / 2 + segLen % 2;
            this.shiftBoundaryNodesLeft(tree, rightChild, subTreeSlot, rightSegLen, segLen, outLib);
            this.shiftBoundaryNodesRight(tree, leftChild, subTreeSlot, leftSegLen, segLen, outLib);
        }
    }

    private void optimizationIteration(BinaryTree t, int segLen, Library outLib) {
        Node n2;
        this.shiftBoundaryNodesLeft(t, t.getRoot(), -1, segLen, segLen, outLib);
        while ((n2 = t.getNodeWithLongestChildWire()).getChildWireLength() > segLen && this.pass <= 14) {
            this.optimizeSubTree(t, n2, segLen, outLib);
        }
    }

    private void doIt1() {
        Library outLib = LayoutLib.openLibForWrite(OUT_LIB_NM);
        int height = 8;
        BinaryTree t = new BinaryTree(height, this.ep);
        SkewTree.prln("Generate skewed trees of height " + height);
        int segLen = t.getLowBoundWireLen();
        SkewTree.prln("Lower bound on wire length: " + segLen);
        Cell c2 = Cell.newInst(outLib, "skewTree" + height + "pass0{sch}");
        SkewTree.prln("Symmetric tree of height " + height);
        t.draw(c2);
        try {
            this.optimizationIteration(t, segLen, outLib);
        }
        catch (Throwable th) {
            SkewTree.prln("Exception caught in SkewTree: " + String.valueOf(th));
        }
    }

    public static void doIt(EditingPreferences ep) {
        SkewTree sk = new SkewTree(ep);
        sk.doIt1();
    }

    private SkewTree(EditingPreferences ep) {
        this.ep = ep;
    }
}

