/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.cmosPLA;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.cmosPLA.PLA;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.RectangularShape;

public class Decode {
    private PLA pla;
    private EditingPreferences ep;

    Decode(PLA pla, EditingPreferences ep) {
        this.pla = pla;
        this.ep = ep;
    }

    Cell decodeGen(Library library, Cell pmosCell, Cell nmosCell, String cellName, boolean inputsOnTop) {
        NodeInst nNode;
        Cell cell = Cell.makeInstance(this.ep, library, cellName);
        NodeInst pNode = this.pla.makeInstance(cell, pmosCell, 0.0, 0.0, false);
        if (pNode == null) {
            return null;
        }
        pNode.rotate(Orientation.RRR);
        ERectangle nodeRect = pNode.getBounds();
        double x = ((RectangularShape)nodeRect).getWidth();
        if (x < 0.0) {
            x = -x;
        }
        if ((nNode = this.pla.makeInstance(cell, nmosCell, x += 12.0, 0.0, false)) == null) {
            return null;
        }
        nNode.rotate(Orientation.RRR);
        NodeInst[] both = this.decodeBufs(pmosCell, pNode, nmosCell, nNode, cell, x, inputsOnTop);
        if (both == null) {
            return null;
        }
        if (this.decodeRoute(pmosCell, pNode, nmosCell, nNode, cell, both[0], both[1], inputsOnTop)) {
            return null;
        }
        this.decExp(nmosCell, nNode, cell);
        return cell;
    }

    private NodeInst[] decodeBufs(Cell pmosCell, NodeInst pNode, Cell nmosCell, NodeInst nNode, Cell decodeCell, double X, boolean inputsOnTop) {
        int limit;
        NodeInst lastNode = null;
        NodeInst newNode = null;
        NodeInst firstPNode = null;
        NodeInst lastPNode = null;
        NodeInst lastNNode = null;
        int rows = 2;
        Variable var = pmosCell.getVar("PLA_access_rows");
        if (var != null) {
            rows = (Integer)var.getObject();
        } else {
            System.out.println("ACCESS_rows defaulting to 2");
        }
        Export pwrWPort = null;
        Export pwrEPort = null;
        Export gndWPort = null;
        Export gndEPort = null;
        char side = 'w';
        if (inputsOnTop) {
            side = 'e';
        }
        ERectangle nodeBounds = pNode.getBounds();
        double lowX = ((RectangularShape)nodeBounds).getMinX();
        double lowY = ((RectangularShape)nodeBounds).getMinY();
        double highY = ((RectangularShape)nodeBounds).getMaxY();
        ERectangle bufBounds = this.pla.decoderInv.getBounds();
        double diff = ((RectangularShape)bufBounds).getHeight();
        if (diff < 0.0) {
            diff = -diff;
        }
        if ((limit = rows / 4) == 0 || rows % 4 != 0) {
            ++limit;
        }
        int cnt = 0;
        double y = highY;
        if (inputsOnTop) {
            y = lowY - diff;
        }
        y -= 13.0;
        double xOffset = lowX - 38.0;
        if (rows % 4 == 0) {
            xOffset = lowX - 18.0;
        }
        pwrWPort = this.pla.decoderInv.findExport("PWR.m-2.w");
        pwrEPort = this.pla.decoderInv.findExport("PWR.m-2.e");
        gndWPort = this.pla.decoderInv.findExport("GND.m-2.w");
        gndEPort = this.pla.decoderInv.findExport("GND.m-2.e");
        for (int i2 = limit; i2 > 0; --i2) {
            newNode = this.pla.makeInstance(decodeCell, this.pla.decoderInv, (double)(i2 * 50) + xOffset, y, !inputsOnTop);
            if (newNode == null) {
                return null;
            }
            NodeInst newNode2 = this.pla.makeInstance(decodeCell, this.pla.decoderInv, X + (double)(i2 * 50) + xOffset, y, !inputsOnTop);
            if (newNode2 == null) {
                return null;
            }
            if (lastPNode == null && lastNNode == null) {
                Export.newInst(decodeCell, newNode2.findPortInstFromProto(pwrEPort), "PWR.m-2.e", this.ep);
                Export.newInst(decodeCell, newNode2.findPortInstFromProto(gndEPort), "GND.m-2.e", this.ep);
                firstPNode = lastPNode = newNode;
                lastNNode = lastNode = newNode2;
            } else {
                if (pwrWPort != null && pwrEPort != null) {
                    this.pla.makeWire(this.pla.m2Arc, 14.0, lastPNode, pwrWPort, newNode, pwrEPort, decodeCell);
                    this.pla.makeWire(this.pla.m2Arc, 14.0, lastNNode, pwrWPort, newNode2, pwrEPort, decodeCell);
                }
                if (gndWPort != null && gndEPort != null) {
                    this.pla.makeWire(this.pla.m2Arc, 14.0, lastNNode, gndWPort, newNode, gndEPort, decodeCell);
                    this.pla.makeWire(this.pla.m2Arc, 14.0, lastNNode, gndWPort, newNode2, gndEPort, decodeCell);
                }
                lastPNode = newNode;
                lastNNode = newNode2;
            }
            for (int x = cnt; x < cnt + 4; ++x) {
                String aName = "ACCESS" + x + ".m-1." + side;
                Export pPort = pmosCell.findExport(aName);
                Export nPort = this.pla.decoderInv.findExport("LINE" + x % 4 + ".p.n");
                if (pPort != null && nPort != null) {
                    this.pla.makeWire(this.pla.pArc, 2.0, pNode, pPort, newNode, nPort, decodeCell);
                }
                pPort = nmosCell.findExport(aName);
                if (nPort == null || pPort == null) continue;
                this.pla.makeWire(this.pla.pArc, 2.0, nNode, pPort, newNode2, nPort, decodeCell);
            }
            cnt += 4;
        }
        if (pwrWPort != null && pwrEPort != null) {
            this.pla.makeWire(this.pla.m2Arc, 14.0, lastNNode, pwrWPort, firstPNode, pwrEPort, decodeCell);
            Export.newInst(decodeCell, lastPNode.findPortInstFromProto(pwrWPort), "PWR.m-2.w", this.ep);
        }
        if (gndWPort != null && gndEPort != null) {
            this.pla.makeWire(this.pla.m2Arc, 14.0, lastNNode, gndWPort, firstPNode, gndEPort, decodeCell);
            Export.newInst(decodeCell, lastPNode.findPortInstFromProto(gndWPort), "GND.m-2.w", this.ep);
        }
        NodeInst[] both = new NodeInst[]{lastPNode, lastNode};
        return both;
    }

    private void decExp(Cell nmosCell, NodeInst nNode, Cell decodeCell) {
        int x = 0;
        char side = 'n';
        String name = "DATA" + x + ".m-1." + side;
        Export pp = nmosCell.findExport(name);
        while (pp != null) {
            Export.newInst(decodeCell, nNode.findPortInstFromProto(pp), name, this.ep);
            name = "DATA" + ++x + ".m-1." + side;
            pp = nmosCell.findExport(name);
        }
    }

    private boolean decodeRoute(Cell pmosCell, NodeInst pNode, Cell nmosCell, NodeInst nNode, Cell decodeCell, NodeInst firstNode, NodeInst lastNode, boolean inputsOnTop) {
        PortProto pwrPort;
        NodeInst pmNode2;
        NodeInst pmNode22;
        double pY;
        Poly poly;
        double pX;
        NodeInst pmNode1;
        Export pPort = pmosCell.findExport("DATA0.m-1.n");
        Export nPort = nmosCell.findExport("DATA0.m-1.s");
        int cnt = 0;
        while (pPort != null && nPort != null) {
            this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, pPort, nNode, nPort, decodeCell);
            pPort = pmosCell.findExport("DATA" + ++cnt + ".m-1.n");
            nPort = nmosCell.findExport("DATA" + cnt + ".m-1.s");
        }
        pPort = pmosCell.findExport("DATA0.m-1.s");
        nPort = pmosCell.findExport("PWR0.m-1.s");
        if (pPort != null && nPort != null) {
            this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, pPort, pNode, nPort, decodeCell);
        }
        if ((pmNode1 = this.pla.makePin(decodeCell, (pX = (poly = pNode.findPortInstFromProto(nPort).getPoly()).getCenterX()) - 13.0, pY = poly.getCenterY(), 6.0, this.pla.m12Con)) == null) {
            return true;
        }
        this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, nPort, pmNode1, pmNode1.getProto().getPort(0), decodeCell);
        if (!inputsOnTop) {
            PortProto pwrPort2 = firstNode.getProto().findPortProto("PWR.m-2.w");
            pmNode22 = this.pla.makePin(decodeCell, pX - 13.0, pY + 24.0, 14.0, this.pla.m2Pin);
            if (pmNode22 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode22, pmNode22.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.m2Arc, 14.0, firstNode, pwrPort2, pmNode22, pmNode22.getProto().getPort(0), decodeCell);
        }
        nPort = pPort;
        pPort = pmosCell.findExport("DATA1.m-1.s");
        cnt = 1;
        int pwrCnt = 0;
        while (pPort != null && nPort != null) {
            this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, pPort, pNode, nPort, decodeCell);
            nPort = pPort;
            if (++cnt % 4 == 0) {
                String name;
                if ((pPort = pmosCell.findExport(name = "PWR" + ++pwrCnt + ".m-1.s")) != null) {
                    this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, pPort, pNode, nPort, decodeCell);
                }
                if ((pmNode2 = this.pla.makePin(decodeCell, (pX = (poly = pNode.findPortInstFromProto(pPort).getPoly()).getCenterX()) - 13.0, pY = poly.getCenterY(), 6.0, this.pla.m12Con)) == null) {
                    return true;
                }
                this.pla.makeWire(this.pla.m1Arc, 4.0, pNode, pPort, pmNode2, pmNode2.getProto().getPort(0), decodeCell);
                this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode2, pmNode2.getProto().getPort(0), decodeCell);
                pmNode1 = pmNode2;
                nPort = pPort;
            }
            pPort = pmosCell.findExport("DATA" + cnt + ".m-1.s");
        }
        if (inputsOnTop) {
            pwrPort = firstNode.getProto().findPortProto("PWR.m-2.w");
            pmNode2 = this.pla.makePin(decodeCell, pX - 13.0, pY - 24.0, 14.0, this.pla.m2Pin);
            if (pmNode2 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode2, pmNode2.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.m2Arc, 14.0, firstNode, pwrPort, pmNode2, pmNode2.getProto().getPort(0), decodeCell);
        }
        if ((pmNode1 = this.pla.makePin(decodeCell, (pX = (poly = nNode.findPortInstFromProto(nPort = nmosCell.findExport("GND0.m-1.n")).getPoly()).getCenterX()) + 13.0, pY = poly.getCenterY(), 6.0, this.pla.m12Con)) == null) {
            return true;
        }
        this.pla.makeWire(this.pla.m1Arc, 4.0, nNode, nPort, pmNode1, pmNode1.getProto().getPort(0), decodeCell);
        if (!inputsOnTop) {
            pwrPort = lastNode.getProto().findPortProto("GND.m-2.e");
            pmNode2 = this.pla.makePin(decodeCell, pX + 13.0, pY + 90.0, 14.0, this.pla.m2Pin);
            if (pmNode2 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode2, pmNode2.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.m2Arc, 14.0, lastNode, pwrPort, pmNode2, pmNode2.getProto().getPort(0), decodeCell);
        }
        cnt = 1;
        nPort = nmosCell.findExport("GND" + cnt + ".m-1.n");
        while (nPort != null) {
            poly = nNode.findPortInstFromProto(nPort).getPoly();
            pX = poly.getCenterX();
            pmNode22 = this.pla.makePin(decodeCell, pX + 13.0, pY = poly.getCenterY(), 6.0, this.pla.m12Con);
            if (pmNode22 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m1Arc, 4.0, nNode, nPort, pmNode22, pmNode22.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode22, pmNode22.getProto().getPort(0), decodeCell);
            pmNode1 = pmNode22;
            nPort = nmosCell.findExport("GND" + ++cnt + ".m-1.n");
        }
        if (inputsOnTop) {
            pwrPort = lastNode.getProto().findPortProto("GND.m-2.e");
            pmNode2 = this.pla.makePin(decodeCell, pX + 13.0, pY - 90.0, 14.0, this.pla.m2Pin);
            if (pmNode2 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m2Arc, 14.0, pmNode1, pmNode1.getProto().getPort(0), pmNode2, pmNode2.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.m2Arc, 14.0, lastNode, pwrPort, pmNode2, pmNode2.getProto().getPort(0), decodeCell);
        }
        char side = 's';
        char acSide = 'e';
        if (inputsOnTop) {
            side = 'n';
            acSide = 'w';
        }
        int columns = 2;
        Variable var = pmosCell.getVar("PLA_access_rows");
        if (var != null) {
            columns = (Integer)var.getObject() / 2;
        } else {
            System.out.println("DATA_cols defaulting to 2");
        }
        int initOffset = 8;
        int sep = 7;
        cnt = 0;
        String name = "ACCESS" + cnt + ".m-1." + acSide;
        pPort = pmosCell.findExport(name);
        nPort = nmosCell.findExport(name);
        while (pPort != null && nPort != null) {
            double oY;
            double y;
            int inCnt = cnt / 2;
            poly = pNode.findPortInstFromProto(pPort).getPoly();
            pX = poly.getCenterX();
            poly = nNode.findPortInstFromProto(nPort).getPoly();
            double nX = poly.getCenterX();
            double nY = poly.getCenterY();
            if (inputsOnTop) {
                y = nY + (double)initOffset + (double)(inCnt * sep);
                oY = y + (double)((columns - inCnt - 1) * sep);
            } else {
                y = nY - (double)initOffset - (double)(inCnt * sep);
                oY = y - (double)((columns - inCnt - 1) * sep);
            }
            pmNode1 = this.pla.makePin(decodeCell, pX, y, 6.0, this.pla.mpCon);
            if (pmNode1 == null) {
                return true;
            }
            NodeInst pmNode23 = this.pla.makePin(decodeCell, nX, y, 6.0, this.pla.mpCon);
            if (pmNode23 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m1Arc, 4.0, pmNode1, pmNode1.getProto().getPort(0), pmNode23, pmNode23.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.pArc, 2.0, pNode, pPort, pmNode1, pmNode1.getProto().getPort(0), decodeCell);
            this.pla.makeWire(this.pla.pArc, 2.0, nNode, nPort, pmNode23, pmNode23.getProto().getPort(0), decodeCell);
            pmNode1 = this.pla.makePin(decodeCell, nX, oY, 4.0, this.pla.m1Pin);
            if (pmNode1 == null) {
                return true;
            }
            this.pla.makeWire(this.pla.m1Arc, 4.0, pmNode1, pmNode1.getProto().getPort(0), pmNode23, pmNode23.getProto().getPort(0), decodeCell);
            Export.newInst(decodeCell, pmNode1.findPortInstFromProto(pmNode1.getProto().getPort(0)), "INPUT" + inCnt + ".m-1." + side, this.ep);
            name = "ACCESS" + (cnt += 2) + ".m-1." + acSide;
            pPort = pmosCell.findExport(name);
            nPort = nmosCell.findExport(name);
        }
        return false;
    }
}

